/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import java.util.Collection;
import java.util.Iterator;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.AbstractGraph;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.GraphMatcher;

public abstract class AbstractImmutableGraph
extends AbstractGraph
implements ImmutableGraph {
    @Override
    public final synchronized int hashCode() {
        int result = 0;
        Iterator<Triple> iter = this.iterator();
        while (iter.hasNext()) {
            result += this.getBlankNodeBlindHash(iter.next());
        }
        return result;
    }

    private int getBlankNodeBlindHash(Triple triple) {
        RDFTerm object;
        int hash = triple.getPredicate().hashCode();
        BlankNodeOrIRI subject = triple.getSubject();
        if (!(subject instanceof BlankNode)) {
            hash ^= subject.hashCode() >> 1;
        }
        if (!((object = triple.getObject()) instanceof BlankNode)) {
            hash ^= object.hashCode() << 1;
        }
        return hash;
    }

    @Override
    public boolean add(Triple e) {
        throw new UnsupportedOperationException("Graphs are not mutable, use Graph");
    }

    @Override
    public boolean addAll(Collection<? extends Triple> c) {
        throw new UnsupportedOperationException("Graphs are not mutable, use Graph");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Graphs are not mutable, use Graph");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Graphs are not mutable, use Graph");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Graphs are not mutable, use Graph");
    }

    @Override
    public ImmutableGraph getImmutableGraph() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableGraph)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return GraphMatcher.getValidMapping(this, (Graph)((ImmutableGraph)obj)) != null;
    }
}

