/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.LockingIterator;
import org.apache.clerezza.commons.rdf.impl.utils.debug.ReentrantReadWriteLockTracker;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleImmutableGraph;

public abstract class AbstractGraph
extends AbstractCollection<Triple>
implements Graph {
    private static final String DEBUG_MODE = "rdfLocksDebugging";
    private final ReadWriteLock lock;
    private final Lock readLock;
    private final Lock writeLock;

    public AbstractGraph() {
        String debugMode = System.getProperty(DEBUG_MODE);
        this.lock = debugMode != null && debugMode.toLowerCase().equals("true") ? new ReentrantReadWriteLockTracker() : new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    public AbstractGraph(ReadWriteLock lock) {
        this.lock = lock;
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public ImmutableGraph getImmutableGraph() {
        this.readLock.lock();
        try {
            ImmutableGraph immutableGraph = this.performGetImmutableGraph();
            return immutableGraph;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ImmutableGraph performGetImmutableGraph() {
        return new SimpleImmutableGraph(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Triple> filter(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.readLock.lock();
        try {
            LockingIterator lockingIterator = new LockingIterator(this.performFilter(subject, predicate, object), this.lock);
            return lockingIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.performSize();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.performIsEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.readLock.lock();
        try {
            boolean bl = this.performContains(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<Triple> iterator() {
        this.readLock.lock();
        try {
            LockingIterator lockingIterator = new LockingIterator(this.performIterator(), this.lock);
            return lockingIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.performToArray();
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = this.performToArray(a);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.readLock.lock();
        try {
            boolean bl = this.performContainsAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean add(Triple e) {
        this.writeLock.lock();
        try {
            boolean bl = this.performAdd(e);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.performRemove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends Triple> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.performAddAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.performRemoveAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.performRetainAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.performClear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    protected abstract Iterator<Triple> performFilter(BlankNodeOrIRI var1, IRI var2, RDFTerm var3);

    protected abstract int performSize();

    protected boolean performIsEmpty() {
        return super.isEmpty();
    }

    protected Object[] performToArray() {
        return super.toArray();
    }

    protected boolean performRemove(Object o) {
        return super.remove(o);
    }

    protected boolean performAddAll(Collection<? extends Triple> c) {
        return super.addAll(c);
    }

    protected boolean performRemoveAll(Collection<?> c) {
        return super.removeAll(c);
    }

    protected boolean performRetainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    protected void performClear() {
        super.clear();
    }

    protected boolean performContains(Object o) {
        return super.contains(o);
    }

    protected Iterator<Triple> performIterator() {
        return this.performFilter(null, null, null);
    }

    protected boolean performContainsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    protected <T> T[] performToArray(T[] a) {
        return super.toArray(a);
    }

    protected boolean performAdd(Triple e) {
        return super.add(e);
    }
}

