/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.event;

import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;

public class FilterTriple {
    private BlankNodeOrIRI subject;
    private IRI predicate;
    private RDFTerm object;

    public FilterTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public boolean match(Triple triple) {
        boolean subjectMatch = this.subject == null ? true : this.subject.equals(triple.getSubject());
        boolean predicateMatch = this.predicate == null ? true : this.predicate.equals(triple.getPredicate());
        boolean objectMatch = this.object == null ? true : this.object.equals(triple.getObject());
        return subjectMatch && predicateMatch && objectMatch;
    }

    public String toString() {
        return "FilterTriples: " + this.subject + " " + this.predicate + " " + this.object;
    }
}

