/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.session;

import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.ccm.BaseCcmRule;
import com.datastax.oss.driver.api.testinfra.session.CqlSessionRuleBuilder;
import com.datastax.oss.driver.api.testinfra.session.SessionUtils;
import com.datastax.oss.driver.api.testinfra.simulacron.SimulacronRule;
import java.util.Objects;
import java.util.Optional;
import org.junit.rules.ExternalResource;

public class SessionRule<SessionT extends Session>
extends ExternalResource {
    private static final Version V6_8_0 = Objects.requireNonNull(Version.parse((String)"6.8.0"));
    private final CassandraResourceRule cassandraResource;
    private final NodeStateListener nodeStateListener;
    private final SchemaChangeListener schemaChangeListener;
    private final CqlIdentifier keyspace;
    private final DriverConfigLoader configLoader;
    private final String graphName;
    private final boolean isCoreGraph;
    private SessionT session;
    private DriverExecutionProfile slowProfile;

    public static CqlSessionRuleBuilder builder(CassandraResourceRule cassandraResource) {
        return new CqlSessionRuleBuilder(cassandraResource);
    }

    public SessionRule(CassandraResourceRule cassandraResource, boolean createKeyspace, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, DriverConfigLoader configLoader, String graphName, boolean isCoreGraph) {
        this.cassandraResource = cassandraResource;
        this.nodeStateListener = nodeStateListener;
        this.schemaChangeListener = schemaChangeListener;
        this.keyspace = cassandraResource instanceof SimulacronRule || !createKeyspace ? null : SessionUtils.uniqueKeyspaceId();
        this.configLoader = configLoader;
        this.graphName = graphName;
        this.isCoreGraph = isCoreGraph;
    }

    public SessionRule(CassandraResourceRule cassandraResource, boolean createKeyspace, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, DriverConfigLoader configLoader, String graphName) {
        this(cassandraResource, createKeyspace, nodeStateListener, schemaChangeListener, configLoader, graphName, false);
    }

    public SessionRule(CassandraResourceRule cassandraResource, boolean createKeyspace, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, DriverConfigLoader configLoader) {
        this(cassandraResource, createKeyspace, nodeStateListener, schemaChangeListener, configLoader, null, false);
    }

    protected void before() {
        this.session = SessionUtils.newSession(this.cassandraResource, null, this.nodeStateListener, this.schemaChangeListener, null, this.configLoader);
        this.slowProfile = SessionUtils.slowProfile(this.session);
        if (this.keyspace != null) {
            SessionUtils.createKeyspace(this.session, this.keyspace, this.slowProfile);
            this.session.execute((Request)SimpleStatement.newInstance((String)String.format("USE %s", this.keyspace.asCql(false))), Statement.SYNC);
        }
        if (this.graphName != null) {
            Optional dseVersion;
            Optional<Object> optional = dseVersion = this.cassandraResource instanceof BaseCcmRule ? ((BaseCcmRule)this.cassandraResource).getDseVersion() : Optional.empty();
            if (!dseVersion.isPresent()) {
                throw new IllegalArgumentException("DseSessionRule should work with DSE.");
            }
            if (((Version)dseVersion.get()).compareTo(V6_8_0) >= 0) {
                this.session().execute((Request)ScriptGraphStatement.newInstance((String)String.format("system.graph('%s').ifNotExists()%s.create()", this.graphName, this.isCoreGraph ? ".coreEngine()" : ".classicEngine()")).setSystemQuery(Boolean.valueOf(true)), ScriptGraphStatement.SYNC);
            } else {
                if (this.isCoreGraph) {
                    throw new IllegalArgumentException("Core graph is not supported for DSE version < " + V6_8_0);
                }
                this.session().execute((Request)ScriptGraphStatement.newInstance((String)String.format("system.graph('%s').ifNotExists().create()", this.graphName)).setSystemQuery(Boolean.valueOf(true)), ScriptGraphStatement.SYNC);
            }
        }
    }

    protected void after() {
        if (this.graphName != null) {
            this.session().execute((Request)ScriptGraphStatement.newInstance((String)String.format("system.graph('%s').drop()", this.graphName)).setSystemQuery(Boolean.valueOf(true)), ScriptGraphStatement.SYNC);
        }
        if (this.keyspace != null) {
            SessionUtils.dropKeyspace(this.session, this.keyspace, this.slowProfile);
        }
        this.session.close();
    }

    public SessionT session() {
        return this.session;
    }

    public CqlIdentifier keyspace() {
        return this.keyspace;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public DriverExecutionProfile slowProfile() {
        return this.slowProfile;
    }
}

