/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.micrometer;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricUpdater;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MicrometerNodeMetricUpdater
extends MicrometerMetricUpdater<NodeMetric>
implements NodeMetricUpdater {
    private final Node node;

    public MicrometerNodeMetricUpdater(Node node, InternalDriverContext context, Set<NodeMetric> enabledMetrics, MeterRegistry registry) {
        super(context, enabledMetrics, registry);
        this.node = node;
        DriverExecutionProfile profile = context.getConfig().getDefaultProfile();
        this.initializeGauge(DefaultNodeMetric.OPEN_CONNECTIONS, profile, () -> ((Node)node).getOpenConnections());
        this.initializeGauge(DefaultNodeMetric.AVAILABLE_STREAMS, profile, () -> this.availableStreamIds(node));
        this.initializeGauge(DefaultNodeMetric.IN_FLIGHT, profile, () -> this.inFlightRequests(node));
        this.initializeGauge(DefaultNodeMetric.ORPHANED_STREAMS, profile, () -> this.orphanedStreamIds(node));
        this.initializeCounter(DefaultNodeMetric.UNSENT_REQUESTS, profile);
        this.initializeCounter(DefaultNodeMetric.ABORTED_REQUESTS, profile);
        this.initializeCounter(DefaultNodeMetric.WRITE_TIMEOUTS, profile);
        this.initializeCounter(DefaultNodeMetric.READ_TIMEOUTS, profile);
        this.initializeCounter(DefaultNodeMetric.UNAVAILABLES, profile);
        this.initializeCounter(DefaultNodeMetric.OTHER_ERRORS, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_ABORTED, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_ABORTED, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_UNAVAILABLE, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_OTHER_ERROR, profile);
        this.initializeCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, profile);
        this.initializeCounter(DefaultNodeMetric.CONNECTION_INIT_ERRORS, profile);
        this.initializeCounter(DefaultNodeMetric.AUTHENTICATION_ERRORS, profile);
        this.initializeTimer(DefaultNodeMetric.CQL_MESSAGES, profile);
        this.initializeTimer(DseNodeMetric.GRAPH_MESSAGES, profile);
    }

    @Override
    protected MetricId getMetricId(NodeMetric metric) {
        return this.context.getMetricIdGenerator().nodeMetricId(this.node, metric);
    }

    protected void startMetricsExpirationTimeout() {
        super.startMetricsExpirationTimeout();
    }

    protected void cancelMetricsExpirationTimeout() {
        super.cancelMetricsExpirationTimeout();
    }

    @Override
    protected Timer.Builder configureTimer(Timer.Builder builder, NodeMetric metric, MetricId id) {
        DriverExecutionProfile profile = this.context.getConfig().getDefaultProfile();
        super.configureTimer(builder, metric, id);
        if (metric == DefaultNodeMetric.CQL_MESSAGES) {
            builder.minimumExpectedValue(profile.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_LOWEST)).maximumExpectedValue(profile.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST)).serviceLevelObjectives(profile.isDefined((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_SLO) ? profile.getDurationList((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_SLO).toArray(new Duration[0]) : null).percentilePrecision(Integer.valueOf(profile.getInt((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS)));
            MicrometerNodeMetricUpdater.configurePercentilesPublishIfDefined(builder, profile, (DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_PUBLISH_PERCENTILES);
        } else if (metric == DseNodeMetric.GRAPH_MESSAGES) {
            builder.minimumExpectedValue(profile.getDuration((DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_LOWEST)).maximumExpectedValue(profile.getDuration((DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_HIGHEST)).serviceLevelObjectives(profile.isDefined((DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_SLO) ? profile.getDurationList((DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_SLO).toArray(new Duration[0]) : null).percentilePrecision(Integer.valueOf(profile.getInt((DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_DIGITS)));
            MicrometerNodeMetricUpdater.configurePercentilesPublishIfDefined(builder, profile, (DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_PUBLISH_PERCENTILES);
        }
        return builder;
    }
}

