/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;

public interface EntityDefinition {
    public ClassName getClassName();

    public CodeBlock getCqlName();

    @Nullable
    public String getDefaultKeyspace();

    public List<PropertyDefinition> getPartitionKey();

    public List<PropertyDefinition> getClusteringColumns();

    default public List<PropertyDefinition> getPrimaryKey() {
        return ImmutableList.builder().addAll(this.getPartitionKey()).addAll(this.getClusteringColumns()).build();
    }

    public Iterable<PropertyDefinition> getRegularColumns();

    public Iterable<PropertyDefinition> getComputedValues();

    default public List<PropertyDefinition> getAllColumns() {
        return ImmutableList.builder().addAll(this.getPartitionKey()).addAll(this.getClusteringColumns()).addAll(this.getRegularColumns()).build();
    }

    default public List<PropertyDefinition> getAllValues() {
        return ImmutableList.builder().addAll(this.getPartitionKey()).addAll(this.getClusteringColumns()).addAll(this.getRegularColumns()).addAll(this.getComputedValues()).build();
    }

    public boolean isMutable();
}

