/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOCComponent {
    private static final Logger logger = LoggerFactory.getLogger(TOCComponent.class);

    public static Set<Component> loadTOC(Descriptor descriptor) throws IOException {
        return TOCComponent.loadTOC(descriptor, true);
    }

    public static Set<Component> loadTOC(Descriptor descriptor, boolean skipMissing) throws IOException {
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        List<String> componentNames = Files.readAllLines(tocFile.toPath());
        HashSet components = Sets.newHashSetWithExpectedSize((int)componentNames.size());
        for (String componentName : componentNames) {
            Component component = Component.parse(componentName, descriptor.version.format);
            if (skipMissing && !descriptor.fileFor(component).exists()) {
                logger.error("Missing component: {}", (Object)descriptor.fileFor(component));
                continue;
            }
            components.add(component);
        }
        return components;
    }

    public static void updateTOC(Descriptor descriptor, Collection<Component> components) {
        if (components.isEmpty()) {
            return;
        }
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        TreeSet<String> componentNames = new TreeSet<String>(Collections2.transform(components, Component::name));
        if (tocFile.exists()) {
            componentNames.addAll(FileUtils.readLines(tocFile));
        }
        try {
            FileUtils.write(tocFile, new ArrayList<String>(componentNames), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Exception occurred while writing to " + tocFile, ex.getCause() != null ? ex.getCause() : ex);
        }
    }

    public static Set<Component> loadOrCreate(Descriptor descriptor) {
        try {
            return TOCComponent.loadTOC(descriptor);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        Set<Component> components = descriptor.discoverComponents();
        if (components.isEmpty()) {
            return components;
        }
        components.add(SSTableFormat.Components.TOC);
        TOCComponent.updateTOC(descriptor, components);
        return components;
    }

    public static void rewriteTOC(Descriptor descriptor, Collection<Component> components) {
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        if (!tocFile.tryDelete()) {
            logger.error("Failed to delete TOC component for {}", (Object)descriptor);
        }
        TOCComponent.updateTOC(descriptor, components);
    }
}

