/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.InitialSSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.service.SSTablesVersionsInUseChangeNotification;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTablesGlobalTracker
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SSTablesGlobalTracker.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 5L, TimeUnit.MINUTES);
    private final Set<Descriptor> allSSTables = ConcurrentHashMap.newKeySet();
    private final Version currentVersion;
    private int sstablesForCurrentVersion;
    private final Map<Version, Integer> sstablesForOtherVersions = new HashMap<Version, Integer>();
    private volatile ImmutableSet<Version> versionsInUse = ImmutableSet.of();
    private final Set<INotificationConsumer> subscribers = new CopyOnWriteArraySet<INotificationConsumer>();

    public SSTablesGlobalTracker(SSTableFormat<?, ?> currentSSTableFormat) {
        this.currentVersion = currentSSTableFormat.getLatestVersion();
    }

    public Set<Version> versionsInUse() {
        return this.versionsInUse;
    }

    public boolean register(INotificationConsumer subscriber) {
        return this.subscribers.add(subscriber);
    }

    public boolean unregister(INotificationConsumer subscriber) {
        return this.subscribers.remove(subscriber);
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        Iterable<Descriptor> removed = SSTablesGlobalTracker.removedSSTables(notification);
        Iterable<Descriptor> added = SSTablesGlobalTracker.addedSSTables(notification);
        if (Iterables.isEmpty(removed) && Iterables.isEmpty(added)) {
            return;
        }
        boolean triggerUpdate = this.handleSSTablesChange(removed, added);
        if (triggerUpdate) {
            SSTablesVersionsInUseChangeNotification changeNotification = new SSTablesVersionsInUseChangeNotification(this.versionsInUse);
            this.subscribers.forEach(s -> s.handleNotification(changeNotification, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean handleSSTablesChange(Iterable<Descriptor> removed, Iterable<Descriptor> added) {
        boolean triggerUpdate;
        Version version;
        int currentDelta = 0;
        Map<Version, Integer> othersDelta = null;
        for (Descriptor desc : removed) {
            if (!this.allSSTables.remove(desc)) continue;
            version = desc.version;
            if (this.currentVersion.equals(version)) {
                --currentDelta;
                continue;
            }
            othersDelta = SSTablesGlobalTracker.update(othersDelta, version, -1);
        }
        for (Descriptor desc : added) {
            if (!this.allSSTables.add(desc)) continue;
            version = desc.version;
            if (this.currentVersion.equals(version)) {
                ++currentDelta;
                continue;
            }
            othersDelta = SSTablesGlobalTracker.update(othersDelta, version, 1);
        }
        if (currentDelta == 0 && othersDelta == null) {
            return false;
        }
        SSTablesGlobalTracker sSTablesGlobalTracker = this;
        synchronized (sSTablesGlobalTracker) {
            triggerUpdate = currentDelta > 0 && this.sstablesForCurrentVersion == 0 || currentDelta < 0 && this.sstablesForCurrentVersion <= -currentDelta;
            this.sstablesForCurrentVersion += currentDelta;
            this.sstablesForCurrentVersion = SSTablesGlobalTracker.sanitizeSSTablesCount(this.sstablesForCurrentVersion, this.currentVersion);
            if (othersDelta != null) {
                for (Map.Entry<Version, Integer> entry : othersDelta.entrySet()) {
                    Version version2 = entry.getKey();
                    int delta = entry.getValue();
                    Integer oldValue = this.sstablesForOtherVersions.get(version2);
                    int newValue = oldValue == null ? delta : oldValue + delta;
                    newValue = SSTablesGlobalTracker.sanitizeSSTablesCount(newValue, version2);
                    triggerUpdate |= oldValue == null || newValue == 0;
                    if (newValue == 0) {
                        this.sstablesForOtherVersions.remove(version2);
                        continue;
                    }
                    this.sstablesForOtherVersions.put(version2, newValue);
                }
            }
            if (triggerUpdate) {
                this.versionsInUse = SSTablesGlobalTracker.computeVersionsInUse(this.sstablesForCurrentVersion, this.currentVersion, this.sstablesForOtherVersions);
            }
        }
        return triggerUpdate;
    }

    private static ImmutableSet<Version> computeVersionsInUse(int sstablesForCurrentVersion, Version currentVersion, Map<Version, Integer> sstablesForOtherVersions) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (sstablesForCurrentVersion > 0) {
            builder.add((Object)currentVersion);
        }
        builder.addAll(sstablesForOtherVersions.keySet());
        return builder.build();
    }

    private static int sanitizeSSTablesCount(int sstableCount, Version version) {
        if (sstableCount >= 0) {
            return sstableCount;
        }
        noSpamLogger.error("Invalid state while handling sstables change notification: the number of sstables for version {} was computed to {}. This indicate a bug and please report it, but it should not have adverse consequences.", version.toFormatAndVersionString(), sstableCount, new RuntimeException());
        return 0;
    }

    private static Iterable<Descriptor> addedSSTables(INotification notification) {
        if (notification instanceof SSTableAddedNotification) {
            return Iterables.transform(((SSTableAddedNotification)notification).added, s -> s.descriptor);
        }
        if (notification instanceof SSTableListChangedNotification) {
            return Iterables.transform(((SSTableListChangedNotification)notification).added, s -> s.descriptor);
        }
        if (notification instanceof InitialSSTableAddedNotification) {
            return Iterables.transform(((InitialSSTableAddedNotification)notification).added, s -> s.descriptor);
        }
        return Collections.emptyList();
    }

    private static Iterable<Descriptor> removedSSTables(INotification notification) {
        if (notification instanceof SSTableDeletingNotification) {
            return Collections.singletonList(((SSTableDeletingNotification)notification).deleting.descriptor);
        }
        if (notification instanceof SSTableListChangedNotification) {
            return Iterables.transform(((SSTableListChangedNotification)notification).removed, s -> s.descriptor);
        }
        return Collections.emptyList();
    }

    private static Map<Version, Integer> update(Map<Version, Integer> counts, Version toUpdate, int delta) {
        HashMap<Version, Integer> m = counts == null ? new HashMap<Version, Integer>() : counts;
        m.merge(toUpdate, delta, (a, b) -> a + b == 0 ? null : Integer.valueOf(a + b));
        return m;
    }
}

