/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.SchemaChangeListener;
import org.apache.cassandra.schema.SchemaTransformation;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.UserFunctions;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;

public class SchemaChangeNotifier {
    private final List<SchemaChangeListener> changeListeners = new CopyOnWriteArrayList<SchemaChangeListener>();

    public void registerListener(SchemaChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void unregisterListener(SchemaChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void notifyKeyspaceCreated(KeyspaceMetadata keyspace) {
        this.notifyCreateKeyspace(keyspace);
        keyspace.types.forEach(this::notifyCreateType);
        keyspace.tables.forEach(this::notifyCreateTable);
        keyspace.views.forEach(this::notifyCreateView);
        keyspace.userFunctions.udfs().forEach(this::notifyCreateFunction);
        keyspace.userFunctions.udas().forEach(this::notifyCreateAggregate);
    }

    public void notifyKeyspaceAltered(KeyspaceMetadata.KeyspaceDiff delta, boolean dropData) {
        ((UserFunctions)delta.udas.dropped).forEach(uda -> this.notifyDropAggregate((UDAggregate)uda));
        ((UserFunctions)delta.udfs.dropped).forEach(udf -> this.notifyDropFunction((UDFunction)udf));
        ((Views)delta.views.dropped).forEach(view -> this.notifyDropView((ViewMetadata)view, dropData));
        ((Tables)delta.tables.dropped).forEach(metadata -> this.notifyDropTable((TableMetadata)metadata, dropData));
        ((Types)delta.types.dropped).forEach(this::notifyDropType);
        ((Types)delta.types.created).forEach(this::notifyCreateType);
        ((Tables)delta.tables.created).forEach(this::notifyCreateTable);
        ((Views)delta.views.created).forEach(this::notifyCreateView);
        ((UserFunctions)delta.udfs.created).forEach(udf -> this.notifyCreateFunction((UDFunction)udf));
        ((UserFunctions)delta.udas.created).forEach(uda -> this.notifyCreateAggregate((UDAggregate)uda));
        if (!delta.before.params.equals(delta.after.params)) {
            this.notifyAlterKeyspace(delta.before, delta.after);
        }
        delta.types.altered.forEach(diff -> this.notifyAlterType((UserType)diff.before, (UserType)diff.after));
        delta.tables.altered.forEach(diff -> this.notifyAlterTable((TableMetadata)diff.before, (TableMetadata)diff.after));
        delta.views.altered.forEach(diff -> this.notifyAlterView((ViewMetadata)diff.before, (ViewMetadata)diff.after));
        delta.udfs.altered.forEach(diff -> this.notifyAlterFunction((UDFunction)diff.before, (UDFunction)diff.after));
        delta.udas.altered.forEach(diff -> this.notifyAlterAggregate((UDAggregate)diff.before, (UDAggregate)diff.after));
    }

    public void notifyKeyspaceDropped(KeyspaceMetadata keyspace, boolean dropData) {
        keyspace.userFunctions.udas().forEach(this::notifyDropAggregate);
        keyspace.userFunctions.udfs().forEach(this::notifyDropFunction);
        keyspace.views.forEach(view -> this.notifyDropView((ViewMetadata)view, dropData));
        keyspace.tables.forEach(metadata -> this.notifyDropTable((TableMetadata)metadata, dropData));
        keyspace.types.forEach(this::notifyDropType);
        this.notifyDropKeyspace(keyspace, dropData);
    }

    public void notifyPreChanges(SchemaTransformation.SchemaTransformationResult transformationResult) {
        transformationResult.diff.altered.forEach(this::notifyPreAlterKeyspace);
    }

    private void notifyPreAlterKeyspace(KeyspaceMetadata.KeyspaceDiff keyspaceDiff) {
        keyspaceDiff.tables.altered.forEach(this::notifyPreAlterTable);
        keyspaceDiff.views.altered.forEach(this::notifyPreAlterView);
    }

    private void notifyPreAlterTable(Diff.Altered<TableMetadata> altered) {
        this.changeListeners.forEach(l -> l.onPreAlterTable((TableMetadata)altered.before, (TableMetadata)altered.after));
    }

    private void notifyPreAlterView(Diff.Altered<ViewMetadata> altered) {
        this.changeListeners.forEach(l -> l.onPreAlterView((ViewMetadata)altered.before, (ViewMetadata)altered.after));
    }

    private void notifyCreateKeyspace(KeyspaceMetadata ksm) {
        this.changeListeners.forEach(l -> l.onCreateKeyspace(ksm));
    }

    private void notifyCreateTable(TableMetadata metadata) {
        this.changeListeners.forEach(l -> l.onCreateTable(metadata));
    }

    private void notifyCreateView(ViewMetadata view) {
        this.changeListeners.forEach(l -> l.onCreateView(view));
    }

    private void notifyCreateType(UserType ut) {
        this.changeListeners.forEach(l -> l.onCreateType(ut));
    }

    private void notifyCreateFunction(UDFunction udf) {
        this.changeListeners.forEach(l -> l.onCreateFunction(udf));
    }

    private void notifyCreateAggregate(UDAggregate udf) {
        this.changeListeners.forEach(l -> l.onCreateAggregate(udf));
    }

    private void notifyAlterKeyspace(KeyspaceMetadata before, KeyspaceMetadata after) {
        this.changeListeners.forEach(l -> l.onAlterKeyspace(before, after));
    }

    private void notifyAlterTable(TableMetadata before, TableMetadata after) {
        boolean changeAffectedPreparedStatements = before.changeAffectsPreparedStatements(after);
        this.changeListeners.forEach(l -> l.onAlterTable(before, after, changeAffectedPreparedStatements));
    }

    private void notifyAlterView(ViewMetadata before, ViewMetadata after) {
        boolean changeAffectedPreparedStatements = before.metadata.changeAffectsPreparedStatements(after.metadata);
        this.changeListeners.forEach(l -> l.onAlterView(before, after, changeAffectedPreparedStatements));
    }

    private void notifyAlterType(UserType before, UserType after) {
        this.changeListeners.forEach(l -> l.onAlterType(before, after));
    }

    private void notifyAlterFunction(UDFunction before, UDFunction after) {
        this.changeListeners.forEach(l -> l.onAlterFunction(before, after));
    }

    private void notifyAlterAggregate(UDAggregate before, UDAggregate after) {
        this.changeListeners.forEach(l -> l.onAlterAggregate(before, after));
    }

    private void notifyDropKeyspace(KeyspaceMetadata ksm, boolean dropData) {
        this.changeListeners.forEach(l -> l.onDropKeyspace(ksm, dropData));
    }

    private void notifyDropTable(TableMetadata metadata, boolean dropData) {
        this.changeListeners.forEach(l -> l.onDropTable(metadata, dropData));
    }

    private void notifyDropView(ViewMetadata view, boolean dropData) {
        this.changeListeners.forEach(l -> l.onDropView(view, dropData));
    }

    private void notifyDropType(UserType ut) {
        this.changeListeners.forEach(l -> l.onDropType(ut));
    }

    private void notifyDropFunction(UDFunction udf) {
        this.changeListeners.forEach(l -> l.onDropFunction(udf));
    }

    private void notifyDropAggregate(UDAggregate udf) {
        this.changeListeners.forEach(l -> l.onDropAggregate(udf));
    }
}

