/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.primitives.UnsignedLongs;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UUIDSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class UUIDType
extends AbstractType<UUID> {
    public static final UUIDType instance = new UUIDType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer MASKED_VALUE = instance.decompose(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    static final Pattern regexPattern = Pattern.compile("[A-Fa-f0-9]{8}\\-[A-Fa-f0-9]{4}\\-[A-Fa-f0-9]{4}\\-[A-Fa-f0-9]{4}\\-[A-Fa-f0-9]{12}");

    UUIDType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean allowsEmpty() {
        return true;
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        long msb2;
        int version2;
        boolean p2;
        boolean p1 = accessorL.size(left) == 16;
        boolean bl = p2 = accessorR.size(right) == 16;
        if (!(p1 & p2)) {
            assert (p1 || accessorL.isEmpty(left));
            assert (p2 || accessorR.isEmpty(right));
            return p1 ? 1 : (p2 ? -1 : 0);
        }
        long msb1 = accessorL.getLong(left, 0);
        int version1 = (int)(msb1 >>> 12 & 0xFL);
        if (version1 != (version2 = (int)((msb2 = accessorR.getLong(right, 0)) >>> 12 & 0xFL))) {
            return version1 - version2;
        }
        if (version1 == 1) {
            long reorder2;
            long reorder1 = TimeUUIDType.reorderTimestampBytes(msb1);
            int c = Long.compare(reorder1, reorder2 = TimeUUIDType.reorderTimestampBytes(msb2));
            if (c != 0) {
                return c;
            }
        } else {
            int c = UnsignedLongs.compare((long)msb1, (long)msb2);
            if (c != 0) {
                return c;
            }
        }
        return UnsignedLongs.compare((long)accessorL.getLong(left, 8), (long)accessorR.getLong(right, 8));
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version v) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        long msb = accessor.getLong(data, 0);
        long version = msb >>> 12 & 0xFL;
        ByteBuffer swizzled = ByteBuffer.allocate(16);
        if (version == 1L) {
            swizzled.putLong(0, TimeUUIDType.reorderTimestampBytes(msb));
        } else {
            swizzled.putLong(0, version << 60 | msb >>> 4 & 0xFFFFFFFFFFFF000L | msb & 0xFFFL);
        }
        swizzled.putLong(8, accessor.getLong(data, 8));
        return ByteSource.fixedLength(swizzled);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        long hiBits = ByteSourceInverse.getUnsignedFixedLengthAsLong(comparableBytes, 8);
        long loBits = ByteSourceInverse.getUnsignedFixedLengthAsLong(comparableBytes, 8);
        long uuidVersion = hiBits >>> 60 & 0xFL;
        hiBits = uuidVersion == 1L ? TimeUUIDType.reorderBackTimestampBytes(hiBits) : hiBits << 4 & 0xFFFFFFFFFFFF0000L | uuidVersion << 12 | hiBits & 0xFFFL;
        return UUIDType.makeUuidBytes(accessor, hiBits, loBits);
    }

    static <V> V makeUuidBytes(ValueAccessor<V> accessor, long high, long low) {
        V buffer = accessor.allocate(16);
        accessor.putLong(buffer, 0, high);
        accessor.putLong(buffer, 8, low);
        return buffer;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return otherType instanceof UUIDType || otherType instanceof TimeUUIDType;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        ByteBuffer parsed = UUIDType.parse(source);
        if (parsed != null) {
            return parsed;
        }
        throw new MarshalException(String.format("Unable to make UUID from '%s'", source));
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.UUID;
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return UUIDSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    static ByteBuffer parse(String source) {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (regexPattern.matcher(source).matches()) {
            try {
                return UUIDGen.toByteBuffer(UUID.fromString(source));
            }
            catch (IllegalArgumentException e) {
                throw new MarshalException(String.format("Unable to make UUID from '%s'", source), e);
            }
        }
        return null;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a uuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    static int version(ByteBuffer uuid) {
        return (uuid.get(6) & 0xF0) >> 4;
    }

    @Override
    public int valueLengthIfFixed() {
        return 16;
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

