/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.management.InstanceNotFoundException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.TimeWindowCompactionStrategy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsKeyspace;
import org.apache.cassandra.tools.nodetool.stats.StatsTable;
import org.apache.cassandra.tools.nodetool.stats.StatsTableComparator;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class TableStatsHolder
implements StatsHolder {
    public final List<StatsKeyspace> keyspaces = new ArrayList<StatsKeyspace>();
    public int numberOfTables = 0;
    public final boolean humanReadable;
    public final String sortKey;
    public final int top;
    public final boolean locationCheck;

    public TableStatsHolder(NodeProbe probe, boolean humanReadable, boolean ignore, List<String> tableNames, String sortKey, int top, boolean locationCheck) {
        this.humanReadable = humanReadable;
        this.sortKey = sortKey;
        this.top = top;
        this.locationCheck = locationCheck;
        if (!this.isTestTableStatsHolder()) {
            this.initializeKeyspaces(probe, ignore, tableNames);
        }
    }

    @Override
    public Map<String, Object> convert2Map() {
        if (this.sortKey.isEmpty()) {
            return this.convertAllToMap();
        }
        return this.convertSortedFilteredSubsetToMap();
    }

    private Map<String, Object> convertAllToMap() {
        HashMap<String, Object> mpRet = new HashMap<String, Object>();
        mpRet.put("total_number_of_tables", this.numberOfTables);
        for (StatsKeyspace keyspace : this.keyspaces) {
            HashMap<String, Serializable> mpKeyspace = new HashMap<String, Serializable>();
            mpKeyspace.put("read_latency", Double.valueOf(keyspace.readLatency()));
            mpKeyspace.put("read_count", Long.valueOf(keyspace.readCount));
            mpKeyspace.put("read_latency_ms", Double.valueOf(keyspace.readLatency()));
            mpKeyspace.put("write_count", Long.valueOf(keyspace.writeCount));
            mpKeyspace.put("write_latency_ms", Double.valueOf(keyspace.writeLatency()));
            mpKeyspace.put("pending_flushes", Integer.valueOf(keyspace.pendingFlushes));
            List<StatsTable> tables = keyspace.tables;
            HashMap<String, Map<String, Object>> mpTables = new HashMap<String, Map<String, Object>>();
            for (StatsTable table : tables) {
                Map<String, Object> mpTable = this.convertStatsTableToMap(table);
                mpTables.put(table.tableName, mpTable);
            }
            mpKeyspace.put("tables", mpTables);
            mpRet.put(keyspace.name, mpKeyspace);
        }
        return mpRet;
    }

    private Map<String, Object> convertSortedFilteredSubsetToMap() {
        HashMap<String, Object> mpRet = new HashMap<String, Object>();
        mpRet.put("total_number_of_tables", this.numberOfTables);
        List<StatsTable> sortedFilteredTables = this.getSortedFilteredTables();
        for (StatsTable table : sortedFilteredTables) {
            String tableDisplayName = table.keyspaceName + "." + table.tableName;
            Map<String, Object> mpTable = this.convertStatsTableToMap(table);
            mpRet.put(tableDisplayName, mpTable);
        }
        return mpRet;
    }

    private Map<String, Object> convertStatsTableToMap(StatsTable table) {
        HashMap<String, Object> mpTable = new HashMap<String, Object>();
        mpTable.put("sstable_count", table.sstableCount);
        mpTable.put("old_sstable_count", table.oldSSTableCount);
        mpTable.put("sstables_in_each_level", table.sstablesInEachLevel);
        mpTable.put("sstable_bytes_in_each_level", table.sstableBytesInEachLevel);
        mpTable.put("max_sstable_size", table.maxSSTableSize);
        mpTable.put("twcs", table.twcs);
        mpTable.put("space_used_live", table.spaceUsedLive);
        mpTable.put("space_used_total", table.spaceUsedTotal);
        mpTable.put("space_used_by_snapshots_total", table.spaceUsedBySnapshotsTotal);
        if (table.offHeapUsed) {
            mpTable.put("off_heap_memory_used_total", table.offHeapMemoryUsedTotal);
        }
        mpTable.put("sstable_compression_ratio", table.sstableCompressionRatio);
        mpTable.put("number_of_partitions_estimate", table.numberOfPartitionsEstimate);
        mpTable.put("memtable_cell_count", table.memtableCellCount);
        mpTable.put("memtable_data_size", table.memtableDataSize);
        if (table.memtableOffHeapUsed) {
            mpTable.put("memtable_off_heap_memory_used", table.memtableOffHeapMemoryUsed);
        }
        mpTable.put("memtable_switch_count", table.memtableSwitchCount);
        mpTable.put("speculative_retries", table.speculativeRetries);
        mpTable.put("local_read_count", table.localReadCount);
        mpTable.put("local_read_latency_ms", String.format("%01.3f", table.localReadLatencyMs));
        mpTable.put("local_write_count", table.localWriteCount);
        mpTable.put("local_write_latency_ms", String.format("%01.3f", table.localWriteLatencyMs));
        mpTable.put("local_read_write_ratio", String.format("%01.5f", table.localReadWriteRatio));
        mpTable.put("pending_flushes", table.pendingFlushes);
        mpTable.put("percent_repaired", table.percentRepaired);
        mpTable.put("bytes_repaired", table.bytesRepaired);
        mpTable.put("bytes_unrepaired", table.bytesUnrepaired);
        mpTable.put("bytes_pending_repair", table.bytesPendingRepair);
        mpTable.put("bloom_filter_false_positives", table.bloomFilterFalsePositives);
        mpTable.put("bloom_filter_false_ratio", String.format("%01.5f", table.bloomFilterFalseRatio));
        mpTable.put("bloom_filter_space_used", table.bloomFilterSpaceUsed);
        if (table.bloomFilterOffHeapUsed) {
            mpTable.put("bloom_filter_off_heap_memory_used", table.bloomFilterOffHeapMemoryUsed);
        }
        if (table.indexSummaryOffHeapUsed) {
            mpTable.put("index_summary_off_heap_memory_used", table.indexSummaryOffHeapMemoryUsed);
        }
        if (table.compressionMetadataOffHeapUsed) {
            mpTable.put("compression_metadata_off_heap_memory_used", table.compressionMetadataOffHeapMemoryUsed);
        }
        mpTable.put("compacted_partition_minimum_bytes", table.compactedPartitionMinimumBytes);
        mpTable.put("compacted_partition_maximum_bytes", table.compactedPartitionMaximumBytes);
        mpTable.put("compacted_partition_mean_bytes", table.compactedPartitionMeanBytes);
        mpTable.put("average_live_cells_per_slice_last_five_minutes", table.averageLiveCellsPerSliceLastFiveMinutes);
        mpTable.put("maximum_live_cells_per_slice_last_five_minutes", table.maximumLiveCellsPerSliceLastFiveMinutes);
        mpTable.put("average_tombstones_per_slice_last_five_minutes", table.averageTombstonesPerSliceLastFiveMinutes);
        mpTable.put("maximum_tombstones_per_slice_last_five_minutes", table.maximumTombstonesPerSliceLastFiveMinutes);
        mpTable.put("droppable_tombstone_ratio", String.format("%01.5f", table.droppableTombstoneRatio));
        mpTable.put("top_size_partitions", table.topSizePartitions);
        mpTable.put("top_tombstone_partitions", table.topTombstonePartitions);
        if (this.locationCheck) {
            mpTable.put("sstables_in_correct_location", table.isInCorrectLocation);
        }
        mpTable.put("sai_local_query_latency_ms", String.format("%01.3f", table.saiQueryLatencyMs));
        mpTable.put("sai_post_filtering_read_latency", String.format("%01.3f", table.saiPostFilteringReadLatencyMs));
        mpTable.put("sai_disk_used_bytes", table.saiDiskUsedBytes);
        mpTable.put("sai_sstable_indexes_hit", table.saiSSTableIndexesHit);
        mpTable.put("sai_index_segments_hit", table.saiIndexSegmentsHit);
        mpTable.put("sai_rows_filtered", table.saiRowsFiltered);
        mpTable.put("sai_total_query_timeouts", table.saiTotalQueryTimeouts);
        mpTable.put("sai_total_queryable_index_ratio", table.saiTotalQueryableIndexRatio);
        return mpTable;
    }

    private void initializeKeyspaces(NodeProbe probe, boolean ignore, List<String> tableNames) {
        OptionFilter filter = new OptionFilter(ignore, tableNames);
        ArrayListMultimap selectedTableMbeans = ArrayListMultimap.create();
        HashMap<String, StatsKeyspace> keyspaceStats = new HashMap<String, StatsKeyspace>();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> tableMBeans = probe.getColumnFamilyStoreMBeanProxies();
        while (tableMBeans.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = tableMBeans.next();
            String keyspaceName = entry.getKey();
            ColumnFamilyStoreMBean tableProxy = entry.getValue();
            if (!filter.isKeyspaceIncluded(keyspaceName)) continue;
            StatsKeyspace stats = (StatsKeyspace)keyspaceStats.get(keyspaceName);
            if (stats == null) {
                stats = new StatsKeyspace(probe, keyspaceName);
                keyspaceStats.put(keyspaceName, stats);
            }
            stats.add(tableProxy);
            if (!filter.isTableIncluded(keyspaceName, tableProxy.getTableName())) continue;
            selectedTableMbeans.put((Object)keyspaceName, (Object)tableProxy);
        }
        this.numberOfTables = selectedTableMbeans.size();
        filter.verifyKeyspaces(probe.getKeyspaces());
        filter.verifyTables();
        for (Map.Entry entry : selectedTableMbeans.asMap().entrySet()) {
            String keyspaceName = (String)entry.getKey();
            Collection tables = (Collection)entry.getValue();
            StatsKeyspace statsKeyspace = (StatsKeyspace)keyspaceStats.get(keyspaceName);
            for (ColumnFamilyStoreMBean table : tables) {
                double localRLatency;
                Long bytesPendingRepair;
                Long bytesUnrepaired;
                Long bytesRepaired;
                Double percentRepaired;
                Long offHeapSize;
                Long compressionMetadataOffHeapSize;
                Long indexSummaryOffHeapSize;
                Long bloomFilterOffHeapSize;
                Long memtableOffHeapSize;
                StatsTable statsTable;
                String tableName;
                block23: {
                    tableName = table.getTableName();
                    statsTable = new StatsTable();
                    statsTable.fullName = keyspaceName + "." + tableName;
                    statsTable.keyspaceName = keyspaceName;
                    statsTable.tableName = tableName;
                    statsTable.isIndex = tableName.contains(".");
                    statsTable.sstableCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveSSTableCount");
                    statsTable.oldSSTableCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "OldVersionSSTableCount");
                    Long sstableSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MaxSSTableSize");
                    statsTable.maxSSTableSize = sstableSize == null ? 0L : sstableSize;
                    int[] leveledSStables = table.getSSTableCountPerLevel();
                    if (leveledSStables != null) {
                        statsTable.isLeveledSstable = true;
                        for (int level = 0; level < leveledSStables.length; ++level) {
                            int count = leveledSStables[level];
                            long maxCount = 4L;
                            if (level > 0) {
                                maxCount = (long)Math.pow(table.getLevelFanoutSize(), level);
                            }
                            statsTable.sstablesInEachLevel.add(count + (String)((long)count > maxCount ? "/" + maxCount : ""));
                        }
                    }
                    statsTable.sstableCountPerTWCSBucket = table.getSSTableCountPerTWCSBucket();
                    long[] leveledSSTablesBytes = table.getPerLevelSizeBytes();
                    if (leveledSSTablesBytes != null) {
                        statsTable.isLeveledSstable = true;
                        for (int level = 0; level < leveledSSTablesBytes.length; ++level) {
                            long size = leveledSSTablesBytes[level];
                            statsTable.sstableBytesInEachLevel.add(this.format(size, this.humanReadable));
                        }
                    }
                    if (this.locationCheck) {
                        statsTable.isInCorrectLocation = !table.hasMisplacedSSTables();
                    }
                    memtableOffHeapSize = null;
                    bloomFilterOffHeapSize = null;
                    indexSummaryOffHeapSize = null;
                    compressionMetadataOffHeapSize = null;
                    offHeapSize = null;
                    percentRepaired = null;
                    bytesRepaired = null;
                    bytesUnrepaired = null;
                    bytesPendingRepair = null;
                    try {
                        memtableOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableOffHeapSize");
                        bloomFilterOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterOffHeapMemoryUsed");
                        indexSummaryOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "IndexSummaryOffHeapMemoryUsed");
                        compressionMetadataOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionMetadataOffHeapMemoryUsed");
                        offHeapSize = memtableOffHeapSize + bloomFilterOffHeapSize + indexSummaryOffHeapSize + compressionMetadataOffHeapSize;
                        percentRepaired = (Double)probe.getColumnFamilyMetric(keyspaceName, tableName, "PercentRepaired");
                        bytesRepaired = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BytesRepaired");
                        bytesUnrepaired = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BytesUnrepaired");
                        bytesPendingRepair = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BytesPendingRepair");
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InstanceNotFoundException) break block23;
                        throw e;
                    }
                }
                statsTable.spaceUsedLive = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveDiskSpaceUsed"), this.humanReadable);
                statsTable.spaceUsedTotal = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "TotalDiskSpaceUsed"), this.humanReadable);
                statsTable.spaceUsedBySnapshotsTotal = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "SnapshotsSize"), this.humanReadable);
                this.maybeAddTWCSWindowWithMaxDuration(statsTable, probe, keyspaceName, tableName);
                if (offHeapSize != null) {
                    statsTable.offHeapUsed = true;
                    statsTable.offHeapMemoryUsedTotal = this.format(offHeapSize, this.humanReadable);
                }
                if (percentRepaired != null) {
                    statsTable.percentRepaired = (double)Math.round(100.0 * percentRepaired) / 100.0;
                }
                statsTable.bytesRepaired = bytesRepaired != null ? bytesRepaired : 0L;
                statsTable.bytesUnrepaired = bytesUnrepaired != null ? bytesUnrepaired : 0L;
                statsTable.bytesPendingRepair = bytesPendingRepair != null ? bytesPendingRepair : 0L;
                statsTable.sstableCompressionRatio = probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionRatio");
                Object estimatedPartitionCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "EstimatedPartitionCount");
                if (Long.valueOf(-1L).equals(estimatedPartitionCount)) {
                    estimatedPartitionCount = 0L;
                }
                statsTable.numberOfPartitionsEstimate = estimatedPartitionCount;
                statsTable.memtableCellCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableColumnsCount");
                statsTable.memtableDataSize = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableLiveDataSize"), this.humanReadable);
                if (memtableOffHeapSize != null) {
                    statsTable.memtableOffHeapUsed = true;
                    statsTable.memtableOffHeapMemoryUsed = this.format(memtableOffHeapSize, this.humanReadable);
                }
                statsTable.memtableSwitchCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableSwitchCount");
                statsTable.speculativeRetries = probe.getColumnFamilyMetric(keyspaceName, tableName, "SpeculativeRetries");
                statsTable.localReadCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getCount();
                double localReadLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getMean() / 1000.0;
                statsTable.localReadLatencyMs = localRLatency = localReadLatency > 0.0 ? localReadLatency : Double.NaN;
                statsTable.localWriteCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getCount();
                double localWriteLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getMean() / 1000.0;
                double localWLatency = localWriteLatency > 0.0 ? localWriteLatency : Double.NaN;
                statsTable.localReadWriteRatio = statsTable.localWriteCount > 0L ? (double)statsTable.localReadCount / (double)statsTable.localWriteCount : 0.0;
                statsTable.localWriteLatencyMs = localWLatency;
                statsTable.pendingFlushes = probe.getColumnFamilyMetric(keyspaceName, tableName, "PendingFlushes");
                statsTable.bloomFilterFalsePositives = probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterFalsePositives");
                statsTable.bloomFilterFalseRatio = probe.getColumnFamilyMetric(keyspaceName, tableName, "RecentBloomFilterFalseRatio");
                statsTable.bloomFilterSpaceUsed = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterDiskSpaceUsed"), this.humanReadable);
                if (bloomFilterOffHeapSize != null) {
                    statsTable.bloomFilterOffHeapUsed = true;
                    statsTable.bloomFilterOffHeapMemoryUsed = this.format(bloomFilterOffHeapSize, this.humanReadable);
                }
                if (indexSummaryOffHeapSize != null) {
                    statsTable.indexSummaryOffHeapUsed = true;
                    statsTable.indexSummaryOffHeapMemoryUsed = this.format(indexSummaryOffHeapSize, this.humanReadable);
                }
                if (compressionMetadataOffHeapSize != null) {
                    statsTable.compressionMetadataOffHeapUsed = true;
                    statsTable.compressionMetadataOffHeapMemoryUsed = this.format(compressionMetadataOffHeapSize, this.humanReadable);
                }
                statsTable.compactedPartitionMinimumBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MinPartitionSize");
                statsTable.compactedPartitionMaximumBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MaxPartitionSize");
                statsTable.compactedPartitionMeanBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MeanPartitionSize");
                CassandraMetricsRegistry.JmxHistogramMBean histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveScannedHistogram");
                statsTable.averageLiveCellsPerSliceLastFiveMinutes = histogram.getMean();
                statsTable.maximumLiveCellsPerSliceLastFiveMinutes = histogram.getMax();
                histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "TombstoneScannedHistogram");
                statsTable.averageTombstonesPerSliceLastFiveMinutes = histogram.getMean();
                statsTable.maximumTombstonesPerSliceLastFiveMinutes = histogram.getMax();
                statsTable.droppableTombstoneRatio = probe.getDroppableTombstoneRatio(keyspaceName, tableName);
                statsTable.topSizePartitions = this.format(table.getTopSizePartitions(), this.humanReadable);
                if (table.getTopSizePartitionsLastUpdate() != null) {
                    statsTable.topSizePartitionsLastUpdate = this.millisToDateString(table.getTopSizePartitionsLastUpdate());
                }
                statsTable.topTombstonePartitions = table.getTopTombstonePartitions();
                if (table.getTopTombstonePartitionsLastUpdate() != null) {
                    statsTable.topTombstonePartitionsLastUpdate = this.millisToDateString(table.getTopTombstonePartitionsLastUpdate());
                }
                if (!SchemaConstants.isSystemKeyspace(keyspaceName)) {
                    Object totalIndexCount = probe.getSaiMetric(keyspaceName, tableName, "TotalIndexCount");
                    int n = statsTable.saiTotalIndexCount = totalIndexCount != null ? (Integer)totalIndexCount : 0;
                    if (statsTable.saiTotalIndexCount > 0) {
                        Object queryLatencyMetric = probe.getSaiMetric(keyspaceName, tableName, "QueryLatency");
                        double queryLatency = this.getMetricMean(queryLatencyMetric);
                        statsTable.saiQueryLatencyMs = queryLatency > 0.0 ? queryLatency : Double.NaN;
                        Object PostFilteringReadLatency = probe.getSaiMetric(keyspaceName, tableName, "PostFilteringReadLatency");
                        double postfilteringreadlatency = this.getMetricMean(PostFilteringReadLatency);
                        statsTable.saiPostFilteringReadLatencyMs = postfilteringreadlatency > 0.0 ? postfilteringreadlatency : Double.NaN;
                        Object diskUsedBytes = probe.getSaiMetric(keyspaceName, tableName, "DiskUsedBytes");
                        long saidiskusedbytes = diskUsedBytes != null ? (Long)diskUsedBytes : 0L;
                        statsTable.saiDiskUsedBytes = this.format(saidiskusedbytes, this.humanReadable);
                        Object SSTableIndexesHit = probe.getSaiMetric(keyspaceName, tableName, "SSTableIndexesHit");
                        statsTable.saiSSTableIndexesHit = this.getMetricMean(SSTableIndexesHit);
                        Object IndexSegmentsHit = probe.getSaiMetric(keyspaceName, tableName, "IndexSegmentsHit");
                        statsTable.saiIndexSegmentsHit = this.getMetricMean(IndexSegmentsHit);
                        Object RowsFiltered = probe.getSaiMetric(keyspaceName, tableName, "RowsFiltered");
                        statsTable.saiRowsFiltered = this.getMetricMean(RowsFiltered);
                        Object totalQueryTimeouts = probe.getSaiMetric(keyspaceName, tableName, "TotalQueryTimeouts");
                        statsTable.saiTotalQueryTimeouts = totalQueryTimeouts != null ? (Long)totalQueryTimeouts : 0L;
                        Object totalQueryableIndexCount = probe.getSaiMetric(keyspaceName, tableName, "TotalQueryableIndexCount");
                        int saiTotalQueryableIndexCount = totalQueryableIndexCount != null ? (Integer)totalQueryableIndexCount : 0;
                        statsTable.saiTotalQueryableIndexRatio = String.format("%d/%d", saiTotalQueryableIndexCount, statsTable.saiTotalIndexCount);
                    }
                }
                statsKeyspace.tables.add(statsTable);
            }
            this.keyspaces.add(statsKeyspace);
        }
    }

    private double getMetricMean(Object metricObject) {
        if (metricObject instanceof CassandraMetricsRegistry.JmxTimerMBean) {
            return ((CassandraMetricsRegistry.JmxTimerMBean)metricObject).getMean() / 1000.0;
        }
        if (metricObject instanceof CassandraMetricsRegistry.JmxHistogramMBean) {
            return (double)Math.round(((CassandraMetricsRegistry.JmxHistogramMBean)metricObject).getMean() * 100.0) / 100.0;
        }
        throw new IllegalArgumentException("Unsupported metric object type: " + metricObject.getClass().getName());
    }

    private void maybeAddTWCSWindowWithMaxDuration(StatsTable statsTable, NodeProbe probe, String keyspaceName, String tableName) {
        Map<String, String> compactionParameters = probe.getCfsProxy(statsTable.keyspaceName, statsTable.tableName).getCompactionParameters();
        if (compactionParameters == null) {
            return;
        }
        String compactor = compactionParameters.get("class");
        if (compactor == null || !compactor.endsWith(TimeWindowCompactionStrategy.class.getSimpleName())) {
            return;
        }
        String unit = compactionParameters.get("compaction_window_unit");
        String size = compactionParameters.get("compaction_window_size");
        statsTable.twcsDurationInMillis = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MaxSSTableDuration");
        String maxDuration = this.millisToDuration(statsTable.twcsDurationInMillis);
        statsTable.twcs = String.format("%s %s, max duration: %s", size, unit, maxDuration);
    }

    private String format(long bytes, boolean humanReadable) {
        return humanReadable ? FileUtils.stringifyFileSize(bytes) : Long.toString(bytes);
    }

    private Map<String, String> format(Map<String, Long> map, boolean humanReadable) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            retMap.put(entry.getKey(), this.format(entry.getValue(), humanReadable));
        }
        return retMap;
    }

    private String millisToDateString(long millis) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date(millis));
    }

    private String millisToDuration(long millis) {
        return DurationFormatUtils.formatDurationWords((long)millis, (boolean)true, (boolean)true);
    }

    public List<StatsTable> getSortedFilteredTables() {
        int k;
        List<StatsTable> tables = new ArrayList<StatsTable>();
        for (StatsKeyspace keyspace : this.keyspaces) {
            tables.addAll(keyspace.tables);
        }
        Collections.sort(tables, new StatsTableComparator(this.sortKey, this.humanReadable));
        int n = k = tables.size() >= this.top ? this.top : tables.size();
        if (k > 0) {
            tables = tables.subList(0, k);
        }
        return tables;
    }

    protected boolean isTestTableStatsHolder() {
        return false;
    }

    private static class OptionFilter {
        private final Map<String, List<String>> filter = new HashMap<String, List<String>>();
        private final Map<String, List<String>> verifier = new HashMap<String, List<String>>();
        private final List<String> filterList = new ArrayList<String>();
        private final boolean ignoreMode;

        OptionFilter(boolean ignoreMode, List<String> filterList) {
            this.filterList.addAll(filterList);
            this.ignoreMode = ignoreMode;
            for (String s : filterList) {
                String[] keyValues = s.split("\\.", 2);
                if (!this.filter.containsKey(keyValues[0])) {
                    this.filter.put(keyValues[0], new ArrayList());
                    this.verifier.put(keyValues[0], new ArrayList());
                }
                if (keyValues.length != 2) continue;
                this.filter.get(keyValues[0]).add(keyValues[1]);
                this.verifier.get(keyValues[0]).add(keyValues[1]);
            }
        }

        public boolean isTableIncluded(String keyspace, String table) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            List<String> tables = this.filter.get(keyspace);
            if (tables == null) {
                return this.ignoreMode;
            }
            if (tables.isEmpty()) {
                return !this.ignoreMode;
            }
            this.verifier.get(keyspace).remove(table);
            return this.ignoreMode ^ tables.contains(table);
        }

        public boolean isKeyspaceIncluded(String keyspace) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            return this.filter.get(keyspace) != null || this.ignoreMode;
        }

        public void verifyKeyspaces(Collection<String> keyspaces) {
            for (String ks : this.verifier.keySet()) {
                if (keyspaces.contains(ks)) continue;
                throw new IllegalArgumentException("Unknown keyspace: " + ks);
            }
        }

        public void verifyTables() {
            for (String ks : this.filter.keySet()) {
                if (this.verifier.get(ks).isEmpty()) continue;
                throw new IllegalArgumentException("Unknown tables: " + this.verifier.get(ks) + " in keyspace: " + ks);
            }
        }
    }
}

