/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Objects;
import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;

public class SyncNodePair {
    public static IVersionedSerializer<SyncNodePair> serializer = new NodePairSerializer();
    public final InetAddressAndPort coordinator;
    public final InetAddressAndPort peer;

    public SyncNodePair(InetAddressAndPort coordinator, InetAddressAndPort peer) {
        this.coordinator = coordinator;
        this.peer = peer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncNodePair nodePair = (SyncNodePair)o;
        return this.coordinator.equals(nodePair.coordinator) && this.peer.equals(nodePair.peer);
    }

    public String toString() {
        return this.coordinator.toString() + " - " + this.peer.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.coordinator, this.peer});
    }

    public static class NodePairSerializer
    implements IVersionedSerializer<SyncNodePair> {
        @Override
        public void serialize(SyncNodePair nodePair, DataOutputPlus out, int version) throws IOException {
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(nodePair.coordinator, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(nodePair.peer, out, version);
        }

        @Override
        public SyncNodePair deserialize(DataInputPlus in, int version) throws IOException {
            InetAddressAndPort ep1 = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            InetAddressAndPort ep2 = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            return new SyncNodePair(ep1, ep2);
        }

        @Override
        public long serializedSize(SyncNodePair nodePair, int version) {
            return InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(nodePair.coordinator, version) + InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(nodePair.peer, version);
        }
    }
}

