/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.metrics.SamplingManager;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.MonotonicClock;

public abstract class Sampler<T> {
    private static long DISABLED = -1L;
    private static final BiFunction<SamplerType, SamplingManager.ResultBuilder, SamplingManager.ResultBuilder> FrequencySamplerFomatter = (type, resultBuilder) -> resultBuilder.forType((SamplerType)((Object)type), type.description).addColumn("Table", "table").addColumn("Partition", "value").addColumn("Count", "count").addColumn("+/-", "error");
    @VisibleForTesting
    MonotonicClock clock = MonotonicClock.Global.approxTime;
    @VisibleForTesting
    public static final ExecutorPlus samplerExecutor = (ExecutorPlus)ExecutorFactory.Global.executorFactory().withJmxInternal().configureSequential("Sampler").withQueueLimit(1000).withRejectedExecutionHandler((runnable, executor) -> MessagingService.instance().metrics.recordSelfDroppedMessage(Verb._SAMPLE)).build();
    private long endTimeNanos = -1L;

    public void addSample(T item, int value) {
        if (this.isEnabled()) {
            samplerExecutor.submit(() -> this.insert(item, value));
        }
    }

    protected abstract void insert(T var1, long var2);

    public boolean isEnabled() {
        return this.endTimeNanos != DISABLED;
    }

    public void disable() {
        this.endTimeNanos = DISABLED;
    }

    public boolean isActive() {
        return this.isEnabled() && this.clock.now() <= this.endTimeNanos;
    }

    public void updateEndTime(long endTimeMillis) {
        this.endTimeNanos = endTimeMillis;
    }

    public abstract void beginSampling(int var1, long var2);

    public abstract List<Sample<T>> finishSampling(int var1);

    public abstract String toString(T var1);

    public static void shutdownNowAndWait(long time, TimeUnit units) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(time, units, samplerExecutor);
    }

    public static class Sample<S>
    implements Serializable {
        public final S value;
        public final long count;
        public final long error;

        public Sample(S value, long count, long error) {
            this.value = value;
            this.count = count;
            this.error = error;
        }

        public String toString() {
            return "Sample [value=" + this.value + ", count=" + this.count + ", error=" + this.error + "]";
        }
    }

    public static enum SamplerType {
        READS("Frequency of reads by partition", FrequencySamplerFomatter),
        WRITES("Frequency of writes by partition", FrequencySamplerFomatter),
        LOCAL_READ_TIME("Longest read query times", (samplerType, resultBuilder) -> resultBuilder.forType((SamplerType)((Object)samplerType), samplerType.description).addColumn("Query", "value").addColumn("Microseconds", "count")),
        READ_ROW_COUNT("Partitions read with the most rows", (samplerType, resultBuilder) -> resultBuilder.forType((SamplerType)((Object)samplerType), samplerType.description).addColumn("Table", "table").addColumn("Partition", "value").addColumn("Rows", "count")),
        READ_TOMBSTONE_COUNT("Partitions read with the most tombstones", (samplerType, resultBuilder) -> resultBuilder.forType((SamplerType)((Object)samplerType), samplerType.description).addColumn("Table", "table").addColumn("Partition", "value").addColumn("Tombstones", "count")),
        READ_SSTABLE_COUNT("Partitions read with the most sstables", (samplerType, resultBuilder) -> resultBuilder.forType((SamplerType)((Object)samplerType), samplerType.description).addColumn("Table", "table").addColumn("Partition", "value").addColumn("SSTables", "count")),
        WRITE_SIZE("Max mutation size by partition", (samplerType, resultBuilder) -> resultBuilder.forType((SamplerType)((Object)samplerType), samplerType.description).addColumn("Table", "table").addColumn("Partition", "value").addColumn("Bytes", "count")),
        CAS_CONTENTIONS("Frequency of CAS contention by partition", FrequencySamplerFomatter);

        private final String description;
        private final BiFunction<SamplerType, SamplingManager.ResultBuilder, SamplingManager.ResultBuilder> formatter;

        private SamplerType(String description, BiFunction<SamplerType, SamplingManager.ResultBuilder, SamplingManager.ResultBuilder> formatter) {
            this.description = description;
            this.formatter = formatter;
        }

        void format(SamplingManager.ResultBuilder resultBuilder, PrintStream ps) {
            this.formatter.apply(this, resultBuilder).print(ps);
        }
    }
}

