/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.exceptions.UnknownColumnException;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.schema.TableMetadata;

public class StatsComponent {
    public final Map<MetadataType, MetadataComponent> metadata;

    public StatsComponent(Map<MetadataType, MetadataComponent> metadata) {
        this.metadata = ImmutableMap.copyOf(metadata);
    }

    public static StatsComponent load(Descriptor descriptor) throws IOException {
        return StatsComponent.load(descriptor, MetadataType.values());
    }

    public static StatsComponent load(Descriptor descriptor, MetadataType ... types) throws IOException {
        Map<MetadataType, MetadataComponent> metadata;
        try {
            metadata = descriptor.getMetadataSerializer().deserialize(descriptor, EnumSet.copyOf(Arrays.asList(types)));
        }
        catch (IOException e) {
            throw new CorruptSSTableException((Throwable)e, descriptor.fileFor(SSTableFormat.Components.STATS));
        }
        return new StatsComponent(metadata);
    }

    public SerializationHeader.Component serializationHeader() {
        return (SerializationHeader.Component)this.metadata.get((Object)MetadataType.HEADER);
    }

    public SerializationHeader serializationHeader(TableMetadata metadata) {
        SerializationHeader.Component header = this.serializationHeader();
        if (header != null) {
            try {
                return header.toHeader(metadata);
            }
            catch (UnknownColumnException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return null;
    }

    public CompactionMetadata compactionMetadata() {
        return (CompactionMetadata)this.metadata.get((Object)MetadataType.COMPACTION);
    }

    public ValidationMetadata validationMetadata() {
        return (ValidationMetadata)this.metadata.get((Object)MetadataType.VALIDATION);
    }

    public StatsMetadata statsMetadata() {
        return (StatsMetadata)this.metadata.get((Object)MetadataType.STATS);
    }

    public void save(Descriptor desc) {
        File file = desc.fileFor(SSTableFormat.Components.STATS);
        try (SequentialWriter out = new SequentialWriter(file, SequentialWriterOption.DEFAULT);){
            desc.getMetadataSerializer().serialize(this.metadata, out, desc.version);
            out.finish();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, file.path());
        }
    }
}

