/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Converters;
import org.apache.cassandra.config.DataRateSpec;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.InheritingClass;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.RepairConfig;
import org.apache.cassandra.config.Replaces;
import org.apache.cassandra.config.ReplacesList;
import org.apache.cassandra.config.ReplicaFilteringProtectionOptions;
import org.apache.cassandra.config.StorageAttachedIndexOptions;
import org.apache.cassandra.config.SubnetGroups;
import org.apache.cassandra.config.TransparentDataEncryptionOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.service.StartupChecks;
import org.apache.cassandra.utils.StorageCompatibilityMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    public static final String PROPERTY_PREFIX = "cassandra.";
    public String cluster_name = "Test Cluster";
    public ParameterizedClass authenticator;
    public ParameterizedClass authorizer;
    public ParameterizedClass role_manager;
    public ParameterizedClass crypto_provider;
    public ParameterizedClass network_authorizer;
    public ParameterizedClass cidr_authorizer;
    @Replaces(oldName="permissions_validity_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound permissions_validity = new DurationSpec.IntMillisecondsBound("2s");
    public volatile int permissions_cache_max_entries = 1000;
    @Replaces(oldName="permissions_update_interval_in_ms", converter=Converters.MILLIS_CUSTOM_DURATION, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound permissions_update_interval = null;
    public volatile boolean permissions_cache_active_update = false;
    @Replaces(oldName="roles_validity_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound roles_validity = new DurationSpec.IntMillisecondsBound("2s");
    public volatile int roles_cache_max_entries = 1000;
    @Replaces(oldName="roles_update_interval_in_ms", converter=Converters.MILLIS_CUSTOM_DURATION, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound roles_update_interval = null;
    public volatile boolean roles_cache_active_update = false;
    @Replaces(oldName="credentials_validity_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound credentials_validity = new DurationSpec.IntMillisecondsBound("2s");
    public volatile int credentials_cache_max_entries = 1000;
    @Replaces(oldName="credentials_update_interval_in_ms", converter=Converters.MILLIS_CUSTOM_DURATION, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound credentials_update_interval = null;
    public volatile boolean credentials_cache_active_update = false;
    public String partitioner;
    public boolean auto_bootstrap = true;
    public volatile boolean hinted_handoff_enabled = true;
    public Set<String> hinted_handoff_disabled_datacenters = Sets.newConcurrentHashSet();
    @Replaces(oldName="max_hint_window_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound max_hint_window = new DurationSpec.IntMillisecondsBound("3h");
    public String hints_directory;
    public boolean hint_window_persistent_enabled = true;
    public volatile boolean force_new_prepared_statement_behaviour = false;
    public ParameterizedClass seed_provider;
    public DiskAccessMode disk_access_mode = DiskAccessMode.mmap_index_only;
    public DiskFailurePolicy disk_failure_policy = DiskFailurePolicy.ignore;
    public CommitFailurePolicy commit_failure_policy = CommitFailurePolicy.stop;
    @Deprecated(since="5.0.1")
    public volatile boolean use_deterministic_table_id = false;
    public String initial_token;
    public Integer num_tokens;
    public String allocate_tokens_for_keyspace = null;
    public Integer allocate_tokens_for_local_replication_factor = null;
    @Replaces(oldName="native_transport_idle_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public DurationSpec.LongMillisecondsBound native_transport_idle_timeout = new DurationSpec.LongMillisecondsBound("0ms");
    @Replaces(oldName="request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound request_timeout = new DurationSpec.LongMillisecondsBound("10000ms");
    @Replaces(oldName="read_request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound read_request_timeout = new DurationSpec.LongMillisecondsBound("5000ms");
    @Replaces(oldName="range_request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound range_request_timeout = new DurationSpec.LongMillisecondsBound("10000ms");
    @Replaces(oldName="write_request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound write_request_timeout = new DurationSpec.LongMillisecondsBound("2000ms");
    @Replaces(oldName="counter_write_request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound counter_write_request_timeout = new DurationSpec.LongMillisecondsBound("5000ms");
    @Replaces(oldName="cas_contention_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound cas_contention_timeout = new DurationSpec.LongMillisecondsBound("1800ms");
    @Replaces(oldName="truncate_request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound truncate_request_timeout = new DurationSpec.LongMillisecondsBound("60000ms");
    @Replaces(oldName="repair_request_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound repair_request_timeout = new DurationSpec.LongMillisecondsBound("120000ms");
    public Integer streaming_connections_per_host = 1;
    @Replaces(oldName="streaming_keep_alive_period_in_secs", converter=Converters.SECONDS_DURATION, deprecated=true)
    public DurationSpec.IntSecondsBound streaming_keep_alive_period = new DurationSpec.IntSecondsBound("300s");
    @Replaces(oldName="cross_node_timeout", converter=Converters.IDENTITY, deprecated=true)
    public boolean internode_timeout = true;
    @Replaces(oldName="slow_query_log_timeout_in_ms", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public volatile DurationSpec.LongMillisecondsBound slow_query_log_timeout = new DurationSpec.LongMillisecondsBound("500ms");
    public volatile DurationSpec.LongMillisecondsBound stream_transfer_task_timeout = new DurationSpec.LongMillisecondsBound("12h");
    public volatile double phi_convict_threshold = 8.0;
    public int concurrent_reads = 32;
    public int concurrent_writes = 32;
    public int concurrent_counter_writes = 32;
    public int concurrent_materialized_view_writes = 32;
    public int available_processors = -1;
    public int memtable_flush_writers = 0;
    @Replaces(oldName="memtable_heap_space_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound memtable_heap_space;
    @Replaces(oldName="memtable_offheap_space_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound memtable_offheap_space;
    public Float memtable_cleanup_threshold = null;
    public MemtableOptions memtable;
    @Deprecated(since="4.0")
    public volatile Integer repair_session_max_tree_depth = null;
    @Replaces(oldName="repair_session_space_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public volatile DataStorageSpec.IntMebibytesBound repair_session_space = null;
    public volatile int concurrent_merkle_tree_requests = 0;
    public volatile boolean use_offheap_merkle_trees = true;
    public int storage_port = 7000;
    public int ssl_storage_port = 7001;
    public String listen_address;
    public String listen_interface;
    public boolean listen_interface_prefer_ipv6 = false;
    public String broadcast_address;
    public boolean listen_on_broadcast_address = false;
    public ParameterizedClass internode_authenticator;
    public boolean traverse_auth_from_root = false;
    public String rpc_address;
    public String rpc_interface;
    public boolean rpc_interface_prefer_ipv6 = false;
    public String broadcast_rpc_address;
    public boolean rpc_keepalive = true;
    @Replaces(oldName="internode_max_message_size_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_max_message_size;
    @ReplacesList(value={@Replaces(oldName="internode_socket_send_buffer_size_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true), @Replaces(oldName="internode_send_buff_size_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)})
    public DataStorageSpec.IntBytesBound internode_socket_send_buffer_size = new DataStorageSpec.IntBytesBound("0B");
    @ReplacesList(value={@Replaces(oldName="internode_socket_receive_buffer_size_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true), @Replaces(oldName="internode_recv_buff_size_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)})
    public DataStorageSpec.IntBytesBound internode_socket_receive_buffer_size = new DataStorageSpec.IntBytesBound("0B");
    @Replaces(oldName="internode_application_send_queue_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_application_send_queue_capacity = new DataStorageSpec.IntBytesBound("4MiB");
    @Replaces(oldName="internode_application_send_queue_reserve_endpoint_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_application_send_queue_reserve_endpoint_capacity = new DataStorageSpec.IntBytesBound("128MiB");
    @Replaces(oldName="internode_application_send_queue_reserve_global_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_application_send_queue_reserve_global_capacity = new DataStorageSpec.IntBytesBound("512MiB");
    @Replaces(oldName="internode_application_receive_queue_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_application_receive_queue_capacity = new DataStorageSpec.IntBytesBound("4MiB");
    @Replaces(oldName="internode_application_receive_queue_reserve_endpoint_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_application_receive_queue_reserve_endpoint_capacity = new DataStorageSpec.IntBytesBound("128MiB");
    @Replaces(oldName="internode_application_receive_queue_reserve_global_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound internode_application_receive_queue_reserve_global_capacity = new DataStorageSpec.IntBytesBound("512MiB");
    @Replaces(oldName="internode_tcp_connect_timeout_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound internode_tcp_connect_timeout = new DurationSpec.IntMillisecondsBound("2s");
    @Replaces(oldName="internode_tcp_user_timeout_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound internode_tcp_user_timeout = new DurationSpec.IntMillisecondsBound("30s");
    @Replaces(oldName="internode_streaming_tcp_user_timeout_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound internode_streaming_tcp_user_timeout = new DurationSpec.IntMillisecondsBound("300s");
    public boolean start_native_transport = true;
    public int native_transport_port = 9042;
    @Deprecated(since="5.0")
    public Integer native_transport_port_ssl = null;
    public int native_transport_max_threads = 128;
    @Replaces(oldName="native_transport_max_frame_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound native_transport_max_frame_size = new DataStorageSpec.IntMebibytesBound("16MiB");
    public int native_transport_max_auth_threads = 4;
    public volatile long native_transport_max_concurrent_connections = -1L;
    public volatile long native_transport_max_concurrent_connections_per_ip = -1L;
    public boolean native_transport_flush_in_batches_legacy = false;
    public volatile boolean native_transport_allow_older_protocols = true;
    @Replaces(oldName="native_transport_max_concurrent_requests_in_bytes_per_ip", converter=Converters.BYTES_CUSTOM_DATASTORAGE, deprecated=true)
    public volatile DataStorageSpec.LongBytesBound native_transport_max_request_data_in_flight_per_ip = null;
    @Replaces(oldName="native_transport_max_concurrent_requests_in_bytes", converter=Converters.BYTES_CUSTOM_DATASTORAGE, deprecated=true)
    public volatile DataStorageSpec.LongBytesBound native_transport_max_request_data_in_flight = null;
    public volatile boolean native_transport_rate_limiting_enabled = false;
    public volatile int native_transport_max_requests_per_second = 1000000;
    @Replaces(oldName="native_transport_receive_queue_capacity_in_bytes", converter=Converters.BYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntBytesBound native_transport_receive_queue_capacity = new DataStorageSpec.IntBytesBound("1MiB");
    @Replaces(oldName="max_value_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound max_value_size = new DataStorageSpec.IntMebibytesBound("256MiB");
    public boolean snapshot_before_compaction = false;
    public boolean auto_snapshot = true;
    public String auto_snapshot_ttl;
    public volatile long snapshot_links_per_second = 0L;
    @Replaces(oldName="column_index_size_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public volatile DataStorageSpec.IntKibibytesBound column_index_size;
    @Replaces(oldName="column_index_cache_size_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public volatile DataStorageSpec.IntKibibytesBound column_index_cache_size = new DataStorageSpec.IntKibibytesBound("2KiB");
    @Replaces(oldName="batch_size_warn_threshold_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public volatile DataStorageSpec.IntKibibytesBound batch_size_warn_threshold = new DataStorageSpec.IntKibibytesBound("5KiB");
    @Replaces(oldName="batch_size_fail_threshold_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public volatile DataStorageSpec.IntKibibytesBound batch_size_fail_threshold = new DataStorageSpec.IntKibibytesBound("50KiB");
    public Integer unlogged_batch_across_partitions_warn_threshold = 10;
    public volatile Integer concurrent_compactors;
    @Replaces(oldName="compaction_throughput_mb_per_sec", converter=Converters.MEBIBYTES_PER_SECOND_DATA_RATE, deprecated=true)
    public volatile DataRateSpec.LongBytesPerSecondBound compaction_throughput = new DataRateSpec.LongBytesPerSecondBound("64MiB/s");
    @Replaces(oldName="min_free_space_per_drive_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound min_free_space_per_drive = new DataStorageSpec.IntMebibytesBound("50MiB");
    public volatile Double max_space_usable_for_compactions_in_percentage = 0.95;
    public volatile int concurrent_materialized_view_builders = 1;
    public volatile int reject_repair_compaction_threshold = Integer.MAX_VALUE;
    public volatile int concurrent_index_builders = 2;
    @Deprecated(since="4.1")
    public int max_streaming_retries = 3;
    @Replaces(oldName="stream_throughput_outbound_megabits_per_sec", converter=Converters.MEGABITS_TO_BYTES_PER_SECOND_DATA_RATE, deprecated=true)
    public volatile DataRateSpec.LongBytesPerSecondBound stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound("24MiB/s");
    @Replaces(oldName="inter_dc_stream_throughput_outbound_megabits_per_sec", converter=Converters.MEGABITS_TO_BYTES_PER_SECOND_DATA_RATE, deprecated=true)
    public volatile DataRateSpec.LongBytesPerSecondBound inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound("24MiB/s");
    public volatile DataRateSpec.LongBytesPerSecondBound entire_sstable_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound("24MiB/s");
    public volatile DataRateSpec.LongBytesPerSecondBound entire_sstable_inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound("24MiB/s");
    public String[] data_file_directories = new String[0];
    public final SSTableConfig sstable = new SSTableConfig();
    public String local_system_data_file_directory;
    public String saved_caches_directory;
    public String commitlog_directory;
    @Replaces(oldName="commitlog_total_space_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound commitlog_total_space;
    public CommitLogSync commitlog_sync;
    @Replaces(oldName="commitlog_sync_group_window_in_ms", converter=Converters.MILLIS_DURATION_DOUBLE, deprecated=true)
    public DurationSpec.IntMillisecondsBound commitlog_sync_group_window = new DurationSpec.IntMillisecondsBound("0ms");
    @Replaces(oldName="commitlog_sync_period_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public DurationSpec.IntMillisecondsBound commitlog_sync_period = new DurationSpec.IntMillisecondsBound("0ms");
    @Replaces(oldName="commitlog_segment_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound commitlog_segment_size = new DataStorageSpec.IntMebibytesBound("32MiB");
    public ParameterizedClass commitlog_compression;
    public FlushCompression flush_compression = FlushCompression.fast;
    public int commitlog_max_compression_buffers_in_pool = 3;
    public DiskAccessMode commitlog_disk_access_mode = DiskAccessMode.legacy;
    @Replaces(oldName="periodic_commitlog_sync_lag_block_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public DurationSpec.IntMillisecondsBound periodic_commitlog_sync_lag_block;
    public TransparentDataEncryptionOptions transparent_data_encryption_options = new TransparentDataEncryptionOptions();
    @Replaces(oldName="max_mutation_size_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntKibibytesBound max_mutation_size;
    public boolean cdc_enabled = false;
    public volatile boolean cdc_block_writes = true;
    public volatile boolean cdc_on_repair_enabled = true;
    public String cdc_raw_directory;
    @Replaces(oldName="cdc_total_space_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound cdc_total_space = new DataStorageSpec.IntMebibytesBound("0MiB");
    @Replaces(oldName="cdc_free_space_check_interval_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public DurationSpec.IntMillisecondsBound cdc_free_space_check_interval = new DurationSpec.IntMillisecondsBound("250ms");
    public String endpoint_snitch;
    public boolean dynamic_snitch = true;
    @Replaces(oldName="dynamic_snitch_update_interval_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public DurationSpec.IntMillisecondsBound dynamic_snitch_update_interval = new DurationSpec.IntMillisecondsBound("100ms");
    @Replaces(oldName="dynamic_snitch_reset_interval_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public DurationSpec.IntMillisecondsBound dynamic_snitch_reset_interval = new DurationSpec.IntMillisecondsBound("10m");
    public double dynamic_snitch_badness_threshold = 1.0;
    public String failure_detector = "FailureDetector";
    public EncryptionOptions.ServerEncryptionOptions server_encryption_options = new EncryptionOptions.ServerEncryptionOptions();
    public EncryptionOptions client_encryption_options = new EncryptionOptions();
    public InternodeCompression internode_compression = InternodeCompression.none;
    @Replaces(oldName="hinted_handoff_throttle_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntKibibytesBound hinted_handoff_throttle = new DataStorageSpec.IntKibibytesBound("1024KiB");
    @Replaces(oldName="batchlog_replay_throttle_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntKibibytesBound batchlog_replay_throttle = new DataStorageSpec.IntKibibytesBound("1024KiB");
    public int max_hints_delivery_threads = 2;
    @Replaces(oldName="hints_flush_period_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public DurationSpec.IntMillisecondsBound hints_flush_period = new DurationSpec.IntMillisecondsBound("10s");
    @Replaces(oldName="max_hints_file_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound max_hints_file_size = new DataStorageSpec.IntMebibytesBound("128MiB");
    public volatile DataStorageSpec.LongBytesBound max_hints_size_per_host = new DataStorageSpec.LongBytesBound("0B");
    public ParameterizedClass hints_compression;
    public volatile boolean auto_hints_cleanup_enabled = false;
    public volatile boolean transfer_hints_on_decommission = true;
    public volatile boolean incremental_backups = false;
    public boolean trickle_fsync = false;
    @Replaces(oldName="trickle_fsync_interval_in_kb", converter=Converters.KIBIBYTES_DATASTORAGE, deprecated=true)
    public DataStorageSpec.IntKibibytesBound trickle_fsync_interval = new DataStorageSpec.IntKibibytesBound("10240KiB");
    @Nullable
    @Replaces(oldName="sstable_preemptive_open_interval_in_mb", converter=Converters.NEGATIVE_MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public volatile DataStorageSpec.IntMebibytesBound sstable_preemptive_open_interval = new DataStorageSpec.IntMebibytesBound("50MiB");
    public volatile boolean key_cache_migrate_during_compaction = true;
    public volatile int key_cache_keys_to_save = Integer.MAX_VALUE;
    @Replaces(oldName="key_cache_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_LONG, deprecated=true)
    public DataStorageSpec.LongMebibytesBound key_cache_size = null;
    @Replaces(oldName="key_cache_save_period", converter=Converters.SECONDS_CUSTOM_DURATION)
    public volatile DurationSpec.IntSecondsBound key_cache_save_period = new DurationSpec.IntSecondsBound("4h");
    public String row_cache_class_name = "org.apache.cassandra.cache.OHCProvider";
    @Replaces(oldName="row_cache_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_LONG, deprecated=true)
    public DataStorageSpec.LongMebibytesBound row_cache_size = new DataStorageSpec.LongMebibytesBound("0MiB");
    @Replaces(oldName="row_cache_save_period", converter=Converters.SECONDS_CUSTOM_DURATION)
    public volatile DurationSpec.IntSecondsBound row_cache_save_period = new DurationSpec.IntSecondsBound("0s");
    public volatile int row_cache_keys_to_save = Integer.MAX_VALUE;
    @Replaces(oldName="counter_cache_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_LONG, deprecated=true)
    public DataStorageSpec.LongMebibytesBound counter_cache_size = null;
    @Replaces(oldName="counter_cache_save_period", converter=Converters.SECONDS_CUSTOM_DURATION)
    public volatile DurationSpec.IntSecondsBound counter_cache_save_period = new DurationSpec.IntSecondsBound("7200s");
    public volatile int counter_cache_keys_to_save = Integer.MAX_VALUE;
    public DataStorageSpec.LongMebibytesBound paxos_cache_size = null;
    @Replaces(oldName="cache_load_timeout_seconds", converter=Converters.NEGATIVE_SECONDS_DURATION, deprecated=true)
    public DurationSpec.IntSecondsBound cache_load_timeout = new DurationSpec.IntSecondsBound("30s");
    private static boolean isClientMode = false;
    private static Supplier<Config> overrideLoadConfig = null;
    @Replaces(oldName="networking_cache_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound networking_cache_size;
    @Replaces(oldName="file_cache_size_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_INT, deprecated=true)
    public DataStorageSpec.IntMebibytesBound file_cache_size;
    public boolean file_cache_enabled = CassandraRelevantProperties.FILE_CACHE_ENABLED.getBoolean();
    public Boolean file_cache_round_up;
    @Deprecated(since="4.0")
    public boolean buffer_pool_use_heap_if_exhausted;
    public DiskOptimizationStrategy disk_optimization_strategy = DiskOptimizationStrategy.ssd;
    public double disk_optimization_estimate_percentile = 0.95;
    public double disk_optimization_page_cross_chance = 0.1;
    public boolean inter_dc_tcp_nodelay = true;
    public MemtableAllocationType memtable_allocation_type = MemtableAllocationType.heap_buffers;
    public volatile boolean read_thresholds_enabled = false;
    public volatile DataStorageSpec.LongBytesBound coordinator_read_size_warn_threshold = null;
    public volatile DataStorageSpec.LongBytesBound coordinator_read_size_fail_threshold = null;
    public volatile DataStorageSpec.LongBytesBound local_read_size_warn_threshold = null;
    public volatile DataStorageSpec.LongBytesBound local_read_size_fail_threshold = null;
    public volatile DataStorageSpec.LongBytesBound row_index_read_size_warn_threshold = null;
    public volatile DataStorageSpec.LongBytesBound row_index_read_size_fail_threshold = null;
    public volatile int tombstone_warn_threshold = 1000;
    public volatile int tombstone_failure_threshold = 100000;
    public final ReplicaFilteringProtectionOptions replica_filtering_protection = new ReplicaFilteringProtectionOptions();
    @Replaces(oldName="index_summary_capacity_in_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_LONG, deprecated=true)
    public volatile DataStorageSpec.LongMebibytesBound index_summary_capacity;
    @Nullable
    @Replaces(oldName="index_summary_resize_interval_in_minutes", converter=Converters.MINUTES_CUSTOM_DURATION, deprecated=true)
    public volatile DurationSpec.IntMinutesBound index_summary_resize_interval = new DurationSpec.IntMinutesBound("60m");
    @Replaces(oldName="gc_log_threshold_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound gc_log_threshold = new DurationSpec.IntMillisecondsBound("200ms");
    @Replaces(oldName="gc_warn_threshold_in_ms", converter=Converters.MILLIS_DURATION_INT, deprecated=true)
    public volatile DurationSpec.IntMillisecondsBound gc_warn_threshold = new DurationSpec.IntMillisecondsBound("1s");
    @Replaces(oldName="tracetype_query_ttl", converter=Converters.SECONDS_DURATION, deprecated=true)
    public DurationSpec.IntSecondsBound trace_type_query_ttl = new DurationSpec.IntSecondsBound("1d");
    @Replaces(oldName="tracetype_repair_ttl", converter=Converters.SECONDS_DURATION, deprecated=true)
    public DurationSpec.IntSecondsBound trace_type_repair_ttl = new DurationSpec.IntSecondsBound("7d");
    public volatile ConsistencyLevel ideal_consistency_level = null;
    @Deprecated(since="4.1")
    public int windows_timer_interval = 0;
    @Deprecated(since="4.0")
    public String otc_coalescing_strategy = "DISABLED";
    @Deprecated(since="4.0")
    public static final int otc_coalescing_window_us_default = 200;
    @Deprecated(since="4.0")
    public int otc_coalescing_window_us = 200;
    @Deprecated(since="4.0")
    public int otc_coalescing_enough_coalesced_messages = 8;
    @Deprecated(since="4.0")
    public static final int otc_backlog_expiration_interval_ms_default = 200;
    @Deprecated(since="4.0")
    public volatile int otc_backlog_expiration_interval_ms = 200;
    @Replaces(oldName="prepared_statements_cache_size_mb", converter=Converters.MEBIBYTES_DATA_STORAGE_LONG, deprecated=true)
    public DataStorageSpec.LongMebibytesBound prepared_statements_cache_size = null;
    @Replaces(oldName="enable_user_defined_functions", converter=Converters.IDENTITY, deprecated=true)
    public boolean user_defined_functions_enabled = false;
    @Deprecated(since="5.0")
    @Replaces(oldName="enable_scripted_user_defined_functions", converter=Converters.IDENTITY, deprecated=true)
    public boolean scripted_user_defined_functions_enabled = false;
    @Replaces(oldName="enable_materialized_views", converter=Converters.IDENTITY, deprecated=true)
    public boolean materialized_views_enabled = false;
    @Replaces(oldName="enable_transient_replication", converter=Converters.IDENTITY, deprecated=true)
    public boolean transient_replication_enabled = false;
    @Replaces(oldName="enable_sasi_indexes", converter=Converters.IDENTITY, deprecated=true)
    public boolean sasi_indexes_enabled = false;
    @Replaces(oldName="enable_drop_compact_storage", converter=Converters.IDENTITY, deprecated=true)
    public volatile boolean drop_compact_storage_enabled = false;
    public volatile boolean use_statements_enabled = true;
    @Replaces(oldName="enable_user_defined_functions_threads", converter=Converters.IDENTITY, deprecated=true)
    public boolean user_defined_functions_threads_enabled = true;
    public boolean allow_insecure_udfs = false;
    public boolean allow_extra_insecure_udfs = false;
    public boolean dynamic_data_masking_enabled = false;
    @Replaces(oldName="user_defined_function_warn_timeout", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public DurationSpec.LongMillisecondsBound user_defined_functions_warn_timeout = new DurationSpec.LongMillisecondsBound("500ms");
    @Replaces(oldName="user_defined_function_fail_timeout", converter=Converters.MILLIS_DURATION_LONG, deprecated=true)
    public DurationSpec.LongMillisecondsBound user_defined_functions_fail_timeout = new DurationSpec.LongMillisecondsBound("1500ms");
    public UserFunctionTimeoutPolicy user_function_timeout_policy = UserFunctionTimeoutPolicy.die;
    @Deprecated(since="4.0")
    public volatile boolean back_pressure_enabled = false;
    @Deprecated(since="4.0")
    public volatile ParameterizedClass back_pressure_strategy;
    public volatile int concurrent_validations;
    public RepairCommandPoolFullStrategy repair_command_pool_full_strategy = RepairCommandPoolFullStrategy.queue;
    public int repair_command_pool_size = this.concurrent_validations;
    public int block_for_peers_timeout_in_secs = 10;
    public boolean block_for_peers_in_remote_dcs = false;
    public volatile boolean automatic_sstable_upgrade = false;
    public volatile int max_concurrent_automatic_sstable_upgrades = 1;
    public boolean stream_entire_sstables = true;
    public volatile boolean skip_stream_disk_space_check = false;
    public volatile AuditLogOptions audit_logging_options = new AuditLogOptions();
    public volatile FullQueryLoggerOptions full_query_logging_options = new FullQueryLoggerOptions();
    public CorruptedTombstoneStrategy corrupted_tombstone_strategy = CorruptedTombstoneStrategy.disabled;
    public volatile boolean diagnostic_events_enabled = false;
    public volatile int default_keyspace_rf = 1;
    public volatile boolean repaired_data_tracking_for_range_reads_enabled = false;
    public volatile boolean repaired_data_tracking_for_partition_reads_enabled = false;
    public volatile boolean report_unconfirmed_repaired_data_mismatches = false;
    public volatile boolean snapshot_on_repaired_data_mismatch = false;
    @Replaces(oldName="validation_preview_purge_head_start_in_sec", converter=Converters.NEGATIVE_SECONDS_DURATION, deprecated=true)
    public volatile DurationSpec.IntSecondsBound validation_preview_purge_head_start = new DurationSpec.IntSecondsBound("3600s");
    public boolean auth_cache_warming_enabled = false;
    public volatile String auth_read_consistency_level = "LOCAL_QUORUM";
    public volatile String auth_write_consistency_level = "EACH_QUORUM";
    public volatile boolean partition_denylist_enabled = false;
    public volatile boolean denylist_writes_enabled = true;
    public volatile boolean denylist_reads_enabled = true;
    public volatile boolean denylist_range_reads_enabled = true;
    public DurationSpec.IntSecondsBound denylist_refresh = new DurationSpec.IntSecondsBound("600s");
    public DurationSpec.IntSecondsBound denylist_initial_load_retry = new DurationSpec.IntSecondsBound("5s");
    public volatile int denylist_max_keys_per_table = 1000;
    public volatile int denylist_max_keys_total = 10000;
    public ConsistencyLevel denylist_consistency_level = ConsistencyLevel.QUORUM;
    public volatile boolean log_out_of_token_range_requests = true;
    public volatile boolean reject_out_of_token_range_requests = false;
    public volatile int initial_range_tombstone_list_allocation_size = 1;
    public volatile double range_tombstone_list_growth_factor = 1.5;
    public StorageAttachedIndexOptions sai_options = new StorageAttachedIndexOptions();
    public volatile boolean snapshot_on_duplicate_row_detection = false;
    public volatile boolean check_for_duplicate_rows_during_reads = true;
    public volatile boolean check_for_duplicate_rows_during_compaction = true;
    public boolean autocompaction_on_startup_enabled = CassandraRelevantProperties.AUTOCOMPACTION_ON_STARTUP_ENABLED.getBoolean();
    public volatile boolean auto_optimise_inc_repair_streams = false;
    public volatile boolean auto_optimise_full_repair_streams = false;
    public volatile boolean auto_optimise_preview_repair_streams = false;
    public boolean uuid_sstable_identifiers_enabled = false;
    public volatile int consecutive_message_errors_threshold = 1;
    public volatile SubnetGroups client_error_reporting_exclusions = new SubnetGroups();
    public volatile SubnetGroups internode_error_reporting_exclusions = new SubnetGroups();
    @Replaces(oldName="keyspace_count_warn_threshold", converter=Converters.KEYSPACE_COUNT_THRESHOLD_TO_GUARDRAIL, deprecated=true)
    public volatile int keyspaces_warn_threshold = -1;
    public volatile int keyspaces_fail_threshold = -1;
    @Replaces(oldName="table_count_warn_threshold", converter=Converters.TABLE_COUNT_THRESHOLD_TO_GUARDRAIL, deprecated=true)
    public volatile int tables_warn_threshold = -1;
    public volatile int tables_fail_threshold = -1;
    public volatile int columns_per_table_warn_threshold = -1;
    public volatile int columns_per_table_fail_threshold = -1;
    public volatile int secondary_indexes_per_table_warn_threshold = -1;
    public volatile int secondary_indexes_per_table_fail_threshold = -1;
    public volatile int materialized_views_per_table_warn_threshold = -1;
    public volatile int materialized_views_per_table_fail_threshold = -1;
    public volatile int page_size_warn_threshold = -1;
    public volatile int page_size_fail_threshold = -1;
    public volatile int partition_keys_in_select_warn_threshold = -1;
    public volatile int partition_keys_in_select_fail_threshold = -1;
    public volatile int in_select_cartesian_product_warn_threshold = -1;
    public volatile int in_select_cartesian_product_fail_threshold = -1;
    public volatile Set<String> table_properties_warned = Collections.emptySet();
    public volatile Set<String> table_properties_ignored = Collections.emptySet();
    public volatile Set<String> table_properties_disallowed = Collections.emptySet();
    public volatile Set<ConsistencyLevel> read_consistency_levels_warned = Collections.emptySet();
    public volatile Set<ConsistencyLevel> read_consistency_levels_disallowed = Collections.emptySet();
    public volatile Set<ConsistencyLevel> write_consistency_levels_warned = Collections.emptySet();
    public volatile Set<ConsistencyLevel> write_consistency_levels_disallowed = Collections.emptySet();
    public volatile boolean user_timestamps_enabled = true;
    public volatile boolean alter_table_enabled = true;
    public volatile boolean group_by_enabled = true;
    public volatile boolean drop_truncate_table_enabled = true;
    public volatile boolean drop_keyspace_enabled = true;
    public volatile boolean secondary_indexes_enabled = true;
    public volatile String default_secondary_index = "legacy_local_table";
    public volatile boolean default_secondary_index_enabled = true;
    public volatile boolean uncompressed_tables_enabled = true;
    public volatile boolean compact_tables_enabled = true;
    public volatile boolean read_before_write_list_operations_enabled = true;
    public volatile boolean allow_filtering_enabled = true;
    public volatile boolean simplestrategy_enabled = true;
    @ReplacesList(value={@Replaces(oldName="compaction_large_partition_warning_threshold_mb", converter=Converters.LONG_BYTES_DATASTORAGE_MEBIBYTES_INT, deprecated=true), @Replaces(oldName="compaction_large_partition_warning_threshold", converter=Converters.LONG_BYTES_DATASTORAGE_MEBIBYTES_DATASTORAGE, deprecated=true)})
    public volatile DataStorageSpec.LongBytesBound partition_size_warn_threshold = null;
    public volatile DataStorageSpec.LongBytesBound partition_size_fail_threshold = null;
    @Replaces(oldName="compaction_tombstone_warning_threshold", converter=Converters.INTEGER_PRIMITIVE_LONG, deprecated=true)
    public volatile long partition_tombstones_warn_threshold = -1L;
    public volatile long partition_tombstones_fail_threshold = -1L;
    public volatile DataStorageSpec.LongBytesBound column_value_size_warn_threshold = null;
    public volatile DataStorageSpec.LongBytesBound column_value_size_fail_threshold = null;
    public volatile DataStorageSpec.LongBytesBound collection_size_warn_threshold = null;
    public volatile DataStorageSpec.LongBytesBound collection_size_fail_threshold = null;
    public volatile int items_per_collection_warn_threshold = -1;
    public volatile int items_per_collection_fail_threshold = -1;
    public volatile int fields_per_udt_warn_threshold = -1;
    public volatile int fields_per_udt_fail_threshold = -1;
    public volatile boolean vector_type_enabled = true;
    public volatile int vector_dimensions_warn_threshold = -1;
    public volatile int vector_dimensions_fail_threshold = -1;
    public volatile int data_disk_usage_percentage_warn_threshold = -1;
    public volatile int data_disk_usage_percentage_fail_threshold = -1;
    public volatile DataStorageSpec.LongBytesBound data_disk_usage_max_disk_size = null;
    public volatile int minimum_replication_factor_warn_threshold = -1;
    public volatile int minimum_replication_factor_fail_threshold = -1;
    public volatile int maximum_replication_factor_warn_threshold = -1;
    public volatile int maximum_replication_factor_fail_threshold = -1;
    public volatile boolean zero_ttl_on_twcs_warned = true;
    public volatile boolean zero_ttl_on_twcs_enabled = true;
    public volatile boolean non_partition_restricted_index_query_enabled = true;
    public volatile boolean intersect_filtering_query_warned = true;
    public volatile boolean intersect_filtering_query_enabled = true;
    public volatile int sai_sstable_indexes_per_query_warn_threshold = 32;
    public volatile int sai_sstable_indexes_per_query_fail_threshold = -1;
    public volatile DataStorageSpec.LongBytesBound sai_string_term_size_warn_threshold = new DataStorageSpec.LongBytesBound("1KiB");
    public volatile DataStorageSpec.LongBytesBound sai_string_term_size_fail_threshold = new DataStorageSpec.LongBytesBound("8KiB");
    public volatile DataStorageSpec.LongBytesBound sai_frozen_term_size_warn_threshold = new DataStorageSpec.LongBytesBound("1KiB");
    public volatile DataStorageSpec.LongBytesBound sai_frozen_term_size_fail_threshold = new DataStorageSpec.LongBytesBound("8KiB");
    public volatile DataStorageSpec.LongBytesBound sai_vector_term_size_warn_threshold = new DataStorageSpec.LongBytesBound("16KiB");
    public volatile DataStorageSpec.LongBytesBound sai_vector_term_size_fail_threshold = new DataStorageSpec.LongBytesBound("32KiB");
    public volatile DurationSpec.LongNanosecondsBound streaming_state_expires = new DurationSpec.LongNanosecondsBound("3d");
    public volatile DataStorageSpec.LongBytesBound streaming_state_size = new DataStorageSpec.LongBytesBound("40MiB");
    public volatile boolean streaming_stats_enabled = true;
    public volatile DurationSpec.IntSecondsBound streaming_slow_events_log_timeout = new DurationSpec.IntSecondsBound("10s");
    public volatile Map<StartupChecks.StartupCheckType, Map<String, Object>> startup_checks = new HashMap<StartupChecks.StartupCheckType, Map<String, Object>>();
    public volatile DurationSpec.LongNanosecondsBound repair_state_expires = new DurationSpec.LongNanosecondsBound("3d");
    public volatile int repair_state_size = 100000;
    public volatile DurationSpec.LongMicrosecondsBound maximum_timestamp_warn_threshold = null;
    public volatile DurationSpec.LongMicrosecondsBound maximum_timestamp_fail_threshold = null;
    public volatile DurationSpec.LongMicrosecondsBound minimum_timestamp_warn_threshold = null;
    public volatile DurationSpec.LongMicrosecondsBound minimum_timestamp_fail_threshold = null;
    public volatile PaxosVariant paxos_variant = PaxosVariant.v1;
    public volatile boolean skip_paxos_repair_on_topology_change = CassandraRelevantProperties.SKIP_PAXOS_REPAIR_ON_TOPOLOGY_CHANGE.getBoolean();
    public volatile DurationSpec.LongSecondsBound paxos_purge_grace_period = new DurationSpec.LongSecondsBound("60s");
    public volatile PaxosOnLinearizabilityViolation paxos_on_linearizability_violations = PaxosOnLinearizabilityViolation.ignore;
    public volatile PaxosStatePurging paxos_state_purging;
    public volatile boolean paxos_repair_enabled = true;
    public boolean paxos_topology_repair_no_dc_checks = false;
    public boolean paxos_topology_repair_strict_each_quorum = false;
    public volatile Set<String> skip_paxos_repair_on_topology_change_keyspaces = Config.splitCommaDelimited(CassandraRelevantProperties.SKIP_PAXOS_REPAIR_ON_TOPOLOGY_CHANGE_KEYSPACES.getString());
    public String paxos_contention_wait_randomizer;
    public String paxos_contention_min_wait;
    public String paxos_contention_max_wait;
    public String paxos_contention_min_delta;
    public volatile int paxos_repair_parallelism = -1;
    public volatile boolean sstable_read_rate_persistence_enabled = false;
    public volatile boolean client_request_size_metrics_enabled = true;
    public volatile int max_top_size_partition_count = 10;
    public volatile int max_top_tombstone_partition_count = 10;
    public volatile DataStorageSpec.LongBytesBound min_tracked_partition_size = new DataStorageSpec.LongBytesBound("1MiB");
    public volatile long min_tracked_partition_tombstone_count = 5000L;
    public volatile boolean top_partitions_enabled = true;
    public final RepairConfig repair = new RepairConfig();
    public ParameterizedClass default_compaction = null;
    private static final Set<String> SENSITIVE_KEYS = new HashSet<String>(){
        {
            this.add("client_encryption_options");
            this.add("server_encryption_options");
        }
    };
    public volatile boolean dump_heap_on_uncaught_exception = false;
    public String heap_dump_path = "heapdump";
    public double severity_during_decommission = 0.0;
    public StorageCompatibilityMode storage_compatibility_mode;
    public volatile CQLStartTime cql_start_time = CQLStartTime.REQUEST;
    public boolean native_transport_throw_on_overload = false;
    public double native_transport_queue_max_item_age_threshold = Double.MAX_VALUE;
    public DurationSpec.LongMillisecondsBound native_transport_min_backoff_on_queue_overload = new DurationSpec.LongMillisecondsBound("10ms");
    public DurationSpec.LongMillisecondsBound native_transport_max_backoff_on_queue_overload = new DurationSpec.LongMillisecondsBound("200ms");
    public DurationSpec.LongMillisecondsBound native_transport_timeout = new DurationSpec.LongMillisecondsBound("12s");
    public boolean enforce_native_deadline_for_hints = false;

    public static Set<String> splitCommaDelimited(String src) {
        if (src == null) {
            return ImmutableSet.of();
        }
        String[] split = src.split(",\\s*");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String s : split) {
            if ((s = s.trim()).isEmpty()) continue;
            builder.add((Object)s);
        }
        return builder.build();
    }

    @Deprecated(since="3.10")
    public static boolean isClientMode() {
        return isClientMode;
    }

    @Deprecated(since="3.10")
    public static void setClientMode(boolean clientMode) {
        isClientMode = clientMode;
    }

    public static Supplier<Config> getOverrideLoadConfig() {
        return overrideLoadConfig;
    }

    public static void setOverrideLoadConfig(Supplier<Config> loadConfig) {
        overrideLoadConfig = loadConfig;
    }

    public static void log(Config config) {
        TreeMap<String, String> configMap = new TreeMap<String, String>();
        for (Field field : Config.class.getFields()) {
            String value;
            if (Modifier.isFinal(field.getModifiers())) continue;
            String name = field.getName();
            if (SENSITIVE_KEYS.contains(name)) {
                configMap.put(name, "<REDACTED>");
                continue;
            }
            try {
                value = field.get(config).toString();
            }
            catch (IllegalAccessException | NullPointerException npe) {
                value = "null";
            }
            configMap.put(name, value);
        }
        logger.info("Node configuration:[{}]", (Object)Joiner.on((String)"; ").join(configMap.entrySet()));
    }

    public static enum CQLStartTime {
        REQUEST,
        QUEUE;

    }

    public static enum CorruptedTombstoneStrategy {
        disabled,
        warn,
        exception;

    }

    public static enum RepairCommandPoolFullStrategy {
        queue,
        reject;

    }

    public static enum DiskOptimizationStrategy {
        ssd,
        spinning;

    }

    public static enum UserFunctionTimeoutPolicy {
        ignore,
        die,
        die_immediate;

    }

    public static enum CommitFailurePolicy {
        stop,
        stop_commit,
        ignore,
        die;

    }

    public static enum DiskFailurePolicy {
        best_effort,
        stop,
        ignore,
        stop_paranoid,
        die;

    }

    public static enum MemtableAllocationType {
        unslabbed_heap_buffers,
        unslabbed_heap_buffers_logged,
        heap_buffers,
        offheap_buffers,
        offheap_objects;


        public BufferType toBufferType() {
            switch (this) {
                case unslabbed_heap_buffers: 
                case unslabbed_heap_buffers_logged: 
                case heap_buffers: {
                    return BufferType.ON_HEAP;
                }
                case offheap_buffers: 
                case offheap_objects: {
                    return BufferType.OFF_HEAP;
                }
            }
            throw new AssertionError();
        }
    }

    public static enum DiskAccessMode {
        auto,
        mmap,
        mmap_index_only,
        standard,
        legacy,
        direct;

    }

    public static enum InternodeCompression {
        all,
        none,
        dc;

    }

    public static enum FlushCompression {
        none,
        fast,
        table;

    }

    public static enum CommitLogSync {
        periodic,
        batch,
        group;

    }

    public static enum PaxosOnLinearizabilityViolation {
        fail,
        log,
        ignore;

    }

    public static enum PaxosStatePurging {
        legacy,
        gc_grace,
        repaired;


        public static PaxosStatePurging fromBoolean(boolean enabled) {
            return enabled ? repaired : gc_grace;
        }
    }

    public static enum PaxosVariant {
        v1_without_linearizable_reads_or_rejected_writes,
        v1,
        v2_without_linearizable_reads,
        v2_without_linearizable_reads_or_rejected_writes,
        v2;

    }

    public static class SSTableConfig {
        public String selected_format = "big";
        public Map<String, Map<String, String>> format = new HashMap<String, Map<String, String>>();
    }

    public static class MemtableOptions {
        public LinkedHashMap<String, InheritingClass> configurations;
    }
}

