/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;

public interface IAuthenticator {
    public boolean requireAuthentication();

    public Set<? extends IResource> protectedResources();

    public void validateConfiguration() throws ConfigurationException;

    public void setup();

    public SaslNegotiator newSaslNegotiator(InetAddress var1);

    default public SaslNegotiator newSaslNegotiator(InetAddress clientAddress, Certificate[] certificates) {
        return this.newSaslNegotiator(clientAddress);
    }

    public AuthenticatedUser legacyAuthenticate(Map<String, String> var1) throws AuthenticationException;

    public static interface SaslNegotiator {
        public byte[] evaluateResponse(byte[] var1) throws AuthenticationException;

        public boolean isComplete();

        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException;
    }
}

