/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import java.util.concurrent.atomic.LongAdder;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.memtable.TrieMemtable;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeIterator;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.lucene.util.packed.PackedLongValues;

@NotThreadSafe
public class BlockBalancedTreeRamBuffer {
    private final InMemoryTrie<PackedLongValues.Builder> trie = new InMemoryTrie(TrieMemtable.BUFFER_TYPE);
    private final PostingsAccumulator postingsAccumulator = new PostingsAccumulator();
    private final int bytesPerValue;
    private int numRows;

    public BlockBalancedTreeRamBuffer(int bytesPerValue) {
        this.bytesPerValue = bytesPerValue;
    }

    public int numRows() {
        return this.numRows;
    }

    public long memoryUsed() {
        return this.trie.sizeOnHeap() + this.postingsAccumulator.heapAllocations();
    }

    public long add(int segmentRowId, byte[] value) {
        long initialSizeOnHeap = this.trie.sizeOnHeap();
        long reducerHeapSize = this.postingsAccumulator.heapAllocations();
        try {
            this.trie.putRecursive(v -> ByteSource.fixedLength(value), segmentRowId, this.postingsAccumulator);
        }
        catch (InMemoryTrie.SpaceExhaustedException e) {
            throw Throwables.unchecked(e);
        }
        ++this.numRows;
        return this.trie.sizeOnHeap() - initialSizeOnHeap + (this.postingsAccumulator.heapAllocations() - reducerHeapSize);
    }

    public BlockBalancedTreeIterator iterator() {
        return BlockBalancedTreeIterator.fromTrieIterator(this.trie.entrySet().iterator(), this.bytesPerValue);
    }

    private static class PostingsAccumulator
    implements InMemoryTrie.UpsertTransformer<PackedLongValues.Builder, Integer> {
        private final LongAdder heapAllocations = new LongAdder();

        private PostingsAccumulator() {
        }

        @Override
        public PackedLongValues.Builder apply(PackedLongValues.Builder existing, Integer rowID) {
            if (existing == null) {
                existing = PackedLongValues.deltaPackedBuilder((float)0.0f);
                this.heapAllocations.add(existing.ramBytesUsed());
            }
            long ramBefore = existing.ramBytesUsed();
            existing.add((long)rowID.intValue());
            this.heapAllocations.add(existing.ramBytesUsed() - ramBefore);
            return existing;
        }

        long heapAllocations() {
            return this.heapAllocations.longValue();
        }
    }
}

