/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.DiagnosticSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotVerbHandler
implements IVerbHandler<SnapshotCommand> {
    public static final SnapshotVerbHandler instance = new SnapshotVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(SnapshotVerbHandler.class);

    @Override
    public void doVerb(Message<SnapshotCommand> message) {
        SnapshotCommand command = (SnapshotCommand)message.payload;
        if (command.clear_snapshot) {
            StorageService.instance.clearSnapshot(command.snapshot_name, command.keyspace);
        } else if (DiagnosticSnapshotService.isDiagnosticSnapshotRequest(command)) {
            List ranges = Collections.emptyList();
            if (message.header.params().containsKey((Object)ParamType.SNAPSHOT_RANGES)) {
                ranges = (List)message.header.params().get((Object)ParamType.SNAPSHOT_RANGES);
            }
            DiagnosticSnapshotService.snapshot(command, ranges, message.from());
        } else {
            Keyspace.open(command.keyspace).getColumnFamilyStore(command.column_family).snapshot(command.snapshot_name);
        }
        logger.debug("Enqueuing response to snapshot request {} to {}", (Object)command.snapshot_name, (Object)message.from());
        MessagingService.instance().send(message.emptyResponse(), message.from());
    }
}

