/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.EndpointsByRange;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.RangesByEndpoint;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicationFactor;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.DatacenterSyncWriteResponseHandler;
import org.apache.cassandra.service.DatacenterWriteResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.utils.FBUtilities;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReplicationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReplicationStrategy.class);
    public final Map<String, String> configOptions;
    protected final String keyspaceName;
    private final TokenMetadata tokenMetadata;
    private final ReplicaCache<Token, EndpointsForRange> replicas = new ReplicaCache();
    public IEndpointSnitch snitch;

    protected AbstractReplicationStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        assert (snitch != null);
        assert (tokenMetadata != null);
        this.tokenMetadata = tokenMetadata;
        this.snitch = snitch;
        this.configOptions = configOptions == null ? Collections.emptyMap() : configOptions;
        this.keyspaceName = keyspaceName;
    }

    public EndpointsForRange getCachedReplicas(long ringVersion, Token t) {
        return this.replicas.get(ringVersion, t);
    }

    public EndpointsForToken getNaturalReplicasForToken(RingPosition<?> searchPosition) {
        return this.getNaturalReplicas(searchPosition).forToken(searchPosition.getToken());
    }

    public EndpointsForRange getNaturalReplicas(RingPosition<?> searchPosition) {
        Token keyToken;
        Token searchToken = searchPosition.getToken();
        long currentRingVersion = this.tokenMetadata.getRingVersion();
        EndpointsForRange endpoints = this.getCachedReplicas(currentRingVersion, keyToken = TokenMetadata.firstToken(this.tokenMetadata.sortedTokens(), searchToken));
        if (endpoints == null) {
            TokenMetadata tm = this.tokenMetadata.cachedOnlyTokenMap();
            keyToken = TokenMetadata.firstToken(tm.sortedTokens(), searchToken);
            endpoints = this.calculateNaturalReplicas(searchToken, tm);
            this.replicas.put(tm.getRingVersion(), keyToken, endpoints);
        }
        return endpoints;
    }

    public Replica getLocalReplicaFor(RingPosition<?> searchPosition) {
        return this.getNaturalReplicas(searchPosition).byEndpoint().get(FBUtilities.getBroadcastAddressAndPort());
    }

    public abstract EndpointsForRange calculateNaturalReplicas(Token var1, TokenMetadata var2);

    public <T> AbstractWriteResponseHandler<T> getWriteResponseHandler(ReplicaPlan.ForWrite replicaPlan, Runnable callback, WriteType writeType, Supplier<Mutation> hintOnFailure, long queryStartNanoTime) {
        return this.getWriteResponseHandler(replicaPlan, callback, writeType, hintOnFailure, queryStartNanoTime, DatabaseDescriptor.getIdealConsistencyLevel());
    }

    public <T> AbstractWriteResponseHandler<T> getWriteResponseHandler(ReplicaPlan.ForWrite replicaPlan, Runnable callback, WriteType writeType, Supplier<Mutation> hintOnFailure, long queryStartNanoTime, ConsistencyLevel idealConsistencyLevel) {
        AbstractWriteResponseHandler resultResponseHandler = replicaPlan.consistencyLevel().isDatacenterLocal() ? new DatacenterWriteResponseHandler(replicaPlan, callback, writeType, hintOnFailure, queryStartNanoTime) : (replicaPlan.consistencyLevel() == ConsistencyLevel.EACH_QUORUM && this instanceof NetworkTopologyStrategy ? new DatacenterSyncWriteResponseHandler(replicaPlan, callback, writeType, hintOnFailure, queryStartNanoTime) : new WriteResponseHandler(replicaPlan, callback, writeType, hintOnFailure, queryStartNanoTime));
        if (idealConsistencyLevel != null) {
            if (idealConsistencyLevel == replicaPlan.consistencyLevel()) {
                resultResponseHandler.setIdealCLResponseHandler(resultResponseHandler);
            } else {
                AbstractWriteResponseHandler<T> idealHandler = this.getWriteResponseHandler(replicaPlan.withConsistencyLevel(idealConsistencyLevel), callback, writeType, hintOnFailure, queryStartNanoTime, idealConsistencyLevel);
                resultResponseHandler.setIdealCLResponseHandler(idealHandler);
            }
        }
        return resultResponseHandler;
    }

    public abstract ReplicationFactor getReplicationFactor();

    public boolean hasTransientReplicas() {
        return this.getReplicationFactor().hasTransientReplicas();
    }

    public RangesByEndpoint getAddressReplicas(TokenMetadata metadata) {
        RangesByEndpoint.Builder map = new RangesByEndpoint.Builder();
        for (Token token : metadata.sortedTokens()) {
            Range<Token> range = metadata.getPrimaryRangeFor(token);
            for (Replica replica : this.calculateNaturalReplicas(token, metadata)) {
                Preconditions.checkState((range.equals(replica.range()) || this instanceof LocalStrategy ? 1 : 0) != 0);
                map.put(replica.endpoint(), replica);
            }
        }
        return map.build();
    }

    public RangesAtEndpoint getAddressReplicas(TokenMetadata metadata, InetAddressAndPort endpoint) {
        RangesAtEndpoint.Builder builder = RangesAtEndpoint.builder(endpoint);
        for (Token token : metadata.sortedTokens()) {
            Range<Token> range = metadata.getPrimaryRangeFor(token);
            Replica replica = this.calculateNaturalReplicas(token, metadata).byEndpoint().get(endpoint);
            if (replica == null) continue;
            Preconditions.checkState((range.equals(replica.range()) || this instanceof LocalStrategy ? 1 : 0) != 0);
            builder.add(replica, ReplicaCollection.Builder.Conflict.DUPLICATE);
        }
        return builder.build();
    }

    public EndpointsByRange getRangeAddresses(TokenMetadata metadata) {
        EndpointsByRange.Builder map = new EndpointsByRange.Builder();
        for (Token token : metadata.sortedTokens()) {
            Range<Token> range = metadata.getPrimaryRangeFor(token);
            for (Replica replica : this.calculateNaturalReplicas(token, metadata)) {
                Preconditions.checkState((range.equals(replica.range()) || this instanceof LocalStrategy ? 1 : 0) != 0);
                map.put(range, replica);
            }
        }
        return map.build();
    }

    public RangesByEndpoint getAddressReplicas() {
        return this.getAddressReplicas(this.tokenMetadata.cloneOnlyTokenMap());
    }

    public RangesAtEndpoint getAddressReplicas(InetAddressAndPort endpoint) {
        return this.getAddressReplicas(this.tokenMetadata.cloneOnlyTokenMap(), endpoint);
    }

    public RangesAtEndpoint getPendingAddressRanges(TokenMetadata metadata, Token pendingToken, InetAddressAndPort pendingAddress) {
        return this.getPendingAddressRanges(metadata, Collections.singleton(pendingToken), pendingAddress);
    }

    public RangesAtEndpoint getPendingAddressRanges(TokenMetadata metadata, Collection<Token> pendingTokens, InetAddressAndPort pendingAddress) {
        TokenMetadata temp = metadata.cloneOnlyTokenMap();
        temp.updateNormalTokens(pendingTokens, pendingAddress);
        return this.getAddressReplicas(temp, pendingAddress);
    }

    public abstract void validateOptions() throws ConfigurationException;

    @Deprecated(since="4.1")
    public void maybeWarnOnOptions() {
    }

    public void maybeWarnOnOptions(ClientState state) {
        this.maybeWarnOnOptions();
    }

    public Collection<String> recognizedOptions() {
        return null;
    }

    private static AbstractReplicationStrategy createInternal(String keyspaceName, Class<? extends AbstractReplicationStrategy> strategyClass, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> strategyOptions) throws ConfigurationException {
        AbstractReplicationStrategy strategy;
        Class[] parameterTypes = new Class[]{String.class, TokenMetadata.class, IEndpointSnitch.class, Map.class};
        try {
            Constructor<? extends AbstractReplicationStrategy> constructor = strategyClass.getConstructor(parameterTypes);
            strategy = constructor.newInstance(keyspaceName, tokenMetadata, snitch, strategyOptions);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new ConfigurationException(targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error constructing replication strategy class", e);
        }
        return strategy;
    }

    public static AbstractReplicationStrategy createReplicationStrategy(String keyspaceName, Class<? extends AbstractReplicationStrategy> strategyClass, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> strategyOptions) {
        AbstractReplicationStrategy strategy = AbstractReplicationStrategy.createInternal(keyspaceName, strategyClass, tokenMetadata, snitch, strategyOptions);
        try {
            strategy.validateExpectedOptions();
        }
        catch (ConfigurationException e) {
            logger.warn("Ignoring {}", (Object)e.getMessage());
        }
        strategy.validateOptions();
        return strategy;
    }

    public static void prepareReplicationStrategyOptions(Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, Map<String, String> previousStrategyOptions) {
        try {
            Method method = strategyClass.getDeclaredMethod("prepareOptions", Map.class, Map.class);
            method.invoke(null, strategyOptions, previousStrategyOptions);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static void validateReplicationStrategy(String keyspaceName, Class<? extends AbstractReplicationStrategy> strategyClass, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> strategyOptions, ClientState state) throws ConfigurationException {
        AbstractReplicationStrategy strategy = AbstractReplicationStrategy.createInternal(keyspaceName, strategyClass, tokenMetadata, snitch, strategyOptions);
        strategy.validateExpectedOptions();
        strategy.validateOptions();
        strategy.maybeWarnOnOptions(state);
        if (strategy.hasTransientReplicas() && !DatabaseDescriptor.isTransientReplicationEnabled()) {
            throw new ConfigurationException("Transient replication is disabled. Enable in cassandra.yaml to use.");
        }
    }

    public static Class<AbstractReplicationStrategy> getClass(String cls) throws ConfigurationException {
        Object className;
        Object object = className = cls.contains(".") ? cls : "org.apache.cassandra.locator." + cls;
        if ("org.apache.cassandra.locator.OldNetworkTopologyStrategy".equals(className)) {
            throw new ConfigurationException("The support for the OldNetworkTopologyStrategy has been removed in C* version 4.0. The keyspace strategy should be switch to NetworkTopologyStrategy");
        }
        Class<AbstractReplicationStrategy> strategyClass = FBUtilities.classForName((String)className, "replication strategy");
        if (!AbstractReplicationStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Specified replication strategy class (%s) is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public boolean hasSameSettings(AbstractReplicationStrategy other) {
        return this.getClass().equals(other.getClass()) && this.getReplicationFactor().equals(other.getReplicationFactor());
    }

    protected void validateReplicationFactor(String s) throws ConfigurationException {
        try {
            ReplicationFactor rf = ReplicationFactor.fromString(s);
            if (rf.hasTransientReplicas() && DatabaseDescriptor.getNumTokens() > 1) {
                throw new ConfigurationException("Transient replication is not supported with vnodes yet");
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    protected void validateExpectedOptions() throws ConfigurationException {
        Collection<String> expectedOptions = this.recognizedOptions();
        if (expectedOptions == null) {
            return;
        }
        for (String key : this.configOptions.keySet()) {
            if (expectedOptions.contains(key)) continue;
            throw new ConfigurationException(String.format("Unrecognized strategy option {%s} passed to %s for keyspace %s", key, this.getClass().getSimpleName(), this.keyspaceName));
        }
    }

    static class ReplicaHolder<K, V> {
        private final long ringVersion;
        private final NonBlockingHashMap<K, V> replicas;

        ReplicaHolder(long ringVersion, int expectedEntries) {
            this.ringVersion = ringVersion;
            this.replicas = new NonBlockingHashMap(expectedEntries);
        }
    }

    static class ReplicaCache<K, V> {
        private final AtomicReference<ReplicaHolder<K, V>> cachedReplicas = new AtomicReference(new ReplicaHolder(0L, 4));

        ReplicaCache() {
        }

        V get(long ringVersion, K keyToken) {
            ReplicaHolder<K, V> replicaHolder = this.maybeClearAndGet(ringVersion);
            if (replicaHolder == null) {
                return null;
            }
            return (V)replicaHolder.replicas.get(keyToken);
        }

        void put(long ringVersion, K keyToken, V endpoints) {
            ReplicaHolder<K, V> current = this.maybeClearAndGet(ringVersion);
            if (current != null) {
                current.replicas.putIfAbsent(keyToken, endpoints);
            }
        }

        ReplicaHolder<K, V> maybeClearAndGet(long ringVersion) {
            ReplicaHolder<K, V> current = this.cachedReplicas.get();
            if (ringVersion == current.ringVersion) {
                return current;
            }
            if (ringVersion < current.ringVersion) {
                return null;
            }
            ReplicaHolder cleaned = new ReplicaHolder(ringVersion, current.replicas.size());
            this.cachedReplicas.compareAndSet(current, cleaned);
            current = this.cachedReplicas.get();
            if (ringVersion == current.ringVersion) {
                return current;
            }
            return null;
        }
    }
}

