/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.WrappingRebufferer;

@NotThreadSafe
public class TailOverridingRebufferer
extends WrappingRebufferer {
    private final long cutoff;
    private final ByteBuffer tail;

    public TailOverridingRebufferer(Rebufferer source, long cutoff, ByteBuffer tail) {
        super(source);
        this.cutoff = cutoff;
        this.tail = tail;
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long position) {
        assert (this.buffer == null) : "Buffer holder has been already acquired and has been not released yet";
        if (position < this.cutoff) {
            super.rebuffer(position);
            if (this.offset + (long)this.buffer.limit() > this.cutoff) {
                this.buffer.limit((int)(this.cutoff - this.offset));
            }
        } else {
            this.buffer = this.tail.duplicate();
            this.offset = this.cutoff;
        }
        return this;
    }

    @Override
    public long fileLength() {
        return this.cutoff + (long)this.tail.limit();
    }

    @Override
    public String toString() {
        return String.format("%s[+%d@%d]:%s", this.getClass().getSimpleName(), this.tail.limit(), this.cutoff, this.wrapped.toString());
    }
}

