/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.vint.VIntCoding;

@Shared(scope={Shared.Scope.SIMULATION})
public interface DataInputPlus
extends DataInput {
    default public long readVInt() throws IOException {
        return VIntCoding.readVInt(this);
    }

    default public int readVInt32() throws IOException {
        return VIntCoding.readVInt32(this);
    }

    default public long readUnsignedVInt() throws IOException {
        return VIntCoding.readUnsignedVInt(this);
    }

    default public int readUnsignedVInt32() throws IOException {
        return VIntCoding.readUnsignedVInt32(this);
    }

    @Override
    public int skipBytes(int var1) throws IOException;

    default public void skipBytesFully(int n) throws IOException {
        int skipped = this.skipBytes(n);
        if (skipped != n) {
            throw new EOFException("EOF after " + skipped + " bytes out of " + n);
        }
    }

    public static abstract class DataInputStreamPlus
    extends InputStream
    implements DataInputPlus {
    }
}

