/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.view.RangeTermTree;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class View
implements Iterable<SSTableIndex> {
    private final Map<Descriptor, SSTableIndex> view = new HashMap<Descriptor, SSTableIndex>();
    private final RangeTermTree rangeTermTree;

    public View(IndexContext context, Collection<SSTableIndex> indexes) {
        AbstractType<?> termValidator = context.getValidator();
        RangeTermTree.Builder rangeTermTreeBuilder = new RangeTermTree.Builder(termValidator);
        for (SSTableIndex sstableIndex : indexes) {
            this.view.put(sstableIndex.getSSTable().descriptor, sstableIndex);
            rangeTermTreeBuilder.add(sstableIndex);
        }
        this.rangeTermTree = rangeTermTreeBuilder.build();
    }

    public Collection<SSTableIndex> match(Expression expression) {
        if (expression.getOp() == Expression.IndexOperator.ANN) {
            return this.getIndexes();
        }
        return this.rangeTermTree.search(expression);
    }

    @Override
    public Iterator<SSTableIndex> iterator() {
        return this.view.values().iterator();
    }

    public Collection<SSTableIndex> getIndexes() {
        return this.view.values();
    }

    public boolean containsSSTable(SSTableReader sstable) {
        return this.view.containsKey(sstable.descriptor);
    }

    public int size() {
        return this.view.size();
    }

    public String toString() {
        return String.format("View{view=%s}", this.view);
    }
}

