/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expression {
    private static final Logger logger = LoggerFactory.getLogger(Expression.class);
    public final AbstractAnalyzer.AnalyzerFactory analyzerFactory;
    public final IndexContext context;
    public final AbstractType<?> validator;
    protected IndexOperator operator;
    public Bound lower;
    public Bound upper;
    public boolean upperInclusive;
    public boolean lowerInclusive;

    public Expression(IndexContext indexContext) {
        this.context = indexContext;
        this.analyzerFactory = indexContext.getAnalyzerFactory();
        this.validator = indexContext.getValidator();
    }

    public Expression add(Operator op, ByteBuffer value) {
        boolean upperInclusive;
        boolean lowerInclusive = upperInclusive = TypeUtil.supportsRounding(this.validator);
        switch (op) {
            case EQ: 
            case CONTAINS: 
            case CONTAINS_KEY: {
                this.upper = this.lower = new Bound(value, this.validator, true);
                this.operator = IndexOperator.valueOf(op);
                break;
            }
            case LTE: {
                if (this.context.getDefinition().isReversedType()) {
                    this.lowerInclusive = true;
                    lowerInclusive = true;
                } else {
                    this.upperInclusive = true;
                    upperInclusive = true;
                }
            }
            case LT: {
                this.operator = IndexOperator.RANGE;
                if (this.context.getDefinition().isReversedType()) {
                    this.lower = new Bound(value, this.validator, lowerInclusive);
                    break;
                }
                this.upper = new Bound(value, this.validator, upperInclusive);
                break;
            }
            case GTE: {
                if (this.context.getDefinition().isReversedType()) {
                    this.upperInclusive = true;
                    upperInclusive = true;
                } else {
                    this.lowerInclusive = true;
                    lowerInclusive = true;
                }
            }
            case GT: {
                this.operator = IndexOperator.RANGE;
                if (this.context.getDefinition().isReversedType()) {
                    this.upper = new Bound(value, this.validator, upperInclusive);
                    break;
                }
                this.lower = new Bound(value, this.validator, lowerInclusive);
                break;
            }
            case ANN: {
                this.operator = IndexOperator.ANN;
                this.upper = this.lower = new Bound(value, this.validator, true);
            }
        }
        assert (this.operator != null);
        return this;
    }

    public boolean isSatisfiedBy(ByteBuffer columnValue) {
        int cmp;
        if (this.validator.isVector()) {
            return true;
        }
        if (!TypeUtil.isValid(columnValue, this.validator)) {
            logger.error(this.context.logMessage("Value is not valid for indexed column {} with {}"), (Object)this.context.getColumnName(), this.validator);
            return false;
        }
        Value value = new Value(columnValue, this.validator);
        if (this.lower != null) {
            if (TypeUtil.isLiteral(this.validator)) {
                return this.validateStringValue(value.raw, this.lower.value.raw);
            }
            cmp = TypeUtil.comparePostFilter(this.lower.value, value, this.validator);
            if (this.operator == IndexOperator.EQ || this.operator == IndexOperator.CONTAINS_KEY || this.operator == IndexOperator.CONTAINS_VALUE) {
                return cmp == 0;
            }
            if (cmp > 0 || cmp == 0 && !this.lowerInclusive) {
                return false;
            }
        }
        if (this.upper != null && this.lower != this.upper) {
            if (TypeUtil.isLiteral(this.validator)) {
                return this.validateStringValue(value.raw, this.upper.value.raw);
            }
            cmp = TypeUtil.comparePostFilter(this.upper.value, value, this.validator);
            return cmp > 0 || cmp == 0 && this.upperInclusive;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateStringValue(ByteBuffer columnValue, ByteBuffer requestedValue) {
        AbstractAnalyzer analyzer = this.analyzerFactory.create();
        analyzer.reset(columnValue.duplicate());
        try {
            while (analyzer.hasNext()) {
                ByteBuffer term = analyzer.next();
                boolean isMatch = false;
                switch (this.operator) {
                    case EQ: 
                    case CONTAINS_KEY: 
                    case CONTAINS_VALUE: {
                        isMatch = this.validator.compare(term, requestedValue) == 0;
                        break;
                    }
                    case RANGE: {
                        boolean bl = isMatch = this.isLowerSatisfiedBy(term) && this.isUpperSatisfiedBy(term);
                    }
                }
                if (!isMatch) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            analyzer.end();
        }
    }

    public IndexOperator getOp() {
        return this.operator;
    }

    private boolean hasLower() {
        return this.lower != null;
    }

    private boolean hasUpper() {
        return this.upper != null;
    }

    private boolean isLowerSatisfiedBy(ByteBuffer value) {
        if (!this.hasLower()) {
            return true;
        }
        int cmp = this.validator.compare(value, this.lower.value.raw);
        return cmp > 0 || cmp == 0 && this.lower.inclusive;
    }

    private boolean isUpperSatisfiedBy(ByteBuffer value) {
        if (!this.hasUpper()) {
            return true;
        }
        int cmp = this.validator.compare(value, this.upper.value.raw);
        return cmp < 0 || cmp == 0 && this.upper.inclusive;
    }

    public String toString() {
        return String.format("Expression{name: %s, op: %s, lower: (%s, %s), upper: (%s, %s)}", new Object[]{this.context.getColumnName(), this.operator, this.lower == null ? "null" : this.validator.getString(this.lower.value.raw), this.lower != null && this.lower.inclusive, this.upper == null ? "null" : this.validator.getString(this.upper.value.raw), this.upper != null && this.upper.inclusive});
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.context.getColumnName()).append((Object)this.operator).append(this.validator).append((Object)this.lower).append((Object)this.upper).build();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Expression)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Expression o = (Expression)other;
        return Objects.equals(this.context.getColumnName(), o.context.getColumnName()) && this.validator.equals(o.validator) && this.operator == o.operator && Objects.equals(this.lower, o.lower) && Objects.equals(this.upper, o.upper);
    }

    public static class Bound {
        public final Value value;
        public final boolean inclusive;

        public Bound(ByteBuffer value, AbstractType<?> type, boolean inclusive) {
            this.value = new Value(value, type);
            this.inclusive = inclusive;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Bound)) {
                return false;
            }
            Bound o = (Bound)other;
            return this.value.equals(o.value) && this.inclusive == o.inclusive;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.value);
            builder.append(this.inclusive);
            return builder.toHashCode();
        }
    }

    public static class Value {
        public final ByteBuffer raw;
        public final ByteBuffer encoded;

        public Value(ByteBuffer value, AbstractType<?> type) {
            this.raw = value;
            this.encoded = TypeUtil.asIndexBytes(value, type);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Value)) {
                return false;
            }
            Value o = (Value)other;
            return this.raw.equals(o.raw) && this.encoded.equals(o.encoded);
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.raw);
            builder.append((Object)this.encoded);
            return builder.toHashCode();
        }
    }

    public static enum IndexOperator {
        EQ,
        RANGE,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        ANN;


        public static IndexOperator valueOf(Operator operator) {
            switch (operator) {
                case EQ: {
                    return EQ;
                }
                case CONTAINS: {
                    return CONTAINS_VALUE;
                }
                case CONTAINS_KEY: {
                    return CONTAINS_KEY;
                }
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    return RANGE;
                }
                case ANN: {
                    return ANN;
                }
            }
            return null;
        }

        public boolean isEquality() {
            return this == EQ || this == CONTAINS_KEY || this == CONTAINS_VALUE;
        }

        public boolean isEqualityOrRange() {
            return this.isEquality() || this == RANGE;
        }
    }
}

