/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.memory.MemtableIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;

public class MemtableIndexManager {
    private final IndexContext indexContext;
    private final ConcurrentMap<Memtable, MemtableIndex> liveMemtableIndexMap;

    public MemtableIndexManager(IndexContext indexContext) {
        this.indexContext = indexContext;
        this.liveMemtableIndexMap = new ConcurrentHashMap<Memtable, MemtableIndex>();
    }

    public long index(DecoratedKey key, Row row, Memtable mt) {
        MemtableIndex current = (MemtableIndex)this.liveMemtableIndexMap.get(mt);
        MemtableIndex target = current != null ? current : this.liveMemtableIndexMap.computeIfAbsent(mt, memtable -> new MemtableIndex(this.indexContext));
        long start = Clock.Global.nanoTime();
        long bytes = 0L;
        if (this.indexContext.isNonFrozenCollection()) {
            Iterator<ByteBuffer> bufferIterator = this.indexContext.getValuesOf(row, FBUtilities.nowInSeconds());
            if (bufferIterator != null) {
                while (bufferIterator.hasNext()) {
                    ByteBuffer value = bufferIterator.next();
                    bytes += target.index(key, (Clustering<?>)row.clustering(), value);
                }
            }
        } else {
            ByteBuffer value = this.indexContext.getValueOf(key, row, FBUtilities.nowInSeconds());
            bytes += target.index(key, (Clustering<?>)row.clustering(), value);
        }
        this.indexContext.getIndexMetrics().memtableIndexWriteLatency.update(Clock.Global.nanoTime() - start, TimeUnit.NANOSECONDS);
        return bytes;
    }

    public long update(DecoratedKey key, Row oldRow, Row newRow, Memtable memtable) {
        if (!this.indexContext.isVector()) {
            return this.index(key, newRow, memtable);
        }
        MemtableIndex target = (MemtableIndex)this.liveMemtableIndexMap.get(memtable);
        if (target == null) {
            return 0L;
        }
        ByteBuffer oldValue = this.indexContext.getValueOf(key, oldRow, FBUtilities.nowInSeconds());
        ByteBuffer newValue = this.indexContext.getValueOf(key, newRow, FBUtilities.nowInSeconds());
        return target.update(key, (Clustering<?>)oldRow.clustering(), oldValue, newValue);
    }

    public void renewMemtable(Memtable renewed) {
        for (Memtable memtable : this.liveMemtableIndexMap.keySet()) {
            if (renewed == memtable) continue;
            this.liveMemtableIndexMap.remove(memtable);
        }
    }

    public void discardMemtable(Memtable discarded) {
        this.liveMemtableIndexMap.remove(discarded);
    }

    @Nullable
    public MemtableIndex getPendingMemtableIndex(LifecycleNewTracker tracker) {
        return this.liveMemtableIndexMap.keySet().stream().filter(m -> tracker.equals(m.getFlushTransaction())).findFirst().map(this.liveMemtableIndexMap::get).orElse(null);
    }

    public KeyRangeIterator searchMemtableIndexes(QueryContext queryContext, Expression e, AbstractBounds<PartitionPosition> keyRange) {
        Collection memtableIndexes = this.liveMemtableIndexMap.values();
        if (memtableIndexes.isEmpty()) {
            return KeyRangeIterator.empty();
        }
        KeyRangeUnionIterator.Builder builder = KeyRangeUnionIterator.builder(memtableIndexes.size());
        for (MemtableIndex memtableIndex : memtableIndexes) {
            ((KeyRangeIterator.Builder)builder).add(memtableIndex.search(queryContext, e, keyRange));
        }
        return builder.build();
    }

    public KeyRangeIterator limitToTopResults(QueryContext context, List<PrimaryKey> source, Expression e) {
        Collection memtables = this.liveMemtableIndexMap.values();
        if (memtables.isEmpty()) {
            return KeyRangeIterator.empty();
        }
        KeyRangeUnionIterator.Builder builder = KeyRangeUnionIterator.builder(memtables.size());
        for (MemtableIndex index : memtables) {
            builder.add(index.limitToTopResults(source, e, context.vectorContext().limit()));
        }
        return builder.build();
    }

    public long liveMemtableWriteCount() {
        return this.liveMemtableIndexMap.values().stream().mapToLong(MemtableIndex::writeCount).sum();
    }

    public long estimatedMemIndexMemoryUsed() {
        return this.liveMemtableIndexMap.values().stream().mapToLong(MemtableIndex::estimatedMemoryUsed).sum();
    }

    @VisibleForTesting
    public int size() {
        return this.liveMemtableIndexMap.size();
    }

    public void invalidate() {
        this.liveMemtableIndexMap.clear();
    }
}

