/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.CassandraWriteContext;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.TargetParser;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.StorageAttachedIndexBuilder;
import org.apache.cassandra.index.sai.StorageAttachedIndexGroup;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.disk.v1.IndexWriterConfig;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.cassandra.index.sai.view.View;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAttachedIndex
implements Index {
    public static final String NAME = "sai";
    public static final String VECTOR_USAGE_WARNING = "SAI ANN indexes on vector columns are experimental and are not recommended for production use.\nThey don't yet support SELECT queries with:\n * Consistency level higher than ONE/LOCAL_ONE.\n * Paging.\n * No LIMIT clauses.\n * PER PARTITION LIMIT clauses.\n * GROUP BY clauses.\n * Aggregation functions.\n * Filters on columns without a SAI index.";
    public static final String VECTOR_NON_FLOAT_ERROR = "SAI ANN indexes are only allowed on vector columns with float elements";
    public static final String VECTOR_1_DIMENSION_COSINE_ERROR = "Cosine similarity is not supported for single-dimension vectors";
    public static final String VECTOR_MULTIPLE_DATA_DIRECTORY_ERROR = "SAI ANN indexes are not allowed on multiple data directories";
    @VisibleForTesting
    public static final String ANALYSIS_ON_KEY_COLUMNS_MESSAGE = "Analysis options are not supported on primary key columns, but found ";
    public static final String ANN_LIMIT_ERROR = "Use of ANN OF in an ORDER BY clause requires a LIMIT that is not greater than %s. LIMIT was %s";
    private static final Logger logger = LoggerFactory.getLogger(StorageAttachedIndex.class);
    private static final StorageAttachedIndexBuildingSupport INDEX_BUILDER_SUPPORT = new StorageAttachedIndexBuildingSupport();
    private static final Set<String> VALID_OPTIONS = ImmutableSet.of((Object)"target", (Object)"class_name", (Object)"maximum_node_connections", (Object)"construction_beam_width", (Object)"similarity_function", (Object)"optimize_for", (Object[])new String[]{"case_sensitive", "normalize", "ascii"});
    public static final Set<CQL3Type> SUPPORTED_TYPES = ImmutableSet.of((Object)CQL3Type.Native.ASCII, (Object)CQL3Type.Native.BIGINT, (Object)CQL3Type.Native.DATE, (Object)CQL3Type.Native.DOUBLE, (Object)CQL3Type.Native.FLOAT, (Object)CQL3Type.Native.INT, (Object[])new CQL3Type[]{CQL3Type.Native.SMALLINT, CQL3Type.Native.TEXT, CQL3Type.Native.TIME, CQL3Type.Native.TIMESTAMP, CQL3Type.Native.TIMEUUID, CQL3Type.Native.TINYINT, CQL3Type.Native.UUID, CQL3Type.Native.VARCHAR, CQL3Type.Native.INET, CQL3Type.Native.VARINT, CQL3Type.Native.DECIMAL, CQL3Type.Native.BOOLEAN});
    private static final Set<Class<? extends IPartitioner>> ILLEGAL_PARTITIONERS = ImmutableSet.of(OrderPreservingPartitioner.class, LocalPartitioner.class, ByteOrderedPartitioner.class, RandomPartitioner.class);
    private final ColumnFamilyStore baseCfs;
    private final IndexContext indexContext;
    private volatile boolean initBuildStarted = false;
    private volatile boolean valid = true;

    public StorageAttachedIndex(ColumnFamilyStore baseCfs, IndexMetadata config) {
        this.baseCfs = baseCfs;
        TableMetadata tableMetadata = baseCfs.metadata();
        Pair<ColumnMetadata, IndexTarget.Type> target = TargetParser.parse(tableMetadata, config);
        this.indexContext = new IndexContext(tableMetadata.keyspace, tableMetadata.name, tableMetadata.partitionKeyType, tableMetadata.partitioner, tableMetadata.comparator, (ColumnMetadata)target.left, (IndexTarget.Type)((Object)target.right), config);
    }

    public static Map<String, String> validateOptions(Map<String, String> options, TableMetadata metadata) {
        HashMap<String, String> unknown = new HashMap<String, String>(2);
        for (Map.Entry<String, String> option : options.entrySet()) {
            if (VALID_OPTIONS.contains(option.getKey())) continue;
            unknown.put(option.getKey(), option.getValue());
        }
        if (!unknown.isEmpty()) {
            return unknown;
        }
        if (ILLEGAL_PARTITIONERS.contains(metadata.partitioner.getClass())) {
            throw new InvalidRequestException("Storage-attached index does not support the following IPartitioner implementations: " + ILLEGAL_PARTITIONERS);
        }
        String targetColumn = options.get("target");
        if (targetColumn == null) {
            throw new InvalidRequestException("Missing target column");
        }
        if (targetColumn.split(",").length > 1) {
            throw new InvalidRequestException("A storage-attached index cannot be created over multiple columns: " + targetColumn);
        }
        Pair<ColumnMetadata, IndexTarget.Type> target = TargetParser.parse(metadata, targetColumn);
        if (target == null) {
            throw new InvalidRequestException("Failed to retrieve target column for: " + targetColumn);
        }
        if (metadata.indexes.stream().filter(index -> index.getIndexClassName().equals(StorageAttachedIndex.class.getName())).map(index -> TargetParser.parse(metadata, index.options.get("target"))).filter(Objects::nonNull).filter(t -> t.equals(target)).count() > 1L) {
            throw new InvalidRequestException("Cannot create more than one storage-attached index on the same column: " + target.left);
        }
        Map<String, String> analysisOptions = AbstractAnalyzer.getAnalyzerOptions(options);
        if (((ColumnMetadata)target.left).isPrimaryKeyColumn() && !analysisOptions.isEmpty()) {
            throw new InvalidRequestException(ANALYSIS_ON_KEY_COLUMNS_MESSAGE + new CqlBuilder().append(analysisOptions));
        }
        AbstractType<?> type = TypeUtil.cellValueType((ColumnMetadata)target.left, (IndexTarget.Type)((Object)target.right));
        AbstractAnalyzer.fromOptions(type, analysisOptions);
        IndexWriterConfig config = IndexWriterConfig.fromOptions(null, type, options);
        if (TypeUtil.isComposite(type)) {
            for (AbstractType<?> subType : type.subTypes()) {
                if (SUPPORTED_TYPES.contains(subType.asCQL3Type()) || TypeUtil.isFrozen(subType)) continue;
                throw new InvalidRequestException("Unsupported type: " + subType.asCQL3Type());
            }
        } else {
            if (!SUPPORTED_TYPES.contains(type.asCQL3Type()) && !TypeUtil.isFrozen(type)) {
                throw new InvalidRequestException("Unsupported type: " + type.asCQL3Type());
            }
            if (type.isVector()) {
                VectorType vectorType = (VectorType)type;
                if (!(vectorType.elementType instanceof FloatType)) {
                    throw new InvalidRequestException(VECTOR_NON_FLOAT_ERROR);
                }
                if (vectorType.dimension == 1 && config.getSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                    throw new InvalidRequestException(VECTOR_1_DIMENSION_COSINE_ERROR);
                }
                if (DatabaseDescriptor.getRawConfig().data_file_directories.length > 1) {
                    throw new InvalidRequestException(VECTOR_MULTIPLE_DATA_DIRECTORY_ERROR);
                }
                ClientWarn.instance.warn(VECTOR_USAGE_WARNING);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void register(IndexRegistry registry) {
        registry.registerIndex(this, StorageAttachedIndexGroup.GROUP_KEY, () -> new StorageAttachedIndexGroup(this.baseCfs));
    }

    @Override
    public void unregister(IndexRegistry registry) {
        registry.unregisterIndex(this, StorageAttachedIndexGroup.GROUP_KEY);
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.indexContext.getIndexMetadata();
    }

    @Override
    public Callable<?> getInitializationTask() {
        IndexValidation validation = StorageService.instance.isStarting() ? IndexValidation.HEADER_FOOTER : IndexValidation.NONE;
        return () -> this.startInitialBuild(this.baseCfs, validation).get();
    }

    private Future<?> startInitialBuild(ColumnFamilyStore baseCfs, IndexValidation validation) {
        if (baseCfs.indexManager.isIndexQueryable(this)) {
            logger.debug(this.indexContext.logMessage("Skipping validation and building in initialization task, as pre-join has already made the storage-attached index queryable..."));
            this.initBuildStarted = true;
            return CompletableFuture.completedFuture(null);
        }
        logger.debug(this.indexContext.logMessage("Stopping active compactions to make sure all sstables are indexed after initial build."));
        CompactionManager.instance.interruptCompactionFor(Collections.singleton(baseCfs.metadata()), ssTableReader -> true, true);
        if (!baseCfs.getTracker().getView().liveMemtables.isEmpty()) {
            baseCfs.forceBlockingFlush(ColumnFamilyStore.FlushReason.INDEX_BUILD_STARTED);
        }
        this.initBuildStarted = true;
        StorageAttachedIndexGroup indexGroup = StorageAttachedIndexGroup.getIndexGroup(baseCfs);
        assert (indexGroup != null) : "Index group does not exist for table " + baseCfs.keyspace + "." + baseCfs.name;
        List<SSTableReader> nonIndexed = this.findNonIndexedSSTables(baseCfs, indexGroup, validation);
        if (nonIndexed.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        List<List<SSTableReader>> groups = StorageAttachedIndex.groupBySize(nonIndexed, DatabaseDescriptor.getConcurrentIndexBuilders());
        ArrayList futures = new ArrayList();
        for (List<SSTableReader> group : groups) {
            TreeMap<SSTableReader, Set<StorageAttachedIndex>> current = new TreeMap<SSTableReader, Set<StorageAttachedIndex>>(Comparator.comparing(s -> s.descriptor.id, SSTableIdFactory.COMPARATOR));
            group.forEach(sstable -> current.put((SSTableReader)sstable, Collections.singleton(this)));
            futures.add(CompactionManager.instance.submitIndexBuild(new StorageAttachedIndexBuilder(indexGroup, current, false, true)));
        }
        logger.info(this.indexContext.logMessage("Submitting {} parallel initial index builds over {} total sstables..."), (Object)futures.size(), (Object)nonIndexed.size());
        return Futures.allAsList(futures);
    }

    @VisibleForTesting
    public static List<List<SSTableReader>> groupBySize(List<SSTableReader> toRebuild, int parallelism) {
        ArrayList<List<SSTableReader>> groups = new ArrayList<List<SSTableReader>>();
        toRebuild.sort(Comparator.comparingLong(SSTableReader::onDiskLength).reversed());
        Iterator<SSTableReader> sortedSSTables = toRebuild.iterator();
        double dataPerCompactor = (double)toRebuild.stream().mapToLong(SSTableReader::onDiskLength).sum() * 1.0 / (double)parallelism;
        while (sortedSSTables.hasNext()) {
            long sum = 0L;
            ArrayList<SSTableReader> current = new ArrayList<SSTableReader>();
            while (sortedSSTables.hasNext() && (double)sum < dataPerCompactor) {
                SSTableReader sstable = sortedSSTables.next();
                sum += sstable.onDiskLength();
                current.add(sstable);
            }
            assert (!current.isEmpty());
            groups.add(current);
        }
        return groups;
    }

    @Override
    public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
        return null;
    }

    @Override
    public Callable<?> getBlockingFlushTask() {
        return null;
    }

    @Override
    public Callable<?> getInvalidateTask() {
        return () -> {
            this.valid = false;
            Set<Component> toRemove = this.getComponents();
            for (SSTableIndex sstableIndex : this.indexContext.getView().getIndexes()) {
                sstableIndex.getSSTable().unregisterComponents(toRemove, this.baseCfs.getTracker());
            }
            this.indexContext.invalidate();
            return null;
        };
    }

    @Override
    public Callable<?> getPreJoinTask(boolean hadBootstrap) {
        return this::startPreJoinTask;
    }

    public boolean isInitBuildStarted() {
        return this.initBuildStarted;
    }

    public BooleanSupplier isIndexValid() {
        return () -> this.valid;
    }

    private Future<?> startPreJoinTask() {
        try {
            if (this.baseCfs.indexManager.isIndexQueryable(this)) {
                logger.debug(this.indexContext.logMessage("Skipping validation in pre-join task, as the initialization task has already made the index queryable..."));
                this.baseCfs.indexManager.makeIndexQueryable(this, Index.Status.BUILD_SUCCEEDED);
                return null;
            }
            StorageAttachedIndexGroup indexGroup = StorageAttachedIndexGroup.getIndexGroup(this.baseCfs);
            assert (indexGroup != null) : "Index group does not exist for table";
            List<SSTableReader> nonIndexed = this.findNonIndexedSSTables(this.baseCfs, indexGroup, IndexValidation.HEADER_FOOTER);
            if (nonIndexed.isEmpty()) {
                this.baseCfs.indexManager.makeIndexQueryable(this, Index.Status.BUILD_SUCCEEDED);
            }
        }
        catch (Throwable t) {
            logger.error(this.indexContext.logMessage("Failed in pre-join task!"), t);
        }
        return null;
    }

    @Override
    public Callable<?> getTruncateTask(long truncatedAt) {
        return null;
    }

    @Override
    public boolean shouldBuildBlocking() {
        return true;
    }

    @Override
    public boolean isSSTableAttached() {
        return true;
    }

    @Override
    public Optional<ColumnFamilyStore> getBackingTable() {
        return Optional.empty();
    }

    @Override
    public boolean dependsOn(ColumnMetadata column) {
        return this.indexContext.getDefinition().compareTo(column) == 0;
    }

    @Override
    public boolean supportsExpression(ColumnMetadata column, Operator operator) {
        return this.dependsOn(column) && this.indexContext.supports(operator);
    }

    @Override
    public boolean filtersMultipleContains() {
        return false;
    }

    @Override
    public AbstractType<?> customExpressionValueType() {
        return null;
    }

    @Override
    public RowFilter getPostIndexQueryFilter(RowFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<ByteBuffer> getPostQueryOrdering(Restriction restriction, QueryOptions options) {
        assert (restriction instanceof SingleColumnRestriction.AnnRestriction);
        Preconditions.checkState((boolean)this.indexContext.isVector());
        SingleColumnRestriction.AnnRestriction annRestriction = (SingleColumnRestriction.AnnRestriction)restriction;
        VectorSimilarityFunction function = this.indexContext.getIndexWriterConfig().getSimilarityFunction();
        float[] target = TypeUtil.decomposeVector(this.indexContext, annRestriction.value(options).duplicate());
        return (leftBuf, rightBuf) -> {
            float[] left = TypeUtil.decomposeVector(this.indexContext, leftBuf.duplicate());
            double scoreLeft = function.compare(left, target);
            float[] right = TypeUtil.decomposeVector(this.indexContext, rightBuf.duplicate());
            double scoreRight = function.compare(right, target);
            return Double.compare(scoreRight, scoreLeft);
        };
    }

    @Override
    public void validate(ReadCommand command) throws InvalidRequestException {
        if (!this.getIndexContext().isVector()) {
            return;
        }
        if (command.limits().count() > IndexWriterConfig.MAX_TOP_K) {
            throw new InvalidRequestException(String.format(ANN_LIMIT_ERROR, IndexWriterConfig.MAX_TOP_K, command.limits().count()));
        }
    }

    @Override
    public long getEstimatedResultRows() {
        throw new UnsupportedOperationException("Use StorageAttachedIndexQueryPlan#getEstimatedResultRows() instead.");
    }

    @Override
    public boolean isQueryable(Index.Status status) {
        return status == Index.Status.BUILD_SUCCEEDED || status == Index.Status.UNKNOWN;
    }

    @Override
    public void validate(PartitionUpdate update) throws InvalidRequestException {
    }

    private synchronized List<SSTableReader> findNonIndexedSSTables(ColumnFamilyStore baseCfs, StorageAttachedIndexGroup group, IndexValidation validation) {
        Set<SSTableReader> sstables = baseCfs.getLiveSSTables();
        assert (group != null) : "Missing index group on " + baseCfs.name;
        group.onSSTableChanged(Collections.emptyList(), sstables, Collections.singleton(this), validation);
        ArrayList<SSTableReader> nonIndexed = new ArrayList<SSTableReader>();
        View view = this.indexContext.getView();
        for (SSTableReader sstable : sstables) {
            if (view.containsSSTable(sstable) || sstable.isMarkedCompacted() || IndexDescriptor.create(sstable).isPerColumnIndexBuildComplete(this.indexContext)) continue;
            nonIndexed.add(sstable);
        }
        return nonIndexed;
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker) {
        throw new UnsupportedOperationException("Storage-attached index flush observers should never be created directly.");
    }

    @Override
    public Set<Component> getComponents() {
        return Version.LATEST.onDiskFormat().perColumnIndexComponents(this.indexContext).stream().map(c -> Version.LATEST.makePerIndexComponent((IndexComponent)((Object)c), this.indexContext)).collect(Collectors.toSet());
    }

    @Override
    public Index.Indexer indexerFor(DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, WriteContext writeContext, IndexTransaction.Type transactionType, Memtable memtable) {
        if (transactionType == IndexTransaction.Type.UPDATE) {
            return new UpdateIndexer(key, memtable, writeContext);
        }
        return null;
    }

    @Override
    public Index.IndexBuildingSupport getBuildTaskSupport() {
        return INDEX_BUILDER_SUPPORT;
    }

    public IndexContext getIndexContext() {
        return this.indexContext;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.baseCfs.keyspace.getName(), this.baseCfs.name, this.getIndexMetadata() == null ? "?" : this.getIndexMetadata());
    }

    public void makeIndexNonQueryable() {
        this.baseCfs.indexManager.makeIndexNonQueryable(this, Index.Status.BUILD_FAILED);
        logger.warn(this.indexContext.logMessage("Storage-attached index is no longer queryable. Please restart this node to repair it."));
    }

    private class UpdateIndexer
    implements Index.Indexer {
        private final DecoratedKey key;
        private final Memtable memtable;
        private final WriteContext writeContext;

        UpdateIndexer(DecoratedKey key, Memtable memtable, WriteContext writeContext) {
            this.key = key;
            this.memtable = memtable;
            this.writeContext = writeContext;
        }

        @Override
        public void insertRow(Row row) {
            this.adjustMemtableSize(StorageAttachedIndex.this.indexContext.getMemtableIndexManager().index(this.key, row, this.memtable), CassandraWriteContext.fromContext(this.writeContext).getGroup());
        }

        @Override
        public void updateRow(Row oldRow, Row newRow) {
            this.adjustMemtableSize(StorageAttachedIndex.this.indexContext.getMemtableIndexManager().update(this.key, oldRow, newRow, this.memtable), CassandraWriteContext.fromContext(this.writeContext).getGroup());
        }

        void adjustMemtableSize(long additionalSpace, OpOrder.Group opGroup) {
            if (additionalSpace >= 0L) {
                this.memtable.markExtraOnHeapUsed(additionalSpace, opGroup);
            }
        }
    }

    private static class StorageAttachedIndexBuildingSupport
    implements Index.IndexBuildingSupport {
        private StorageAttachedIndexBuildingSupport() {
        }

        @Override
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore cfs, Set<Index> indexes, Collection<SSTableReader> sstablesToRebuild, boolean isFullRebuild) {
            TreeMap<SSTableReader, Set<StorageAttachedIndex>> sstables = new TreeMap<SSTableReader, Set<StorageAttachedIndex>>(Comparator.comparing(s -> s.descriptor.id, SSTableIdFactory.COMPARATOR));
            StorageAttachedIndexGroup group = StorageAttachedIndexGroup.getIndexGroup(cfs);
            assert (group != null) : "Index group does not exist for table " + cfs.keyspace + "." + cfs.name;
            indexes.stream().filter(i -> i instanceof StorageAttachedIndex).forEach(i -> {
                StorageAttachedIndex sai = (StorageAttachedIndex)i;
                IndexContext indexContext = ((StorageAttachedIndex)i).getIndexContext();
                Collection ss = sstablesToRebuild;
                if (!isFullRebuild) {
                    ss = sstablesToRebuild.stream().filter(s -> !IndexDescriptor.create(s).isPerColumnIndexBuildComplete(indexContext)).collect(Collectors.toList());
                }
                group.dropIndexSSTables(ss, sai);
                ss.forEach(sstable -> sstables.computeIfAbsent((SSTableReader)sstable, ignore -> new HashSet()).add(sai));
            });
            return new StorageAttachedIndexBuilder(group, sstables, isFullRebuild, false);
        }
    }
}

