/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongPredicate;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.AbstractCompactionController;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.PurgeFunction;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.db.transform.DuplicateRowChecker;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.transactions.CompactionTransaction;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.TopPartitionTracker;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;
import org.apache.cassandra.service.paxos.uncommitted.PaxosRows;
import org.apache.cassandra.utils.TimeUUID;

public class CompactionIterator
extends CompactionInfo.Holder
implements UnfilteredPartitionIterator {
    private static final long UNFILTERED_TO_UPDATE_PROGRESS = 100L;
    private final OperationType type;
    private final AbstractCompactionController controller;
    private final List<ISSTableScanner> scanners;
    private final ImmutableSet<SSTableReader> sstables;
    private final long nowInSec;
    private final TimeUUID compactionId;
    private final long totalBytes;
    private long bytesRead;
    private long totalSourceCQLRows;
    private volatile String targetDirectory;
    private final long[] mergeCounters;
    private final UnfilteredPartitionIterator compacted;
    private final ActiveCompactionsTracker activeCompactions;

    public CompactionIterator(OperationType type, List<ISSTableScanner> scanners, AbstractCompactionController controller, long nowInSec, TimeUUID compactionId) {
        this(type, scanners, controller, nowInSec, compactionId, ActiveCompactionsTracker.NOOP, null);
    }

    public CompactionIterator(OperationType type, List<ISSTableScanner> scanners, AbstractCompactionController controller, long nowInSec, TimeUUID compactionId, ActiveCompactionsTracker activeCompactions, TopPartitionTracker.Collector topPartitionCollector) {
        UnfilteredPartitionIterator merged;
        this.controller = controller;
        this.type = type;
        this.scanners = scanners;
        this.nowInSec = nowInSec;
        this.compactionId = compactionId;
        this.bytesRead = 0L;
        long bytes = 0L;
        for (ISSTableScanner scanner : scanners) {
            bytes += scanner.getLengthInBytes();
        }
        this.totalBytes = bytes;
        this.mergeCounters = new long[scanners.size()];
        this.sstables = (ImmutableSet)scanners.stream().map(ISSTableScanner::getBackingSSTables).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        this.activeCompactions = activeCompactions == null ? ActiveCompactionsTracker.NOOP : activeCompactions;
        this.activeCompactions.beginCompaction(this);
        UnfilteredPartitionIterator unfilteredPartitionIterator = merged = scanners.isEmpty() ? EmptyIterators.unfilteredPartition(controller.cfs.metadata()) : UnfilteredPartitionIterators.merge(scanners, this.listener());
        if (topPartitionCollector != null) {
            merged = Transformation.apply(merged, new TopPartitionTracker.TombstoneCounter(topPartitionCollector, nowInSec));
        }
        merged = Transformation.apply(merged, new GarbageSkipper(controller));
        Transformation purger = CompactionIterator.isPaxos(controller.cfs) && DatabaseDescriptor.paxosStatePurging() != Config.PaxosStatePurging.legacy ? new PaxosPurger(nowInSec) : new Purger(controller, nowInSec);
        merged = Transformation.apply(merged, purger);
        merged = DuplicateRowChecker.duringCompaction(merged, type);
        this.compacted = Transformation.apply(merged, new AbortableUnfilteredPartitionTransformation(this));
    }

    @Override
    public TableMetadata metadata() {
        return this.controller.cfs.metadata();
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.controller.cfs.metadata(), this.type, this.bytesRead, this.totalBytes, this.compactionId, (Collection<SSTableReader>)this.sstables, this.targetDirectory);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    private void updateCounterFor(int rows) {
        assert (rows > 0 && rows - 1 < this.mergeCounters.length);
        int n = rows - 1;
        this.mergeCounters[n] = this.mergeCounters[n] + 1L;
    }

    public long[] getMergedRowCounts() {
        return this.mergeCounters;
    }

    public long getTotalSourceCQLRows() {
        return this.totalSourceCQLRows;
    }

    private UnfilteredPartitionIterators.MergeListener listener() {
        return new UnfilteredPartitionIterators.MergeListener(){

            private boolean rowProcessingNeeded() {
                return (CompactionIterator.this.type == OperationType.COMPACTION || CompactionIterator.this.type == OperationType.MAJOR_COMPACTION) && CompactionIterator.this.controller.cfs.indexManager.handles(IndexTransaction.Type.COMPACTION);
            }

            @Override
            public boolean preserveOrder() {
                return this.rowProcessingNeeded();
            }

            @Override
            public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                int merged = 0;
                int isize = versions.size();
                for (int i = 0; i < isize; ++i) {
                    UnfilteredRowIterator iter = versions.get(i);
                    if (iter == null) continue;
                    ++merged;
                }
                assert (merged > 0);
                CompactionIterator.this.updateCounterFor(merged);
                if (!this.rowProcessingNeeded()) {
                    return null;
                }
                Columns statics = Columns.NONE;
                Columns regulars = Columns.NONE;
                int isize2 = versions.size();
                for (int i = 0; i < isize2; ++i) {
                    UnfilteredRowIterator iter = versions.get(i);
                    if (iter == null) continue;
                    statics = statics.mergeTo(iter.columns().statics);
                    regulars = regulars.mergeTo(iter.columns().regulars);
                }
                RegularAndStaticColumns regularAndStaticColumns = new RegularAndStaticColumns(statics, regulars);
                final CompactionTransaction indexTransaction = CompactionIterator.this.controller.cfs.indexManager.newCompactionTransaction(partitionKey, regularAndStaticColumns, versions.size(), CompactionIterator.this.nowInSec);
                return new UnfilteredRowIterators.MergeListener(){

                    @Override
                    public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                    }

                    @Override
                    public Row onMergedRows(Row merged, Row[] versions) {
                        indexTransaction.start();
                        indexTransaction.onRowMerge(merged, versions);
                        indexTransaction.commit();
                        return merged;
                    }

                    @Override
                    public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker mergedMarker, RangeTombstoneMarker[] versions) {
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public void close() {
            }
        };
    }

    private void updateBytesRead() {
        long n = 0L;
        for (ISSTableScanner scanner : this.scanners) {
            n += scanner.getCurrentPosition();
        }
        this.bytesRead = n;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public boolean hasNext() {
        return this.compacted.hasNext();
    }

    @Override
    public UnfilteredRowIterator next() {
        return (UnfilteredRowIterator)this.compacted.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        try {
            this.compacted.close();
        }
        finally {
            this.activeCompactions.finishCompaction(this);
        }
    }

    public String toString() {
        return this.getCompactionInfo().toString();
    }

    private static boolean isPaxos(ColumnFamilyStore cfs) {
        return cfs.name.equals("paxos") && cfs.getKeyspaceName().equals("system");
    }

    private static class AbortableUnfilteredRowTransformation
    extends Transformation<UnfilteredRowIterator> {
        private final CompactionIterator iter;

        private AbortableUnfilteredRowTransformation(CompactionIterator iter) {
            this.iter = iter;
        }

        @Override
        public Row applyToRow(Row row) {
            if (this.iter.isStopRequested()) {
                throw new CompactionInterruptedException(this.iter.getCompactionInfo());
            }
            return row;
        }
    }

    private static class AbortableUnfilteredPartitionTransformation
    extends Transformation<UnfilteredRowIterator> {
        private final AbortableUnfilteredRowTransformation abortableIter;

        private AbortableUnfilteredPartitionTransformation(CompactionIterator iter) {
            this.abortableIter = new AbortableUnfilteredRowTransformation(iter);
        }

        @Override
        protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            if (this.abortableIter.iter.isStopRequested()) {
                throw new CompactionInterruptedException(this.abortableIter.iter.getCompactionInfo());
            }
            return Transformation.apply(partition, this.abortableIter);
        }
    }

    private class PaxosPurger
    extends Transformation<UnfilteredRowIterator> {
        private final long nowInSec;
        private final long paxosPurgeGraceMicros = DatabaseDescriptor.getPaxosPurgeGrace(TimeUnit.MICROSECONDS);
        private final Map<TableId, PaxosRepairHistory.Searcher> tableIdToHistory = new HashMap<TableId, PaxosRepairHistory.Searcher>();
        private Token currentToken;
        private int compactedUnfiltered;

        private PaxosPurger(long nowInSec) {
            this.nowInSec = nowInSec;
        }

        protected void onEmptyPartitionPostPurge(DecoratedKey key) {
            if (CompactionIterator.this.type == OperationType.COMPACTION) {
                CompactionIterator.this.controller.cfs.invalidateCachedPartition(key);
            }
        }

        protected void updateProgress() {
            if ((long)(++this.compactedUnfiltered) % 100L == 0L) {
                CompactionIterator.this.updateBytesRead();
            }
        }

        @Override
        protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            this.currentToken = partition.partitionKey().getToken();
            UnfilteredRowIterator purged = Transformation.apply(partition, this);
            if (purged.isEmpty()) {
                this.onEmptyPartitionPostPurge(purged.partitionKey());
                purged.close();
                return null;
            }
            return purged;
        }

        @Override
        protected Row applyToRow(Row row) {
            this.updateProgress();
            TableId tableId = PaxosRows.getTableId(row);
            switch (DatabaseDescriptor.paxosStatePurging()) {
                default: {
                    throw new AssertionError();
                }
                case legacy: 
                case gc_grace: {
                    TableMetadata metadata = Schema.instance.getTableMetadata(tableId);
                    return row.purgeDataOlderThan(TimeUnit.SECONDS.toMicros(this.nowInSec - (long)(metadata == null ? 10800 : metadata.params.gcGraceSeconds)), false);
                }
                case repaired: 
            }
            PaxosRepairHistory.Searcher history = this.tableIdToHistory.computeIfAbsent(tableId, find -> {
                TableMetadata metadata = Schema.instance.getTableMetadata((TableId)find);
                if (metadata == null) {
                    return null;
                }
                return Keyspace.openAndGetStore(metadata).getPaxosRepairHistory().searcher();
            });
            return history == null ? row : row.purgeDataOlderThan(history.ballotForToken(this.currentToken).unixMicros() - this.paxosPurgeGraceMicros, false);
        }
    }

    private static class GarbageSkipper
    extends Transformation<UnfilteredRowIterator> {
        final AbstractCompactionController controller;
        final boolean cellLevelGC;

        private GarbageSkipper(AbstractCompactionController controller) {
            this.controller = controller;
            this.cellLevelGC = controller.tombstoneOption == CompactionParams.TombstoneOption.CELL;
        }

        @Override
        protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            Iterable<UnfilteredRowIterator> sources = this.controller.shadowSources(partition.partitionKey(), !this.cellLevelGC);
            if (sources == null) {
                return partition;
            }
            ArrayList<UnfilteredRowIterator> iters = new ArrayList<UnfilteredRowIterator>();
            for (UnfilteredRowIterator iter : sources) {
                if (!iter.isEmpty()) {
                    iters.add(iter);
                    continue;
                }
                iter.close();
            }
            if (iters.isEmpty()) {
                return partition;
            }
            return new GarbageSkippingUnfilteredRowIterator(partition, UnfilteredRowIterators.merge(iters), this.cellLevelGC);
        }
    }

    private static class GarbageSkippingUnfilteredRowIterator
    implements WrappingUnfilteredRowIterator {
        private final UnfilteredRowIterator wrapped;
        final UnfilteredRowIterator tombSource;
        final DeletionTime partitionLevelDeletion;
        final Row staticRow;
        final ColumnFilter cf;
        final TableMetadata metadata;
        final boolean cellLevelGC;
        DeletionTime tombOpenDeletionTime = DeletionTime.LIVE;
        DeletionTime dataOpenDeletionTime = DeletionTime.LIVE;
        DeletionTime openDeletionTime = DeletionTime.LIVE;
        DeletionTime partitionDeletionTime;
        DeletionTime activeDeletionTime;
        Unfiltered tombNext = null;
        Unfiltered dataNext = null;
        Unfiltered next = null;

        protected GarbageSkippingUnfilteredRowIterator(UnfilteredRowIterator dataSource, UnfilteredRowIterator tombSource, boolean cellLevelGC) {
            this.wrapped = dataSource;
            this.tombSource = tombSource;
            this.cellLevelGC = cellLevelGC;
            this.metadata = dataSource.metadata();
            this.cf = ColumnFilter.all(this.metadata);
            this.activeDeletionTime = this.partitionDeletionTime = tombSource.partitionLevelDeletion();
            this.partitionLevelDeletion = dataSource.partitionLevelDeletion().supersedes(tombSource.partitionLevelDeletion()) ? dataSource.partitionLevelDeletion() : DeletionTime.LIVE;
            Row dataStaticRow = this.garbageFilterRow(dataSource.staticRow(), tombSource.staticRow());
            this.staticRow = dataStaticRow != null ? dataStaticRow : Rows.EMPTY_STATIC_ROW;
            this.tombNext = GarbageSkippingUnfilteredRowIterator.advance(tombSource);
            this.dataNext = GarbageSkippingUnfilteredRowIterator.advance(dataSource);
        }

        @Override
        public UnfilteredRowIterator wrapped() {
            return this.wrapped;
        }

        private static Unfiltered advance(UnfilteredRowIterator source) {
            return source.hasNext() ? (Unfiltered)source.next() : null;
        }

        @Override
        public DeletionTime partitionLevelDeletion() {
            return this.partitionLevelDeletion;
        }

        @Override
        public void close() {
            this.wrapped.close();
            this.tombSource.close();
        }

        @Override
        public Row staticRow() {
            return this.staticRow;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.dataNext != null) {
                int cmp;
                int n = cmp = this.tombNext == null ? -1 : this.metadata.comparator.compare(this.dataNext, this.tombNext);
                if (cmp < 0) {
                    this.next = this.dataNext.isRow() ? ((Row)this.dataNext).filter(this.cf, this.activeDeletionTime, false, this.metadata) : this.processDataMarker();
                } else if (cmp == 0) {
                    if (this.dataNext.isRow()) {
                        this.next = this.garbageFilterRow((Row)this.dataNext, (Row)this.tombNext);
                    } else {
                        this.tombOpenDeletionTime = this.updateOpenDeletionTime(this.tombOpenDeletionTime, this.tombNext);
                        this.activeDeletionTime = (DeletionTime)Ordering.natural().max((Object)this.partitionDeletionTime, (Object)this.tombOpenDeletionTime);
                        this.next = this.processDataMarker();
                    }
                } else if (this.tombNext.isRangeTombstoneMarker()) {
                    boolean supersededAfter;
                    this.tombOpenDeletionTime = this.updateOpenDeletionTime(this.tombOpenDeletionTime, this.tombNext);
                    this.activeDeletionTime = (DeletionTime)Ordering.natural().max((Object)this.partitionDeletionTime, (Object)this.tombOpenDeletionTime);
                    boolean supersededBefore = this.openDeletionTime.isLive();
                    boolean bl = supersededAfter = !this.dataOpenDeletionTime.supersedes(this.activeDeletionTime);
                    if (supersededBefore && !supersededAfter) {
                        this.next = new RangeTombstoneBoundMarker((ClusteringBound<?>)((RangeTombstoneMarker)this.tombNext).closeBound(false).invert(), this.dataOpenDeletionTime);
                    }
                }
                if (this.next instanceof RangeTombstoneMarker) {
                    this.openDeletionTime = this.updateOpenDeletionTime(this.openDeletionTime, this.next);
                }
                if (cmp <= 0) {
                    this.dataNext = GarbageSkippingUnfilteredRowIterator.advance(this.wrapped);
                }
                if (cmp < 0) continue;
                this.tombNext = GarbageSkippingUnfilteredRowIterator.advance(this.tombSource);
            }
            return this.next != null;
        }

        protected Row garbageFilterRow(Row dataRow, Row tombRow) {
            if (this.cellLevelGC) {
                return Rows.removeShadowedCells(dataRow, tombRow, this.activeDeletionTime);
            }
            DeletionTime deletion = (DeletionTime)Ordering.natural().max((Object)tombRow.deletion().time(), (Object)this.activeDeletionTime);
            return dataRow.filter(this.cf, deletion, false, this.metadata);
        }

        private RangeTombstoneMarker processDataMarker() {
            this.dataOpenDeletionTime = this.updateOpenDeletionTime(this.dataOpenDeletionTime, this.dataNext);
            boolean supersededBefore = this.openDeletionTime.isLive();
            boolean supersededAfter = !this.dataOpenDeletionTime.supersedes(this.activeDeletionTime);
            RangeTombstoneMarker marker = (RangeTombstoneMarker)this.dataNext;
            if (!supersededBefore) {
                if (!supersededAfter) {
                    return marker;
                }
                return new RangeTombstoneBoundMarker(marker.closeBound(false), marker.closeDeletionTime(false));
            }
            if (!supersededAfter) {
                return new RangeTombstoneBoundMarker(marker.openBound(false), marker.openDeletionTime(false));
            }
            return null;
        }

        @Override
        public Unfiltered next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            Unfiltered v = this.next;
            this.next = null;
            return v;
        }

        private DeletionTime updateOpenDeletionTime(DeletionTime openDeletionTime, Unfiltered next) {
            RangeTombstoneMarker marker = (RangeTombstoneMarker)next;
            assert (openDeletionTime.isLive() == !marker.isClose(false));
            assert (openDeletionTime.isLive() || openDeletionTime.equals(marker.closeDeletionTime(false)));
            return marker.isOpen(false) ? marker.openDeletionTime(false) : DeletionTime.LIVE;
        }
    }

    private class Purger
    extends PurgeFunction {
        private final AbstractCompactionController controller;
        private DecoratedKey currentKey;
        private LongPredicate purgeEvaluator;
        private long compactedUnfiltered;

        private Purger(AbstractCompactionController controller, long nowInSec) {
            super(nowInSec, controller.gcBefore, controller.compactingRepaired() ? Long.MAX_VALUE : Integer.MIN_VALUE, controller.cfs.getCompactionStrategyManager().onlyPurgeRepairedTombstones(), controller.cfs.metadata.get().enforceStrictLiveness());
            this.controller = controller;
        }

        @Override
        protected void onEmptyPartitionPostPurge(DecoratedKey key) {
            if (CompactionIterator.this.type == OperationType.COMPACTION) {
                this.controller.cfs.invalidateCachedPartition(key);
            }
        }

        @Override
        protected void onNewPartition(DecoratedKey key) {
            this.currentKey = key;
            this.purgeEvaluator = null;
        }

        @Override
        protected void updateProgress() {
            ++CompactionIterator.this.totalSourceCQLRows;
            if (++this.compactedUnfiltered % 100L == 0L) {
                CompactionIterator.this.updateBytesRead();
            }
        }

        @Override
        protected boolean shouldIgnoreGcGrace() {
            return this.controller.cfs.shouldIgnoreGcGraceForKey(this.currentKey);
        }

        @Override
        protected LongPredicate getPurgeEvaluator() {
            if (this.purgeEvaluator == null) {
                this.purgeEvaluator = this.controller.getPurgeEvaluator(this.currentKey);
            }
            return this.purgeEvaluator;
        }
    }
}

