/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.function.Predicate;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public class InOurDc {
    private static ReplicaTester replicas;
    private static EndpointTester endpoints;
    final String dc;
    final IEndpointSnitch snitch;

    private InOurDc(String dc, IEndpointSnitch snitch) {
        this.dc = dc;
        this.snitch = snitch;
    }

    boolean stale() {
        return this.dc != DatabaseDescriptor.getLocalDataCenter() || this.snitch != DatabaseDescriptor.getEndpointSnitch() || !this.dc.equals(this.snitch.getLocalDatacenter());
    }

    public static Predicate<Replica> replicas() {
        ReplicaTester cur = replicas;
        if (cur == null || cur.stale()) {
            replicas = cur = new ReplicaTester(DatabaseDescriptor.getLocalDataCenter(), DatabaseDescriptor.getEndpointSnitch());
        }
        return cur;
    }

    public static Predicate<InetAddressAndPort> endpoints() {
        EndpointTester cur = endpoints;
        if (cur == null || cur.stale()) {
            endpoints = cur = new EndpointTester(DatabaseDescriptor.getLocalDataCenter(), DatabaseDescriptor.getEndpointSnitch());
        }
        return cur;
    }

    public static boolean isInOurDc(Replica replica) {
        return InOurDc.replicas().test(replica);
    }

    public static boolean isInOurDc(InetAddressAndPort endpoint) {
        return InOurDc.endpoints().test(endpoint);
    }

    private static final class EndpointTester
    extends InOurDc
    implements Predicate<InetAddressAndPort> {
        private EndpointTester(String dc, IEndpointSnitch snitch) {
            super(dc, snitch);
        }

        @Override
        public boolean test(InetAddressAndPort endpoint) {
            return this.dc.equals(this.snitch.getDatacenter(endpoint));
        }
    }

    private static final class ReplicaTester
    extends InOurDc
    implements Predicate<Replica> {
        private ReplicaTester(String dc, IEndpointSnitch snitch) {
            super(dc, snitch);
        }

        @Override
        public boolean test(Replica replica) {
            return this.dc.equals(this.snitch.getDatacenter(replica.endpoint()));
        }
    }
}

