/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Callables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.uncommitted.PaxosKeyState;
import org.apache.cassandra.service.paxos.uncommitted.PaxosRows;
import org.apache.cassandra.service.paxos.uncommitted.PaxosUncommittedTracker;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class PaxosUncommittedIndex
implements Index,
PaxosUncommittedTracker.UpdateSupplier {
    public final ColumnFamilyStore baseCfs;
    protected IndexMetadata metadata;
    private static final DataRange FULL_RANGE = DataRange.allData(DatabaseDescriptor.getPartitioner());
    private final ColumnFilter memtableColumnFilter;
    private final Index.Indexer indexer = new Index.Indexer(){

        @Override
        public void begin() {
        }

        @Override
        public void partitionDelete(DeletionTime deletionTime) {
        }

        @Override
        public void rangeTombstone(RangeTombstone tombstone) {
        }

        @Override
        public void insertRow(Row row) {
            PaxosState.ballotTracker().onUpdate(row);
        }

        @Override
        public void updateRow(Row oldRowData, Row newRowData) {
            PaxosState.ballotTracker().onUpdate(newRowData);
        }

        @Override
        public void removeRow(Row row) {
        }

        @Override
        public void finish() {
        }
    };

    public PaxosUncommittedIndex(ColumnFamilyStore baseTable, IndexMetadata metadata) {
        Preconditions.checkState((boolean)baseTable.metadata.keyspace.equals("system"));
        Preconditions.checkState((boolean)baseTable.metadata.name.equals("paxos"));
        this.baseCfs = baseTable;
        this.metadata = metadata;
        this.memtableColumnFilter = ColumnFilter.all(baseTable.metadata.get());
        PaxosUncommittedTracker.unsafSetUpdateSupplier(this);
    }

    public static IndexMetadata indexMetadata() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("class_name", PaxosUncommittedIndex.class.getName());
        options.put("target", "");
        return IndexMetadata.fromSchemaMetadata("PaxosUncommittedIndex", IndexMetadata.Kind.CUSTOM, options);
    }

    public static Indexes indexes() {
        return Indexes.builder().add(PaxosUncommittedIndex.indexMetadata()).build();
    }

    @Override
    public Callable<?> getInitializationTask() {
        return Callables.returning(null);
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.metadata;
    }

    @Override
    public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
        return Callables.returning(null);
    }

    @Override
    public void register(IndexRegistry registry) {
        registry.registerIndex(this);
    }

    @Override
    public Optional<ColumnFamilyStore> getBackingTable() {
        return Optional.empty();
    }

    private CloseableIterator<PaxosKeyState> getPaxosUpdates(List<UnfilteredPartitionIterator> iterators, TableId filterByTableId, boolean materializeLazily) {
        Preconditions.checkArgument((filterByTableId == null == materializeLazily ? 1 : 0) != 0);
        return PaxosRows.toIterator(UnfilteredPartitionIterators.merge(iterators, UnfilteredPartitionIterators.MergeListener.NOOP), filterByTableId, materializeLazily);
    }

    @Override
    public CloseableIterator<PaxosKeyState> repairIterator(TableId tableId, Collection<Range<Token>> ranges) {
        Preconditions.checkNotNull((Object)tableId);
        try (OpOrder.Group op = this.baseCfs.readOrdering.start();){
            View view = this.baseCfs.getTracker().getView();
            ImmutableList memtables = view.flushingMemtables.isEmpty() ? view.liveMemtables : ImmutableList.builder().addAll(view.flushingMemtables).addAll(view.liveMemtables).build();
            List dataRanges = ranges.stream().map(DataRange::forTokenRange).collect(Collectors.toList());
            ArrayList<UnfilteredPartitionIterator> iters = new ArrayList<UnfilteredPartitionIterator>(memtables.size() * ranges.size());
            int jsize = dataRanges.size();
            for (int j = 0; j < jsize; ++j) {
                int isize = memtables.size();
                for (int i = 0; i < isize; ++i) {
                    iters.add(((Memtable)memtables.get(i)).partitionIterator(this.memtableColumnFilter, (DataRange)dataRanges.get(j), SSTableReadsListener.NOOP_LISTENER));
                }
            }
            CloseableIterator<PaxosKeyState> closeableIterator = this.getPaxosUpdates(iters, tableId, false);
            return closeableIterator;
        }
    }

    @Override
    public CloseableIterator<PaxosKeyState> flushIterator(Memtable flushing) {
        List<UnfilteredPartitionIterator> iters = Collections.singletonList(flushing.partitionIterator(this.memtableColumnFilter, FULL_RANGE, SSTableReadsListener.NOOP_LISTENER));
        return this.getPaxosUpdates(iters, null, true);
    }

    @Override
    public Callable<?> getBlockingFlushTask() {
        return () -> {
            PaxosState.ballotTracker().flush();
            return null;
        };
    }

    @Override
    public Callable<?> getBlockingFlushTask(Memtable paxos) {
        return () -> {
            PaxosState.uncommittedTracker().flushUpdates(paxos);
            PaxosState.ballotTracker().flush();
            return null;
        };
    }

    @Override
    public Callable<?> getInvalidateTask() {
        return () -> {
            PaxosState.uncommittedTracker().truncate();
            PaxosState.ballotTracker().truncate();
            return null;
        };
    }

    @Override
    public Callable<?> getTruncateTask(long truncatedAt) {
        return () -> {
            PaxosState.uncommittedTracker().truncate();
            PaxosState.ballotTracker().truncate();
            return null;
        };
    }

    @Override
    public boolean shouldBuildBlocking() {
        return false;
    }

    @Override
    public boolean dependsOn(ColumnMetadata column) {
        return false;
    }

    @Override
    public boolean supportsExpression(ColumnMetadata column, Operator operator) {
        return false;
    }

    @Override
    public AbstractType<?> customExpressionValueType() {
        return null;
    }

    @Override
    public RowFilter getPostIndexQueryFilter(RowFilter filter) {
        return null;
    }

    @Override
    public long getEstimatedResultRows() {
        return 0L;
    }

    @Override
    public void validate(PartitionUpdate update) throws InvalidRequestException {
    }

    @Override
    public Index.Indexer indexerFor(DecoratedKey key, RegularAndStaticColumns columns, int nowInSec, WriteContext ctx, IndexTransaction.Type transactionType) {
        return this.indexer;
    }

    @Override
    public BiFunction<PartitionIterator, ReadCommand, PartitionIterator> postProcessorFor(ReadCommand command) {
        return null;
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) {
        throw new UnsupportedOperationException();
    }
}

