/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;

public final class Hint {
    public static final Serializer serializer = new Serializer();
    static final int maxHintTTL = Integer.getInteger("cassandra.maxHintTTL", Integer.MAX_VALUE);
    final Mutation mutation;
    final long creationTime;
    final int gcgs;

    private Hint(Mutation mutation, long creationTime, int gcgs) {
        this.mutation = mutation;
        this.creationTime = creationTime;
        this.gcgs = gcgs;
    }

    public static Hint create(Mutation mutation, long creationTime) {
        return new Hint(mutation, creationTime, mutation.smallestGCGS());
    }

    public static Hint create(Mutation mutation, long creationTime, int gcgs) {
        return new Hint(mutation, creationTime, gcgs);
    }

    Future<?> applyFuture() {
        if (this.isLive()) {
            Mutation filtered = this.mutation;
            for (TableId id : this.mutation.getTableIds()) {
                if (this.creationTime > SystemKeyspace.getTruncatedAt(id)) continue;
                filtered = filtered.without(id);
            }
            if (!filtered.isEmpty()) {
                return filtered.applyFuture();
            }
        }
        return ImmediateFuture.success(null);
    }

    void apply() {
        try {
            this.applyFuture().get();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    int ttl() {
        return Math.min(this.gcgs, this.mutation.smallestGCGS());
    }

    public boolean isLive() {
        return Hint.isLive(this.creationTime, Clock.Global.currentTimeMillis(), this.ttl());
    }

    static boolean isLive(long creationTime, long now, int hintTTL) {
        return Hint.expirationInMillis(creationTime, hintTTL) > now;
    }

    @VisibleForTesting
    long expirationInMillis() {
        int smallestGCGS = Math.min(this.gcgs, this.mutation.smallestGCGS());
        return Hint.expirationInMillis(this.creationTime, smallestGCGS);
    }

    private static long expirationInMillis(long creationTime, int hintTTL) {
        return creationTime + TimeUnit.SECONDS.toMillis(Math.min(hintTTL, maxHintTTL));
    }

    static final class Serializer
    implements IVersionedSerializer<Hint> {
        Serializer() {
        }

        @Override
        public long serializedSize(Hint hint, int version) {
            long size = TypeSizes.sizeof(hint.creationTime);
            size += (long)TypeSizes.sizeofUnsignedVInt(hint.gcgs);
            return size += (long)hint.mutation.serializedSize(version);
        }

        @Override
        public void serialize(Hint hint, DataOutputPlus out, int version) throws IOException {
            out.writeLong(hint.creationTime);
            out.writeUnsignedVInt(hint.gcgs);
            Mutation.serializer.serialize(hint.mutation, out, version);
        }

        @Override
        public Hint deserialize(DataInputPlus in, int version) throws IOException {
            long creationTime = in.readLong();
            int gcgs = (int)in.readUnsignedVInt();
            return new Hint(Mutation.serializer.deserialize(in, version), creationTime, gcgs);
        }

        public long getHintCreationTime(ByteBuffer hintBuffer, int version) {
            return hintBuffer.getLong(0);
        }

        @Nullable
        Hint deserializeIfLive(DataInputPlus in, long now, long size, int version) throws IOException {
            long creationTime = in.readLong();
            int gcgs = (int)in.readUnsignedVInt();
            int bytesRead = TypeSizes.sizeof(creationTime) + TypeSizes.sizeofUnsignedVInt(gcgs);
            if (Hint.isLive(creationTime, now, gcgs)) {
                return new Hint(Mutation.serializer.deserialize(in, version), creationTime, gcgs);
            }
            in.skipBytesFully(Ints.checkedCast((long)size) - bytesRead);
            return null;
        }

        @Nullable
        ByteBuffer readBufferIfLive(DataInputPlus in, long now, int size, int version) throws IOException {
            int maxHeaderSize = Math.min(TypeSizes.sizeof(Long.MAX_VALUE) + 10, size);
            byte[] header = new byte[maxHeaderSize];
            in.readFully(header);
            try (DataInputBuffer input = new DataInputBuffer(header);){
                long creationTime = input.readLong();
                int gcgs = (int)input.readUnsignedVInt();
                if (!Hint.isLive(creationTime, now, gcgs)) {
                    in.skipBytesFully(size - maxHeaderSize);
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
            }
            byte[] bytes = new byte[size];
            System.arraycopy(header, 0, bytes, 0, header.length);
            in.readFully(bytes, header.length, size - header.length);
            return ByteBuffer.wrap(bytes);
        }
    }
}

