/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ChecksumType;
import org.apache.cassandra.utils.Throwables;

public class DataIntegrityMetadata {
    public static ChecksumValidator checksumValidator(Descriptor desc) throws IOException {
        return new ChecksumValidator(desc);
    }

    public static FileDigestValidator fileDigestValidator(Descriptor desc) throws IOException {
        return new FileDigestValidator(desc);
    }

    public static class FileDigestValidator
    implements Closeable {
        private final Checksum checksum;
        private final RandomAccessReader digestReader;
        private final RandomAccessReader dataReader;
        private final Descriptor descriptor;
        private long storedDigestValue;

        public FileDigestValidator(Descriptor descriptor) throws IOException {
            this.descriptor = descriptor;
            this.checksum = ChecksumType.CRC32.newInstance();
            this.digestReader = RandomAccessReader.open(new File(descriptor.filenameFor(Component.DIGEST)));
            this.dataReader = RandomAccessReader.open(new File(descriptor.filenameFor(Component.DATA)));
            try {
                this.storedDigestValue = Long.parseLong(this.digestReader.readLine());
            }
            catch (Exception e) {
                this.close();
                throw new IOException("Corrupted SSTable : " + descriptor.filenameFor(Component.DATA));
            }
        }

        public void validate() throws IOException {
            CheckedInputStream checkedInputStream = new CheckedInputStream(this.dataReader, this.checksum);
            byte[] chunk = new byte[65536];
            while (checkedInputStream.read(chunk) > 0) {
            }
            long calculatedDigestValue = checkedInputStream.getChecksum().getValue();
            if (this.storedDigestValue != calculatedDigestValue) {
                throw new IOException("Corrupted SSTable : " + this.descriptor.filenameFor(Component.DATA));
            }
        }

        @Override
        public void close() {
            Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[2];
            discreteActionArray[0] = this.digestReader::close;
            discreteActionArray[1] = this.dataReader::close;
            Throwables.perform(discreteActionArray);
        }
    }

    public static class ChecksumValidator
    implements Closeable {
        private final ChecksumType checksumType;
        private final RandomAccessReader reader;
        public final int chunkSize;
        private final String dataFilename;

        public ChecksumValidator(Descriptor descriptor) throws IOException {
            this(ChecksumType.CRC32, RandomAccessReader.open(new File(descriptor.filenameFor(Component.CRC))), descriptor.filenameFor(Component.DATA));
        }

        public ChecksumValidator(ChecksumType checksumType, RandomAccessReader reader, String dataFilename) throws IOException {
            this.checksumType = checksumType;
            this.reader = reader;
            this.dataFilename = dataFilename;
            this.chunkSize = reader.readInt();
        }

        @VisibleForTesting
        protected ChecksumValidator(ChecksumType checksumType, RandomAccessReader reader, int chunkSize) {
            this.checksumType = checksumType;
            this.reader = reader;
            this.dataFilename = null;
            this.chunkSize = chunkSize;
        }

        public void seek(long offset) {
            long start = this.chunkStart(offset);
            this.reader.seek(start / (long)this.chunkSize * 4L + 4L);
        }

        public long chunkStart(long offset) {
            long startChunk = offset / (long)this.chunkSize;
            return startChunk * (long)this.chunkSize;
        }

        public void validate(byte[] bytes, int start, int end) throws IOException {
            int actual;
            int current = (int)this.checksumType.of(bytes, start, end);
            if (current != (actual = this.reader.readInt())) {
                throw new IOException("Corrupted File : " + this.dataFilename);
            }
        }

        public void validate(ByteBuffer buffer) throws IOException {
            int actual;
            int current = (int)this.checksumType.of(buffer);
            if (current != (actual = this.reader.readInt())) {
                throw new IOException("Corrupted File : " + this.dataFilename);
            }
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

