/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.formatter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TableBuilder {
    private final String columnDelimiter;
    private int[] maximumColumnWidth;
    private final List<String[]> rows = new ArrayList<String[]>();

    public TableBuilder() {
        this(' ');
    }

    public TableBuilder(char columnDelimiter) {
        this(String.valueOf(columnDelimiter));
    }

    public TableBuilder(String columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    private TableBuilder(TableBuilder base, int[] maximumColumnWidth) {
        this(base.columnDelimiter);
        this.maximumColumnWidth = maximumColumnWidth;
        this.rows.addAll(base.rows);
    }

    public void add(@Nonnull List<String> row) {
        this.add(row.toArray(new String[0]));
    }

    public void add(String ... row) {
        Objects.requireNonNull(row);
        if (this.rows.isEmpty()) {
            this.maximumColumnWidth = new int[row.length];
        }
        if (row.length > this.maximumColumnWidth.length) {
            int[] tmp = new int[row.length];
            System.arraycopy(this.maximumColumnWidth, 0, tmp, 0, this.maximumColumnWidth.length);
            this.maximumColumnWidth = tmp;
        }
        int i = 0;
        for (String col : row) {
            this.maximumColumnWidth[i] = Math.max(this.maximumColumnWidth[i], col != null ? col.length() : 1);
            ++i;
        }
        this.rows.add(row);
    }

    public void printTo(PrintStream out) {
        if (this.rows.isEmpty()) {
            return;
        }
        for (String[] row : this.rows) {
            for (int i = 0; i < this.maximumColumnWidth.length; ++i) {
                String col = i < row.length ? row[i] : "";
                out.print(String.format("%-" + this.maximumColumnWidth[i] + 's', col != null ? col : ""));
                if (i >= this.maximumColumnWidth.length - 1) continue;
                out.print(this.columnDelimiter);
            }
            out.println();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream((OutputStream)os, true, StandardCharsets.UTF_8.displayName());){
            this.printTo(stream);
            stream.flush();
            String string = os.toString(StandardCharsets.UTF_8.displayName());
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class SharedTable {
        private List<TableBuilder> tables = new ArrayList<TableBuilder>();
        private final String columnDelimiter;

        public SharedTable() {
            this(' ');
        }

        public SharedTable(char columnDelimiter) {
            this(String.valueOf(columnDelimiter));
        }

        public SharedTable(String columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
        }

        public TableBuilder next() {
            TableBuilder next = new TableBuilder(this.columnDelimiter);
            this.tables.add(next);
            return next;
        }

        public List<TableBuilder> complete() {
            if (this.tables.size() == 0) {
                return Collections.emptyList();
            }
            int columns = this.tables.stream().max(Comparator.comparing(tb -> ((TableBuilder)tb).maximumColumnWidth.length)).get().maximumColumnWidth.length;
            int[] maximumColumnWidth = new int[columns];
            for (TableBuilder tb2 : this.tables) {
                for (int i = 0; i < tb2.maximumColumnWidth.length; ++i) {
                    maximumColumnWidth[i] = Math.max(tb2.maximumColumnWidth[i], maximumColumnWidth[i]);
                }
            }
            return this.tables.stream().map(tb -> new TableBuilder((TableBuilder)tb, maximumColumnWidth)).collect(Collectors.toList());
        }
    }
}

