/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.management.NotificationBroadcasterSupport;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.cassandra.audit.AuditLogManager;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.auth.AuthCacheService;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.auth.AuthSchemaChangeListener;
import org.apache.cassandra.batchlog.BatchlogManager;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.FutureTask;
import org.apache.cassandra.concurrent.FutureTaskWithResources;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SizeEstimatesRecorder;
import org.apache.cassandra.db.SnapshotDetailsTabularData;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.StreamStateStore;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.fql.FullQueryLogger;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.apache.cassandra.fql.FullQueryLoggerOptionsCompositeData;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.TokenSerializer;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.VersionAndType;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.PathUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointsByRange;
import org.apache.cassandra.locator.EndpointsByReplica;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.RangesByEndpoint;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.locator.SystemReplicas;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.repair.RepairRunnable;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.ReplicationParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.SchemaTransformations;
import org.apache.cassandra.schema.SystemDistributedKeyspace;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.LoadBroadcaster;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.RangeRelocator;
import org.apache.cassandra.service.SSTablesGlobalTracker;
import org.apache.cassandra.service.SSTablesVersionsInUseChangeNotification;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.service.TokenRange;
import org.apache.cassandra.service.disk.usage.DiskUsageBroadcaster;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosCommit;
import org.apache.cassandra.service.paxos.PaxosRepair;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupLocalCoordinator;
import org.apache.cassandra.service.paxos.cleanup.PaxosTableRepairs;
import org.apache.cassandra.service.snapshot.SnapshotLoader;
import org.apache.cassandra.service.snapshot.SnapshotManager;
import org.apache.cassandra.service.snapshot.TableSnapshot;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.transport.ClientResourceLimits;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.FutureCombiner;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.apache.cassandra.utils.logging.LoggingSupportFactory;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.ProgressListener;
import org.apache.cassandra.utils.progress.jmx.JMXBroadcastExecutor;
import org.apache.cassandra.utils.progress.jmx.JMXProgressSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
extends NotificationBroadcasterSupport
implements IEndpointStateChangeSubscriber,
StorageServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageService.class);
    public static final int INDEFINITE = -1;
    public static final int RING_DELAY_MILLIS = StorageService.getRingDelay();
    public static final int SCHEMA_DELAY_MILLIS = StorageService.getSchemaDelay();
    private static final boolean REQUIRE_SCHEMAS = !CassandraRelevantProperties.BOOTSTRAP_SKIP_SCHEMA_CHECK.getBoolean();
    private final JMXProgressSupport progressSupport = new JMXProgressSupport(this);
    private TokenMetadata tokenMetadata = new TokenMetadata();
    public volatile VersionedValue.VersionedValueFactory valueFactory;
    private Thread drainOnShutdown;
    private volatile boolean isShutdown;
    private final List<Runnable> preShutdownHooks;
    private final List<Runnable> postShutdownHooks;
    private final SnapshotManager snapshotManager;
    public static final StorageService instance = new StorageService();
    private final Set<InetAddressAndPort> replicatingNodes;
    private CassandraDaemon daemon;
    private InetAddressAndPort removingNode;
    private volatile boolean isBootstrapMode;
    private boolean isSurveyMode;
    private final AtomicBoolean isRebuilding;
    private final AtomicBoolean isDecommissioning;
    private volatile boolean initialized;
    private volatile boolean joined;
    private volatile boolean gossipActive;
    private final AtomicBoolean authSetupCalled;
    private volatile boolean authSetupComplete;
    private double traceProbability;
    private volatile Mode operationMode;
    private volatile int totalCFs;
    private volatile int remainingCFs;
    private static final AtomicInteger nextRepairCommand = new AtomicInteger();
    private final List<IEndpointLifecycleSubscriber> lifecycleSubscribers;
    private final String jmxObjectName;
    private Collection<Token> bootstrapTokens;
    public static final boolean useStrictConsistency = Boolean.parseBoolean(System.getProperty("cassandra.consistent.rangemovement", "true"));
    private static final boolean allowSimultaneousMoves = Boolean.parseBoolean(System.getProperty("cassandra.consistent.simultaneousmoves.allow", "false"));
    private static final boolean joinRing = Boolean.parseBoolean(System.getProperty("cassandra.join_ring", "true"));
    private boolean replacing;
    private final StreamStateStore streamStateStore;
    public final SSTablesGlobalTracker sstablesTracker;

    private static int getRingDelay() {
        String newdelay = CassandraRelevantProperties.RING_DELAY.getString();
        if (newdelay != null) {
            logger.info("Overriding RING_DELAY to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    private static int getSchemaDelay() {
        String newdelay = CassandraRelevantProperties.BOOTSTRAP_SCHEMA_DELAY_MS.getString();
        if (newdelay != null) {
            logger.info("Overriding SCHEMA_DELAY_MILLIS to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    @Deprecated
    public boolean isInShutdownHook() {
        return this.isShutdown();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @VisibleForTesting
    public void setIsShutdownUnsafeForTests(boolean isShutdown) {
        this.isShutdown = isShutdown;
    }

    public RangesAtEndpoint getLocalReplicas(String keyspaceName) {
        return Keyspace.open(keyspaceName).getReplicationStrategy().getAddressReplicas(FBUtilities.getBroadcastAddressAndPort());
    }

    public List<Range<Token>> getLocalRanges(String ks) {
        InetAddressAndPort broadcastAddress = FBUtilities.getBroadcastAddressAndPort();
        Keyspace keyspace = Keyspace.open(ks);
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
        for (Replica r : keyspace.getReplicationStrategy().getAddressReplicas(broadcastAddress)) {
            ranges.add(r.range());
        }
        return ranges;
    }

    public List<Range<Token>> getLocalAndPendingRanges(String ks) {
        InetAddressAndPort broadcastAddress = FBUtilities.getBroadcastAddressAndPort();
        Keyspace keyspace = Keyspace.open(ks);
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
        for (Replica r : keyspace.getReplicationStrategy().getAddressReplicas(broadcastAddress)) {
            ranges.add(r.range());
        }
        for (Replica r : this.getTokenMetadata().getPendingRanges(ks, broadcastAddress)) {
            ranges.add(r.range());
        }
        return ranges;
    }

    public Collection<Range<Token>> getPrimaryRanges(String keyspace) {
        return this.getPrimaryRangesForEndpoint(keyspace, FBUtilities.getBroadcastAddressAndPort());
    }

    public Collection<Range<Token>> getPrimaryRangesWithinDC(String keyspace) {
        return this.getPrimaryRangeForEndpointWithinDC(keyspace, FBUtilities.getBroadcastAddressAndPort());
    }

    public boolean isSurveyMode() {
        return this.isSurveyMode;
    }

    public boolean hasJoined() {
        return this.joined;
    }

    public void setTokens(Collection<Token> tokens) {
        assert (tokens != null && !tokens.isEmpty()) : "Node needs at least one token.";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting tokens to {}", tokens);
        }
        SystemKeyspace.updateTokens(tokens);
        Collection<Token> localTokens = this.getLocalTokens();
        this.setGossipTokens(localTokens);
        this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddressAndPort());
        this.setMode(Mode.NORMAL, false);
        this.invalidateLocalRanges();
    }

    public void setGossipTokens(Collection<Token> tokens) {
        ArrayList<Pair<ApplicationState, VersionedValue>> states = new ArrayList<Pair<ApplicationState, VersionedValue>>();
        states.add(Pair.create(ApplicationState.TOKENS, this.valueFactory.tokens(tokens)));
        states.add(Pair.create(ApplicationState.STATUS_WITH_PORT, this.valueFactory.normal(tokens)));
        states.add(Pair.create(ApplicationState.STATUS, this.valueFactory.normal(tokens)));
        Gossiper.instance.addLocalApplicationStates(states);
    }

    public StorageService() {
        super(JMXBroadcastExecutor.executor);
        this.valueFactory = new VersionedValue.VersionedValueFactory(this.tokenMetadata.partitioner);
        this.drainOnShutdown = null;
        this.isShutdown = false;
        this.preShutdownHooks = new ArrayList<Runnable>();
        this.postShutdownHooks = new ArrayList<Runnable>();
        this.snapshotManager = new SnapshotManager();
        this.replicatingNodes = Sets.newConcurrentHashSet();
        this.isSurveyMode = Boolean.parseBoolean(System.getProperty("cassandra.write_survey", "false"));
        this.isRebuilding = new AtomicBoolean();
        this.isDecommissioning = new AtomicBoolean();
        this.initialized = false;
        this.joined = false;
        this.gossipActive = false;
        this.authSetupCalled = new AtomicBoolean(false);
        this.authSetupComplete = false;
        this.traceProbability = 0.0;
        this.operationMode = Mode.STARTING;
        this.lifecycleSubscribers = new CopyOnWriteArrayList<IEndpointLifecycleSubscriber>();
        this.bootstrapTokens = null;
        this.streamStateStore = new StreamStateStore();
        this.jmxObjectName = "org.apache.cassandra.db:type=StorageService";
        MBeanWrapper.instance.registerMBean((Object)this, this.jmxObjectName);
        MBeanWrapper.instance.registerMBean((Object)StreamManager.instance, "org.apache.cassandra.net:type=StreamManager");
        this.sstablesTracker = new SSTablesGlobalTracker(SSTableFormat.Type.current());
    }

    public void registerDaemon(CassandraDaemon daemon) {
        this.daemon = daemon;
    }

    public void register(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.add(subscriber);
    }

    public void unregister(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.remove(subscriber);
    }

    @Override
    public void stopGossiping() {
        if (this.gossipActive) {
            if (!this.isNormal() && joinRing) {
                throw new IllegalStateException("Unable to stop gossip because the node is not in the normal state. Try to stop the node instead.");
            }
            logger.warn("Stopping gossip by operator request");
            if (this.isNativeTransportRunning()) {
                logger.warn("Disabling gossip while native transport is still active is unsafe");
            }
            Gossiper.instance.stop();
            this.gossipActive = false;
        }
    }

    @Override
    public synchronized void startGossiping() {
        if (!this.gossipActive) {
            boolean validTokens;
            this.checkServiceAllowedToStart("gossip");
            logger.warn("Starting gossip by operator request");
            Collection<Token> tokens = SystemKeyspace.getSavedTokens();
            boolean bl = validTokens = tokens != null && !tokens.isEmpty();
            if (this.joined || joinRing) assert (validTokens) : "Cannot start gossiping for a node intended to join without valid tokens";
            if (validTokens) {
                this.setGossipTokens(tokens);
            }
            Gossiper.instance.forceNewerGeneration();
            Gossiper.instance.start((int)(Clock.Global.currentTimeMillis() / 1000L));
            this.gossipActive = true;
        }
    }

    @Override
    public boolean isGossipRunning() {
        return Gossiper.instance.isEnabled();
    }

    @Override
    public synchronized void startNativeTransport() {
        this.checkServiceAllowedToStart("native transport");
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        try {
            this.daemon.startNativeTransport();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting native transport: " + e.getMessage());
        }
    }

    @Override
    public void stopNativeTransport() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.stopNativeTransport();
    }

    @Override
    public boolean isNativeTransportRunning() {
        if (this.daemon == null) {
            return false;
        }
        return this.daemon.isNativeTransportRunning();
    }

    @Override
    public void enableNativeTransportOldProtocolVersions() {
        DatabaseDescriptor.setNativeTransportAllowOlderProtocols(true);
    }

    @Override
    public void disableNativeTransportOldProtocolVersions() {
        DatabaseDescriptor.setNativeTransportAllowOlderProtocols(false);
    }

    public void stopTransports() {
        if (this.isNativeTransportRunning()) {
            logger.error("Stopping native transport");
            this.stopNativeTransport();
        }
        if (this.isGossipActive()) {
            logger.error("Stopping gossiper");
            this.stopGossiping();
        }
    }

    private void shutdownClientServers() {
        this.setRpcReady(false);
        this.stopNativeTransport();
    }

    public void stopClient() {
        Gossiper.instance.unregister(this);
        Gossiper.instance.stop();
        MessagingService.instance().shutdown();
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        Stage.shutdownNow();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isGossipActive() {
        return this.gossipActive;
    }

    public boolean isDaemonSetupCompleted() {
        return this.daemon != null && this.daemon.setupCompleted();
    }

    @Override
    public void stopDaemon() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.deactivate();
    }

    private synchronized UUID prepareForReplacement() throws ConfigurationException {
        if (SystemKeyspace.bootstrapComplete()) {
            throw new RuntimeException("Cannot replace address with a node that is already bootstrapped");
        }
        if (!joinRing) {
            throw new ConfigurationException("Cannot set both join_ring=false and attempt to replace a node");
        }
        if (!this.shouldBootstrap() && !Boolean.getBoolean("cassandra.allow_unsafe_replace")) {
            throw new RuntimeException("Replacing a node without bootstrapping risks invalidating consistency guarantees as the expected data may not be present until repair is run. To perform this operation, please restart with -Dcassandra.allow_unsafe_replace=true");
        }
        InetAddressAndPort replaceAddress = DatabaseDescriptor.getReplaceAddress();
        logger.info("Gathering node replacement information for {}", (Object)replaceAddress);
        Map<InetAddressAndPort, EndpointState> epStates = Gossiper.instance.doShadowRound();
        EndpointState state = epStates.get(replaceAddress);
        if (state == null) {
            throw new RuntimeException(String.format("Cannot replace_address %s because it doesn't exist in gossip", replaceAddress));
        }
        StorageService.validateEndpointSnitch(epStates.values().iterator());
        try {
            VersionedValue tokensVersionedValue = state.getApplicationState(ApplicationState.TOKENS);
            if (tokensVersionedValue == null) {
                throw new RuntimeException(String.format("Could not find tokens for %s to replace", replaceAddress));
            }
            Collection<Token> tokens = TokenSerializer.deserialize(this.tokenMetadata.partitioner, new DataInputStream(new ByteArrayInputStream(tokensVersionedValue.toBytes())));
            this.bootstrapTokens = StorageService.validateReplacementBootstrapTokens(this.tokenMetadata, replaceAddress, tokens);
            if (state.isEmptyWithoutStatus() && CassandraRelevantProperties.REPLACEMENT_ALLOW_EMPTY.getBoolean()) {
                logger.warn("Gossip state not present for replacing node {}. Adding temporary entry to continue.", (Object)replaceAddress);
                this.tokenMetadata.updateNormalTokens(this.bootstrapTokens, replaceAddress);
                UUID hostId = Gossiper.instance.getHostId(replaceAddress, epStates);
                if (hostId != null) {
                    this.tokenMetadata.updateHostId(hostId, replaceAddress);
                }
                Gossiper.instance.initializeUnreachableNodeUnsafe(replaceAddress);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        UUID localHostId = SystemKeyspace.getOrInitializeLocalHostId();
        if (StorageService.isReplacingSameAddress()) {
            localHostId = Gossiper.instance.getHostId(replaceAddress, epStates);
            SystemKeyspace.setLocalHostId(localHostId);
        }
        return localHostId;
    }

    private static Collection<Token> validateReplacementBootstrapTokens(TokenMetadata tokenMetadata, InetAddressAndPort replaceAddress, Collection<Token> bootstrapTokens) {
        HashMap<Token, InetAddressAndPort> conflicts = new HashMap<Token, InetAddressAndPort>();
        for (Token token : bootstrapTokens) {
            InetAddressAndPort conflict = tokenMetadata.getEndpoint(token);
            if (null == conflict || conflict.equals(replaceAddress)) continue;
            conflicts.put(token, tokenMetadata.getEndpoint(token));
        }
        if (!conflicts.isEmpty()) {
            String error = String.format("Conflicting token ownership information detected between gossip and current ring view during proposed replacement of %s. Some tokens identified in gossip for the node being replaced are currently owned by other peers: %s", replaceAddress, conflicts.entrySet().stream().map(e -> e.getKey() + "(" + e.getValue() + ")").collect(Collectors.joining(",")));
            throw new RuntimeException(error);
        }
        return bootstrapTokens;
    }

    public synchronized void checkForEndpointCollision(UUID localHostId, Set<InetAddressAndPort> peers) throws ConfigurationException {
        if (Boolean.getBoolean("cassandra.allow_unsafe_join")) {
            logger.warn("Skipping endpoint collision check as cassandra.allow_unsafe_join=true");
            return;
        }
        logger.debug("Starting shadow gossip round to check for endpoint collision");
        Map<InetAddressAndPort, EndpointState> epStates = Gossiper.instance.doShadowRound(peers);
        if (epStates.isEmpty() && DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddressAndPort())) {
            logger.info("Unable to gossip with any peers but continuing anyway since node is in its own seed list");
        }
        if (!Gossiper.instance.isSafeForStartup(FBUtilities.getBroadcastAddressAndPort(), localHostId, this.shouldBootstrap(), epStates)) {
            throw new RuntimeException(String.format("A node with address %s already exists, cancelling join. Use cassandra.replace_address if you want to replace this node.", FBUtilities.getBroadcastAddressAndPort()));
        }
        StorageService.validateEndpointSnitch(epStates.values().iterator());
        if (this.shouldBootstrap() && useStrictConsistency && !this.allowSimultaneousMoves()) {
            for (Map.Entry<InetAddressAndPort, EndpointState> entry : epStates.entrySet()) {
                if (entry.getKey().equals(FBUtilities.getBroadcastAddressAndPort()) || entry.getValue().getApplicationState(ApplicationState.STATUS_WITH_PORT) == null & entry.getValue().getApplicationState(ApplicationState.STATUS) == null) continue;
                VersionedValue value = entry.getValue().getApplicationState(ApplicationState.STATUS_WITH_PORT);
                if (value == null) {
                    value = entry.getValue().getApplicationState(ApplicationState.STATUS);
                }
                String[] pieces = StorageService.splitValue(value);
                assert (pieces.length > 0);
                String state = pieces[0];
                if (!state.equals("BOOT") && !state.equals("LEAVING") && !state.equals("MOVING")) continue;
                throw new UnsupportedOperationException("Other bootstrapping/leaving/moving nodes detected, cannot bootstrap while cassandra.consistent.rangemovement is true");
            }
        }
    }

    private static void validateEndpointSnitch(Iterator<EndpointState> endpointStates) {
        HashSet<String> datacenters = new HashSet<String>();
        HashSet<String> racks = new HashSet<String>();
        while (endpointStates.hasNext()) {
            EndpointState state = endpointStates.next();
            VersionedValue val = state.getApplicationState(ApplicationState.DC);
            if (val != null) {
                datacenters.add(val.value);
            }
            if ((val = state.getApplicationState(ApplicationState.RACK)) == null) continue;
            racks.add(val.value);
        }
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        if (!snitch.validate(datacenters, racks)) {
            throw new IllegalStateException();
        }
    }

    private boolean allowSimultaneousMoves() {
        return allowSimultaneousMoves && DatabaseDescriptor.getNumTokens() == 1;
    }

    public void unsafeInitialize() throws ConfigurationException {
        this.initialized = true;
        this.gossipActive = true;
        Gossiper.instance.register(this);
        Gossiper.instance.start((int)(Clock.Global.currentTimeMillis() / 1000L));
        Gossiper.instance.addLocalApplicationState(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
        MessagingService.instance().listen();
    }

    public synchronized void initServer() throws ConfigurationException {
        this.initServer(SCHEMA_DELAY_MILLIS, RING_DELAY_MILLIS);
    }

    public synchronized void initServer(int schemaAndRingDelayMillis) throws ConfigurationException {
        this.initServer(schemaAndRingDelayMillis, RING_DELAY_MILLIS);
    }

    public synchronized void initServer(int schemaTimeoutMillis, int ringTimeoutMillis) throws ConfigurationException {
        logger.info("Cassandra version: {}", (Object)FBUtilities.getReleaseVersionString());
        logger.info("CQL version: {}", (Object)QueryProcessor.CQL_VERSION);
        logger.info("Native protocol supported versions: {} (default: {})", (Object)StringUtils.join(ProtocolVersion.supportedVersions(), (String)", "), (Object)ProtocolVersion.CURRENT);
        try {
            Class.forName("org.apache.cassandra.service.StorageProxy");
            Class.forName("org.apache.cassandra.io.sstable.IndexSummaryManager");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            logger.info("Loading persisted ring state");
            this.populatePeerTokenMetadata();
            for (InetAddressAndPort endpoint : this.tokenMetadata.getAllEndpoints()) {
                Gossiper.runInGossipStageBlocking(() -> Gossiper.instance.addSavedEndpoint(endpoint));
            }
        }
        this.drainOnShutdown = NamedThreadFactory.createThread(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws InterruptedException, ExecutionException, IOException {
                StorageService.this.drain(true);
                try {
                    ExecutorUtils.shutdownNowAndWait(1L, TimeUnit.MINUTES, ScheduledExecutors.scheduledFastTasks);
                }
                catch (Throwable t) {
                    logger.warn("Unable to terminate fast tasks within 1 minute.", t);
                }
                finally {
                    LoggingSupportFactory.getLoggingSupport().onShutdown();
                }
            }
        }, "StorageServiceShutdownHook");
        Runtime.getRuntime().addShutdownHook(this.drainOnShutdown);
        this.replacing = this.isReplacing();
        if (!Boolean.parseBoolean(System.getProperty("cassandra.start_gossip", "true"))) {
            logger.info("Not starting gossip as requested.");
            this.initialized = true;
            return;
        }
        this.prepareToJoin();
        try {
            CacheService.instance.counterCache.loadSavedAsync().get();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Error loading counter cache", t);
        }
        if (joinRing) {
            this.joinTokenRing(schemaTimeoutMillis, ringTimeoutMillis);
        } else {
            Collection<Token> tokens = SystemKeyspace.getSavedTokens();
            if (!tokens.isEmpty()) {
                this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddressAndPort());
                ArrayList<Pair<ApplicationState, VersionedValue>> states = new ArrayList<Pair<ApplicationState, VersionedValue>>();
                states.add(Pair.create(ApplicationState.TOKENS, this.valueFactory.tokens(tokens)));
                states.add(Pair.create(ApplicationState.STATUS_WITH_PORT, this.valueFactory.hibernate(true)));
                states.add(Pair.create(ApplicationState.STATUS, this.valueFactory.hibernate(true)));
                Gossiper.instance.addLocalApplicationStates(states);
            }
            this.doAuthSetup(true);
            logger.info("Not joining ring as requested. Use JMX (StorageService->joinRing()) to initiate ring joining");
        }
        this.initialized = true;
    }

    public void populateTokenMetadata() {
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            this.populatePeerTokenMetadata();
            if (!this.shouldBootstrap()) {
                this.tokenMetadata.updateNormalTokens(SystemKeyspace.getSavedTokens(), FBUtilities.getBroadcastAddressAndPort());
            }
            logger.info("Token metadata: {}", (Object)this.tokenMetadata);
        }
    }

    private void populatePeerTokenMetadata() {
        logger.info("Populating token metadata from system tables");
        SetMultimap<InetAddressAndPort, Token> loadedTokens = SystemKeyspace.loadTokens();
        if (loadedTokens.containsKey((Object)FBUtilities.getBroadcastAddressAndPort())) {
            SystemKeyspace.removeEndpoint(FBUtilities.getBroadcastAddressAndPort());
        }
        Map<InetAddressAndPort, UUID> loadedHostIds = SystemKeyspace.loadHostIds();
        HashMap<UUID, InetAddressAndPort> hostIdToEndpointMap = new HashMap<UUID, InetAddressAndPort>();
        for (InetAddressAndPort ep : loadedTokens.keySet()) {
            UUID hostId = loadedHostIds.get(ep);
            if (hostId == null) continue;
            hostIdToEndpointMap.put(hostId, ep);
        }
        this.tokenMetadata.updateNormalTokens((Multimap<InetAddressAndPort, Token>)loadedTokens);
        this.tokenMetadata.updateHostIds(hostIdToEndpointMap);
    }

    public boolean isReplacing() {
        if (this.replacing) {
            return true;
        }
        if (System.getProperty("cassandra.replace_address_first_boot", null) != null && SystemKeyspace.bootstrapComplete()) {
            logger.info("Replace address on first boot requested; this node is already bootstrapped");
            return false;
        }
        return DatabaseDescriptor.getReplaceAddress() != null;
    }

    public void removeShutdownHook() {
        PathUtils.clearOnExitThreads();
        if (this.drainOnShutdown != null) {
            Runtime.getRuntime().removeShutdownHook(this.drainOnShutdown);
        }
    }

    private boolean shouldBootstrap() {
        return DatabaseDescriptor.isAutoBootstrap() && !SystemKeyspace.bootstrapComplete() && !StorageService.isSeed();
    }

    public static boolean isSeed() {
        return DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddressAndPort());
    }

    private void prepareToJoin() throws ConfigurationException {
        if (!this.joined) {
            EnumMap<ApplicationState, VersionedValue> appStates = new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class);
            if (SystemKeyspace.wasDecommissioned()) {
                if (Boolean.getBoolean("cassandra.override_decommission")) {
                    logger.warn("This node was decommissioned, but overriding by operator request.");
                    SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.COMPLETED);
                } else {
                    throw new ConfigurationException("This node was decommissioned and will not rejoin the ring unless cassandra.override_decommission=true has been set, or all existing data is removed and the node is bootstrapped again");
                }
            }
            if (DatabaseDescriptor.getReplaceTokens().size() > 0 || DatabaseDescriptor.getReplaceNode() != null) {
                throw new RuntimeException("Replace method removed; use cassandra.replace_address instead");
            }
            MessagingService.instance().listen();
            UUID localHostId = SystemKeyspace.getOrInitializeLocalHostId();
            if (this.replacing) {
                localHostId = this.prepareForReplacement();
                appStates.put(ApplicationState.TOKENS, this.valueFactory.tokens(this.bootstrapTokens));
                if (!this.shouldBootstrap()) {
                    SystemKeyspace.updateTokens(this.bootstrapTokens);
                } else if (StorageService.isReplacingSameAddress()) {
                    logger.warn("Writes will not be forwarded to this node during replacement because it has the same address as the node to be replaced ({}). If the previous node has been down for longer than max_hint_window, repair must be run after the replacement process in order to make this node consistent.", (Object)DatabaseDescriptor.getReplaceAddress());
                    appStates.put(ApplicationState.STATUS_WITH_PORT, this.valueFactory.hibernate(true));
                    appStates.put(ApplicationState.STATUS, this.valueFactory.hibernate(true));
                }
            } else {
                this.checkForEndpointCollision(localHostId, SystemKeyspace.loadHostIds().keySet());
                if (SystemKeyspace.bootstrapComplete()) {
                    Preconditions.checkState((!Config.isClientMode() ? 1 : 0) != 0);
                    Collection<Token> savedTokens = SystemKeyspace.getSavedTokens();
                    if (!savedTokens.isEmpty()) {
                        appStates.put(ApplicationState.TOKENS, this.valueFactory.tokens(savedTokens));
                    }
                }
            }
            this.getTokenMetadata().updateHostId(localHostId, FBUtilities.getBroadcastAddressAndPort());
            appStates.put(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
            appStates.put(ApplicationState.HOST_ID, this.valueFactory.hostId(localHostId));
            appStates.put(ApplicationState.NATIVE_ADDRESS_AND_PORT, this.valueFactory.nativeaddressAndPort(FBUtilities.getBroadcastNativeAddressAndPort()));
            appStates.put(ApplicationState.RPC_ADDRESS, this.valueFactory.rpcaddress(FBUtilities.getJustBroadcastNativeAddress()));
            appStates.put(ApplicationState.RELEASE_VERSION, this.valueFactory.releaseVersion());
            appStates.put(ApplicationState.SSTABLE_VERSIONS, this.valueFactory.sstableVersions(this.sstablesTracker.versionsInUse()));
            logger.info("Starting up server gossip");
            Gossiper.instance.register(this);
            Gossiper.instance.start(SystemKeyspace.incrementAndGetGeneration(), appStates);
            this.gossipActive = true;
            this.sstablesTracker.register((INotification notification, Object o) -> {
                if (!(notification instanceof SSTablesVersionsInUseChangeNotification)) {
                    return;
                }
                ImmutableSet<VersionAndType> versions = ((SSTablesVersionsInUseChangeNotification)notification).versionsInUse;
                logger.debug("Updating local sstables version in Gossip to {}", versions);
                Gossiper.instance.addLocalApplicationState(ApplicationState.SSTABLE_VERSIONS, this.valueFactory.sstableVersions((Set<VersionAndType>)versions));
            });
            this.gossipSnitchInfo();
            Schema.instance.startSync();
            LoadBroadcaster.instance.startBroadcasting();
            DiskUsageBroadcaster.instance.startBroadcasting();
            HintsService.instance.startDispatch();
            BatchlogManager.instance.start();
            this.snapshotManager.start();
        }
    }

    public void waitForSchema(long schemaTimeoutMillis, long ringTimeoutMillis) {
        Instant deadline = FBUtilities.now().plus(Duration.ofMillis(ringTimeoutMillis));
        while (Schema.instance.isEmpty() && FBUtilities.now().isBefore(deadline)) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (!Schema.instance.waitUntilReady(Duration.ofMillis(schemaTimeoutMillis))) {
            throw new IllegalStateException("Could not achieve schema readiness in " + Duration.ofMillis(schemaTimeoutMillis));
        }
    }

    private void joinTokenRing(long schemaTimeoutMillis, long ringTimeoutMillis) throws ConfigurationException {
        this.joinTokenRing(!this.isSurveyMode, this.shouldBootstrap(), schemaTimeoutMillis, -1L, ringTimeoutMillis);
    }

    @VisibleForTesting
    public void joinTokenRing(boolean finishJoiningRing, boolean shouldBootstrap, long schemaTimeoutMillis, long bootstrapTimeoutMillis, long ringTimeoutMillis) throws ConfigurationException {
        this.joined = true;
        HashSet<InetAddressAndPort> current = new HashSet<InetAddressAndPort>();
        if (logger.isDebugEnabled()) {
            logger.debug("Bootstrap variables: {} {} {} {}", new Object[]{DatabaseDescriptor.isAutoBootstrap(), SystemKeyspace.bootstrapInProgress(), SystemKeyspace.bootstrapComplete(), DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddressAndPort())});
        }
        if (DatabaseDescriptor.isAutoBootstrap() && !SystemKeyspace.bootstrapComplete() && DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddressAndPort())) {
            logger.info("This node will not auto bootstrap because it is configured to be a seed node.");
        }
        boolean dataAvailable = true;
        if (shouldBootstrap) {
            current.addAll(this.prepareForBootstrap(schemaTimeoutMillis, ringTimeoutMillis));
            dataAvailable = this.bootstrap(this.bootstrapTokens, bootstrapTimeoutMillis);
        } else {
            this.bootstrapTokens = SystemKeyspace.getSavedTokens();
            if (this.bootstrapTokens.isEmpty()) {
                this.bootstrapTokens = BootStrapper.getBootstrapTokens(this.tokenMetadata, FBUtilities.getBroadcastAddressAndPort(), schemaTimeoutMillis, ringTimeoutMillis);
            } else {
                if (this.bootstrapTokens.size() != DatabaseDescriptor.getNumTokens()) {
                    throw new ConfigurationException("Cannot change the number of tokens from " + this.bootstrapTokens.size() + " to " + DatabaseDescriptor.getNumTokens());
                }
                logger.info("Using saved tokens {}", this.bootstrapTokens);
            }
        }
        this.setUpDistributedSystemKeyspaces();
        if (finishJoiningRing) {
            if (dataAvailable) {
                this.finishJoiningRing(shouldBootstrap, this.bootstrapTokens);
                if (!current.isEmpty()) {
                    Gossiper.runInGossipStageBlocking(() -> {
                        for (InetAddressAndPort existing : current) {
                            Gossiper.instance.replacedEndpoint(existing);
                        }
                    });
                }
            } else {
                logger.warn("Some data streaming failed. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`. {}", (Object)SystemKeyspace.getBootstrapState());
            }
            StorageProxy.instance.initialLoadPartitionDenylist();
        } else if (dataAvailable) {
            logger.info("Startup complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
        } else {
            logger.warn("Some data streaming failed. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`. {}", (Object)SystemKeyspace.getBootstrapState());
        }
    }

    public static boolean isReplacingSameAddress() {
        InetAddressAndPort replaceAddress = DatabaseDescriptor.getReplaceAddress();
        return replaceAddress != null && replaceAddress.equals(FBUtilities.getBroadcastAddressAndPort());
    }

    public void gossipSnitchInfo() {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        String dc = snitch.getLocalDatacenter();
        String rack = snitch.getLocalRack();
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(dc));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(rack));
    }

    @Override
    public void joinRing() throws IOException {
        SystemKeyspace.BootstrapState state = SystemKeyspace.getBootstrapState();
        this.joinRing(state.equals((Object)SystemKeyspace.BootstrapState.IN_PROGRESS));
    }

    private synchronized void joinRing(boolean resumedBootstrap) throws IOException {
        if (!this.joined) {
            logger.info("Joining ring by operator request");
            try {
                this.joinTokenRing(SCHEMA_DELAY_MILLIS, 0L);
                this.doAuthSetup(false);
            }
            catch (ConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        } else if (this.isSurveyMode) {
            if (!this.isBootstrapMode()) {
                logger.info("Leaving write survey mode and joining ring at operator request");
                this.finishJoiningRing(resumedBootstrap, SystemKeyspace.getSavedTokens());
                this.doAuthSetup(false);
                this.isSurveyMode = false;
                this.daemon.start();
            } else {
                logger.warn("Can't join the ring because in write_survey mode and bootstrap hasn't completed");
            }
        } else if (this.isBootstrapMode()) {
            logger.warn("Can't join the ring because bootstrap hasn't completed.");
        }
    }

    private void executePreJoinTasks(boolean bootstrap) {
        StreamSupport.stream(ColumnFamilyStore.all().spliterator(), false).filter(cfs -> Schema.instance.getUserKeyspaces().names().contains((Object)cfs.keyspace.getName())).forEach(cfs -> cfs.indexManager.executePreJoinTasksBlocking(bootstrap));
    }

    @VisibleForTesting
    public void finishJoiningRing(boolean didBootstrap, Collection<Token> tokens) {
        this.setMode(Mode.JOINING, "Finish joining ring", true);
        SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.COMPLETED);
        this.executePreJoinTasks(didBootstrap);
        this.setTokens(tokens);
        assert (this.tokenMetadata.sortedTokens().size() > 0);
    }

    @VisibleForTesting
    public void doAuthSetup(boolean setUpSchema) {
        if (!this.authSetupCalled.getAndSet(true)) {
            if (setUpSchema) {
                Schema.instance.transform(SchemaTransformations.updateSystemKeyspace(AuthKeyspace.metadata(), 1L));
            }
            DatabaseDescriptor.getRoleManager().setup();
            DatabaseDescriptor.getAuthenticator().setup();
            DatabaseDescriptor.getAuthorizer().setup();
            DatabaseDescriptor.getNetworkAuthorizer().setup();
            AuthCacheService.initializeAndRegisterCaches();
            Schema.instance.registerListener(new AuthSchemaChangeListener());
            this.authSetupComplete = true;
        }
    }

    public boolean isAuthSetupComplete() {
        return this.authSetupComplete;
    }

    @VisibleForTesting
    public boolean authSetupCalled() {
        return this.authSetupCalled.get();
    }

    @VisibleForTesting
    public void setUpDistributedSystemKeyspaces() {
        Schema.instance.transform(SchemaTransformations.updateSystemKeyspace(TraceKeyspace.metadata(), 1577836800000002L));
        Schema.instance.transform(SchemaTransformations.updateSystemKeyspace(SystemDistributedKeyspace.metadata(), 6L));
        Schema.instance.transform(SchemaTransformations.updateSystemKeyspace(AuthKeyspace.metadata(), 1L));
    }

    @Override
    public boolean isJoined() {
        return this.tokenMetadata.isMember(FBUtilities.getBroadcastAddressAndPort()) && !this.isSurveyMode;
    }

    @Override
    public void rebuild(String sourceDc) {
        this.rebuild(sourceDc, null, null, null);
    }

    @Override
    public void rebuild(String sourceDc, String keyspace, String tokens, String specificSources) {
        if (!this.isRebuilding.compareAndSet(false, true)) {
            throw new IllegalStateException("Node is still rebuilding. Check nodetool netstats.");
        }
        try {
            if (keyspace == null && tokens != null) {
                throw new IllegalArgumentException("Cannot specify tokens without keyspace.");
            }
            logger.info("rebuild from dc: {}, {}, {}", new Object[]{sourceDc == null ? "(any dc)" : sourceDc, keyspace == null ? "(All keyspaces)" : keyspace, tokens == null ? "(All tokens)" : tokens});
            this.repairPaxosForTopologyChange("rebuild");
            RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, null, FBUtilities.getBroadcastAddressAndPort(), StreamOperation.REBUILD, useStrictConsistency && !this.replacing, DatabaseDescriptor.getEndpointSnitch(), this.streamStateStore, false, DatabaseDescriptor.getStreamingConnectionsPerHost());
            if (sourceDc != null) {
                streamer.addSourceFilter(new RangeStreamer.SingleDatacenterFilter(DatabaseDescriptor.getEndpointSnitch(), sourceDc));
            }
            if (keyspace == null) {
                for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces().names()) {
                    streamer.addRanges(keyspaceName, this.getLocalReplicas(keyspaceName));
                }
            } else if (tokens == null) {
                streamer.addRanges(keyspace, this.getLocalReplicas(keyspace));
            } else {
                Token.TokenFactory factory = this.getTokenFactory();
                ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
                Pattern rangePattern = Pattern.compile("\\(\\s*(-?\\w+)\\s*,\\s*(-?\\w+)\\s*\\]");
                try (Scanner tokenScanner = new Scanner(tokens);){
                    while (tokenScanner.findInLine(rangePattern) != null) {
                        MatchResult range = tokenScanner.match();
                        Token startToken = factory.fromString(range.group(1));
                        Token endToken = factory.fromString(range.group(2));
                        logger.info("adding range: ({},{}]", (Object)startToken, (Object)endToken);
                        ranges.add(new Range<Token>(startToken, endToken));
                    }
                    if (tokenScanner.hasNext()) {
                        throw new IllegalArgumentException("Unexpected string: " + tokenScanner.next());
                    }
                }
                RangesAtEndpoint localReplicas = this.getLocalReplicas(keyspace);
                RangesAtEndpoint.Builder streamRanges = new RangesAtEndpoint.Builder(FBUtilities.getBroadcastAddressAndPort(), ranges.size());
                for (Range specifiedRange : ranges) {
                    boolean foundParentRange = false;
                    for (Replica localReplica : localReplicas) {
                        if (!localReplica.contains(specifiedRange)) continue;
                        streamRanges.add(localReplica.decorateSubrange(specifiedRange));
                        foundParentRange = true;
                        break;
                    }
                    if (foundParentRange) continue;
                    throw new IllegalArgumentException(String.format("The specified range %s is not a range that is owned by this node. Please ensure that all token ranges specified to be rebuilt belong to this node.", specifiedRange.toString()));
                }
                if (specificSources != null) {
                    String[] stringHosts = specificSources.split(",");
                    HashSet<InetAddressAndPort> sources = new HashSet<InetAddressAndPort>(stringHosts.length);
                    for (String stringHost : stringHosts) {
                        try {
                            InetAddressAndPort endpoint = InetAddressAndPort.getByName(stringHost);
                            if (FBUtilities.getBroadcastAddressAndPort().equals(endpoint)) {
                                throw new IllegalArgumentException("This host was specified as a source for rebuilding. Sources for a rebuild can only be other nodes in the cluster.");
                            }
                            sources.add(endpoint);
                        }
                        catch (UnknownHostException ex) {
                            throw new IllegalArgumentException("Unknown host specified " + stringHost, ex);
                        }
                    }
                    streamer.addSourceFilter(new RangeStreamer.AllowedSourcesFilter(sources));
                }
                streamer.addRanges(keyspace, streamRanges.build());
            }
            StreamResultFuture resultFuture = streamer.fetchAsync();
            resultFuture.get();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (ExecutionException e) {
            logger.error("Error while rebuilding node", e.getCause());
            throw new RuntimeException("Error while rebuilding node: " + e.getCause().getMessage());
        }
        finally {
            this.isRebuilding.set(false);
        }
    }

    @Override
    public void setRpcTimeout(long value) {
        DatabaseDescriptor.setRpcTimeout(value);
        logger.info("set rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadRpcTimeout(long value) {
        DatabaseDescriptor.setReadRpcTimeout(value);
        logger.info("set read rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getReadRpcTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setRangeRpcTimeout(long value) {
        DatabaseDescriptor.setRangeRpcTimeout(value);
        logger.info("set range rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getRangeRpcTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteRpcTimeout(long value) {
        DatabaseDescriptor.setWriteRpcTimeout(value);
        logger.info("set write rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getWriteRpcTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setInternodeTcpConnectTimeoutInMS(int value) {
        DatabaseDescriptor.setInternodeTcpConnectTimeoutInMS(value);
        logger.info("set internode tcp connect timeout to {} ms", (Object)value);
    }

    @Override
    public int getInternodeTcpConnectTimeoutInMS() {
        return DatabaseDescriptor.getInternodeTcpConnectTimeoutInMS();
    }

    @Override
    public void setInternodeTcpUserTimeoutInMS(int value) {
        DatabaseDescriptor.setInternodeTcpUserTimeoutInMS(value);
        logger.info("set internode tcp user timeout to {} ms", (Object)value);
    }

    @Override
    public int getInternodeTcpUserTimeoutInMS() {
        return DatabaseDescriptor.getInternodeTcpUserTimeoutInMS();
    }

    @Override
    public void setInternodeStreamingTcpUserTimeoutInMS(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (String)"TCP user timeout cannot be negative for internode streaming connection. Got %s", (int)value);
        DatabaseDescriptor.setInternodeStreamingTcpUserTimeoutInMS(value);
        logger.info("set internode streaming tcp user timeout to {} ms", (Object)value);
    }

    @Override
    public int getInternodeStreamingTcpUserTimeoutInMS() {
        return DatabaseDescriptor.getInternodeStreamingTcpUserTimeoutInMS();
    }

    @Override
    public void setCounterWriteRpcTimeout(long value) {
        DatabaseDescriptor.setCounterWriteRpcTimeout(value);
        logger.info("set counter write rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getCounterWriteRpcTimeout() {
        return DatabaseDescriptor.getCounterWriteRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setCasContentionTimeout(long value) {
        DatabaseDescriptor.setCasContentionTimeout(value);
        logger.info("set cas contention rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getCasContentionTimeout() {
        return DatabaseDescriptor.getCasContentionTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTruncateRpcTimeout(long value) {
        DatabaseDescriptor.setTruncateRpcTimeout(value);
        logger.info("set truncate rpc timeout to {} ms", (Object)value);
    }

    @Override
    public long getTruncateRpcTimeout() {
        return DatabaseDescriptor.getTruncateRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public void setStreamThroughputMbPerSec(int value) {
        this.setStreamThroughputMbitPerSec(value);
    }

    @Override
    public void setStreamThroughputMbitPerSec(int value) {
        double oldValue = DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSecAsDouble();
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(value);
        StreamManager.StreamRateLimiter.updateThroughput();
        logger.info("setstreamthroughput: throttle set to {}{} megabits per second (was approximately {} megabits per second)", new Object[]{value, value <= 0 ? " (unlimited)" : "", oldValue});
    }

    @Override
    public void setStreamThroughputMebibytesPerSec(int value) {
        double oldValue = DatabaseDescriptor.getStreamThroughputOutboundMebibytesPerSec();
        DatabaseDescriptor.setStreamThroughputOutboundMebibytesPerSecAsInt(value);
        StreamManager.StreamRateLimiter.updateThroughput();
        logger.info("setstreamthroughput: throttle set to {}{} MiB/s (was {} MiB/s)", new Object[]{value, value <= 0 ? " (unlimited)" : "", oldValue});
    }

    @Override
    public double getStreamThroughputMebibytesPerSecAsDouble() {
        return DatabaseDescriptor.getStreamThroughputOutboundMebibytesPerSec();
    }

    @Override
    public int getStreamThroughputMebibytesPerSec() {
        return DatabaseDescriptor.getStreamThroughputOutboundMebibytesPerSecAsInt();
    }

    @Override
    @Deprecated
    public int getStreamThroughputMbPerSec() {
        return this.getStreamThroughputMbitPerSec();
    }

    @Override
    @Deprecated
    public int getStreamThroughputMbitPerSec() {
        return DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public double getStreamThroughputMbitPerSecAsDouble() {
        return DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSecAsDouble();
    }

    @Override
    public void setEntireSSTableStreamThroughputMebibytesPerSec(int value) {
        double oldValue = DatabaseDescriptor.getEntireSSTableStreamThroughputOutboundMebibytesPerSec();
        DatabaseDescriptor.setEntireSSTableStreamThroughputOutboundMebibytesPerSec(value);
        StreamManager.StreamRateLimiter.updateEntireSSTableThroughput();
        logger.info("setstreamthroughput (entire SSTable): throttle set to {}{} MiB/s (was {} MiB/s)", new Object[]{value, value <= 0 ? " (unlimited)" : "", oldValue});
    }

    @Override
    public double getEntireSSTableStreamThroughputMebibytesPerSecAsDouble() {
        return DatabaseDescriptor.getEntireSSTableStreamThroughputOutboundMebibytesPerSec();
    }

    @Override
    @Deprecated
    public void setInterDCStreamThroughputMbPerSec(int value) {
        this.setInterDCStreamThroughputMbitPerSec(value);
    }

    @Override
    public void setInterDCStreamThroughputMbitPerSec(int value) {
        double oldValue = DatabaseDescriptor.getInterDCStreamThroughputOutboundMegabitsPerSecAsDouble();
        DatabaseDescriptor.setInterDCStreamThroughputOutboundMegabitsPerSec(value);
        StreamManager.StreamRateLimiter.updateInterDCThroughput();
        logger.info("setinterdcstreamthroughput: throttle set to {}{} megabits per second (was {} megabits per second)", new Object[]{value, value <= 0 ? " (unlimited)" : "", oldValue});
    }

    @Override
    @Deprecated
    public int getInterDCStreamThroughputMbPerSec() {
        return this.getInterDCStreamThroughputMbitPerSec();
    }

    @Override
    @Deprecated
    public int getInterDCStreamThroughputMbitPerSec() {
        return DatabaseDescriptor.getInterDCStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public double getInterDCStreamThroughputMbitPerSecAsDouble() {
        return DatabaseDescriptor.getInterDCStreamThroughputOutboundMegabitsPerSecAsDouble();
    }

    @Override
    public void setInterDCStreamThroughputMebibytesPerSec(int value) {
        double oldValue = DatabaseDescriptor.getInterDCStreamThroughputOutboundMebibytesPerSec();
        DatabaseDescriptor.setInterDCStreamThroughputOutboundMebibytesPerSecAsInt(value);
        StreamManager.StreamRateLimiter.updateInterDCThroughput();
        logger.info("setinterdcstreamthroughput: throttle set to {}{} MiB/s (was {} MiB/s)", new Object[]{value, value <= 0 ? " (unlimited)" : "", oldValue});
    }

    @Override
    public int getInterDCStreamThroughputMebibytesPerSec() {
        return DatabaseDescriptor.getInterDCStreamThroughputOutboundMebibytesPerSecAsInt();
    }

    @Override
    public double getInterDCStreamThroughputMebibytesPerSecAsDouble() {
        return DatabaseDescriptor.getInterDCStreamThroughputOutboundMebibytesPerSec();
    }

    @Override
    public void setEntireSSTableInterDCStreamThroughputMebibytesPerSec(int value) {
        double oldValue = DatabaseDescriptor.getEntireSSTableInterDCStreamThroughputOutboundMebibytesPerSec();
        DatabaseDescriptor.setEntireSSTableInterDCStreamThroughputOutboundMebibytesPerSec(value);
        StreamManager.StreamRateLimiter.updateEntireSSTableInterDCThroughput();
        logger.info("setinterdcstreamthroughput (entire SSTable): throttle set to {}{} MiB/s (was {} MiB/s)", new Object[]{value, value <= 0 ? " (unlimited)" : "", oldValue});
    }

    @Override
    public double getEntireSSTableInterDCStreamThroughputMebibytesPerSecAsDouble() {
        return DatabaseDescriptor.getEntireSSTableInterDCStreamThroughputOutboundMebibytesPerSec();
    }

    @Override
    public double getCompactionThroughtputMibPerSecAsDouble() {
        return DatabaseDescriptor.getCompactionThroughputMebibytesPerSec();
    }

    @Override
    public long getCompactionThroughtputBytesPerSec() {
        return (long)DatabaseDescriptor.getCompactionThroughputBytesPerSec();
    }

    @Override
    @Deprecated
    public int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.getCompactionThroughputMebibytesPerSecAsInt();
    }

    @Override
    public void setCompactionThroughputMbPerSec(int value) {
        double oldValue = DatabaseDescriptor.getCompactionThroughputMebibytesPerSec();
        DatabaseDescriptor.setCompactionThroughputMebibytesPerSec(value);
        double valueInBytes = (double)value * 1024.0 * 1024.0;
        CompactionManager.instance.setRateInBytes(valueInBytes);
        logger.info("compactionthroughput: throttle set to {} mebibytes per second (was {} mebibytes per second)", (Object)value, (Object)oldValue);
    }

    @Override
    public int getBatchlogReplayThrottleInKB() {
        return DatabaseDescriptor.getBatchlogReplayThrottleInKiB();
    }

    @Override
    public void setBatchlogReplayThrottleInKB(int throttleInKB) {
        DatabaseDescriptor.setBatchlogReplayThrottleInKiB(throttleInKB);
        BatchlogManager.instance.setRate(throttleInKB);
    }

    @Override
    public int getConcurrentCompactors() {
        return DatabaseDescriptor.getConcurrentCompactors();
    }

    @Override
    public void setConcurrentCompactors(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Number of concurrent compactors should be greater than 0.");
        }
        DatabaseDescriptor.setConcurrentCompactors(value);
        CompactionManager.instance.setConcurrentCompactors(value);
    }

    @Override
    public void bypassConcurrentValidatorsLimit() {
        logger.info("Enabling the ability to set concurrent validations to an unlimited value");
        DatabaseDescriptor.allowUnlimitedConcurrentValidations = true;
    }

    @Override
    public void enforceConcurrentValidatorsLimit() {
        logger.info("Disabling the ability to set concurrent validations to an unlimited value");
        DatabaseDescriptor.allowUnlimitedConcurrentValidations = false;
    }

    @Override
    public boolean isConcurrentValidatorsLimitEnforced() {
        return DatabaseDescriptor.allowUnlimitedConcurrentValidations;
    }

    @Override
    public int getConcurrentValidators() {
        return DatabaseDescriptor.getConcurrentValidations();
    }

    @Override
    public void setConcurrentValidators(int value) {
        int concurrentCompactors = DatabaseDescriptor.getConcurrentCompactors();
        if (value > concurrentCompactors && !DatabaseDescriptor.allowUnlimitedConcurrentValidations) {
            throw new IllegalArgumentException(String.format("Cannot set concurrent_validations greater than concurrent_compactors (%d)", concurrentCompactors));
        }
        if (value <= 0) {
            logger.info("Using default value of concurrent_compactors ({}) for concurrent_validations", (Object)concurrentCompactors);
            value = concurrentCompactors;
        } else {
            logger.info("Setting concurrent_validations to {}", (Object)value);
        }
        DatabaseDescriptor.setConcurrentValidations(value);
        CompactionManager.instance.setConcurrentValidations();
    }

    @Override
    public int getConcurrentViewBuilders() {
        return DatabaseDescriptor.getConcurrentViewBuilders();
    }

    @Override
    public void setConcurrentViewBuilders(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Number of concurrent view builders should be greater than 0.");
        }
        DatabaseDescriptor.setConcurrentViewBuilders(value);
        CompactionManager.instance.setConcurrentViewBuilders(DatabaseDescriptor.getConcurrentViewBuilders());
    }

    @Override
    public boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.isIncrementalBackupsEnabled();
    }

    @Override
    public void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.setIncrementalBackupsEnabled(value);
    }

    @VisibleForTesting
    public void setMovingModeUnsafe() {
        this.setMode(Mode.MOVING, true);
    }

    @VisibleForTesting
    public void setNormalModeUnsafe() {
        this.setMode(Mode.NORMAL, true);
    }

    private void setMode(Mode m, boolean log) {
        this.setMode(m, null, log);
    }

    private void setMode(Mode m, String msg, boolean log) {
        String logMsg;
        this.operationMode = m;
        String string = logMsg = msg == null ? m.toString() : String.format("%s: %s", new Object[]{m, msg});
        if (log) {
            logger.info(logMsg);
        } else {
            logger.debug(logMsg);
        }
    }

    @VisibleForTesting
    public Collection<InetAddressAndPort> prepareForBootstrap(long schemaTimeoutMillis, long ringTimeoutMillis) {
        HashSet<InetAddressAndPort> collisions = new HashSet<InetAddressAndPort>();
        if (SystemKeyspace.bootstrapInProgress()) {
            logger.warn("Detected previous bootstrap failure; retrying");
        } else {
            SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.IN_PROGRESS);
        }
        this.setMode(Mode.JOINING, "waiting for ring information", true);
        this.waitForSchema(schemaTimeoutMillis, ringTimeoutMillis);
        this.setMode(Mode.JOINING, "schema complete, ready to bootstrap", true);
        this.setMode(Mode.JOINING, "waiting for pending range calculation", true);
        PendingRangeCalculatorService.instance.blockUntilFinished();
        this.setMode(Mode.JOINING, "calculation complete, ready to bootstrap", true);
        logger.debug("... got ring + schema info");
        if (useStrictConsistency && !this.allowSimultaneousMoves() && (this.tokenMetadata.getBootstrapTokens().valueSet().size() > 0 || this.tokenMetadata.getSizeOfLeavingEndpoints() > 0 || this.tokenMetadata.getSizeOfMovingEndpoints() > 0)) {
            String bootstrapTokens = StringUtils.join(this.tokenMetadata.getBootstrapTokens().valueSet(), (char)',');
            String leavingTokens = StringUtils.join(this.tokenMetadata.getLeavingEndpoints(), (char)',');
            String movingTokens = StringUtils.join((Object[])this.tokenMetadata.getMovingEndpoints().stream().map(e -> (InetAddressAndPort)e.right).toArray(), (char)',');
            throw new UnsupportedOperationException(String.format("Other bootstrapping/leaving/moving nodes detected, cannot bootstrap while cassandra.consistent.rangemovement is true. Nodes detected, bootstrapping: %s; leaving: %s; moving: %s;", bootstrapTokens, leavingTokens, movingTokens));
        }
        if (!this.replacing) {
            if (this.tokenMetadata.isMember(FBUtilities.getBroadcastAddressAndPort())) {
                String s = "This node is already a member of the token ring; bootstrap aborted. (If replacing a dead node, remove the old one from the ring first.)";
                throw new UnsupportedOperationException(s);
            }
            this.setMode(Mode.JOINING, "getting bootstrap token", true);
            this.bootstrapTokens = BootStrapper.getBootstrapTokens(this.tokenMetadata, FBUtilities.getBroadcastAddressAndPort(), schemaTimeoutMillis, ringTimeoutMillis);
        } else {
            if (!StorageService.isReplacingSameAddress()) {
                try {
                    Thread.sleep(LoadBroadcaster.BROADCAST_INTERVAL);
                }
                catch (InterruptedException e2) {
                    throw new UncheckedInterruptedException(e2);
                }
                for (Token token : this.bootstrapTokens) {
                    InetAddressAndPort existing = this.tokenMetadata.getEndpoint(token);
                    if (existing != null) {
                        long nanoDelay = ringTimeoutMillis * 1000000L;
                        if (Gossiper.instance.getEndpointStateForEndpoint(existing).getUpdateTimestamp() > Clock.Global.nanoTime() - nanoDelay) {
                            throw new UnsupportedOperationException("Cannot replace a live node... ");
                        }
                        collisions.add(existing);
                        continue;
                    }
                    throw new UnsupportedOperationException("Cannot replace token " + token + " which does not exist!");
                }
            } else {
                try {
                    Thread.sleep(RING_DELAY_MILLIS);
                }
                catch (InterruptedException e3) {
                    throw new UncheckedInterruptedException(e3);
                }
            }
            this.setMode(Mode.JOINING, "Replacing a node with token(s): " + this.bootstrapTokens, true);
        }
        return collisions;
    }

    @VisibleForTesting
    public boolean bootstrap(Collection<Token> tokens, long bootstrapTimeoutMillis) {
        this.isBootstrapMode = true;
        SystemKeyspace.updateTokens(tokens);
        if (!this.replacing || !StorageService.isReplacingSameAddress()) {
            ArrayList<Pair<ApplicationState, VersionedValue>> states = new ArrayList<Pair<ApplicationState, VersionedValue>>();
            states.add(Pair.create(ApplicationState.TOKENS, this.valueFactory.tokens(tokens)));
            states.add(Pair.create(ApplicationState.STATUS_WITH_PORT, this.replacing ? this.valueFactory.bootReplacingWithPort(DatabaseDescriptor.getReplaceAddress()) : this.valueFactory.bootstrapping(tokens)));
            states.add(Pair.create(ApplicationState.STATUS, this.replacing ? this.valueFactory.bootReplacing(DatabaseDescriptor.getReplaceAddress().getAddress()) : this.valueFactory.bootstrapping(tokens)));
            Gossiper.instance.addLocalApplicationStates(states);
            this.setMode(Mode.JOINING, "sleeping " + RING_DELAY_MILLIS + " ms for pending range setup", true);
            Uninterruptibles.sleepUninterruptibly((long)RING_DELAY_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddressAndPort());
            SystemKeyspace.removeEndpoint(DatabaseDescriptor.getReplaceAddress());
        }
        if (!Gossiper.instance.seenAnySeed()) {
            throw new IllegalStateException("Unable to contact any seeds: " + Gossiper.instance.getSeeds());
        }
        if (Boolean.getBoolean("cassandra.reset_bootstrap_progress")) {
            logger.info("Resetting bootstrap progress to start fresh");
            SystemKeyspace.resetAvailableRanges();
        }
        this.invalidateLocalRanges();
        this.repairPaxosForTopologyChange("bootstrap");
        Future<StreamState> bootstrapStream = this.startBootstrap(tokens);
        try {
            if (bootstrapTimeoutMillis > 0L) {
                bootstrapStream.get(bootstrapTimeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                bootstrapStream.get();
            }
            this.bootstrapFinished();
            logger.info("Bootstrap completed for tokens {}", tokens);
            return true;
        }
        catch (Throwable e) {
            logger.error("Error while waiting on bootstrap to complete. Bootstrap will have to be restarted.", e);
            return false;
        }
    }

    public Future<StreamState> startBootstrap(Collection<Token> tokens) {
        return this.startBootstrap(tokens, this.replacing);
    }

    public Future<StreamState> startBootstrap(Collection<Token> tokens, boolean replacing) {
        this.setMode(Mode.JOINING, "Starting to bootstrap...", true);
        BootStrapper bootstrapper = new BootStrapper(FBUtilities.getBroadcastAddressAndPort(), tokens, this.tokenMetadata);
        bootstrapper.addProgressListener(this.progressSupport);
        return bootstrapper.bootstrap(this.streamStateStore, useStrictConsistency && !replacing);
    }

    private void invalidateLocalRanges() {
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.invalidateLocalRanges();
                }
            }
        }
    }

    private void markViewsAsBuilt() {
        for (String keyspace : Schema.instance.getUserKeyspaces().names()) {
            for (ViewMetadata view : Schema.instance.getKeyspaceMetadata((String)keyspace).views) {
                SystemKeyspace.finishViewBuildStatus(view.keyspace(), view.name());
            }
        }
    }

    private void bootstrapFinished() {
        this.markViewsAsBuilt();
        this.isBootstrapMode = false;
    }

    @Override
    public boolean resumeBootstrap() {
        if (this.isBootstrapMode && SystemKeyspace.bootstrapInProgress()) {
            logger.info("Resuming bootstrap...");
            Collection<Token> tokens = SystemKeyspace.getSavedTokens();
            BootStrapper bootstrapper = new BootStrapper(FBUtilities.getBroadcastAddressAndPort(), tokens, this.tokenMetadata);
            bootstrapper.addProgressListener(this.progressSupport);
            Future<StreamState> bootstrapStream = bootstrapper.bootstrap(this.streamStateStore, useStrictConsistency && !this.replacing);
            bootstrapStream.addCallback(new FutureCallback<StreamState>(){

                public void onSuccess(StreamState streamState) {
                    try {
                        StorageService.this.bootstrapFinished();
                        if (StorageService.this.isSurveyMode) {
                            logger.info("Startup complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
                        } else {
                            StorageService.this.isSurveyMode = false;
                            StorageService.this.progressSupport.progress("bootstrap", ProgressEvent.createNotification("Joining ring..."));
                            StorageService.this.finishJoiningRing(true, StorageService.this.bootstrapTokens);
                            StorageService.this.doAuthSetup(false);
                        }
                        StorageService.this.progressSupport.progress("bootstrap", new ProgressEvent(ProgressEventType.COMPLETE, 1, 1, "Resume bootstrap complete"));
                        if (!StorageService.this.isNativeTransportRunning()) {
                            StorageService.this.daemon.initializeClientTransports();
                        }
                        StorageService.this.daemon.start();
                        logger.info("Resume complete");
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                        throw e;
                    }
                }

                public void onFailure(Throwable e) {
                    String message = "Error during bootstrap: ";
                    message = e instanceof ExecutionException && e.getCause() != null ? message + e.getCause().getMessage() : message + e.getMessage();
                    logger.error(message, e);
                    StorageService.this.progressSupport.progress("bootstrap", new ProgressEvent(ProgressEventType.ERROR, 1, 1, message));
                    StorageService.this.progressSupport.progress("bootstrap", new ProgressEvent(ProgressEventType.COMPLETE, 1, 1, "Resume bootstrap complete"));
                }
            });
            return true;
        }
        logger.info("Resuming bootstrap is requested, but the node is already bootstrapped.");
        return false;
    }

    @Override
    public Map<String, List<Integer>> getConcurrency(List<String> stageNames) {
        Stream<Stage> stageStream = stageNames.isEmpty() ? Arrays.stream(Stage.values()) : stageNames.stream().map(Stage::fromPoolName);
        return stageStream.collect(Collectors.toMap(s -> s.jmxName, s -> Arrays.asList(s.getCorePoolSize(), s.getMaximumPoolSize())));
    }

    @Override
    public void setConcurrency(String threadPoolName, int newCorePoolSize, int newMaximumPoolSize) {
        Stage stage = Stage.fromPoolName(threadPoolName);
        if (newCorePoolSize >= 0) {
            stage.setCorePoolSize(newCorePoolSize);
        }
        stage.setMaximumPoolSize(newMaximumPoolSize);
    }

    @Override
    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointMap(String keyspace) {
        return this.getRangeToEndpointMap(keyspace, false);
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointWithPortMap(String keyspace) {
        return this.getRangeToEndpointMap(keyspace, true);
    }

    public Map<List<String>, List<String>> getRangeToEndpointMap(String keyspace, boolean withPort) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            map.put(((Range)entry.getKey()).asList(), Replicas.stringify((ReplicaCollection)entry.getValue(), withPort));
        }
        return map;
    }

    public String getNativeaddress(InetAddressAndPort endpoint, boolean withPort) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return FBUtilities.getBroadcastNativeAddressAndPort().getHostAddress(withPort);
        }
        if (Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.NATIVE_ADDRESS_AND_PORT) != null) {
            try {
                InetAddressAndPort address = InetAddressAndPort.getByName(Gossiper.instance.getEndpointStateForEndpoint((InetAddressAndPort)endpoint).getApplicationState((ApplicationState)ApplicationState.NATIVE_ADDRESS_AND_PORT).value);
                return address.getHostAddress(withPort);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        String ipAddress = Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.RPC_ADDRESS) != null ? Gossiper.instance.getEndpointStateForEndpoint((InetAddressAndPort)endpoint).getApplicationState((ApplicationState)ApplicationState.RPC_ADDRESS).value : endpoint.getHostAddress(false);
        try {
            InetAddressAndPort address = InetAddressAndPort.getByNameOverrideDefaults(ipAddress, DatabaseDescriptor.getNativeTransportPort());
            return address.getHostAddress(withPort);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String keyspace) {
        return this.getRangeToNativeaddressMap(keyspace, false);
    }

    @Override
    public Map<List<String>, List<String>> getRangeToNativeaddressWithPortMap(String keyspace) {
        return this.getRangeToNativeaddressMap(keyspace, true);
    }

    private Map<List<String>, List<String>> getRangeToNativeaddressMap(String keyspace, boolean withPort) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            ArrayList<String> rpcaddrs = new ArrayList<String>(((EndpointsForRange)entry.getValue()).size());
            for (Replica replicas : (EndpointsForRange)entry.getValue()) {
                rpcaddrs.add(this.getNativeaddress(replicas.endpoint(), withPort));
            }
            map.put(((Range)entry.getKey()).asList(), rpcaddrs);
        }
        return map;
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String keyspace) {
        return this.getPendingRangeToEndpointMap(keyspace, false);
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointWithPortMap(String keyspace) {
        return this.getPendingRangeToEndpointMap(keyspace, true);
    }

    private Map<List<String>, List<String>> getPendingRangeToEndpointMap(String keyspace, boolean withPort) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonLocalStrategyKeyspaces().iterator().next().name;
        }
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry entry : this.tokenMetadata.getPendingRangesMM(keyspace).asMap().entrySet()) {
            map.put(((Range)entry.getKey()).asList(), Replicas.stringify((ReplicaCollection)entry.getValue(), withPort));
        }
        return map;
    }

    public EndpointsByRange getRangeToAddressMap(String keyspace) {
        return this.getRangeToAddressMap(keyspace, this.tokenMetadata.sortedTokens());
    }

    public EndpointsByRange getRangeToAddressMapInLocalDC(String keyspace) {
        Predicate isLocalDC = replica -> this.isLocalDC(replica.endpoint());
        EndpointsByRange origMap = this.getRangeToAddressMap(keyspace, this.getTokensInLocalDC());
        HashMap filteredMap = Maps.newHashMap();
        for (Map.Entry entry : origMap.entrySet()) {
            EndpointsForRange endpointsInLocalDC = (EndpointsForRange)((EndpointsForRange)entry.getValue()).filter((java.util.function.Predicate)isLocalDC);
            filteredMap.put(entry.getKey(), endpointsInLocalDC);
        }
        return new EndpointsByRange(filteredMap);
    }

    private List<Token> getTokensInLocalDC() {
        ArrayList filteredTokens = Lists.newArrayList();
        for (Token token : this.tokenMetadata.sortedTokens()) {
            InetAddressAndPort endpoint = this.tokenMetadata.getEndpoint(token);
            if (!this.isLocalDC(endpoint)) continue;
            filteredTokens.add(token);
        }
        return filteredTokens;
    }

    private boolean isLocalDC(InetAddressAndPort targetHost) {
        String remoteDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(targetHost);
        String localDC = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
        return remoteDC.equals(localDC);
    }

    private EndpointsByRange getRangeToAddressMap(String keyspace, List<Token> sortedTokens) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonLocalStrategyKeyspaces().iterator().next().name;
        }
        List<Range<Token>> ranges = this.getAllRanges(sortedTokens);
        return this.constructRangeToEndpointMap(keyspace, ranges);
    }

    @Override
    public List<String> describeRingJMX(String keyspace) throws IOException {
        return this.describeRingJMX(keyspace, false);
    }

    @Override
    public List<String> describeRingWithPortJMX(String keyspace) throws IOException {
        return this.describeRingJMX(keyspace, true);
    }

    private List<String> describeRingJMX(String keyspace, boolean withPort) throws IOException {
        List<TokenRange> tokenRanges;
        try {
            tokenRanges = this.describeRing(keyspace, false, withPort);
        }
        catch (InvalidRequestException e) {
            throw new IOException(e.getMessage());
        }
        ArrayList<String> result = new ArrayList<String>(tokenRanges.size());
        for (TokenRange tokenRange : tokenRanges) {
            result.add(tokenRange.toString(withPort));
        }
        return result;
    }

    public List<TokenRange> describeRing(String keyspace) throws InvalidRequestException {
        return this.describeRing(keyspace, false, false);
    }

    public List<TokenRange> describeLocalRing(String keyspace) throws InvalidRequestException {
        return this.describeRing(keyspace, true, false);
    }

    private List<TokenRange> describeRing(String keyspace, boolean includeOnlyLocalDC, boolean withPort) throws InvalidRequestException {
        if (!Schema.instance.getKeyspaces().contains((Object)keyspace)) {
            throw new InvalidRequestException("No such keyspace: " + keyspace);
        }
        if (keyspace == null || Keyspace.open(keyspace).getReplicationStrategy() instanceof LocalStrategy) {
            throw new InvalidRequestException("There is no ring for the keyspace: " + keyspace);
        }
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        Token.TokenFactory tf = this.getTokenFactory();
        EndpointsByRange rangeToAddressMap = includeOnlyLocalDC ? this.getRangeToAddressMapInLocalDC(keyspace) : this.getRangeToAddressMap(keyspace);
        for (Map.Entry entry : rangeToAddressMap.entrySet()) {
            ranges.add(TokenRange.create(tf, (Range)entry.getKey(), (List<InetAddressAndPort>)ImmutableList.copyOf(((EndpointsForRange)entry.getValue()).endpoints()), withPort));
        }
        return ranges;
    }

    @Override
    public Map<String, String> getTokenToEndpointMap() {
        return this.getTokenToEndpointMap(false);
    }

    @Override
    public Map<String, String> getTokenToEndpointWithPortMap() {
        return this.getTokenToEndpointMap(true);
    }

    private Map<String, String> getTokenToEndpointMap(boolean withPort) {
        Map<Token, InetAddressAndPort> mapInetAddress = this.tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap();
        LinkedHashMap<String, String> mapString = new LinkedHashMap<String, String>(mapInetAddress.size());
        ArrayList<Token> tokens = new ArrayList<Token>(mapInetAddress.keySet());
        Collections.sort(tokens);
        for (Token token : tokens) {
            mapString.put(token.toString(), mapInetAddress.get(token).getHostAddress(withPort));
        }
        return mapString;
    }

    @Override
    public String getLocalHostId() {
        return this.getTokenMetadata().getHostId(FBUtilities.getBroadcastAddressAndPort()).toString();
    }

    public UUID getLocalHostUUID() {
        return this.getTokenMetadata().getHostId(FBUtilities.getBroadcastAddressAndPort());
    }

    @Override
    public Map<String, String> getHostIdMap() {
        return this.getEndpointToHostId();
    }

    @Override
    public Map<String, String> getEndpointToHostId() {
        return this.getEndpointToHostId(false);
    }

    @Override
    public Map<String, String> getEndpointWithPortToHostId() {
        return this.getEndpointToHostId(true);
    }

    private Map<String, String> getEndpointToHostId(boolean withPort) {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        for (Map.Entry<InetAddressAndPort, UUID> entry : this.getTokenMetadata().getEndpointToHostIdMapForReading().entrySet()) {
            mapOut.put(entry.getKey().getHostAddress(withPort), entry.getValue().toString());
        }
        return mapOut;
    }

    @Override
    public Map<String, String> getHostIdToEndpoint() {
        return this.getHostIdToEndpoint(false);
    }

    @Override
    public Map<String, String> getHostIdToEndpointWithPort() {
        return this.getHostIdToEndpoint(true);
    }

    private Map<String, String> getHostIdToEndpoint(boolean withPort) {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        for (Map.Entry<InetAddressAndPort, UUID> entry : this.getTokenMetadata().getEndpointToHostIdMapForReading().entrySet()) {
            mapOut.put(entry.getValue().toString(), entry.getKey().getHostAddress(withPort));
        }
        return mapOut;
    }

    private EndpointsByRange constructRangeToEndpointMap(String keyspace, List<Range<Token>> ranges) {
        AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
        HashMap<Range<Token>, EndpointsForRange> rangeToEndpointMap = new HashMap<Range<Token>, EndpointsForRange>(ranges.size());
        for (Range<Token> range : ranges) {
            rangeToEndpointMap.put(range, strategy.getNaturalReplicas(range.right));
        }
        return new EndpointsByRange((Map<Range<Token>, EndpointsForRange>)rangeToEndpointMap);
    }

    @Override
    public void beforeChange(InetAddressAndPort endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddressAndPort endpoint, ApplicationState state, VersionedValue value) {
        if (state == ApplicationState.STATUS || state == ApplicationState.STATUS_WITH_PORT) {
            String moveName;
            String[] pieces = StorageService.splitValue(value);
            assert (pieces.length > 0);
            switch (moveName = pieces[0]) {
                case "BOOT_REPLACE": {
                    this.handleStateBootreplacing(endpoint, pieces);
                    break;
                }
                case "BOOT": {
                    this.handleStateBootstrap(endpoint);
                    break;
                }
                case "NORMAL": {
                    this.handleStateNormal(endpoint, "NORMAL");
                    break;
                }
                case "shutdown": {
                    this.handleStateNormal(endpoint, "shutdown");
                    break;
                }
                case "removing": 
                case "removed": {
                    this.handleStateRemoving(endpoint, pieces);
                    break;
                }
                case "LEAVING": {
                    this.handleStateLeaving(endpoint);
                    break;
                }
                case "LEFT": {
                    this.handleStateLeft(endpoint, pieces);
                    break;
                }
                case "MOVING": {
                    this.handleStateMoving(endpoint, pieces);
                }
            }
        } else {
            EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
            if (epState == null || Gossiper.instance.isDeadState(epState)) {
                logger.debug("Ignoring state change for dead or unknown endpoint: {}", (Object)endpoint);
                return;
            }
            if (this.getTokenMetadata().isMember(endpoint)) {
                switch (state) {
                    case RELEASE_VERSION: {
                        SystemKeyspace.updatePeerInfo(endpoint, "release_version", value.value);
                        break;
                    }
                    case DC: {
                        this.updateTopology(endpoint);
                        SystemKeyspace.updatePeerInfo(endpoint, "data_center", value.value);
                        break;
                    }
                    case RACK: {
                        this.updateTopology(endpoint);
                        SystemKeyspace.updatePeerInfo(endpoint, "rack", value.value);
                        break;
                    }
                    case RPC_ADDRESS: {
                        try {
                            SystemKeyspace.updatePeerInfo(endpoint, "rpc_address", InetAddress.getByName(value.value));
                            break;
                        }
                        catch (UnknownHostException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case NATIVE_ADDRESS_AND_PORT: {
                        try {
                            InetAddressAndPort address = InetAddressAndPort.getByName(value.value);
                            SystemKeyspace.updatePeerNativeAddress(endpoint, address);
                            break;
                        }
                        catch (UnknownHostException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case SCHEMA: {
                        SystemKeyspace.updatePeerInfo(endpoint, "schema_version", UUID.fromString(value.value));
                        break;
                    }
                    case HOST_ID: {
                        SystemKeyspace.updatePeerInfo(endpoint, "host_id", UUID.fromString(value.value));
                        break;
                    }
                    case RPC_READY: {
                        this.notifyRpcChange(endpoint, epState.isRpcReady());
                        break;
                    }
                    case NET_VERSION: {
                        this.updateNetVersion(endpoint, value);
                    }
                }
            } else {
                logger.debug("Ignoring application state {} from {} because it is not a member in token metadata", (Object)state, (Object)endpoint);
            }
        }
    }

    private static String[] splitValue(VersionedValue value) {
        return value.value.split(VersionedValue.DELIMITER_STR, -1);
    }

    private void updateNetVersion(InetAddressAndPort endpoint, VersionedValue value) {
        try {
            MessagingService.instance().versions.set(endpoint, Integer.parseInt(value.value));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)("Got invalid value for NET_VERSION application state: " + value.value));
        }
    }

    public void updateTopology(InetAddressAndPort endpoint) {
        if (this.getTokenMetadata().isMember(endpoint)) {
            this.getTokenMetadata().updateTopology(endpoint);
        }
    }

    public void updateTopology() {
        this.getTokenMetadata().updateTopology();
    }

    private void updatePeerInfo(InetAddressAndPort endpoint) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        InetAddress native_address = null;
        int native_port = DatabaseDescriptor.getNativeTransportPort();
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.states()) {
            switch (entry.getKey()) {
                case RELEASE_VERSION: {
                    SystemKeyspace.updatePeerInfo(endpoint, "release_version", entry.getValue().value);
                    break;
                }
                case DC: {
                    SystemKeyspace.updatePeerInfo(endpoint, "data_center", entry.getValue().value);
                    break;
                }
                case RACK: {
                    SystemKeyspace.updatePeerInfo(endpoint, "rack", entry.getValue().value);
                    break;
                }
                case RPC_ADDRESS: {
                    try {
                        native_address = InetAddress.getByName(entry.getValue().value);
                        break;
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                }
                case NATIVE_ADDRESS_AND_PORT: {
                    try {
                        InetAddressAndPort address = InetAddressAndPort.getByName(entry.getValue().value);
                        native_address = address.getAddress();
                        native_port = address.getPort();
                        break;
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                }
                case SCHEMA: {
                    SystemKeyspace.updatePeerInfo(endpoint, "schema_version", UUID.fromString(entry.getValue().value));
                    break;
                }
                case HOST_ID: {
                    SystemKeyspace.updatePeerInfo(endpoint, "host_id", UUID.fromString(entry.getValue().value));
                }
            }
        }
        if (native_address != null) {
            SystemKeyspace.updatePeerNativeAddress(endpoint, InetAddressAndPort.getByAddressOverrideDefaults(native_address, native_port));
        }
    }

    private void notifyRpcChange(InetAddressAndPort endpoint, boolean ready) {
        if (ready) {
            this.notifyUp(endpoint);
        } else {
            this.notifyDown(endpoint);
        }
    }

    private void notifyUp(InetAddressAndPort endpoint) {
        if (!this.isRpcReady(endpoint) || !Gossiper.instance.isAlive(endpoint)) {
            return;
        }
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onUp(endpoint);
        }
    }

    private void notifyDown(InetAddressAndPort endpoint) {
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onDown(endpoint);
        }
    }

    private void notifyJoined(InetAddressAndPort endpoint) {
        if (!this.isStatus(endpoint, "NORMAL")) {
            return;
        }
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onJoinCluster(endpoint);
        }
    }

    private void notifyMoved(InetAddressAndPort endpoint) {
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onMove(endpoint);
        }
    }

    private void notifyLeft(InetAddressAndPort endpoint) {
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onLeaveCluster(endpoint);
        }
    }

    private boolean isStatus(InetAddressAndPort endpoint, String status) {
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        return state != null && state.getStatus().equals(status);
    }

    public boolean isRpcReady(InetAddressAndPort endpoint) {
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        return state != null && state.isRpcReady();
    }

    public void setRpcReady(boolean value) {
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(FBUtilities.getBroadcastAddressAndPort());
        assert (!value || state != null);
        if (state != null) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.RPC_READY, this.valueFactory.rpcReady(value));
        }
    }

    private Collection<Token> getTokensFor(InetAddressAndPort endpoint) {
        try {
            EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
            if (state == null) {
                return Collections.emptyList();
            }
            VersionedValue versionedValue = state.getApplicationState(ApplicationState.TOKENS);
            if (versionedValue == null) {
                return Collections.emptyList();
            }
            return TokenSerializer.deserialize(this.tokenMetadata.partitioner, new DataInputStream(new ByteArrayInputStream(versionedValue.toBytes())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleStateBootstrap(InetAddressAndPort endpoint) {
        Collection<Token> tokens = this.getTokensFor(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state bootstrapping, token {}", (Object)endpoint, tokens);
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            if (!this.tokenMetadata.isLeaving(endpoint)) {
                logger.info("Node {} state jump to bootstrap", (Object)endpoint);
            }
            this.tokenMetadata.removeEndpoint(endpoint);
        }
        this.tokenMetadata.addBootstrapTokens(tokens, endpoint);
        PendingRangeCalculatorService.instance.update();
        this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(endpoint), endpoint);
    }

    private void handleStateBootreplacing(InetAddressAndPort newNode, String[] pieces) {
        InetAddressAndPort oldNode;
        try {
            oldNode = InetAddressAndPort.getByName(pieces[1]);
        }
        catch (Exception e) {
            logger.error("Node {} tried to replace malformed endpoint {}.", new Object[]{newNode, pieces[1], e});
            return;
        }
        if (FailureDetector.instance.isAlive(oldNode)) {
            throw new RuntimeException(String.format("Node %s is trying to replace alive node %s.", newNode, oldNode));
        }
        Optional<InetAddressAndPort> replacingNode = this.tokenMetadata.getReplacingNode(newNode);
        if (replacingNode.isPresent() && !replacingNode.get().equals(oldNode)) {
            throw new RuntimeException(String.format("Node %s is already replacing %s but is trying to replace %s.", newNode, replacingNode.get(), oldNode));
        }
        Collection<Token> tokens = this.getTokensFor(newNode);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} is replacing {}, tokens {}", new Object[]{newNode, oldNode, tokens});
        }
        this.tokenMetadata.addReplaceTokens(tokens, newNode, oldNode);
        PendingRangeCalculatorService.instance.update();
        this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(newNode), newNode);
    }

    private void ensureUpToDateTokenMetadata(String status, InetAddressAndPort endpoint) {
        TreeSet<Token> tokens = new TreeSet<Token>(this.getTokensFor(endpoint));
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state {}, tokens {}", new Object[]{endpoint, status, tokens});
        }
        if (!this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node {} state jump to {}", (Object)endpoint, (Object)status);
            this.updateTokenMetadata(endpoint, tokens);
        } else if (!tokens.equals(new TreeSet<Token>(this.tokenMetadata.getTokens(endpoint)))) {
            logger.warn("Node {} '{}' token mismatch. Long network partition?", (Object)endpoint, (Object)status);
            this.updateTokenMetadata(endpoint, tokens);
        }
    }

    private void updateTokenMetadata(InetAddressAndPort endpoint, Iterable<Token> tokens) {
        this.updateTokenMetadata(endpoint, tokens, new HashSet<InetAddressAndPort>());
    }

    private void updateTokenMetadata(InetAddressAndPort endpoint, Iterable<Token> tokens, Set<InetAddressAndPort> endpointsToRemove) {
        HashSet<Token> tokensToUpdateInMetadata = new HashSet<Token>();
        HashSet<Token> tokensToUpdateInSystemKeyspace = new HashSet<Token>();
        for (Token token : tokens) {
            InetAddressAndPort currentOwner = this.tokenMetadata.getEndpoint(token);
            if (currentOwner == null) {
                logger.debug("New node {} at token {}", (Object)endpoint, (Object)token);
                tokensToUpdateInMetadata.add(token);
                tokensToUpdateInSystemKeyspace.add(token);
                continue;
            }
            if (endpoint.equals(currentOwner)) {
                tokensToUpdateInMetadata.add(token);
                tokensToUpdateInSystemKeyspace.add(token);
                continue;
            }
            if (endpoint.equals(this.tokenMetadata.getReplacementNode(currentOwner).orElse(null)) || Gossiper.instance.compareEndpointStartup(endpoint, currentOwner) > 0) {
                tokensToUpdateInMetadata.add(token);
                tokensToUpdateInSystemKeyspace.add(token);
                Multimap<InetAddressAndPort, Token> epToTokenCopy = this.getTokenMetadata().getEndpointToTokenMapForReading();
                epToTokenCopy.get((Object)currentOwner).remove(token);
                if (epToTokenCopy.get((Object)currentOwner).isEmpty()) {
                    endpointsToRemove.add(currentOwner);
                }
                logger.info("Nodes {} and {} have the same token {}. {} is the new owner", new Object[]{endpoint, currentOwner, token, endpoint});
                continue;
            }
            logger.info("Nodes {} and {} have the same token {}.  Ignoring {}", new Object[]{endpoint, currentOwner, token, endpoint});
        }
        this.tokenMetadata.updateNormalTokens(tokensToUpdateInMetadata, endpoint);
        for (InetAddressAndPort ep : endpointsToRemove) {
            this.removeEndpoint(ep);
            if (!this.replacing || !ep.equals(DatabaseDescriptor.getReplaceAddress())) continue;
            Gossiper.instance.replacementQuarantine(ep);
        }
        if (!tokensToUpdateInSystemKeyspace.isEmpty()) {
            SystemKeyspace.updateTokens(endpoint, tokensToUpdateInSystemKeyspace);
        }
        this.invalidateLocalRanges();
    }

    @VisibleForTesting
    public boolean isReplacingSameHostAddressAndHostId(UUID hostId) {
        try {
            return StorageService.isReplacingSameAddress() && Gossiper.instance.getEndpointStateForEndpoint(DatabaseDescriptor.getReplaceAddress()) != null && hostId.equals(Gossiper.instance.getHostId(DatabaseDescriptor.getReplaceAddress()));
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause().getClass() == UnknownHostException.class) {
                logger.info("Suppressed exception while checking isReplacingSameHostAddressAndHostId({}). Original host was probably decommissioned. ({})", (Object)hostId, (Object)ex.getMessage());
                return false;
            }
            throw ex;
        }
    }

    private void handleStateNormal(InetAddressAndPort endpoint, String status) {
        Optional<InetAddressAndPort> replacementNode;
        Optional<InetAddressAndPort> replacingNode;
        Collection<Token> tokens = this.getTokensFor(endpoint);
        HashSet<InetAddressAndPort> endpointsToRemove = new HashSet<InetAddressAndPort>();
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state {}, token {}", new Object[]{endpoint, status, tokens});
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node {} state jump to {}", (Object)endpoint, (Object)status);
        }
        if (tokens.isEmpty() && status.equals("NORMAL")) {
            logger.error("Node {} is in state normal but it has no tokens, state: {}", (Object)endpoint, (Object)Gossiper.instance.getEndpointStateForEndpoint(endpoint));
        }
        if ((replacingNode = this.tokenMetadata.getReplacingNode(endpoint)).isPresent()) {
            assert (!endpoint.equals(replacingNode.get())) : "Pending replacement endpoint with same address is not supported";
            logger.info("Node {} will complete replacement of {} for tokens {}", new Object[]{endpoint, replacingNode.get(), tokens});
            if (FailureDetector.instance.isAlive(replacingNode.get())) {
                logger.error("Node {} cannot complete replacement of alive node {}.", (Object)endpoint, (Object)replacingNode.get());
                return;
            }
            endpointsToRemove.add(replacingNode.get());
        }
        if ((replacementNode = this.tokenMetadata.getReplacementNode(endpoint)).isPresent()) {
            logger.warn("Node {} is currently being replaced by node {}.", (Object)endpoint, (Object)replacementNode.get());
        }
        this.updatePeerInfo(endpoint);
        UUID hostId = Gossiper.instance.getHostId(endpoint);
        InetAddressAndPort existing = this.tokenMetadata.getEndpointForHostId(hostId);
        if (this.replacing && this.isReplacingSameHostAddressAndHostId(hostId)) {
            logger.warn("Not updating token metadata for {} because I am replacing it", (Object)endpoint);
        } else if (existing != null && !existing.equals(endpoint)) {
            if (existing.equals(FBUtilities.getBroadcastAddressAndPort())) {
                logger.warn("Not updating host ID {} for {} because it's mine", (Object)hostId, (Object)endpoint);
                this.tokenMetadata.removeEndpoint(endpoint);
                endpointsToRemove.add(endpoint);
            } else if (Gossiper.instance.compareEndpointStartup(endpoint, existing) > 0) {
                logger.warn("Host ID collision for {} between {} and {}; {} is the new owner", new Object[]{hostId, existing, endpoint, endpoint});
                this.tokenMetadata.removeEndpoint(existing);
                endpointsToRemove.add(existing);
                this.tokenMetadata.updateHostId(hostId, endpoint);
            } else {
                logger.warn("Host ID collision for {} between {} and {}; ignored {}", new Object[]{hostId, existing, endpoint, endpoint});
                this.tokenMetadata.removeEndpoint(endpoint);
                endpointsToRemove.add(endpoint);
            }
        } else {
            this.tokenMetadata.updateHostId(hostId, endpoint);
        }
        boolean isMember = this.tokenMetadata.isMember(endpoint);
        boolean isMoving = this.tokenMetadata.isMoving(endpoint);
        this.updateTokenMetadata(endpoint, tokens, endpointsToRemove);
        if (isMoving || this.operationMode == Mode.MOVING) {
            this.tokenMetadata.removeFromMoving(endpoint);
            this.invalidateLocalRanges();
            this.notifyMoved(endpoint);
        } else if (!isMember) {
            this.notifyJoined(endpoint);
        }
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateLeaving(InetAddressAndPort endpoint) {
        this.ensureUpToDateTokenMetadata("LEAVING", endpoint);
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateLeft(InetAddressAndPort endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state left, tokens {}", (Object)endpoint, tokens);
        }
        this.excise(tokens, endpoint, this.extractExpireTime(pieces));
    }

    private void handleStateMoving(InetAddressAndPort endpoint, String[] pieces) {
        this.ensureUpToDateTokenMetadata("MOVING", endpoint);
        assert (pieces.length >= 2);
        Token token = this.getTokenFactory().fromString(pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state moving, new token {}", (Object)endpoint, (Object)token);
        }
        this.tokenMetadata.addMovingEndpoint(token, endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateRemoving(InetAddressAndPort endpoint, String[] pieces) {
        assert (pieces.length > 0);
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            logger.info("Received removenode gossip about myself. Is this node rejoining after an explicit removenode?");
            try {
                this.drain();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            String state = pieces[0];
            Collection<Token> removeTokens = this.tokenMetadata.getTokens(endpoint);
            if ("removed".equals(state)) {
                this.excise(removeTokens, endpoint, this.extractExpireTime(pieces));
            } else if ("removing".equals(state)) {
                this.ensureUpToDateTokenMetadata(state, endpoint);
                if (logger.isDebugEnabled()) {
                    logger.debug("Tokens {} removed manually (endpoint was {})", removeTokens, (Object)endpoint);
                }
                this.tokenMetadata.addLeavingEndpoint(endpoint);
                PendingRangeCalculatorService.instance.update();
                String[] coordinator = StorageService.splitValue(Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.REMOVAL_COORDINATOR));
                UUID hostId = UUID.fromString(coordinator[1]);
                this.restoreReplicaCount(endpoint, this.tokenMetadata.getEndpointForHostId(hostId));
            }
        } else {
            if ("removed".equals(pieces[0])) {
                this.addExpireTimeIfFound(endpoint, this.extractExpireTime(pieces));
            }
            this.removeEndpoint(endpoint);
        }
    }

    private void excise(Collection<Token> tokens, InetAddressAndPort endpoint) {
        logger.info("Removing tokens {} for {}", tokens, (Object)endpoint);
        UUID hostId = this.tokenMetadata.getHostId(endpoint);
        if (hostId != null && this.tokenMetadata.isMember(endpoint)) {
            long delay = DatabaseDescriptor.getMinRpcTimeout(TimeUnit.MILLISECONDS) + DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MILLISECONDS);
            ScheduledExecutors.optionalTasks.schedule(() -> HintsService.instance.excise(hostId), delay, TimeUnit.MILLISECONDS);
        }
        this.removeEndpoint(endpoint);
        this.tokenMetadata.removeEndpoint(endpoint);
        if (!tokens.isEmpty()) {
            this.tokenMetadata.removeBootstrapTokens(tokens);
        }
        this.notifyLeft(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void excise(Collection<Token> tokens, InetAddressAndPort endpoint, long expireTime) {
        this.addExpireTimeIfFound(endpoint, expireTime);
        this.excise(tokens, endpoint);
    }

    private void removeEndpoint(InetAddressAndPort endpoint) {
        Gossiper.runInGossipStageBlocking(() -> Gossiper.instance.removeEndpoint(endpoint));
        SystemKeyspace.removeEndpoint(endpoint);
    }

    protected void addExpireTimeIfFound(InetAddressAndPort endpoint, long expireTime) {
        if (expireTime != 0L) {
            Gossiper.instance.addExpireTimeForEndpoint(endpoint, expireTime);
        }
    }

    protected long extractExpireTime(String[] pieces) {
        return Long.parseLong(pieces[2]);
    }

    private Multimap<InetAddressAndPort, RangeStreamer.FetchReplica> getNewSourceReplicas(String keyspaceName, Set<LeavingReplica> leavingReplicas) {
        InetAddressAndPort myAddress = FBUtilities.getBroadcastAddressAndPort();
        EndpointsByRange rangeReplicas = Keyspace.open(keyspaceName).getReplicationStrategy().getRangeAddresses(this.tokenMetadata.cloneOnlyTokenMap());
        HashMultimap sourceRanges = HashMultimap.create();
        IFailureDetector failureDetector = FailureDetector.instance;
        logger.debug("Getting new source replicas for {}", leavingReplicas);
        for (LeavingReplica leaver : leavingReplicas) {
            boolean transientToFull;
            Replica leavingReplica = leaver.leavingReplica;
            Replica ourReplica = leaver.ourReplica;
            Predicate replicaFilter = ourReplica.isFull() ? Replica::isFull : Predicates.alwaysTrue();
            Predicate notSelf = replica -> !replica.endpoint().equals(myAddress);
            EndpointsForRange possibleReplicas = rangeReplicas.get(leavingReplica.range());
            logger.info("Possible replicas for newReplica {} are {}", (Object)ourReplica, (Object)possibleReplicas);
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            EndpointsForRange sortedPossibleReplicas = snitch.sortedByProximity(myAddress, possibleReplicas);
            logger.info("Sorted possible replicas starts as {}", (Object)sortedPossibleReplicas);
            Optional myCurrentReplica = Iterables.tryFind((Iterable)possibleReplicas, replica -> replica.endpoint().equals(myAddress)).toJavaUtil();
            boolean bl = transientToFull = myCurrentReplica.isPresent() && ((Replica)myCurrentReplica.get()).isTransient() && ourReplica.isFull();
            assert (!sortedPossibleReplicas.endpoints().contains(myAddress) || transientToFull) : String.format("My address %s, sortedPossibleReplicas %s, myCurrentReplica %s, myNewReplica %s", myAddress, sortedPossibleReplicas, myCurrentReplica, ourReplica);
            boolean foundLiveReplica = false;
            for (Replica possibleReplica : (EndpointsForRange)sortedPossibleReplicas.filter((java.util.function.Predicate)Predicates.and((Predicate)replicaFilter, (Predicate)notSelf))) {
                if (failureDetector.isAlive(possibleReplica.endpoint())) {
                    foundLiveReplica = true;
                    sourceRanges.put((Object)possibleReplica.endpoint(), (Object)new RangeStreamer.FetchReplica(ourReplica, possibleReplica));
                    break;
                }
                logger.debug("Skipping down replica {}", (Object)possibleReplica);
            }
            if (foundLiveReplica) continue;
            logger.warn("Didn't find live replica to restore replication for " + ourReplica);
        }
        return sourceRanges;
    }

    private void sendReplicationNotification(InetAddressAndPort remote) {
        Message<NoPayload> msg = Message.out(Verb.REPLICATION_DONE_REQ, NoPayload.noPayload);
        IFailureDetector failureDetector = FailureDetector.instance;
        if (logger.isDebugEnabled()) {
            logger.debug("Notifying {} of replication completion\n", (Object)remote);
        }
        while (failureDetector.isAlive(remote)) {
            AsyncOneResponse ior = new AsyncOneResponse();
            MessagingService.instance().sendWithCallback(msg, remote, ior);
            if (!ior.awaitUninterruptibly(DatabaseDescriptor.getRpcTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS)) continue;
            if (!ior.isSuccess()) {
                throw new AssertionError((Object)ior.cause());
            }
            return;
        }
    }

    private void restoreReplicaCount(InetAddressAndPort endpoint, final InetAddressAndPort notifyEndpoint) {
        HashMap<String, Object> replicasToFetch = new HashMap<String, Object>();
        InetAddressAndPort myAddress = FBUtilities.getBroadcastAddressAndPort();
        for (String keyspaceName2 : Schema.instance.getNonLocalStrategyKeyspaces().names()) {
            logger.debug("Restoring replica count for keyspace {}", (Object)keyspaceName2);
            EndpointsByReplica changedReplicas = StorageService.getChangedReplicasForLeaving(keyspaceName2, endpoint, this.tokenMetadata, Keyspace.open(keyspaceName2).getReplicationStrategy());
            HashSet<LeavingReplica> myNewReplicas = new HashSet<LeavingReplica>();
            for (Map.Entry entry : changedReplicas.flattenEntries()) {
                Replica replica = entry.getValue();
                if (!replica.endpoint().equals(myAddress)) continue;
                myNewReplicas.add(new LeavingReplica((Replica)entry.getKey(), entry.getValue()));
            }
            logger.debug("Changed replicas for leaving {}, myNewReplicas {}", (Object)changedReplicas, myNewReplicas);
            replicasToFetch.put(keyspaceName2, this.getNewSourceReplicas(keyspaceName2, myNewReplicas));
        }
        StreamPlan stream = new StreamPlan(StreamOperation.RESTORE_REPLICA_COUNT);
        replicasToFetch.forEach((keyspaceName, sources) -> {
            logger.debug("Requesting keyspace {} sources", keyspaceName);
            sources.asMap().forEach((sourceAddress, fetchReplicas) -> {
                logger.debug("Source and our replicas are {}", fetchReplicas);
                RangesAtEndpoint full = fetchReplicas.stream().filter(f -> f.remote.isFull()).map(f -> f.local).collect(RangesAtEndpoint.collector(myAddress));
                RangesAtEndpoint transientReplicas = fetchReplicas.stream().filter(f -> f.remote.isTransient()).map(f -> f.local).collect(RangesAtEndpoint.collector(myAddress));
                if (logger.isDebugEnabled()) {
                    logger.debug("Requesting from {} full replicas {} transient replicas {}", new Object[]{sourceAddress, StringUtils.join((Iterable)full, (String)", "), StringUtils.join((Iterable)transientReplicas, (String)", ")});
                }
                stream.requestRanges((InetAddressAndPort)sourceAddress, (String)keyspaceName, full, transientReplicas);
            });
        });
        StreamResultFuture future = stream.execute();
        future.addCallback((FutureCallback)new FutureCallback<StreamState>(){

            public void onSuccess(StreamState finalState) {
                StorageService.this.sendReplicationNotification(notifyEndpoint);
            }

            public void onFailure(Throwable t) {
                logger.warn("Streaming to restore replica count failed", t);
                StorageService.this.sendReplicationNotification(notifyEndpoint);
            }
        });
    }

    static EndpointsByReplica getChangedReplicasForLeaving(String keyspaceName, InetAddressAndPort endpoint, TokenMetadata tokenMetadata, AbstractReplicationStrategy strat) {
        RangesAtEndpoint replicas = strat.getAddressReplicas(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} replicas [{}]", (Object)endpoint, (Object)StringUtils.join((Iterable)replicas, (String)", "));
        }
        HashMap currentReplicaEndpoints = Maps.newHashMapWithExpectedSize((int)replicas.size());
        TokenMetadata metadata = tokenMetadata.cloneOnlyTokenMap();
        for (Replica replica : replicas) {
            currentReplicaEndpoints.put(replica, strat.calculateNaturalReplicas((Token)replica.range().right, metadata));
        }
        TokenMetadata temp = tokenMetadata.cloneAfterAllLeft();
        if (temp.isMember(endpoint)) {
            temp.removeEndpoint(endpoint);
        }
        EndpointsByReplica.Builder changedRanges = new EndpointsByReplica.Builder();
        for (Replica replica : replicas) {
            EndpointsForRange newReplicaEndpoints = strat.calculateNaturalReplicas((Token)replica.range().right, temp);
            newReplicaEndpoints = (EndpointsForRange)newReplicaEndpoints.filter(newReplica -> {
                Optional currentReplicaOptional = Iterables.tryFind((Iterable)((Iterable)currentReplicaEndpoints.get(replica)), currentReplica -> newReplica.endpoint().equals(currentReplica.endpoint())).toJavaUtil();
                if (!currentReplicaOptional.isPresent()) {
                    return true;
                }
                Replica currentReplica2 = (Replica)currentReplicaOptional.get();
                return currentReplica2.isTransient() && newReplica.isFull();
            });
            if (logger.isDebugEnabled()) {
                if (newReplicaEndpoints.isEmpty()) {
                    logger.debug("Replica {} already in all replicas", (Object)replica);
                } else {
                    logger.debug("Replica {} will be responsibility of {}", (Object)replica, (Object)StringUtils.join((Iterable)newReplicaEndpoints, (String)", "));
                }
            }
            changedRanges.putAll(replica, newReplicaEndpoints, ReplicaCollection.Builder.Conflict.NONE);
        }
        return changedRanges.build();
    }

    @Override
    public void onJoin(InetAddressAndPort endpoint, EndpointState epState) {
        ApplicationState statusState = ApplicationState.STATUS_WITH_PORT;
        VersionedValue statusValue = epState.getApplicationState(statusState);
        if (statusValue == null) {
            statusState = ApplicationState.STATUS;
            statusValue = epState.getApplicationState(statusState);
        }
        if (statusValue != null) {
            Gossiper.instance.doOnChangeNotifications(endpoint, statusState, statusValue);
        }
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.states()) {
            if (entry.getKey() == ApplicationState.STATUS_WITH_PORT || entry.getKey() == ApplicationState.STATUS) continue;
            Gossiper.instance.doOnChangeNotifications(endpoint, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onAlive(InetAddressAndPort endpoint, EndpointState state) {
        if (this.tokenMetadata.isMember(endpoint)) {
            this.notifyUp(endpoint);
        }
    }

    @Override
    public void onRemove(InetAddressAndPort endpoint) {
        this.tokenMetadata.removeEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    @Override
    public void onDead(InetAddressAndPort endpoint, EndpointState state) {
        MessagingService.instance().interruptOutbound(endpoint);
        this.notifyDown(endpoint);
    }

    @Override
    public void onRestart(InetAddressAndPort endpoint, EndpointState state) {
        VersionedValue netVersion;
        if (state.isAlive()) {
            this.onDead(endpoint, state);
        }
        if ((netVersion = state.getApplicationState(ApplicationState.NET_VERSION)) != null) {
            this.updateNetVersion(endpoint, netVersion);
        }
    }

    @Override
    public String getLoadString() {
        return FileUtils.stringifyFileSize(StorageMetrics.load.getCount());
    }

    @Override
    public Map<String, String> getLoadMapWithPort() {
        return this.getLoadMap(true);
    }

    @Override
    public Map<String, String> getLoadMap() {
        return this.getLoadMap(false);
    }

    private Map<String, String> getLoadMap(boolean withPort) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<InetAddressAndPort, Double> entry : LoadBroadcaster.instance.getLoadInfo().entrySet()) {
            map.put(entry.getKey().getHostAddress(withPort), FileUtils.stringifyFileSize(entry.getValue()));
        }
        map.put(FBUtilities.getBroadcastAddressAndPort().getHostAddress(withPort), this.getLoadString());
        return map;
    }

    @Override
    public final void deliverHints(String host) {
        throw new UnsupportedOperationException();
    }

    public Collection<Token> getLocalTokens() {
        Collection<Token> tokens = SystemKeyspace.getSavedTokens();
        assert (tokens != null && !tokens.isEmpty());
        return tokens;
    }

    @Nullable
    public InetAddressAndPort getEndpointForHostId(UUID hostId) {
        return this.tokenMetadata.getEndpointForHostId(hostId);
    }

    @Nullable
    public UUID getHostIdForEndpoint(InetAddressAndPort address) {
        return this.tokenMetadata.getHostId(address);
    }

    @Override
    public List<String> getTokens() {
        return this.getTokens(FBUtilities.getBroadcastAddressAndPort());
    }

    @Override
    public List<String> getTokens(String endpoint) throws UnknownHostException {
        return this.getTokens(InetAddressAndPort.getByName(endpoint));
    }

    private List<String> getTokens(InetAddressAndPort endpoint) {
        ArrayList<String> strTokens = new ArrayList<String>();
        for (Token tok : this.getTokenMetadata().getTokens(endpoint)) {
            strTokens.add(tok.toString());
        }
        return strTokens;
    }

    @Override
    public String getReleaseVersion() {
        return FBUtilities.getReleaseVersionString();
    }

    @Override
    public String getSchemaVersion() {
        return Schema.instance.getVersion().toString();
    }

    @Override
    public String getKeyspaceReplicationInfo(String keyspaceName) {
        Keyspace keyspaceInstance = Schema.instance.getKeyspaceInstance(keyspaceName);
        if (keyspaceInstance == null) {
            throw new IllegalArgumentException();
        }
        ReplicationParams replicationParams = keyspaceInstance.getMetadata().params.replication;
        String replicationInfo = replicationParams.klass.getSimpleName() + " " + replicationParams.options.toString();
        return replicationInfo;
    }

    @Override
    @Deprecated
    public List<String> getLeavingNodes() {
        return this.stringify(this.tokenMetadata.getLeavingEndpoints(), false);
    }

    @Override
    public List<String> getLeavingNodesWithPort() {
        return this.stringify(this.tokenMetadata.getLeavingEndpoints(), true);
    }

    @Override
    @Deprecated
    public List<String> getMovingNodes() {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Pair<Token, InetAddressAndPort> node : this.tokenMetadata.getMovingEndpoints()) {
            endpoints.add(((InetAddressAndPort)node.right).getAddress().getHostAddress());
        }
        return endpoints;
    }

    @Override
    public List<String> getMovingNodesWithPort() {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Pair<Token, InetAddressAndPort> node : this.tokenMetadata.getMovingEndpoints()) {
            endpoints.add(((InetAddressAndPort)node.right).getHostAddressAndPort());
        }
        return endpoints;
    }

    @Override
    @Deprecated
    public List<String> getJoiningNodes() {
        return this.stringify(this.tokenMetadata.getBootstrapTokens().valueSet(), false);
    }

    @Override
    public List<String> getJoiningNodesWithPort() {
        return this.stringify(this.tokenMetadata.getBootstrapTokens().valueSet(), true);
    }

    @Override
    @Deprecated
    public List<String> getLiveNodes() {
        return this.stringify(Gossiper.instance.getLiveMembers(), false);
    }

    @Override
    public List<String> getLiveNodesWithPort() {
        return this.stringify(Gossiper.instance.getLiveMembers(), true);
    }

    public Set<InetAddressAndPort> getLiveRingMembers() {
        return this.getLiveRingMembers(false);
    }

    public Set<InetAddressAndPort> getLiveRingMembers(boolean excludeDeadStates) {
        HashSet<InetAddressAndPort> ret = new HashSet<InetAddressAndPort>();
        for (InetAddressAndPort ep : Gossiper.instance.getLiveMembers()) {
            EndpointState epState;
            if (excludeDeadStates && ((epState = Gossiper.instance.getEndpointStateForEndpoint(ep)) == null || Gossiper.instance.isDeadState(epState)) || !this.tokenMetadata.isMember(ep)) continue;
            ret.add(ep);
        }
        return ret;
    }

    @Override
    @Deprecated
    public List<String> getUnreachableNodes() {
        return this.stringify(Gossiper.instance.getUnreachableMembers(), false);
    }

    @Override
    public List<String> getUnreachableNodesWithPort() {
        return this.stringify(Gossiper.instance.getUnreachableMembers(), true);
    }

    @Override
    public String[] getAllDataFileLocations() {
        return this.getCanonicalPaths(DatabaseDescriptor.getAllDataFileLocations());
    }

    private String[] getCanonicalPaths(String[] paths) {
        String[] locations = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            locations[i] = FileUtils.getCanonicalPath(paths[i]);
        }
        return locations;
    }

    @Override
    public String[] getLocalSystemKeyspacesDataFileLocations() {
        return this.getCanonicalPaths(DatabaseDescriptor.getLocalSystemKeyspacesDataFileLocations());
    }

    @Override
    public String[] getNonLocalSystemKeyspacesDataFileLocations() {
        return this.getCanonicalPaths(DatabaseDescriptor.getNonLocalSystemKeyspacesDataFileLocations());
    }

    @Override
    public String getCommitLogLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getCommitLogLocation());
    }

    @Override
    public String getSavedCachesLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getSavedCachesLocation());
    }

    private List<String> stringify(Iterable<InetAddressAndPort> endpoints, boolean withPort) {
        ArrayList<String> stringEndpoints = new ArrayList<String>();
        for (InetAddressAndPort ep : endpoints) {
            stringEndpoints.add(ep.getHostAddress(withPort));
        }
        return stringEndpoints;
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance.getCurrentGenerationNumber(FBUtilities.getBroadcastAddressAndPort());
    }

    @Override
    public int forceKeyspaceCleanup(String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.forceKeyspaceCleanup(0, keyspaceName, tables);
    }

    @Override
    public int forceKeyspaceCleanup(int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        if (SchemaConstants.isLocalSystemKeyspace(keyspaceName)) {
            throw new RuntimeException("Cleanup of the system keyspace is neither necessary nor wise");
        }
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, tables)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.forceCleanup(jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, true, 0, keyspaceName, tables);
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, checkData, 0, keyspaceName, tables);
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, checkData, false, jobs, keyspaceName, tables);
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tables)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.scrub(disableSnapshot, skipCorrupted, reinsertOverflowedTTL, checkData, jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    @Deprecated
    public int verify(boolean extendedVerify, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.verify(extendedVerify, false, false, false, false, false, keyspaceName, tableNames);
    }

    @Override
    public int verify(boolean extendedVerify, boolean checkVersion, boolean diskFailurePolicy, boolean mutateRepairStatus, boolean checkOwnsTokens, boolean quick, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        Verifier.Options options = Verifier.options().invokeDiskFailurePolicy(diskFailurePolicy).extendedVerification(extendedVerify).checkVersion(checkVersion).mutateRepairStatus(mutateRepairStatus).checkOwnsTokens(checkOwnsTokens).quick(quick).build();
        logger.info("Verifying {}.{} with options = {}", new Object[]{keyspaceName, Arrays.toString(tableNames), options});
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, tableNames)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.verify(options);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public int upgradeSSTables(String keyspaceName, boolean excludeCurrentVersion, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.upgradeSSTables(keyspaceName, excludeCurrentVersion, 0, tableNames);
    }

    @Override
    public int upgradeSSTables(String keyspaceName, boolean skipIfCurrentVersion, long skipIfNewerThanTimestamp, int jobs, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.rewriteSSTables(keyspaceName, skipIfCurrentVersion, skipIfNewerThanTimestamp, false, jobs, tableNames);
    }

    @Override
    public int recompressSSTables(String keyspaceName, int jobs, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.rewriteSSTables(keyspaceName, false, Long.MAX_VALUE, true, jobs, tableNames);
    }

    public int rewriteSSTables(String keyspaceName, boolean skipIfCurrentVersion, long skipIfNewerThanTimestamp, boolean skipIfCompressionMatches, int jobs, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, true, keyspaceName, tableNames)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.sstablesRewrite(skipIfCurrentVersion, skipIfNewerThanTimestamp, skipIfCompressionMatches, jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    public List<Pair<String, String>> getPreparedStatements() {
        ArrayList<Pair<String, String>> statements = new ArrayList<Pair<String, String>>();
        for (Map.Entry<MD5Digest, QueryHandler.Prepared> e : QueryProcessor.instance.getPreparedStatements().entrySet()) {
            statements.add(Pair.create(e.getKey().toString(), e.getValue().rawCQLStatement));
        }
        return statements;
    }

    public void dropPreparedStatements(boolean memoryOnly) {
        QueryProcessor.clearPreparedStatements(memoryOnly);
    }

    @Override
    public void forceKeyspaceCompaction(boolean splitOutput, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            cfStore.forceMajorCompaction(splitOutput);
        }
    }

    @Override
    public int relocateSSTables(String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        return this.relocateSSTables(0, keyspaceName, columnFamilies);
    }

    @Override
    public int relocateSSTables(int jobs, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(false, false, keyspaceName, columnFamilies)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfs.relocateSSTables(jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public int garbageCollect(String tombstoneOptionString, int jobs, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        CompactionParams.TombstoneOption tombstoneOption = CompactionParams.TombstoneOption.valueOf(tombstoneOptionString);
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(false, false, keyspaceName, columnFamilies)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfs.garbageCollect(tombstoneOption, jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public void takeSnapshot(String tag, Map<String, String> options, String ... entities) throws IOException {
        DurationSpec.IntSecondsBound ttl;
        DurationSpec.IntSecondsBound intSecondsBound = ttl = options.containsKey("ttl") ? new DurationSpec.IntSecondsBound(options.get("ttl")) : null;
        if (ttl != null) {
            int minAllowedTtlSecs = CassandraRelevantProperties.SNAPSHOT_MIN_ALLOWED_TTL_SECONDS.getInt();
            if (ttl.toSeconds() < minAllowedTtlSecs) {
                throw new IllegalArgumentException(String.format("ttl for snapshot must be at least %d seconds", minAllowedTtlSecs));
            }
        }
        boolean skipFlush = Boolean.parseBoolean(options.getOrDefault("skipFlush", "false"));
        if (entities != null && entities.length > 0 && entities[0].contains(".")) {
            this.takeMultipleTableSnapshot(tag, skipFlush, ttl, entities);
        } else {
            this.takeSnapshot(tag, skipFlush, ttl, entities);
        }
    }

    @Override
    public void takeTableSnapshot(String keyspaceName, String tableName, String tag) throws IOException {
        this.takeMultipleTableSnapshot(tag, false, null, keyspaceName + "." + tableName);
    }

    @Override
    public void forceKeyspaceCompactionForTokenRange(String keyspaceName, String startToken, String endToken, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        Collection<Range<Token>> tokenRanges = this.createRepairRangeFrom(startToken, endToken);
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            cfStore.forceCompactionForTokenRange(tokenRanges);
        }
    }

    @Override
    public void forceKeyspaceCompactionForPartitionKey(String keyspaceName, String partitionKey, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            try {
                this.getKeyFromPartition(keyspaceName, cfStore.name, partitionKey);
            }
            catch (Exception e) {
                IllegalArgumentException exception = new IllegalArgumentException(String.format("Unable to parse partition key '%s' for table %s; %s", partitionKey, cfStore.metadata, e.getMessage()));
                exception.setStackTrace(e.getStackTrace());
                throw exception;
            }
        }
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            cfStore.forceCompactionForKey(this.getKeyFromPartition(keyspaceName, cfStore.name, partitionKey));
        }
    }

    @Override
    public void takeSnapshot(String tag, String ... keyspaceNames) throws IOException {
        this.takeSnapshot(tag, false, null, keyspaceNames);
    }

    @Override
    public void takeMultipleTableSnapshot(String tag, String ... tableList) throws IOException {
        this.takeMultipleTableSnapshot(tag, false, null, tableList);
    }

    private void takeSnapshot(String tag, boolean skipFlush, DurationSpec.IntSecondsBound ttl, String ... keyspaceNames) throws IOException {
        Object t;
        Object keyspaces;
        if (this.operationMode == Mode.JOINING) {
            throw new IOException("Cannot snapshot until bootstrap completes");
        }
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        if (keyspaceNames.length == 0) {
            keyspaces = Keyspace.all();
        } else {
            t = new ArrayList(keyspaceNames.length);
            for (String keyspaceName : keyspaceNames) {
                ((ArrayList)t).add(this.getValidKeyspace(keyspaceName));
            }
            keyspaces = t;
        }
        t = keyspaces.iterator();
        while (t.hasNext()) {
            Keyspace keyspace = (Keyspace)t.next();
            if (!keyspace.snapshotExists(tag)) continue;
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        RateLimiter snapshotRateLimiter = DatabaseDescriptor.getSnapshotRateLimiter();
        Instant creationTime = FBUtilities.now();
        Iterator<Keyspace> iterator = keyspaces.iterator();
        while (iterator.hasNext()) {
            Keyspace keyspace = iterator.next();
            keyspace.snapshot(tag, null, skipFlush, ttl, snapshotRateLimiter, creationTime);
        }
    }

    private void takeMultipleTableSnapshot(String tag, boolean skipFlush, DurationSpec.IntSecondsBound ttl, String ... tableList) throws IOException {
        HashMap keyspaceColumnfamily = new HashMap();
        for (String table : tableList) {
            Keyspace keyspace;
            String tableName;
            String[] splittedString = StringUtils.split((String)table, (char)'.');
            if (splittedString.length == 2) {
                String keyspaceName = splittedString[0];
                tableName = splittedString[1];
                if (keyspaceName == null) {
                    throw new IOException("You must supply a keyspace name");
                }
                if (this.operationMode.equals((Object)Mode.JOINING)) {
                    throw new IOException("Cannot snapshot until bootstrap completes");
                }
                if (tableName == null) {
                    throw new IOException("You must supply a table name");
                }
                if (tag == null || tag.equals("")) {
                    throw new IOException("You must supply a snapshot name.");
                }
                keyspace = this.getValidKeyspace(keyspaceName);
                ColumnFamilyStore columnFamilyStore = keyspace.getColumnFamilyStore(tableName);
                if (columnFamilyStore.snapshotExists(tag)) {
                    throw new IOException("Snapshot " + tag + " already exists.");
                }
                if (!keyspaceColumnfamily.containsKey(keyspace)) {
                    keyspaceColumnfamily.put(keyspace, new ArrayList());
                }
            } else {
                throw new IllegalArgumentException("Cannot take a snapshot on secondary index or invalid column family name. You must supply a column family name in the form of keyspace.columnfamily");
            }
            ((List)keyspaceColumnfamily.get(keyspace)).add(tableName);
        }
        RateLimiter snapshotRateLimiter = DatabaseDescriptor.getSnapshotRateLimiter();
        Instant creationTime = FBUtilities.now();
        for (Map.Entry entry : keyspaceColumnfamily.entrySet()) {
            for (String table : (List)entry.getValue()) {
                ((Keyspace)entry.getKey()).snapshot(tag, table, skipFlush, ttl, snapshotRateLimiter, creationTime);
            }
        }
    }

    private void verifyKeyspaceIsValid(String keyspaceName) {
        if (null != VirtualKeyspaceRegistry.instance.getKeyspaceNullable(keyspaceName)) {
            throw new IllegalArgumentException("Cannot perform any operations against virtual keyspace " + keyspaceName);
        }
        if (!Schema.instance.getKeyspaces().contains((Object)keyspaceName)) {
            throw new IllegalArgumentException("Keyspace " + keyspaceName + " does not exist");
        }
    }

    private Keyspace getValidKeyspace(String keyspaceName) {
        this.verifyKeyspaceIsValid(keyspaceName);
        return Keyspace.open(keyspaceName);
    }

    @Override
    public void clearSnapshot(String tag, String ... keyspaceNames) throws IOException {
        if (tag == null) {
            tag = "";
        }
        HashSet<String> keyspaces = new HashSet<String>();
        for (String dataDir : DatabaseDescriptor.getAllDataFileLocations()) {
            for (String keyspaceDir : new File(dataDir).tryListNames()) {
                if (keyspaceNames.length > 0 && !Arrays.asList(keyspaceNames).contains(keyspaceDir)) continue;
                keyspaces.add(keyspaceDir);
            }
        }
        for (String keyspace : keyspaces) {
            Keyspace.clearSnapshot(tag, keyspace);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cleared out snapshot directories");
        }
    }

    @Override
    public Map<String, TabularData> getSnapshotDetails(Map<String, String> options) {
        boolean skipExpiring = options != null && Boolean.parseBoolean(options.getOrDefault("no_ttl", "false"));
        SnapshotLoader loader = new SnapshotLoader();
        HashMap<String, TabularData> snapshotMap = new HashMap<String, TabularData>();
        for (TableSnapshot snapshot : loader.loadSnapshots()) {
            if (skipExpiring && snapshot.isExpiring()) continue;
            TabularDataSupport data = (TabularDataSupport)snapshotMap.get(snapshot.getTag());
            if (data == null) {
                data = new TabularDataSupport(SnapshotDetailsTabularData.TABULAR_TYPE);
                snapshotMap.put(snapshot.getTag(), data);
            }
            SnapshotDetailsTabularData.from(snapshot, data);
        }
        return snapshotMap;
    }

    @Override
    @Deprecated
    public Map<String, TabularData> getSnapshotDetails() {
        return this.getSnapshotDetails((Map<String, String>)ImmutableMap.of());
    }

    @Override
    public long trueSnapshotsSize() {
        long total = 0L;
        for (Keyspace keyspace : Keyspace.all()) {
            if (SchemaConstants.isLocalSystemKeyspace(keyspace.getName())) continue;
            for (ColumnFamilyStore cfStore : keyspace.getColumnFamilyStores()) {
                total += cfStore.trueSnapshotsSize();
            }
        }
        return total;
    }

    @Override
    public void setSnapshotLinksPerSecond(long throttle) {
        logger.info("Setting snapshot throttle to {}", (Object)throttle);
        DatabaseDescriptor.setSnapshotLinksPerSecond(throttle);
    }

    @Override
    public long getSnapshotLinksPerSecond() {
        return DatabaseDescriptor.getSnapshotLinksPerSecond();
    }

    @Override
    public void refreshSizeEstimates() throws ExecutionException {
        this.cleanupSizeEstimates();
        FBUtilities.waitOnFuture(ScheduledExecutors.optionalTasks.submit(SizeEstimatesRecorder.instance));
    }

    @Override
    public void cleanupSizeEstimates() {
        SystemKeyspace.clearAllEstimates();
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(boolean allowIndexes, boolean autoAddIndexes, String keyspaceName, String ... cfNames) throws IOException {
        Keyspace keyspace = this.getValidKeyspace(keyspaceName);
        return keyspace.getValidColumnFamilies(allowIndexes, autoAddIndexes, cfNames);
    }

    @Override
    public void forceKeyspaceFlush(String keyspaceName, String ... tableNames) throws IOException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            logger.debug("Forcing flush on keyspace {}, CF {}", (Object)keyspaceName, (Object)cfStore.name);
            cfStore.forceBlockingFlush(ColumnFamilyStore.FlushReason.USER_FORCED);
        }
    }

    public void forceKeyspaceFlush(String keyspaceName, ColumnFamilyStore.FlushReason reason) throws IOException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, new String[0])) {
            logger.debug("Forcing flush on keyspace {}, CF {}", (Object)keyspaceName, (Object)cfStore.name);
            cfStore.forceBlockingFlush(reason);
        }
    }

    @Override
    public int repairAsync(String keyspace, Map<String, String> repairSpec) {
        return (Integer)this.repair((String)keyspace, repairSpec, Collections.emptyList()).left;
    }

    public Pair<Integer, Future<?>> repair(String keyspace, Map<String, String> repairSpec, List<ProgressListener> listeners) {
        RepairOption option = RepairOption.parse(repairSpec, this.tokenMetadata.partitioner);
        return this.repair(keyspace, option, listeners);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<Integer, Future<?>> repair(String keyspace, RepairOption option, List<ProgressListener> listeners) {
        if (option.getRanges().isEmpty()) {
            if (option.isPrimaryRange()) {
                if (option.getDataCenters().isEmpty() && option.getHosts().isEmpty()) {
                    option.getRanges().addAll(this.getPrimaryRanges(keyspace));
                } else {
                    if (!option.isInLocalDCOnly()) throw new IllegalArgumentException("You need to run primary range repair on all nodes in the cluster.");
                    option.getRanges().addAll(this.getPrimaryRangesWithinDC(keyspace));
                }
            } else {
                Iterables.addAll(option.getRanges(), this.getLocalReplicas(keyspace).onlyFull().ranges());
            }
        }
        if (option.getRanges().isEmpty() || Keyspace.open((String)keyspace).getReplicationStrategy().getReplicationFactor().allReplicas < 2) {
            return Pair.create(0, ImmediateFuture.success(null));
        }
        int cmd = nextRepairCommand.incrementAndGet();
        return Pair.create(cmd, ActiveRepairService.repairCommandExecutor().submit(this.createRepairTask(cmd, keyspace, option, listeners)));
    }

    @VisibleForTesting
    Collection<Range<Token>> createRepairRangeFrom(String beginToken, String endToken) {
        Token parsedBeginToken = this.getTokenFactory().fromString(beginToken);
        Token parsedEndToken = this.getTokenFactory().fromString(endToken);
        ArrayList<Range<Token>> repairingRange = new ArrayList<Range<Token>>();
        ArrayList<Token> tokens = new ArrayList<Token>(this.tokenMetadata.sortedTokens());
        if (!tokens.contains(parsedBeginToken)) {
            tokens.add(parsedBeginToken);
        }
        if (!tokens.contains(parsedEndToken)) {
            tokens.add(parsedEndToken);
        }
        Collections.sort(tokens);
        int start = tokens.indexOf(parsedBeginToken);
        int end = tokens.indexOf(parsedEndToken);
        int i = start;
        while (i != end) {
            Range<RingPosition> range = new Range<RingPosition>(tokens.get(i), tokens.get((i + 1) % tokens.size()));
            repairingRange.add(range);
            i = (i + 1) % tokens.size();
        }
        return repairingRange;
    }

    public Token.TokenFactory getTokenFactory() {
        return this.tokenMetadata.partitioner.getTokenFactory();
    }

    private FutureTask<Object> createRepairTask(int cmd, String keyspace, RepairOption options, List<ProgressListener> listeners) {
        ArrayList<String> datacenters;
        if (!options.getDataCenters().isEmpty() && !options.getDataCenters().contains(DatabaseDescriptor.getLocalDataCenter())) {
            throw new IllegalArgumentException("the local data center must be part of the repair");
        }
        Set existingDatacenters = this.tokenMetadata.cloneOnlyTokenMap().getTopology().getDatacenterEndpoints().keys().elementSet();
        if (!existingDatacenters.containsAll(datacenters = new ArrayList<String>(options.getDataCenters()))) {
            datacenters.removeAll(existingDatacenters);
            throw new IllegalArgumentException("data center(s) " + ((Object)datacenters).toString() + " not found");
        }
        RepairRunnable task = new RepairRunnable(this, cmd, options, keyspace);
        task.addProgressListener(this.progressSupport);
        for (ProgressListener listener : listeners) {
            task.addProgressListener(listener);
        }
        if (options.isTraced()) {
            return new FutureTaskWithResources<Object>(() -> ExecutorLocals::clear, task);
        }
        return new FutureTask<Object>(task);
    }

    private void tryRepairPaxosForTopologyChange(String reason) {
        try {
            this.startRepairPaxosForTopologyChange(reason).get();
        }
        catch (InterruptedException e) {
            logger.error("Error during paxos repair", (Throwable)e);
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            logger.error("Error during paxos repair", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void repairPaxosForTopologyChange(String reason) {
        if (this.getSkipPaxosRepairOnTopologyChange() || !Paxos.useV2()) {
            logger.info("skipping paxos repair for {}. skip_paxos_repair_on_topology_change is set, or v2 paxos variant is not being used", (Object)reason);
            return;
        }
        logger.info("repairing paxos for {}", (Object)reason);
        int retries = 0;
        int maxRetries = Integer.getInteger("cassandra.paxos_repair_on_topology_change_retries", 10);
        int delaySec = Integer.getInteger("cassandra.paxos_repair_on_topology_change_retry_delay_seconds", 10);
        boolean completed = false;
        while (!completed) {
            try {
                this.tryRepairPaxosForTopologyChange(reason);
                completed = true;
            }
            catch (Exception e) {
                if (retries >= maxRetries) {
                    throw e;
                }
                int sleep = delaySec * ++retries;
                logger.info("Sleeping {} seconds before retrying paxos repair...", (Object)sleep);
                Uninterruptibles.sleepUninterruptibly((long)sleep, (TimeUnit)TimeUnit.SECONDS);
                logger.info("Retrying paxos repair for {}. Retry {}/{}", new Object[]{reason, retries, maxRetries});
            }
        }
        logger.info("paxos repair for {} complete", (Object)reason);
    }

    @VisibleForTesting
    public Future<?> startRepairPaxosForTopologyChange(String reason) {
        logger.info("repairing paxos for {}", (Object)reason);
        ArrayList futures = new ArrayList();
        Keyspaces keyspaces = Schema.instance.getNonLocalStrategyKeyspaces();
        for (String ksName : keyspaces.names()) {
            if (SchemaConstants.REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(ksName) || DatabaseDescriptor.skipPaxosRepairOnTopologyChangeKeyspaces().contains(ksName)) continue;
            List<Range<Token>> ranges = this.getLocalAndPendingRanges(ksName);
            futures.add(ActiveRepairService.instance.repairPaxosForTopologyChange(ksName, ranges, reason));
        }
        return FutureCombiner.allOf(futures);
    }

    public Future<?> autoRepairPaxos(TableId tableId) {
        TableMetadata table = Schema.instance.getTableMetadata(tableId);
        if (table == null) {
            return ImmediateFuture.success(null);
        }
        List<Range<Token>> ranges = this.getLocalAndPendingRanges(table.keyspace);
        PaxosCleanupLocalCoordinator coordinator = PaxosCleanupLocalCoordinator.createForAutoRepair(tableId, ranges);
        ScheduledExecutors.optionalTasks.submit(coordinator::start);
        return coordinator;
    }

    @Override
    public void forceTerminateAllRepairSessions() {
        ActiveRepairService.instance.terminateSessions();
    }

    @Override
    @Nullable
    public List<String> getParentRepairStatus(int cmd) {
        Pair<ActiveRepairService.ParentRepairStatus, List<String>> pair = ActiveRepairService.instance.getRepairStatus(cmd);
        return pair == null ? null : ImmutableList.builder().add((Object)((ActiveRepairService.ParentRepairStatus)((Object)pair.left)).name()).addAll((Iterable)pair.right).build();
    }

    @Override
    public void setRepairSessionMaxTreeDepth(int depth) {
        DatabaseDescriptor.setRepairSessionMaxTreeDepth(depth);
    }

    @Override
    public int getRepairSessionMaxTreeDepth() {
        return DatabaseDescriptor.getRepairSessionMaxTreeDepth();
    }

    public Collection<Range<Token>> getPrimaryRangesForEndpoint(String keyspace, InetAddressAndPort ep) {
        AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
        HashSet<Range<Token>> primaryRanges = new HashSet<Range<Token>>();
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        for (Token token : metadata.sortedTokens()) {
            EndpointsForRange replicas = strategy.calculateNaturalReplicas(token, metadata);
            if (replicas.size() <= 0 || !replicas.get(0).endpoint().equals(ep)) continue;
            Preconditions.checkState((boolean)replicas.get(0).isFull());
            primaryRanges.add(new Range<Token>(metadata.getPredecessor(token), token));
        }
        return primaryRanges;
    }

    public Collection<Range<Token>> getPrimaryRangeForEndpointWithinDC(String keyspace, InetAddressAndPort referenceEndpoint) {
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        String localDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(referenceEndpoint);
        Collection localDcNodes = metadata.getTopology().getDatacenterEndpoints().get((Object)localDC);
        AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
        HashSet<Range<Token>> localDCPrimaryRanges = new HashSet<Range<Token>>();
        block0: for (Token token : metadata.sortedTokens()) {
            EndpointsForRange replicas = strategy.calculateNaturalReplicas(token, metadata);
            for (Replica replica : replicas) {
                if (!localDcNodes.contains(replica.endpoint())) continue;
                if (!replica.endpoint().equals(referenceEndpoint)) continue block0;
                localDCPrimaryRanges.add(new Range<Token>(metadata.getPredecessor(token), token));
                continue block0;
            }
        }
        return localDCPrimaryRanges;
    }

    public Collection<Range<Token>> getLocalPrimaryRange() {
        return this.getLocalPrimaryRangeForEndpoint(FBUtilities.getBroadcastAddressAndPort());
    }

    public Collection<Range<Token>> getLocalPrimaryRangeForEndpoint(InetAddressAndPort referenceEndpoint) {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        TokenMetadata tokenMetadata = this.tokenMetadata.cloneOnlyTokenMap();
        if (!tokenMetadata.isMember(referenceEndpoint)) {
            return Collections.emptySet();
        }
        String dc = snitch.getDatacenter(referenceEndpoint);
        HashSet<Token> tokens = new HashSet<Token>(tokenMetadata.getTokens(referenceEndpoint));
        ArrayList filteredTokens = Lists.newArrayList();
        for (Token token : tokenMetadata.sortedTokens()) {
            InetAddressAndPort endpoint = tokenMetadata.getEndpoint(token);
            if (!dc.equals(snitch.getDatacenter(endpoint))) continue;
            filteredTokens.add(token);
        }
        return this.getAllRanges(filteredTokens).stream().filter(t -> tokens.contains(t.right)).collect(Collectors.toList());
    }

    public List<Range<Token>> getAllRanges(List<Token> sortedTokens) {
        if (logger.isTraceEnabled()) {
            logger.trace("computing ranges for {}", (Object)StringUtils.join(sortedTokens, (String)", "));
        }
        if (sortedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        int size = sortedTokens.size();
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(size + 1);
        for (int i = 1; i < size; ++i) {
            Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(i - 1), sortedTokens.get(i));
            ranges.add(range);
        }
        Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(size - 1), sortedTokens.get(0));
        ranges.add(range);
        return ranges;
    }

    @Override
    @Deprecated
    public List<InetAddress> getNaturalEndpoints(String keyspaceName, String cf, String key) {
        EndpointsForToken replicas = this.getNaturalReplicasForToken(keyspaceName, cf, key);
        ArrayList<InetAddress> inetList = new ArrayList<InetAddress>(replicas.size());
        replicas.forEach((Consumer<? super Replica>)((Consumer<Replica>)r -> inetList.add(r.endpoint().getAddress())));
        return inetList;
    }

    @Override
    public List<String> getNaturalEndpointsWithPort(String keyspaceName, String cf, String key) {
        return Replicas.stringify(this.getNaturalReplicasForToken(keyspaceName, cf, key), true);
    }

    @Override
    @Deprecated
    public List<InetAddress> getNaturalEndpoints(String keyspaceName, ByteBuffer key) {
        EndpointsForToken replicas = this.getNaturalReplicasForToken(keyspaceName, key);
        ArrayList<InetAddress> inetList = new ArrayList<InetAddress>(replicas.size());
        replicas.forEach((Consumer<? super Replica>)((Consumer<Replica>)r -> inetList.add(r.endpoint().getAddress())));
        return inetList;
    }

    @Override
    public List<String> getNaturalEndpointsWithPort(String keyspaceName, ByteBuffer key) {
        EndpointsForToken replicas = this.getNaturalReplicasForToken(keyspaceName, key);
        return Replicas.stringify(replicas, true);
    }

    public EndpointsForToken getNaturalReplicasForToken(String keyspaceName, String cf, String key) {
        return this.getNaturalReplicasForToken(keyspaceName, StorageService.partitionKeyToBytes(keyspaceName, cf, key));
    }

    public EndpointsForToken getNaturalReplicasForToken(String keyspaceName, ByteBuffer key) {
        Token token = this.tokenMetadata.partitioner.getToken(key);
        return Keyspace.open(keyspaceName).getReplicationStrategy().getNaturalReplicasForToken(token);
    }

    public DecoratedKey getKeyFromPartition(String keyspaceName, String table, String partitionKey) {
        return this.tokenMetadata.partitioner.decorateKey(StorageService.partitionKeyToBytes(keyspaceName, table, partitionKey));
    }

    private static ByteBuffer partitionKeyToBytes(String keyspaceName, String cf, String key) {
        KeyspaceMetadata ksMetaData = Schema.instance.getKeyspaceMetadata(keyspaceName);
        if (ksMetaData == null) {
            throw new IllegalArgumentException("Unknown keyspace '" + keyspaceName + "'");
        }
        TableMetadata metadata = ksMetaData.getTableOrViewNullable(cf);
        if (metadata == null) {
            throw new IllegalArgumentException("Unknown table '" + cf + "' in keyspace '" + keyspaceName + "'");
        }
        return metadata.partitionKeyType.fromString(key);
    }

    @Override
    public String getToken(String keyspaceName, String table, String key) {
        return this.tokenMetadata.partitioner.getToken(StorageService.partitionKeyToBytes(keyspaceName, table, key)).toString();
    }

    @Override
    public void setLoggingLevel(String classQualifier, String rawLevel) throws Exception {
        LoggingSupportFactory.getLoggingSupport().setLoggingLevel(classQualifier, rawLevel);
    }

    @Override
    public Map<String, String> getLoggingLevels() {
        return LoggingSupportFactory.getLoggingSupport().getLoggingLevels();
    }

    public List<Pair<Range<Token>, Long>> getSplits(String keyspaceName, String cfName, Range<Token> range, int keysPerSplit) {
        Keyspace t = Keyspace.open(keyspaceName);
        ColumnFamilyStore cfs = t.getColumnFamilyStore(cfName);
        List<DecoratedKey> keys = this.keySamples(Collections.singleton(cfs), range);
        long totalRowCountEstimate = cfs.estimatedKeysForRange(range);
        int minSamplesPerSplit = 4;
        int maxSplitCount = keys.size() / minSamplesPerSplit + 1;
        int splitCount = Math.max(1, Math.min(maxSplitCount, (int)(totalRowCountEstimate / (long)keysPerSplit)));
        List<Token> tokens = this.keysToTokens(range, keys);
        return this.getSplits(tokens, splitCount, cfs);
    }

    private List<Pair<Range<Token>, Long>> getSplits(List<Token> tokens, int splitCount, ColumnFamilyStore cfs) {
        double step = (double)(tokens.size() - 1) / (double)splitCount;
        Token prevToken = tokens.get(0);
        ArrayList splits = Lists.newArrayListWithExpectedSize((int)splitCount);
        for (int i = 1; i <= splitCount; ++i) {
            int index = (int)Math.round((double)i * step);
            Token token = tokens.get(index);
            Range<Token> range = new Range<Token>(prevToken, token);
            splits.add(Pair.create(range, Math.max((long)cfs.metadata().params.minIndexInterval, cfs.estimatedKeysForRange(range))));
            prevToken = token;
        }
        return splits;
    }

    private List<Token> keysToTokens(Range<Token> range, List<DecoratedKey> keys) {
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)(keys.size() + 2));
        tokens.add(range.left);
        for (DecoratedKey key : keys) {
            tokens.add(key.getToken());
        }
        tokens.add(range.right);
        return tokens;
    }

    private List<DecoratedKey> keySamples(Iterable<ColumnFamilyStore> cfses, Range<Token> range) {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : cfses) {
            Iterables.addAll(keys, cfs.keySamples(range));
        }
        FBUtilities.sortSampledKeys(keys, range);
        return keys;
    }

    private void startLeaving() {
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS_WITH_PORT, this.valueFactory.leaving(this.getLocalTokens()));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.leaving(this.getLocalTokens()));
        this.tokenMetadata.addLeavingEndpoint(FBUtilities.getBroadcastAddressAndPort());
        PendingRangeCalculatorService.instance.update();
    }

    @Override
    public void decommission(boolean force) throws InterruptedException {
        TokenMetadata metadata = this.tokenMetadata.cloneAfterAllLeft();
        if (this.operationMode != Mode.LEAVING) {
            if (!this.tokenMetadata.isMember(FBUtilities.getBroadcastAddressAndPort())) {
                throw new UnsupportedOperationException("local node is not a member of the token ring yet");
            }
            if (metadata.getAllEndpoints().size() < 2) {
                throw new UnsupportedOperationException("no other normal nodes in the ring; decommission would be pointless");
            }
            if (this.operationMode != Mode.NORMAL) {
                throw new UnsupportedOperationException("Node in " + (Object)((Object)this.operationMode) + " state; wait for status to become normal or restart");
            }
        }
        if (!this.isDecommissioning.compareAndSet(false, true)) {
            throw new IllegalStateException("Node is still decommissioning. Check nodetool netstats.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DECOMMISSIONING");
        }
        try {
            PendingRangeCalculatorService.instance.blockUntilFinished();
            String dc = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
            if (this.operationMode != Mode.LEAVING) {
                for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces().names()) {
                    if (!force) {
                        int numNodes;
                        int rf;
                        Keyspace keyspace = Keyspace.open(keyspaceName);
                        if (keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy) {
                            NetworkTopologyStrategy strategy = (NetworkTopologyStrategy)keyspace.getReplicationStrategy();
                            rf = strategy.getReplicationFactor((String)dc).allReplicas;
                            numNodes = metadata.getTopology().getDatacenterEndpoints().get((Object)dc).size();
                        } else {
                            numNodes = metadata.getAllEndpoints().size();
                            rf = keyspace.getReplicationStrategy().getReplicationFactor().allReplicas;
                        }
                        if (numNodes <= rf) {
                            throw new UnsupportedOperationException("Not enough live nodes to maintain replication factor in keyspace " + keyspaceName + " (RF = " + rf + ", N = " + numNodes + "). Perform a forceful decommission to ignore.");
                        }
                    }
                    if (this.tokenMetadata.getPendingRanges(keyspaceName, FBUtilities.getBroadcastAddressAndPort()).size() <= 0) continue;
                    throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
                }
            }
            this.startLeaving();
            long timeout = Math.max((long)RING_DELAY_MILLIS, BatchlogManager.instance.getBatchlogTimeout());
            this.setMode(Mode.LEAVING, "sleeping " + timeout + " ms for batch processing and pending range setup", true);
            Thread.sleep(timeout);
            Runnable finishLeaving = new Runnable(){

                @Override
                public void run() {
                    StorageService.this.shutdownClientServers();
                    Gossiper.instance.stop();
                    try {
                        MessagingService.instance().shutdown();
                    }
                    catch (IOError ioe) {
                        logger.info("failed to shutdown message service: {}", (Throwable)ioe);
                    }
                    Stage.shutdownNow();
                    SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.DECOMMISSIONED);
                    StorageService.this.setMode(Mode.DECOMMISSIONED, true);
                }
            };
            this.unbootstrap(finishLeaving);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (ExecutionException e) {
            logger.error("Error while decommissioning node ", e.getCause());
            throw new RuntimeException("Error while decommissioning node: " + e.getCause().getMessage());
        }
        finally {
            this.isDecommissioning.set(false);
        }
    }

    private void leaveRing() {
        SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.NEEDS_BOOTSTRAP);
        this.tokenMetadata.removeEndpoint(FBUtilities.getBroadcastAddressAndPort());
        PendingRangeCalculatorService.instance.update();
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS_WITH_PORT, this.valueFactory.left(this.getLocalTokens(), Gossiper.computeExpireTime()));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.left(this.getLocalTokens(), Gossiper.computeExpireTime()));
        int delay = Math.max(RING_DELAY_MILLIS, 2000);
        logger.info("Announcing that I have left the ring for {}ms", (Object)delay);
        Uninterruptibles.sleepUninterruptibly((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Supplier<Future<StreamState>> prepareUnbootstrapStreaming() {
        HashMap<String, EndpointsByReplica> rangesToStream = new HashMap<String, EndpointsByReplica>();
        for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces().names()) {
            EndpointsByReplica rangesMM = StorageService.getChangedReplicasForLeaving(keyspaceName, FBUtilities.getBroadcastAddressAndPort(), this.tokenMetadata, Keyspace.open(keyspaceName).getReplicationStrategy());
            if (logger.isDebugEnabled()) {
                logger.debug("Ranges needing transfer are [{}]", (Object)StringUtils.join(rangesMM.keySet(), (String)","));
            }
            rangesToStream.put(keyspaceName, rangesMM);
        }
        return () -> this.streamRanges(rangesToStream);
    }

    private void unbootstrap(Runnable onFinish) throws ExecutionException, InterruptedException {
        Supplier<Future<StreamState>> startStreaming = this.prepareUnbootstrapStreaming();
        this.setMode(Mode.LEAVING, "replaying batch log and streaming data to other nodes", true);
        this.repairPaxosForTopologyChange("decommission");
        Future<?> batchlogReplay = BatchlogManager.instance.startBatchlogReplay();
        Future<StreamState> streamSuccess = startStreaming.get();
        logger.debug("waiting for batch log processing.");
        batchlogReplay.get();
        this.setMode(Mode.LEAVING, "streaming hints to other nodes", true);
        Future hintsSuccess = this.streamHints();
        logger.debug("waiting for stream acks.");
        streamSuccess.get();
        hintsSuccess.get();
        logger.debug("stream acks all received.");
        this.leaveRing();
        onFinish.run();
    }

    private Future streamHints() {
        return HintsService.instance.transferHints(this::getPreferredHintsStreamTarget);
    }

    private static EndpointsForRange getStreamCandidates(Collection<InetAddressAndPort> endpoints) {
        endpoints = endpoints.stream().filter(endpoint -> FailureDetector.instance.isAlive((InetAddressAndPort)endpoint) && !FBUtilities.getBroadcastAddressAndPort().equals(endpoint)).collect(Collectors.toList());
        return SystemReplicas.getSystemReplicas(endpoints);
    }

    private UUID getPreferredHintsStreamTarget() {
        Set<InetAddressAndPort> endpoints = instance.getTokenMetadata().cloneAfterAllLeft().getAllEndpoints();
        EndpointsForRange candidates = StorageService.getStreamCandidates(endpoints);
        if (candidates.isEmpty()) {
            logger.warn("Unable to stream hints since no live endpoints seen");
            throw new RuntimeException("Unable to stream hints since no live endpoints seen");
        }
        candidates = DatabaseDescriptor.getEndpointSnitch().sortedByProximity(FBUtilities.getBroadcastAddressAndPort(), candidates);
        InetAddressAndPort hintsDestinationHost = candidates.get(0).endpoint();
        return this.tokenMetadata.getHostId(hintsDestinationHost);
    }

    @Override
    public void move(String newToken) throws IOException {
        try {
            this.getTokenFactory().validate(newToken);
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this.move(this.getTokenFactory().fromString(newToken));
    }

    private void move(Token newToken) throws IOException {
        if (newToken == null) {
            throw new IOException("Can't move to the undefined (null) token.");
        }
        if (this.tokenMetadata.sortedTokens().contains(newToken)) {
            throw new IOException("target token " + newToken + " is already owned by another node.");
        }
        InetAddressAndPort localAddress = FBUtilities.getBroadcastAddressAndPort();
        if (this.getTokenMetadata().getTokens(localAddress).size() > 1) {
            logger.error("Invalid request to move(Token); This node has more than one token and cannot be moved thusly.");
            throw new UnsupportedOperationException("This node has more than one token and cannot be moved thusly.");
        }
        ImmutableList keyspacesToProcess = ImmutableList.copyOf(Schema.instance.getNonLocalStrategyKeyspaces().names());
        PendingRangeCalculatorService.instance.blockUntilFinished();
        for (String keyspaceName : keyspacesToProcess) {
            if (this.tokenMetadata.getPendingRanges(keyspaceName, localAddress).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS_WITH_PORT, this.valueFactory.moving(newToken));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.moving(newToken));
        this.setMode(Mode.MOVING, String.format("Moving %s from %s to %s.", localAddress, this.getLocalTokens().iterator().next(), newToken), true);
        this.setMode(Mode.MOVING, String.format("Sleeping %s ms before start streaming/fetching ranges", RING_DELAY_MILLIS), true);
        Uninterruptibles.sleepUninterruptibly((long)RING_DELAY_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS);
        RangeRelocator relocator = new RangeRelocator(Collections.singleton(newToken), (List<String>)keyspacesToProcess, this.tokenMetadata);
        relocator.calculateToFromStreams();
        this.repairPaxosForTopologyChange("move");
        if (relocator.streamsNeeded()) {
            this.setMode(Mode.MOVING, "fetching new ranges and streaming old ranges", true);
            try {
                relocator.stream().get();
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Interrupted while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        } else {
            this.setMode(Mode.MOVING, "No ranges to fetch/stream", true);
        }
        this.setTokens(Collections.singleton(newToken));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully moved to new token {}", (Object)this.getLocalTokens().iterator().next());
        }
    }

    @Override
    public String getRemovalStatus() {
        return this.getRemovalStatus(false);
    }

    @Override
    public String getRemovalStatusWithPort() {
        return this.getRemovalStatus(true);
    }

    private String getRemovalStatus(boolean withPort) {
        if (this.removingNode == null) {
            return "No token removals in process.";
        }
        Collection<InetAddressAndPort> toFormat = this.replicatingNodes;
        if (!withPort) {
            toFormat = new ArrayList(this.replicatingNodes.size());
            for (InetAddressAndPort node : this.replicatingNodes) {
                toFormat.add((InetAddressAndPort)((Object)node.toString(false)));
            }
        }
        return String.format("Removing token (%s). Waiting for replication confirmation from [%s].", this.tokenMetadata.getToken(this.removingNode), StringUtils.join(toFormat, (String)","));
    }

    @Override
    public void forceRemoveCompletion() {
        if (!this.replicatingNodes.isEmpty() || this.tokenMetadata.getSizeOfLeavingEndpoints() > 0) {
            logger.warn("Removal not confirmed for for {}", (Object)StringUtils.join(this.replicatingNodes, (String)","));
            for (InetAddressAndPort endpoint : this.tokenMetadata.getLeavingEndpoints()) {
                UUID hostId = this.tokenMetadata.getHostId(endpoint);
                Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
                this.excise(this.tokenMetadata.getTokens(endpoint), endpoint);
            }
            this.replicatingNodes.clear();
            this.removingNode = null;
        } else {
            logger.warn("No nodes to force removal on, call 'removenode' first");
        }
    }

    @Override
    public void removeNode(String hostIdString) {
        InetAddressAndPort myAddress = FBUtilities.getBroadcastAddressAndPort();
        UUID localHostId = this.tokenMetadata.getHostId(myAddress);
        UUID hostId = UUID.fromString(hostIdString);
        InetAddressAndPort endpoint = this.tokenMetadata.getEndpointForHostId(hostId);
        if (endpoint == null) {
            throw new UnsupportedOperationException("Host ID not found.");
        }
        if (!this.tokenMetadata.isMember(endpoint)) {
            throw new UnsupportedOperationException("Node to be removed is not a member of the token ring");
        }
        if (endpoint.equals(myAddress)) {
            throw new UnsupportedOperationException("Cannot remove self");
        }
        if (Gossiper.instance.getLiveMembers().contains(endpoint)) {
            throw new UnsupportedOperationException("Node " + endpoint + " is alive and owns this ID. Use decommission command to remove it from the ring");
        }
        if (this.tokenMetadata.isLeaving(endpoint)) {
            logger.warn("Node {} is already being removed, continuing removal anyway", (Object)endpoint);
        }
        if (!this.replicatingNodes.isEmpty()) {
            throw new UnsupportedOperationException("This node is already processing a removal. Wait for it to complete, or use 'removenode force' if this has failed.");
        }
        Collection<Token> tokens = this.tokenMetadata.getTokens(endpoint);
        for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces().names()) {
            if (Keyspace.open((String)keyspaceName).getReplicationStrategy().getReplicationFactor().allReplicas == 1) continue;
            EndpointsByReplica changedRanges = StorageService.getChangedReplicasForLeaving(keyspaceName, endpoint, this.tokenMetadata, Keyspace.open(keyspaceName).getReplicationStrategy());
            IFailureDetector failureDetector = FailureDetector.instance;
            for (InetAddressAndPort ep : Iterables.transform(changedRanges.flattenValues(), Replica::endpoint)) {
                if (failureDetector.isAlive(ep)) {
                    this.replicatingNodes.add(ep);
                    continue;
                }
                logger.warn("Endpoint {} is down and will not receive data for re-replication of {}", (Object)ep, (Object)endpoint);
            }
        }
        this.removingNode = endpoint;
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
        Gossiper.instance.advertiseRemoving(endpoint, hostId, localHostId);
        this.restoreReplicaCount(endpoint, myAddress);
        while (!this.replicatingNodes.isEmpty()) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.excise(tokens, endpoint);
        Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    public void confirmReplication(InetAddressAndPort node) {
        if (!this.replicatingNodes.isEmpty()) {
            this.replicatingNodes.remove(node);
        } else {
            logger.info("Received unexpected REPLICATION_FINISHED message from {}. Was this node recently a removal coordinator?", (Object)node);
        }
    }

    @Override
    public String getOperationMode() {
        return this.operationMode.toString();
    }

    @Override
    public boolean isStarting() {
        return this.operationMode == Mode.STARTING;
    }

    public boolean isMoving() {
        return this.operationMode == Mode.MOVING;
    }

    public boolean isJoining() {
        return this.operationMode == Mode.JOINING;
    }

    @Override
    public boolean isDrained() {
        return this.operationMode == Mode.DRAINED;
    }

    @Override
    public boolean isDraining() {
        return this.operationMode == Mode.DRAINING;
    }

    public boolean isNormal() {
        return this.operationMode == Mode.NORMAL;
    }

    public boolean isDecommissioned() {
        return this.operationMode == Mode.DECOMMISSIONED;
    }

    @Override
    public String getDrainProgress() {
        return String.format("Drained %s/%s ColumnFamilies", this.remainingCFs, this.totalCFs);
    }

    @Override
    public synchronized void drain() throws IOException, InterruptedException, ExecutionException {
        this.drain(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void drain(boolean isFinalShutdown) throws IOException, InterruptedException, ExecutionException {
        if (Stage.areMutationExecutorsTerminated()) {
            if (!isFinalShutdown) {
                logger.warn("Cannot drain node (did it already happen?)");
            }
            return;
        }
        assert (!this.isShutdown);
        this.isShutdown = true;
        Throwable preShutdownHookThrowable = Throwables.perform(null, this.preShutdownHooks.stream().map(h -> h::run));
        if (preShutdownHookThrowable != null) {
            logger.error("Attempting to continue draining after pre-shutdown hooks returned exception", preShutdownHookThrowable);
        }
        try {
            this.setMode(Mode.DRAINING, "starting drain process", !isFinalShutdown);
            try {
                BatchlogManager.instance.shutdownAndWait(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException t) {
                logger.error("Batchlog manager timed out shutting down", (Throwable)t);
            }
            this.snapshotManager.stop();
            HintsService.instance.pauseDispatch();
            if (this.daemon != null) {
                this.shutdownClientServers();
            }
            ScheduledExecutors.optionalTasks.shutdown();
            Gossiper.instance.stop();
            ActiveRepairService.instance.stop();
            if (!isFinalShutdown) {
                this.setMode(Mode.DRAINING, "shutting down MessageService", false);
            }
            try {
                MessagingService.instance().shutdown();
            }
            catch (Throwable t) {
                logger.error("Messaging service timed out shutting down", t);
            }
            if (!isFinalShutdown) {
                this.setMode(Mode.DRAINING, "clearing mutation stage", false);
            }
            Stage.shutdownAndAwaitMutatingExecutors(false, CassandraRelevantProperties.DRAIN_EXECUTOR_TIMEOUT_MS.getInt(), TimeUnit.MILLISECONDS);
            StorageProxy.instance.verifyNoHintsInProgress();
            if (!isFinalShutdown) {
                this.setMode(Mode.DRAINING, "flushing column families", false);
            }
            this.disableAutoCompaction();
            this.totalCFs = 0;
            for (Keyspace keyspace : Keyspace.nonSystem()) {
                this.totalCFs += keyspace.getColumnFamilyStores().size();
            }
            this.remainingCFs = this.totalCFs;
            ArrayList<Future<CommitLogPosition>> flushes = new ArrayList<Future<CommitLogPosition>>();
            for (Keyspace keyspace : Keyspace.nonSystem()) {
                for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                    flushes.add(cfs.forceFlush(ColumnFamilyStore.FlushReason.DRAIN));
                }
            }
            for (Future future : flushes) {
                try {
                    FBUtilities.waitOnFuture(future);
                }
                catch (Throwable t) {
                    JVMStabilityInspector.inspectThrowable(t);
                    logger.warn("Caught exception while waiting for memtable flushes during shutdown hook", t);
                }
                --this.remainingCFs;
            }
            CompactionManager.instance.forceShutdown();
            flushes.clear();
            for (Keyspace keyspace : Keyspace.system()) {
                for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                    flushes.add(cfs.forceFlush(ColumnFamilyStore.FlushReason.DRAIN));
                }
            }
            FBUtilities.waitOnFutures(flushes);
            SnapshotManager.shutdownAndWait(1L, TimeUnit.MINUTES);
            HintsService.instance.shutdownBlocking();
            CompactionManager.instance.forceShutdown();
            CommitLog.instance.forceRecycleAllSegments();
            CommitLog.instance.shutdownBlocking();
            ColumnFamilyStore.shutdownPostFlushExecutor();
            try {
                ExecutorUtils.shutdownNowAndWait(1L, TimeUnit.MINUTES, ScheduledExecutors.nonPeriodicTasks, ScheduledExecutors.scheduledTasks, ScheduledExecutors.optionalTasks);
                this.setMode(Mode.DRAINED, !isFinalShutdown);
            }
            catch (Throwable throwable) {
                this.setMode(Mode.DRAINED, !isFinalShutdown);
                throw throwable;
            }
        }
        catch (Throwable t) {
            logger.error("Caught an exception while draining ", t);
        }
        finally {
            Throwable postShutdownHookThrowable = Throwables.perform(null, this.postShutdownHooks.stream().map(h -> h::run));
            if (postShutdownHookThrowable != null) {
                logger.error("Post-shutdown hooks returned exception", postShutdownHookThrowable);
            }
        }
    }

    @VisibleForTesting
    public void disableAutoCompaction() {
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    public synchronized boolean addPreShutdownHook(Runnable hook) {
        if (!this.isDraining() && !this.isDrained()) {
            return this.preShutdownHooks.add(hook);
        }
        return false;
    }

    public synchronized boolean removePreShutdownHook(Runnable hook) {
        return this.preShutdownHooks.remove(hook);
    }

    public synchronized boolean addPostShutdownHook(Runnable hook) {
        if (!this.isDraining() && !this.isDrained()) {
            return this.postShutdownHooks.add(hook);
        }
        return false;
    }

    public synchronized boolean removePostShutdownHook(Runnable hook) {
        return this.postShutdownHooks.remove(hook);
    }

    synchronized void checkServiceAllowedToStart(String service) {
        if (this.isDraining()) {
            throw new IllegalStateException(String.format("Unable to start %s because the node is draining.", service));
        }
        if (this.isShutdown()) {
            throw new IllegalStateException(String.format("Unable to start %s because the node was drained.", service));
        }
        if (!this.isNormal() && joinRing) {
            throw new IllegalStateException(String.format("Unable to start %s because the node is not in the normal state.", service));
        }
    }

    @VisibleForTesting
    public IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner oldPartitioner = DatabaseDescriptor.setPartitionerUnsafe(newPartitioner);
        this.tokenMetadata = this.tokenMetadata.cloneWithNewPartitioner(newPartitioner);
        this.valueFactory = new VersionedValue.VersionedValueFactory(newPartitioner);
        return oldPartitioner;
    }

    TokenMetadata setTokenMetadataUnsafe(TokenMetadata tmd) {
        TokenMetadata old = this.tokenMetadata;
        this.tokenMetadata = tmd;
        return old;
    }

    @Override
    public void truncate(String keyspace, String table) throws TimeoutException, IOException {
        this.verifyKeyspaceIsValid(keyspace);
        try {
            StorageProxy.truncateBlocking(keyspace, table);
        }
        catch (UnavailableException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Map<InetAddress, Float> getOwnership() {
        ArrayList<Token> sortedTokens = this.tokenMetadata.sortedTokens();
        TreeMap<Token, Float> tokenMap = new TreeMap<Token, Float>(this.tokenMetadata.partitioner.describeOwnership(sortedTokens));
        LinkedHashMap<InetAddress, Float> nodeMap = new LinkedHashMap<InetAddress, Float>();
        for (Map.Entry entry : tokenMap.entrySet()) {
            InetAddressAndPort endpoint = this.tokenMetadata.getEndpoint((Token)entry.getKey());
            Float tokenOwnership = (Float)entry.getValue();
            if (nodeMap.containsKey(endpoint.getAddress())) {
                nodeMap.put(endpoint.getAddress(), Float.valueOf(((Float)nodeMap.get(endpoint.getAddress())).floatValue() + tokenOwnership.floatValue()));
                continue;
            }
            nodeMap.put(endpoint.getAddress(), tokenOwnership);
        }
        return nodeMap;
    }

    @Override
    public Map<String, Float> getOwnershipWithPort() {
        ArrayList<Token> sortedTokens = this.tokenMetadata.sortedTokens();
        TreeMap<Token, Float> tokenMap = new TreeMap<Token, Float>(this.tokenMetadata.partitioner.describeOwnership(sortedTokens));
        LinkedHashMap<String, Float> nodeMap = new LinkedHashMap<String, Float>();
        for (Map.Entry entry : tokenMap.entrySet()) {
            InetAddressAndPort endpoint = this.tokenMetadata.getEndpoint((Token)entry.getKey());
            Float tokenOwnership = (Float)entry.getValue();
            if (nodeMap.containsKey(endpoint.toString())) {
                nodeMap.put(endpoint.toString(), Float.valueOf(((Float)nodeMap.get(endpoint.toString())).floatValue() + tokenOwnership.floatValue()));
                continue;
            }
            nodeMap.put(endpoint.toString(), tokenOwnership);
        }
        return nodeMap;
    }

    private LinkedHashMap<InetAddressAndPort, Float> getEffectiveOwnership(String keyspace) {
        AbstractReplicationStrategy strategy;
        if (keyspace != null) {
            Keyspace keyspaceInstance = Schema.instance.getKeyspaceInstance(keyspace);
            if (keyspaceInstance == null) {
                throw new IllegalArgumentException("The keyspace " + keyspace + ", does not exist");
            }
            if (keyspaceInstance.getReplicationStrategy() instanceof LocalStrategy) {
                throw new IllegalStateException("Ownership values for keyspaces with LocalStrategy are meaningless");
            }
            strategy = keyspaceInstance.getReplicationStrategy();
        } else {
            Keyspace keyspaceInstance;
            ImmutableSet<String> userKeyspaces = Schema.instance.getUserKeyspaces().names();
            if (userKeyspaces.size() > 0) {
                keyspace = (String)userKeyspaces.iterator().next();
                AbstractReplicationStrategy replicationStrategy = Schema.instance.getKeyspaceInstance(keyspace).getReplicationStrategy();
                for (Object keyspaceName : userKeyspaces) {
                    if (Schema.instance.getKeyspaceInstance((String)keyspaceName).getReplicationStrategy().hasSameSettings(replicationStrategy)) continue;
                    throw new IllegalStateException("Non-system keyspaces don't have the same replication settings, effective ownership information is meaningless");
                }
            } else {
                keyspace = "system_traces";
            }
            if ((keyspaceInstance = Schema.instance.getKeyspaceInstance(keyspace)) == null) {
                throw new IllegalStateException("The node does not have " + keyspace + " yet, probably still bootstrapping. Effective ownership information is meaningless.");
            }
            strategy = keyspaceInstance.getReplicationStrategy();
        }
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        ArrayList<Collection> endpointsGroupedByDc = new ArrayList<Collection>();
        TreeMap sortedDcsToEndpoints = new TreeMap(metadata.getTopology().getDatacenterEndpoints().asMap());
        for (Collection endpoints : sortedDcsToEndpoints.values()) {
            endpointsGroupedByDc.add(endpoints);
        }
        Map<Token, Float> tokenOwnership = this.tokenMetadata.partitioner.describeOwnership(this.tokenMetadata.sortedTokens());
        LinkedHashMap finalOwnership = Maps.newLinkedHashMap();
        RangesByEndpoint endpointToRanges = strategy.getAddressReplicas();
        for (Collection endpoints : endpointsGroupedByDc) {
            for (InetAddressAndPort endpoint : endpoints) {
                float ownership = 0.0f;
                for (Replica replica : endpointToRanges.get(endpoint)) {
                    if (!tokenOwnership.containsKey(replica.range().right)) continue;
                    ownership += tokenOwnership.get(replica.range().right).floatValue();
                }
                finalOwnership.put(endpoint, Float.valueOf(ownership));
            }
        }
        return finalOwnership;
    }

    public LinkedHashMap<InetAddress, Float> effectiveOwnership(String keyspace) throws IllegalStateException {
        LinkedHashMap<InetAddressAndPort, Float> result = this.getEffectiveOwnership(keyspace);
        LinkedHashMap<InetAddress, Float> asInets = new LinkedHashMap<InetAddress, Float>();
        result.entrySet().stream().forEachOrdered(entry -> {
            Float cfr_ignored_0 = (Float)asInets.put(((InetAddressAndPort)entry.getKey()).getAddress(), (Float)entry.getValue());
        });
        return asInets;
    }

    public LinkedHashMap<String, Float> effectiveOwnershipWithPort(String keyspace) throws IllegalStateException {
        LinkedHashMap<InetAddressAndPort, Float> result = this.getEffectiveOwnership(keyspace);
        LinkedHashMap<String, Float> asStrings = new LinkedHashMap<String, Float>();
        result.entrySet().stream().forEachOrdered(entry -> {
            Float cfr_ignored_0 = (Float)asStrings.put(((InetAddressAndPort)entry.getKey()).getHostAddressAndPort(), (Float)entry.getValue());
        });
        return asStrings;
    }

    @Override
    public List<String> getKeyspaces() {
        return Lists.newArrayList(Schema.instance.distributedAndLocalKeyspaces().names());
    }

    @Override
    public List<String> getNonSystemKeyspaces() {
        return Lists.newArrayList(Schema.instance.distributedKeyspaces().names());
    }

    @Override
    public List<String> getNonLocalStrategyKeyspaces() {
        return Lists.newArrayList(Schema.instance.getNonLocalStrategyKeyspaces().names());
    }

    public Map<String, String> getViewBuildStatuses(String keyspace, String view, boolean withPort) {
        Map<UUID, String> coreViewStatus = SystemDistributedKeyspace.viewStatus(keyspace, view);
        Map<InetAddressAndPort, UUID> hostIdToEndpoint = this.tokenMetadata.getEndpointToHostIdMapForReading();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<InetAddressAndPort, UUID> entry : hostIdToEndpoint.entrySet()) {
            UUID hostId = entry.getValue();
            InetAddressAndPort endpoint = entry.getKey();
            result.put(endpoint.toString(withPort), coreViewStatus.getOrDefault(hostId, "UNKNOWN"));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<String, String> getViewBuildStatuses(String keyspace, String view) {
        return this.getViewBuildStatuses(keyspace, view, false);
    }

    @Override
    public Map<String, String> getViewBuildStatusesWithPort(String keyspace, String view) {
        return this.getViewBuildStatuses(keyspace, view, true);
    }

    @Override
    public void setDynamicUpdateInterval(int dynamicUpdateInterval) {
        if (DatabaseDescriptor.getEndpointSnitch() instanceof DynamicEndpointSnitch) {
            try {
                this.updateSnitch(null, true, dynamicUpdateInterval, null, null);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int getDynamicUpdateInterval() {
        return DatabaseDescriptor.getDynamicUpdateInterval();
    }

    @Override
    public void updateSnitch(String epSnitchClassName, Boolean dynamic, Integer dynamicUpdateInterval, Integer dynamicResetInterval, Double dynamicBadnessThreshold) throws ClassNotFoundException {
        if (dynamicUpdateInterval != null) {
            DatabaseDescriptor.setDynamicUpdateInterval(dynamicUpdateInterval);
        }
        if (dynamicResetInterval != null) {
            DatabaseDescriptor.setDynamicResetInterval(dynamicResetInterval);
        }
        if (dynamicBadnessThreshold != null) {
            DatabaseDescriptor.setDynamicBadnessThreshold(dynamicBadnessThreshold);
        }
        IEndpointSnitch oldSnitch = DatabaseDescriptor.getEndpointSnitch();
        if (epSnitchClassName != null) {
            IEndpointSnitch newSnitch;
            if (oldSnitch instanceof DynamicEndpointSnitch) {
                ((DynamicEndpointSnitch)oldSnitch).close();
            }
            try {
                newSnitch = DatabaseDescriptor.createEndpointSnitch(dynamic != null && dynamic != false, epSnitchClassName);
            }
            catch (ConfigurationException e) {
                throw new ClassNotFoundException(e.getMessage());
            }
            if (newSnitch instanceof DynamicEndpointSnitch) {
                logger.info("Created new dynamic snitch {} with update-interval={}, reset-interval={}, badness-threshold={}", new Object[]{((DynamicEndpointSnitch)newSnitch).subsnitch.getClass().getName(), DatabaseDescriptor.getDynamicUpdateInterval(), DatabaseDescriptor.getDynamicResetInterval(), DatabaseDescriptor.getDynamicBadnessThreshold()});
            } else {
                logger.info("Created new non-dynamic snitch {}", (Object)newSnitch.getClass().getName());
            }
            DatabaseDescriptor.setEndpointSnitch(newSnitch);
            for (String ks : Schema.instance.getKeyspaces()) {
                Keyspace.open((String)ks).getReplicationStrategy().snitch = newSnitch;
            }
        } else if (oldSnitch instanceof DynamicEndpointSnitch) {
            logger.info("Applying config change to dynamic snitch {} with update-interval={}, reset-interval={}, badness-threshold={}", new Object[]{((DynamicEndpointSnitch)oldSnitch).subsnitch.getClass().getName(), DatabaseDescriptor.getDynamicUpdateInterval(), DatabaseDescriptor.getDynamicResetInterval(), DatabaseDescriptor.getDynamicBadnessThreshold()});
            DynamicEndpointSnitch snitch = (DynamicEndpointSnitch)oldSnitch;
            snitch.applyConfigChanges();
        }
        this.updateTopology();
    }

    private Future<StreamState> streamRanges(Map<String, EndpointsByReplica> rangesToStreamByKeyspace) {
        HashMap<String, RangesByEndpoint> sessionsToStreamByKeyspace = new HashMap<String, RangesByEndpoint>();
        for (Map.Entry<String, EndpointsByReplica> entry : rangesToStreamByKeyspace.entrySet()) {
            String keyspace = entry.getKey();
            EndpointsByReplica rangesWithEndpoints = entry.getValue();
            if (rangesWithEndpoints.isEmpty()) continue;
            Map<InetAddressAndPort, Set<Range<Token>>> transferredRangePerKeyspace = SystemKeyspace.getTransferredRanges("Unbootstrap", keyspace, StorageService.instance.getTokenMetadata().partitioner);
            RangesByEndpoint.Builder replicasPerEndpoint = new RangesByEndpoint.Builder();
            for (Map.Entry endPointEntry : rangesWithEndpoints.flattenEntries()) {
                Replica local = (Replica)endPointEntry.getKey();
                Replica remote = endPointEntry.getValue();
                Set<Range<Token>> transferredRanges = transferredRangePerKeyspace.get(remote.endpoint());
                if (transferredRanges != null && transferredRanges.contains(local.range())) {
                    logger.debug("Skipping transferred range {} of keyspace {}, endpoint {}", new Object[]{local, keyspace, remote});
                    continue;
                }
                replicasPerEndpoint.put(remote.endpoint(), remote.decorateSubrange(local.range()));
            }
            sessionsToStreamByKeyspace.put(keyspace, replicasPerEndpoint.build());
        }
        StreamPlan streamPlan = new StreamPlan(StreamOperation.DECOMMISSION);
        streamPlan.listeners(this.streamStateStore, new StreamEventHandler[0]);
        for (Map.Entry entry : sessionsToStreamByKeyspace.entrySet()) {
            String keyspaceName = (String)entry.getKey();
            RangesByEndpoint replicasPerEndpoint = (RangesByEndpoint)entry.getValue();
            for (Map.Entry rangesEntry : replicasPerEndpoint.asMap().entrySet()) {
                RangesAtEndpoint replicas = (RangesAtEndpoint)rangesEntry.getValue();
                InetAddressAndPort newEndpoint = (InetAddressAndPort)rangesEntry.getKey();
                streamPlan.transferRanges(newEndpoint, keyspaceName, replicas, new String[0]);
            }
        }
        return streamPlan.execute();
    }

    @Override
    public void bulkLoad(String directory) {
        try {
            this.bulkLoadInternal(directory).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String bulkLoadAsync(String directory) {
        return this.bulkLoadInternal((String)directory).planId.toString();
    }

    private StreamResultFuture bulkLoadInternal(String directory) {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory " + directory);
        }
        SSTableLoader.Client client = new SSTableLoader.Client(){
            private String keyspace;

            @Override
            public void init(String keyspace) {
                this.keyspace = keyspace;
                try {
                    for (Map.Entry entry : instance.getRangeToAddressMap(keyspace).entrySet()) {
                        Range range = (Range)entry.getKey();
                        EndpointsForRange replicas = (EndpointsForRange)entry.getValue();
                        Replicas.temporaryAssertFull(replicas);
                        for (InetAddressAndPort endpoint : replicas.endpoints()) {
                            this.addRangeForEndpoint(range, endpoint);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public TableMetadataRef getTableMetadata(String tableName) {
                return Schema.instance.getTableMetadataRef(this.keyspace, tableName);
            }
        };
        return new SSTableLoader(dir, client, new OutputHandler.LogOutput()).stream();
    }

    @Override
    public void rescheduleFailedDeletions() {
        LifecycleTransaction.rescheduleFailedDeletions();
    }

    @Override
    @Deprecated
    public void loadNewSSTables(String ksName, String cfName) {
        if (!this.isInitialized()) {
            throw new RuntimeException("Not yet initialized, can't load new sstables");
        }
        this.verifyKeyspaceIsValid(ksName);
        ColumnFamilyStore.loadNewSSTables(ksName, cfName);
    }

    @Override
    public List<String> sampleKeyRange() {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (Keyspace keyspace : Keyspace.nonLocalStrategy()) {
            for (Range<Token> range : this.getPrimaryRangesForEndpoint(keyspace.getName(), FBUtilities.getBroadcastAddressAndPort())) {
                keys.addAll(this.keySamples(keyspace.getColumnFamilyStores(), range));
            }
        }
        ArrayList<String> sampledKeys = new ArrayList<String>(keys.size());
        for (DecoratedKey key : keys) {
            sampledKeys.add(key.getToken().toString());
        }
        return sampledKeys;
    }

    @Override
    public Map<String, List<CompositeData>> samplePartitions(int durationMillis, int capacity, int count, List<String> samplers) throws OpenDataException {
        ConcurrentHashMap<String, List<CompositeData>> result = new ConcurrentHashMap<String, List<CompositeData>>();
        for (String sampler : samplers) {
            for (ColumnFamilyStore table : ColumnFamilyStore.all()) {
                table.beginLocalSampling(sampler, capacity, durationMillis);
            }
        }
        Uninterruptibles.sleepUninterruptibly((long)durationMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        for (String sampler : samplers) {
            ArrayList<CompositeData> topk = new ArrayList<CompositeData>();
            for (ColumnFamilyStore table : ColumnFamilyStore.all()) {
                topk.addAll(table.finishLocalSampling(sampler, count));
            }
            Collections.sort(topk, new Ordering<CompositeData>(){

                public int compare(CompositeData left, CompositeData right) {
                    return Long.compare((Long)right.get("count"), (Long)left.get("count"));
                }
            });
            topk = new ArrayList(topk.subList(0, Math.min(topk.size(), count)));
            result.put(sampler, topk);
        }
        return result;
    }

    @Override
    public void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        String[] indices = Arrays.asList(idxNames).stream().map(p -> SecondaryIndexManager.isIndexColumnFamily(p) ? SecondaryIndexManager.getIndexName(p) : p).collect(Collectors.toList()).toArray(new String[idxNames.length]);
        ColumnFamilyStore.rebuildSecondaryIndex(ksName, cfName, indices);
    }

    @Override
    public void resetLocalSchema() throws IOException {
        Schema.instance.resetLocalSchema();
    }

    @Override
    public void reloadLocalSchema() {
        Schema.instance.reloadSchemaAndAnnounceVersion();
    }

    @Override
    public void setTraceProbability(double probability) {
        this.traceProbability = probability;
    }

    @Override
    public double getTraceProbability() {
        return this.traceProbability;
    }

    public boolean shouldTraceProbablistically() {
        return this.traceProbability != 0.0 && ThreadLocalRandom.current().nextDouble() < this.traceProbability;
    }

    @Override
    public void disableAutoCompaction(String ks, String ... tables) throws IOException {
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, tables)) {
            cfs.disableAutoCompaction();
        }
    }

    @Override
    public synchronized void enableAutoCompaction(String ks, String ... tables) throws IOException {
        this.checkServiceAllowedToStart("auto compaction");
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, tables)) {
            cfs.enableAutoCompaction();
        }
    }

    @Override
    public Map<String, Boolean> getAutoCompactionStatus(String ks, String ... tables) throws IOException {
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, tables)) {
            status.put(cfs.getTableName(), cfs.isAutoCompactionDisabled());
        }
        return status;
    }

    @Override
    public String getClusterName() {
        return DatabaseDescriptor.getClusterName();
    }

    @Override
    public String getPartitionerName() {
        return DatabaseDescriptor.getPartitionerName();
    }

    @Override
    public void setSSTablePreemptiveOpenIntervalInMB(int intervalInMB) {
        DatabaseDescriptor.setSSTablePreemptiveOpenIntervalInMiB(intervalInMB);
    }

    @Override
    public int getSSTablePreemptiveOpenIntervalInMB() {
        return DatabaseDescriptor.getSSTablePreemptiveOpenIntervalInMiB();
    }

    @Override
    public boolean getMigrateKeycacheOnCompaction() {
        return DatabaseDescriptor.shouldMigrateKeycacheOnCompaction();
    }

    @Override
    public void setMigrateKeycacheOnCompaction(boolean invalidateKeyCacheOnCompaction) {
        DatabaseDescriptor.setMigrateKeycacheOnCompaction(invalidateKeyCacheOnCompaction);
    }

    @Override
    public int getTombstoneWarnThreshold() {
        return DatabaseDescriptor.getTombstoneWarnThreshold();
    }

    @Override
    public void setTombstoneWarnThreshold(int threshold) {
        DatabaseDescriptor.setTombstoneWarnThreshold(threshold);
        logger.info("updated tombstone_warn_threshold to {}", (Object)threshold);
    }

    @Override
    public int getTombstoneFailureThreshold() {
        return DatabaseDescriptor.getTombstoneFailureThreshold();
    }

    @Override
    public void setTombstoneFailureThreshold(int threshold) {
        DatabaseDescriptor.setTombstoneFailureThreshold(threshold);
        logger.info("updated tombstone_failure_threshold to {}", (Object)threshold);
    }

    @Override
    public int getCachedReplicaRowsWarnThreshold() {
        return DatabaseDescriptor.getCachedReplicaRowsWarnThreshold();
    }

    @Override
    public void setCachedReplicaRowsWarnThreshold(int threshold) {
        DatabaseDescriptor.setCachedReplicaRowsWarnThreshold(threshold);
        logger.info("updated replica_filtering_protection.cached_rows_warn_threshold to {}", (Object)threshold);
    }

    @Override
    public int getCachedReplicaRowsFailThreshold() {
        return DatabaseDescriptor.getCachedReplicaRowsFailThreshold();
    }

    @Override
    public void setCachedReplicaRowsFailThreshold(int threshold) {
        DatabaseDescriptor.setCachedReplicaRowsFailThreshold(threshold);
        logger.info("updated replica_filtering_protection.cached_rows_fail_threshold to {}", (Object)threshold);
    }

    @Override
    public int getColumnIndexSizeInKiB() {
        return DatabaseDescriptor.getColumnIndexSizeInKiB();
    }

    @Override
    public void setColumnIndexSize(int columnIndexSizeInKB) {
        int oldValueInKiB = DatabaseDescriptor.getColumnIndexSizeInKiB();
        DatabaseDescriptor.setColumnIndexSize(columnIndexSizeInKB);
        logger.info("Updated column_index_size to {} KiB (was {} KiB)", (Object)columnIndexSizeInKB, (Object)oldValueInKiB);
    }

    @Override
    public int getColumnIndexCacheSize() {
        return DatabaseDescriptor.getColumnIndexCacheSizeInKiB();
    }

    @Override
    public void setColumnIndexCacheSize(int cacheSizeInKB) {
        DatabaseDescriptor.setColumnIndexCacheSize(cacheSizeInKB);
        logger.info("Updated column_index_cache_size to {}", (Object)cacheSizeInKB);
    }

    @Override
    public int getBatchSizeFailureThreshold() {
        return DatabaseDescriptor.getBatchSizeFailThresholdInKiB();
    }

    @Override
    public void setBatchSizeFailureThreshold(int threshold) {
        DatabaseDescriptor.setBatchSizeFailThresholdInKiB(threshold);
        logger.info("updated batch_size_fail_threshold to {}", (Object)threshold);
    }

    @Override
    public int getBatchSizeWarnThreshold() {
        return DatabaseDescriptor.getBatchSizeWarnThresholdInKiB();
    }

    @Override
    public void setBatchSizeWarnThreshold(int threshold) {
        DatabaseDescriptor.setBatchSizeWarnThresholdInKiB(threshold);
        logger.info("Updated batch_size_warn_threshold to {}", (Object)threshold);
    }

    @Override
    public int getInitialRangeTombstoneListAllocationSize() {
        return DatabaseDescriptor.getInitialRangeTombstoneListAllocationSize();
    }

    @Override
    public void setInitialRangeTombstoneListAllocationSize(int size) {
        if (size < 0 || size > 1024) {
            throw new IllegalStateException("Not updating initial_range_tombstone_allocation_size as it must be in the range [0, 1024] inclusive");
        }
        int originalSize = DatabaseDescriptor.getInitialRangeTombstoneListAllocationSize();
        DatabaseDescriptor.setInitialRangeTombstoneListAllocationSize(size);
        logger.info("Updated initial_range_tombstone_allocation_size from {} to {}", (Object)originalSize, (Object)size);
    }

    @Override
    public double getRangeTombstoneResizeListGrowthFactor() {
        return DatabaseDescriptor.getRangeTombstoneListGrowthFactor();
    }

    @Override
    public void setRangeTombstoneListResizeGrowthFactor(double growthFactor) throws IllegalStateException {
        if (growthFactor < 1.2 || growthFactor > 5.0) {
            throw new IllegalStateException("Not updating range_tombstone_resize_factor as growth factor must be in the range [1.2, 5.0] inclusive");
        }
        double originalGrowthFactor = DatabaseDescriptor.getRangeTombstoneListGrowthFactor();
        DatabaseDescriptor.setRangeTombstoneListGrowthFactor(growthFactor);
        logger.info("Updated range_tombstone_resize_factor from {} to {}", (Object)originalGrowthFactor, (Object)growthFactor);
    }

    @Override
    public void setHintedHandoffThrottleInKB(int throttleInKB) {
        DatabaseDescriptor.setHintedHandoffThrottleInKiB(throttleInKB);
        logger.info("updated hinted_handoff_throttle to {} KiB", (Object)throttleInKB);
    }

    @Override
    public void clearConnectionHistory() {
        this.daemon.clearConnectionHistory();
        logger.info("Cleared connection history");
    }

    @Override
    public void disableAuditLog() {
        AuditLogManager.instance.disableAuditLog();
        logger.info("Auditlog is disabled");
    }

    @Override
    @Deprecated
    public void enableAuditLog(String loggerName, String includedKeyspaces, String excludedKeyspaces, String includedCategories, String excludedCategories, String includedUsers, String excludedUsers) throws ConfigurationException, IllegalStateException {
        this.enableAuditLog(loggerName, Collections.emptyMap(), includedKeyspaces, excludedKeyspaces, includedCategories, excludedCategories, includedUsers, excludedUsers, Integer.MIN_VALUE, null, null, Long.MIN_VALUE, Integer.MIN_VALUE, null);
    }

    @Override
    public void enableAuditLog(String loggerName, String includedKeyspaces, String excludedKeyspaces, String includedCategories, String excludedCategories, String includedUsers, String excludedUsers, Integer maxArchiveRetries, Boolean block, String rollCycle, Long maxLogSize, Integer maxQueueWeight, String archiveCommand) throws IllegalStateException {
        this.enableAuditLog(loggerName, Collections.emptyMap(), includedKeyspaces, excludedKeyspaces, includedCategories, excludedCategories, includedUsers, excludedUsers, maxArchiveRetries, block, rollCycle, maxLogSize, maxQueueWeight, archiveCommand);
    }

    @Override
    @Deprecated
    public void enableAuditLog(String loggerName, Map<String, String> parameters, String includedKeyspaces, String excludedKeyspaces, String includedCategories, String excludedCategories, String includedUsers, String excludedUsers) throws ConfigurationException, IllegalStateException {
        this.enableAuditLog(loggerName, parameters, includedKeyspaces, excludedKeyspaces, includedCategories, excludedCategories, includedUsers, excludedUsers, Integer.MIN_VALUE, null, null, Long.MIN_VALUE, Integer.MIN_VALUE, null);
    }

    @Override
    public void enableAuditLog(String loggerName, Map<String, String> parameters, String includedKeyspaces, String excludedKeyspaces, String includedCategories, String excludedCategories, String includedUsers, String excludedUsers, Integer maxArchiveRetries, Boolean block, String rollCycle, Long maxLogSize, Integer maxQueueWeight, String archiveCommand) throws IllegalStateException {
        AuditLogOptions options = new AuditLogOptions.Builder(DatabaseDescriptor.getAuditLoggingOptions()).withEnabled(true).withLogger(loggerName, parameters).withIncludedKeyspaces(includedKeyspaces).withExcludedKeyspaces(excludedKeyspaces).withIncludedCategories(includedCategories).withExcludedCategories(excludedCategories).withIncludedUsers(includedUsers).withExcludedUsers(excludedUsers).withMaxArchiveRetries(maxArchiveRetries).withBlock(block).withRollCycle(rollCycle).withMaxLogSize(maxLogSize).withMaxQueueWeight(maxQueueWeight).withArchiveCommand(archiveCommand).build();
        AuditLogManager.instance.enable(options);
        logger.info("AuditLog is enabled with configuration: {}", (Object)options);
    }

    @Override
    public boolean isAuditLogEnabled() {
        return AuditLogManager.instance.isEnabled();
    }

    @Override
    public String getCorruptedTombstoneStrategy() {
        return DatabaseDescriptor.getCorruptedTombstoneStrategy().toString();
    }

    @Override
    public void setCorruptedTombstoneStrategy(String strategy) {
        DatabaseDescriptor.setCorruptedTombstoneStrategy(Config.CorruptedTombstoneStrategy.valueOf(strategy));
        logger.info("Setting corrupted tombstone strategy to {}", (Object)strategy);
    }

    @Override
    public long getNativeTransportMaxConcurrentRequestsInBytes() {
        return ClientResourceLimits.getGlobalLimit();
    }

    @Override
    public void setNativeTransportMaxConcurrentRequestsInBytes(long newLimit) {
        ClientResourceLimits.setGlobalLimit(newLimit);
    }

    @Override
    public long getNativeTransportMaxConcurrentRequestsInBytesPerIp() {
        return ClientResourceLimits.getEndpointLimit();
    }

    @Override
    public void setNativeTransportMaxConcurrentRequestsInBytesPerIp(long newLimit) {
        ClientResourceLimits.setEndpointLimit(newLimit);
    }

    @Override
    public int getNativeTransportMaxRequestsPerSecond() {
        return ClientResourceLimits.getNativeTransportMaxRequestsPerSecond();
    }

    @Override
    public void setNativeTransportMaxRequestsPerSecond(int newPerSecond) {
        ClientResourceLimits.setNativeTransportMaxRequestsPerSecond(newPerSecond);
    }

    @Override
    public void setNativeTransportRateLimitingEnabled(boolean enabled) {
        DatabaseDescriptor.setNativeTransportRateLimitingEnabled(enabled);
    }

    @Override
    public boolean getNativeTransportRateLimitingEnabled() {
        return DatabaseDescriptor.getNativeTransportRateLimitingEnabled();
    }

    @VisibleForTesting
    public void shutdownServer() {
        if (this.drainOnShutdown != null) {
            Runtime.getRuntime().removeShutdownHook(this.drainOnShutdown);
        }
    }

    @Override
    public void enableFullQueryLogger(String path, String rollCycle, Boolean blocking, int maxQueueWeight, long maxLogSize, String archiveCommand, int maxArchiveRetries) {
        FullQueryLoggerOptions fqlOptions = DatabaseDescriptor.getFullQueryLogOptions();
        path = path != null ? path : fqlOptions.log_dir;
        rollCycle = rollCycle != null ? rollCycle : fqlOptions.roll_cycle;
        blocking = blocking != null ? blocking : fqlOptions.block;
        maxQueueWeight = maxQueueWeight != Integer.MIN_VALUE ? maxQueueWeight : fqlOptions.max_queue_weight;
        maxLogSize = maxLogSize != Long.MIN_VALUE ? maxLogSize : fqlOptions.max_log_size;
        archiveCommand = archiveCommand != null ? archiveCommand : fqlOptions.archive_command;
        maxArchiveRetries = maxArchiveRetries != Integer.MIN_VALUE ? maxArchiveRetries : fqlOptions.max_archive_retries;
        Preconditions.checkNotNull((Object)path, (Object)"cassandra.yaml did not set log_dir and not set as parameter");
        FullQueryLogger.instance.enableWithoutClean(Paths.get(path, new String[0]), rollCycle, blocking, maxQueueWeight, maxLogSize, archiveCommand, maxArchiveRetries);
    }

    @Override
    public void resetFullQueryLogger() {
        FullQueryLogger.instance.reset(DatabaseDescriptor.getFullQueryLogOptions().log_dir);
    }

    @Override
    public void stopFullQueryLogger() {
        FullQueryLogger.instance.stop();
    }

    @Override
    public boolean isFullQueryLogEnabled() {
        return FullQueryLogger.instance.isEnabled();
    }

    @Override
    public CompositeData getFullQueryLoggerOptions() {
        return FullQueryLoggerOptionsCompositeData.toCompositeData(FullQueryLogger.instance.getFullQueryLoggerOptions());
    }

    @Override
    public Map<String, Set<InetAddress>> getOutstandingSchemaVersions() {
        Map<UUID, Set<InetAddressAndPort>> outstanding = Schema.instance.getOutstandingSchemaVersions();
        return outstanding.entrySet().stream().collect(Collectors.toMap(e -> ((UUID)e.getKey()).toString(), e -> ((Set)e.getValue()).stream().map(InetSocketAddress::getAddress).collect(Collectors.toSet())));
    }

    @Override
    public Map<String, Set<String>> getOutstandingSchemaVersionsWithPort() {
        Map<UUID, Set<InetAddressAndPort>> outstanding = Schema.instance.getOutstandingSchemaVersions();
        return outstanding.entrySet().stream().collect(Collectors.toMap(e -> ((UUID)e.getKey()).toString(), e -> ((Set)e.getValue()).stream().map(Object::toString).collect(Collectors.toSet())));
    }

    @Override
    public boolean autoOptimiseIncRepairStreams() {
        return DatabaseDescriptor.autoOptimiseIncRepairStreams();
    }

    @Override
    public void setAutoOptimiseIncRepairStreams(boolean enabled) {
        DatabaseDescriptor.setAutoOptimiseIncRepairStreams(enabled);
    }

    @Override
    public boolean autoOptimiseFullRepairStreams() {
        return DatabaseDescriptor.autoOptimiseFullRepairStreams();
    }

    @Override
    public void setAutoOptimiseFullRepairStreams(boolean enabled) {
        DatabaseDescriptor.setAutoOptimiseFullRepairStreams(enabled);
    }

    @Override
    public boolean autoOptimisePreviewRepairStreams() {
        return DatabaseDescriptor.autoOptimisePreviewRepairStreams();
    }

    @Override
    public void setAutoOptimisePreviewRepairStreams(boolean enabled) {
        DatabaseDescriptor.setAutoOptimisePreviewRepairStreams(enabled);
    }

    @Override
    @Deprecated
    public int getTableCountWarnThreshold() {
        return DatabaseDescriptor.tableCountWarnThreshold();
    }

    @Override
    @Deprecated
    public void setTableCountWarnThreshold(int value) {
        if (value < 0) {
            throw new IllegalStateException("Table count warn threshold should be positive, not " + value);
        }
        logger.info("Changing table count warn threshold from {} to {}", (Object)this.getTableCountWarnThreshold(), (Object)value);
        DatabaseDescriptor.setTableCountWarnThreshold(value);
    }

    @Override
    @Deprecated
    public int getKeyspaceCountWarnThreshold() {
        return DatabaseDescriptor.keyspaceCountWarnThreshold();
    }

    @Override
    @Deprecated
    public void setKeyspaceCountWarnThreshold(int value) {
        if (value < 0) {
            throw new IllegalStateException("Keyspace count warn threshold should be positive, not " + value);
        }
        logger.info("Changing keyspace count warn threshold from {} to {}", (Object)this.getKeyspaceCountWarnThreshold(), (Object)value);
        DatabaseDescriptor.setKeyspaceCountWarnThreshold(value);
    }

    @Override
    public void setCompactionTombstoneWarningThreshold(int count) {
        if (count < 0) {
            throw new IllegalStateException("compaction tombstone warning threshold needs to be >= 0, not " + count);
        }
        logger.info("Setting compaction_tombstone_warning_threshold to {}", (Object)count);
        DatabaseDescriptor.setCompactionTombstoneWarningThreshold(count);
    }

    @Override
    public int getCompactionTombstoneWarningThreshold() {
        return DatabaseDescriptor.getCompactionTombstoneWarningThreshold();
    }

    public void addSnapshot(TableSnapshot snapshot) {
        this.snapshotManager.addSnapshot(snapshot);
    }

    @Override
    public boolean getReadThresholdsEnabled() {
        return DatabaseDescriptor.getReadThresholdsEnabled();
    }

    @Override
    public void setReadThresholdsEnabled(boolean value) {
        DatabaseDescriptor.setReadThresholdsEnabled(value);
    }

    @Override
    public String getCoordinatorLargeReadWarnThreshold() {
        return StorageService.toString(DatabaseDescriptor.getCoordinatorReadSizeWarnThreshold());
    }

    @Override
    public void setCoordinatorLargeReadWarnThreshold(String threshold) {
        DatabaseDescriptor.setCoordinatorReadSizeWarnThreshold(StorageService.parseDataStorageSpec(threshold));
    }

    @Override
    public String getCoordinatorLargeReadAbortThreshold() {
        return StorageService.toString(DatabaseDescriptor.getCoordinatorReadSizeFailThreshold());
    }

    @Override
    public void setCoordinatorLargeReadAbortThreshold(String threshold) {
        DatabaseDescriptor.setCoordinatorReadSizeFailThreshold(StorageService.parseDataStorageSpec(threshold));
    }

    @Override
    public String getLocalReadTooLargeWarnThreshold() {
        return StorageService.toString(DatabaseDescriptor.getLocalReadSizeWarnThreshold());
    }

    @Override
    public void setLocalReadTooLargeWarnThreshold(String threshold) {
        DatabaseDescriptor.setLocalReadSizeWarnThreshold(StorageService.parseDataStorageSpec(threshold));
    }

    @Override
    public String getLocalReadTooLargeAbortThreshold() {
        return StorageService.toString(DatabaseDescriptor.getLocalReadSizeFailThreshold());
    }

    @Override
    public void setLocalReadTooLargeAbortThreshold(String threshold) {
        DatabaseDescriptor.setLocalReadSizeFailThreshold(StorageService.parseDataStorageSpec(threshold));
    }

    @Override
    public String getRowIndexReadSizeWarnThreshold() {
        return StorageService.toString(DatabaseDescriptor.getRowIndexReadSizeWarnThreshold());
    }

    @Override
    public void setRowIndexReadSizeWarnThreshold(String threshold) {
        DatabaseDescriptor.setRowIndexReadSizeWarnThreshold(StorageService.parseDataStorageSpec(threshold));
    }

    @Override
    public String getRowIndexReadSizeAbortThreshold() {
        return StorageService.toString(DatabaseDescriptor.getRowIndexReadSizeFailThreshold());
    }

    @Override
    public void setRowIndexReadSizeAbortThreshold(String threshold) {
        DatabaseDescriptor.setRowIndexReadSizeFailThreshold(StorageService.parseDataStorageSpec(threshold));
    }

    private static String toString(DataStorageSpec value) {
        return value == null ? null : value.toString();
    }

    @Override
    public void setDefaultKeyspaceReplicationFactor(int value) {
        DatabaseDescriptor.setDefaultKeyspaceRF(value);
        logger.info("set default keyspace rf to {}", (Object)value);
    }

    private static DataStorageSpec.LongBytesBound parseDataStorageSpec(String threshold) {
        return threshold == null ? null : new DataStorageSpec.LongBytesBound(threshold);
    }

    @Override
    public int getDefaultKeyspaceReplicationFactor() {
        return DatabaseDescriptor.getDefaultKeyspaceRF();
    }

    @Override
    public boolean getSkipPaxosRepairOnTopologyChange() {
        return DatabaseDescriptor.skipPaxosRepairOnTopologyChange();
    }

    @Override
    public void setSkipPaxosRepairOnTopologyChange(boolean v) {
        DatabaseDescriptor.setSkipPaxosRepairOnTopologyChange(v);
        logger.info("paxos skip topology change repair {} via jmx", (Object)(v ? "enabled" : "disabled"));
    }

    @Override
    public String getSkipPaxosRepairOnTopologyChangeKeyspaces() {
        return Joiner.on((char)',').join(DatabaseDescriptor.skipPaxosRepairOnTopologyChangeKeyspaces());
    }

    @Override
    public void setSkipPaxosRepairOnTopologyChangeKeyspaces(String v) {
        DatabaseDescriptor.setSkipPaxosRepairOnTopologyChangeKeyspaces(v);
        logger.info("paxos skip topology change repair keyspaces set to  {} via jmx", (Object)v);
    }

    @Override
    public boolean getPaxosAutoRepairsEnabled() {
        return PaxosState.uncommittedTracker().isAutoRepairsEnabled();
    }

    @Override
    public void setPaxosAutoRepairsEnabled(boolean enabled) {
        PaxosState.uncommittedTracker().setAutoRepairsEnabled(enabled);
        logger.info("paxos auto repairs {} via jmx", (Object)(enabled ? "enabled" : "disabled"));
    }

    @Override
    public boolean getPaxosStateFlushEnabled() {
        return PaxosState.uncommittedTracker().isStateFlushEnabled();
    }

    @Override
    public void setPaxosStateFlushEnabled(boolean enabled) {
        PaxosState.uncommittedTracker().setStateFlushEnabled(enabled);
        logger.info("paxos state flush {} via jmx", (Object)(enabled ? "enabled" : "disabled"));
    }

    @Override
    public List<String> getPaxosAutoRepairTables() {
        Set<TableId> tableIds = PaxosState.uncommittedTracker().tableIds();
        ArrayList<String> tables = new ArrayList<String>(tableIds.size());
        for (TableId tableId : tableIds) {
            TableMetadata table = Schema.instance.getTableMetadata(tableId);
            if (table == null) continue;
            tables.add(table.keyspace + '.' + table.name);
        }
        return tables;
    }

    @Override
    public long getPaxosPurgeGraceSeconds() {
        return DatabaseDescriptor.getPaxosPurgeGrace(TimeUnit.SECONDS);
    }

    @Override
    public void setPaxosPurgeGraceSeconds(long v) {
        DatabaseDescriptor.setPaxosPurgeGrace(v);
        logger.info("paxos purging grace seconds set to {} via jmx", (Object)v);
    }

    @Override
    public String getPaxosOnLinearizabilityViolations() {
        return DatabaseDescriptor.paxosOnLinearizabilityViolations().toString();
    }

    @Override
    public void setPaxosOnLinearizabilityViolations(String v) {
        DatabaseDescriptor.setPaxosOnLinearizabilityViolations(Config.PaxosOnLinearizabilityViolation.valueOf(v));
        logger.info("paxos on linearizability violations {} via jmx", (Object)v);
    }

    @Override
    public String getPaxosStatePurging() {
        return DatabaseDescriptor.paxosStatePurging().name();
    }

    @Override
    public void setPaxosStatePurging(String v) {
        DatabaseDescriptor.setPaxosStatePurging(Config.PaxosStatePurging.valueOf(v));
        logger.info("paxos state purging {} via jmx", (Object)v);
    }

    @Override
    public boolean getPaxosRepairEnabled() {
        return DatabaseDescriptor.paxosRepairEnabled();
    }

    @Override
    public void setPaxosRepairEnabled(boolean enabled) {
        DatabaseDescriptor.setPaxosRepairEnabled(enabled);
        logger.info("paxos repair {} via jmx", (Object)(enabled ? "enabled" : "disabled"));
    }

    @Override
    public boolean getPaxosDcLocalCommitEnabled() {
        return PaxosCommit.getEnableDcLocalCommit();
    }

    @Override
    public void setPaxosDcLocalCommitEnabled(boolean enabled) {
        PaxosCommit.setEnableDcLocalCommit(enabled);
        logger.info("paxos dc local commit {} via jmx", (Object)(enabled ? "enabled" : "disabled"));
    }

    @Override
    public String getPaxosBallotLowBound(String ksName, String tblName, String key) {
        Keyspace keyspace = Keyspace.open(ksName);
        if (keyspace == null) {
            throw new IllegalArgumentException("Unknown keyspace '" + ksName + "'");
        }
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(tblName);
        if (cfs == null) {
            throw new IllegalArgumentException("Unknown table '" + tblName + "' in keyspace '" + ksName + "'");
        }
        TableMetadata table = cfs.metadata.get();
        DecoratedKey dk = table.partitioner.decorateKey(table.partitionKeyType.fromString(key));
        return cfs.getPaxosRepairHistory().ballotForToken(dk.getToken()).toString();
    }

    @Override
    public Long getRepairRpcTimeout() {
        return DatabaseDescriptor.getRepairRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setRepairRpcTimeout(Long timeoutInMillis) {
        Preconditions.checkState((timeoutInMillis > 0L ? 1 : 0) != 0);
        DatabaseDescriptor.setRepairRpcTimeout(timeoutInMillis);
        logger.info("RepairRpcTimeout set to {}ms via JMX", (Object)timeoutInMillis);
    }

    @Override
    public void evictHungRepairs() {
        logger.info("StorageService#clearPaxosRateLimiters called via jmx");
        Paxos.evictHungRepairs();
    }

    @Override
    public void clearPaxosRepairs() {
        logger.info("StorageService#clearPaxosRepairs called via jmx");
        PaxosTableRepairs.clearRepairs();
    }

    @Override
    public void setSkipPaxosRepairCompatibilityCheck(boolean v) {
        PaxosRepair.setSkipPaxosRepairCompatibilityCheck(v);
        logger.info("SkipPaxosRepairCompatibilityCheck set to {} via jmx", (Object)v);
    }

    @Override
    public boolean getSkipPaxosRepairCompatibilityCheck() {
        return PaxosRepair.getSkipPaxosRepairCompatibilityCheck();
    }

    @Override
    public boolean topPartitionsEnabled() {
        return DatabaseDescriptor.topPartitionsEnabled();
    }

    @Override
    public int getMaxTopSizePartitionCount() {
        return DatabaseDescriptor.getMaxTopSizePartitionCount();
    }

    @Override
    public void setMaxTopSizePartitionCount(int value) {
        DatabaseDescriptor.setMaxTopSizePartitionCount(value);
    }

    @Override
    public int getMaxTopTombstonePartitionCount() {
        return DatabaseDescriptor.getMaxTopTombstonePartitionCount();
    }

    @Override
    public void setMaxTopTombstonePartitionCount(int value) {
        DatabaseDescriptor.setMaxTopTombstonePartitionCount(value);
    }

    @Override
    public String getMinTrackedPartitionSize() {
        return DatabaseDescriptor.getMinTrackedPartitionSizeInBytes().toString();
    }

    @Override
    public void setMinTrackedPartitionSize(String value) {
        DatabaseDescriptor.setMinTrackedPartitionSizeInBytes(StorageService.parseDataStorageSpec(value));
    }

    @Override
    public long getMinTrackedPartitionTombstoneCount() {
        return DatabaseDescriptor.getMinTrackedPartitionTombstoneCount();
    }

    @Override
    public void setMinTrackedPartitionTombstoneCount(long value) {
        DatabaseDescriptor.setMinTrackedPartitionTombstoneCount(value);
    }

    private static class LeavingReplica {
        private final Replica leavingReplica;
        private final Replica ourReplica;

        public LeavingReplica(Replica leavingReplica, Replica ourReplica) {
            Preconditions.checkNotNull((Object)leavingReplica);
            Preconditions.checkNotNull((Object)ourReplica);
            this.leavingReplica = leavingReplica;
            this.ourReplica = ourReplica;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeavingReplica that = (LeavingReplica)o;
            if (!this.leavingReplica.equals(that.leavingReplica)) {
                return false;
            }
            return this.ourReplica.equals(that.ourReplica);
        }

        public int hashCode() {
            int result = this.leavingReplica.hashCode();
            result = 31 * result + this.ourReplica.hashCode();
            return result;
        }

        public String toString() {
            return "LeavingReplica{leavingReplica=" + this.leavingReplica + ", ourReplica=" + this.ourReplica + '}';
        }
    }

    private static enum Mode {
        STARTING,
        NORMAL,
        JOINING,
        LEAVING,
        DECOMMISSIONED,
        MOVING,
        DRAINING,
        DRAINED;

    }
}

