/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.github.jamm.MemoryLayoutSpecification;
import org.github.jamm.MemoryMeter;

public class ObjectSizes {
    private static final MemoryMeter meter = new MemoryMeter().withGuessing(MemoryMeter.Guess.FALLBACK_UNSAFE).ignoreKnownSingletons();
    private static final long EMPTY_HEAP_BUFFER_SIZE = ObjectSizes.measure(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    private static final long EMPTY_BYTE_ARRAY_SIZE = ObjectSizes.measure(new byte[0]);
    private static final long EMPTY_STRING_SIZE = ObjectSizes.measure("");
    private static final long DIRECT_BUFFER_HEAP_SIZE = ObjectSizes.measure(ByteBuffer.allocateDirect(0));

    public static long sizeOfArray(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        return ObjectSizes.sizeOfArray(bytes.length, 1L);
    }

    public static long sizeOfArray(long[] longs) {
        if (longs == null) {
            return 0L;
        }
        return ObjectSizes.sizeOfArray(longs.length, 8L);
    }

    public static long sizeOfArray(int[] ints) {
        if (ints == null) {
            return 0L;
        }
        return ObjectSizes.sizeOfArray(ints.length, 4L);
    }

    public static long sizeOfReferenceArray(int length) {
        return ObjectSizes.sizeOfArray(length, MemoryLayoutSpecification.SPEC.getReferenceSize());
    }

    public static long sizeOfArray(Object[] objects) {
        if (objects == null) {
            return 0L;
        }
        return ObjectSizes.sizeOfReferenceArray(objects.length);
    }

    private static long sizeOfArray(int length, long elementSize) {
        return MemoryLayoutSpecification.sizeOfArray((int)length, (long)elementSize);
    }

    public static long sizeOnHeapOf(ByteBuffer[] array) {
        if (array == null) {
            return 0L;
        }
        long sum = ObjectSizes.sizeOfArray(array);
        for (ByteBuffer buffer : array) {
            sum += ObjectSizes.sizeOnHeapOf(buffer);
        }
        return sum;
    }

    public static long sizeOnHeapExcludingData(ByteBuffer[] array) {
        if (array == null) {
            return 0L;
        }
        long sum = ObjectSizes.sizeOfArray(array);
        for (ByteBuffer b : array) {
            sum += ObjectSizes.sizeOnHeapExcludingData(b);
        }
        return sum;
    }

    public static long sizeOnHeapOf(ByteBuffer buffer) {
        int bufLen;
        if (buffer == null) {
            return 0L;
        }
        if (buffer.isDirect()) {
            return DIRECT_BUFFER_HEAP_SIZE;
        }
        int arrayLen = buffer.array().length;
        if (arrayLen > (bufLen = buffer.remaining())) {
            return EMPTY_HEAP_BUFFER_SIZE + (long)bufLen;
        }
        return EMPTY_HEAP_BUFFER_SIZE + (arrayLen == 0 ? EMPTY_BYTE_ARRAY_SIZE : ObjectSizes.sizeOfArray(arrayLen, 1L));
    }

    public static long sizeOnHeapExcludingData(ByteBuffer buffer) {
        int bufLen;
        if (buffer == null) {
            return 0L;
        }
        if (buffer.isDirect()) {
            return DIRECT_BUFFER_HEAP_SIZE;
        }
        int arrayLen = buffer.array().length;
        if (arrayLen > (bufLen = buffer.remaining())) {
            return EMPTY_HEAP_BUFFER_SIZE;
        }
        return EMPTY_HEAP_BUFFER_SIZE + (arrayLen == 0 ? EMPTY_BYTE_ARRAY_SIZE : ObjectSizes.sizeOfArray(arrayLen, 1L) - (long)arrayLen);
    }

    public static long sizeOf(String str) {
        if (str == null) {
            return 0L;
        }
        return EMPTY_STRING_SIZE + ObjectSizes.sizeOfArray(str.length(), 2L);
    }

    public static long measureDeep(Object pojo) {
        return meter.measureDeep(pojo);
    }

    public static long measure(Object pojo) {
        return meter.measure(pojo);
    }
}

