/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.MapMaker;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.cql3.ReservedKeywords;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ColumnIdentifier
implements IMeasurableMemory,
Comparable<ColumnIdentifier> {
    private static final Pattern PATTERN_DOUBLE_QUOTE = Pattern.compile("\"", 16);
    private static final String ESCAPED_DOUBLE_QUOTE = Matcher.quoteReplacement("\"\"");
    public final ByteBuffer bytes;
    private final String text;
    public final long prefixComparison;
    private final boolean interned;
    private static final Pattern UNQUOTED_IDENTIFIER = Pattern.compile("[a-z][a-z0-9_]*");
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ColumnIdentifier(ByteBufferUtil.EMPTY_BYTE_BUFFER, "", false));
    private static final ConcurrentMap<InternedKey, ColumnIdentifier> internedInstances = new MapMaker().weakValues().makeMap();

    private static long prefixComparison(ByteBuffer bytes) {
        int i;
        long prefix = 0L;
        ByteBuffer read = bytes.duplicate();
        for (i = 0; read.hasRemaining() && i < 8; ++i) {
            prefix <<= 8;
            prefix |= (long)(read.get() & 0xFF);
        }
        prefix <<= (8 - i) * 8;
        return prefix ^= Long.MIN_VALUE;
    }

    public ColumnIdentifier(String rawText, boolean keepCase) {
        this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        this.bytes = ByteBufferUtil.bytes(this.text);
        this.prefixComparison = ColumnIdentifier.prefixComparison(this.bytes);
        this.interned = false;
    }

    public ColumnIdentifier(ByteBuffer bytes, AbstractType<?> type) {
        this(bytes, type.getString(bytes), false);
    }

    public ColumnIdentifier(ByteBuffer bytes, String text) {
        this(bytes, text, false);
    }

    private ColumnIdentifier(ByteBuffer bytes, String text, boolean interned) {
        this.bytes = bytes;
        this.text = text;
        this.interned = interned;
        this.prefixComparison = ColumnIdentifier.prefixComparison(bytes);
    }

    public static ColumnIdentifier getInterned(ByteBuffer bytes, AbstractType<?> type) {
        return ColumnIdentifier.getInterned(type, bytes, type.getString(bytes));
    }

    public static ColumnIdentifier getInterned(String rawText, boolean keepCase) {
        String text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        ByteBuffer bytes = ByteBufferUtil.bytes(text);
        return ColumnIdentifier.getInterned(UTF8Type.instance, bytes, text);
    }

    public static ColumnIdentifier getInterned(AbstractType<?> type, ByteBuffer bytes, String text) {
        InternedKey key = new InternedKey(type, bytes = ByteBufferUtil.minimalBufferFor(bytes));
        ColumnIdentifier id = (ColumnIdentifier)internedInstances.get(key);
        if (id != null) {
            return id;
        }
        ColumnIdentifier created = new ColumnIdentifier(bytes, text, true);
        ColumnIdentifier previous = internedInstances.putIfAbsent(key, created);
        return previous == null ? created : previous;
    }

    public boolean isInterned() {
        return this.interned;
    }

    public final int hashCode() {
        return this.bytes.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier that = (ColumnIdentifier)o;
        return this.bytes.equals(that.bytes);
    }

    public String toString() {
        return this.text;
    }

    public String toCQLString() {
        return ColumnIdentifier.maybeQuote(this.text);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.bytes) + ObjectSizes.sizeOf(this.text);
    }

    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOfEmptyHeapByteBuffer() + ObjectSizes.sizeOf(this.text);
    }

    public ColumnIdentifier clone(AbstractAllocator allocator) {
        return this.interned ? this : new ColumnIdentifier(allocator.clone(this.bytes), this.text, false);
    }

    @Override
    public int compareTo(ColumnIdentifier that) {
        int c = Long.compare(this.prefixComparison, that.prefixComparison);
        if (c != 0) {
            return c;
        }
        if (this == that) {
            return 0;
        }
        return ByteBufferUtil.compareUnsigned(this.bytes, that.bytes);
    }

    public static String maybeQuote(String text) {
        if (UNQUOTED_IDENTIFIER.matcher(text).matches() && !ReservedKeywords.isReserved(text)) {
            return text;
        }
        return '\"' + PATTERN_DOUBLE_QUOTE.matcher(text).replaceAll(ESCAPED_DOUBLE_QUOTE) + '\"';
    }

    private static final class InternedKey {
        private final AbstractType<?> type;
        private final ByteBuffer bytes;

        InternedKey(AbstractType<?> type, ByteBuffer bytes) {
            this.type = type;
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedKey that = (InternedKey)o;
            return this.bytes.equals(that.bytes) && this.type.equals(that.type);
        }

        public int hashCode() {
            return this.bytes.hashCode() + 31 * this.type.hashCode();
        }
    }
}

