/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.exceptions.UnknownTableException;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.SerializableHintMessage;
import org.apache.cassandra.io.IVersionedAsymmetricSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.TrackedDataInputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.UUIDSerializer;

public final class HintMessage
implements SerializableHintMessage {
    public static final IVersionedAsymmetricSerializer<SerializableHintMessage, HintMessage> serializer = new Serializer();
    final UUID hostId;
    @Nullable
    final Hint hint;
    @Nullable
    final TableId unknownTableID;

    HintMessage(UUID hostId, Hint hint) {
        assert (hint != null);
        this.hostId = hostId;
        this.hint = hint;
        this.unknownTableID = null;
    }

    HintMessage(UUID hostId, TableId unknownTableID) {
        this.hostId = hostId;
        this.hint = null;
        this.unknownTableID = unknownTableID;
    }

    static final class Encoded
    implements SerializableHintMessage {
        private final UUID hostId;
        private final ByteBuffer hint;
        private final int version;

        Encoded(UUID hostId, ByteBuffer hint, int version) {
            this.hostId = hostId;
            this.hint = hint;
            this.version = version;
        }

        public long getHintCreationTime() {
            return Hint.serializer.getHintCreationTime(this.hint, this.version);
        }
    }

    public static class Serializer
    implements IVersionedAsymmetricSerializer<SerializableHintMessage, HintMessage> {
        @Override
        public long serializedSize(SerializableHintMessage obj, int version) {
            if (obj instanceof HintMessage) {
                HintMessage message = (HintMessage)obj;
                Objects.requireNonNull(message.hint);
                long size = UUIDSerializer.serializer.serializedSize(message.hostId, version);
                long hintSize = Hint.serializer.serializedSize(message.hint, version);
                size += (long)TypeSizes.sizeofUnsignedVInt(hintSize);
                return size += hintSize;
            }
            if (obj instanceof Encoded) {
                Encoded message = (Encoded)obj;
                if (version != message.version) {
                    throw new IllegalArgumentException("serializedSize() called with non-matching version " + version);
                }
                long size = UUIDSerializer.serializer.serializedSize(message.hostId, version);
                size += (long)TypeSizes.sizeofUnsignedVInt(message.hint.remaining());
                return size += (long)message.hint.remaining();
            }
            throw new IllegalStateException("Unexpected type: " + obj);
        }

        @Override
        public void serialize(SerializableHintMessage obj, DataOutputPlus out, int version) throws IOException {
            if (obj instanceof HintMessage) {
                HintMessage message = (HintMessage)obj;
                Objects.requireNonNull(message.hint);
                UUIDSerializer.serializer.serialize(message.hostId, out, version);
                out.writeUnsignedVInt(Hint.serializer.serializedSize(message.hint, version));
                Hint.serializer.serialize(message.hint, out, version);
            } else if (obj instanceof Encoded) {
                Encoded message = (Encoded)obj;
                if (version != message.version) {
                    throw new IllegalArgumentException("serialize() called with non-matching version " + version);
                }
                UUIDSerializer.serializer.serialize(message.hostId, out, version);
                out.writeUnsignedVInt(message.hint.remaining());
                out.write(message.hint);
            } else {
                throw new IllegalStateException("Unexpected type: " + obj);
            }
        }

        @Override
        public HintMessage deserialize(DataInputPlus in, int version) throws IOException {
            UUID hostId = UUIDSerializer.serializer.deserialize(in, version);
            long hintSize = in.readUnsignedVInt();
            TrackedDataInputPlus countingIn = new TrackedDataInputPlus(in);
            try {
                return new HintMessage(hostId, Hint.serializer.deserialize(countingIn, version));
            }
            catch (UnknownTableException e) {
                in.skipBytes(Ints.checkedCast((long)(hintSize - countingIn.getBytesRead())));
                return new HintMessage(hostId, e.id);
            }
        }
    }
}

