/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InOurDcTester;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.reads.repair.BlockingReadRepairs;
import org.apache.cassandra.service.reads.repair.ReadRepairDiagnostics;
import org.apache.cassandra.tracing.Tracing;

public class BlockingPartitionRepair
extends AbstractFuture<Object>
implements RequestCallback<Object> {
    private final DecoratedKey key;
    private final ReplicaPlan.ForTokenWrite writePlan;
    private final Map<Replica, Mutation> pendingRepairs;
    private final CountDownLatch latch;
    private volatile long mutationsSentTime;

    public BlockingPartitionRepair(DecoratedKey key, Map<Replica, Mutation> repairs, ReplicaPlan.ForTokenWrite writePlan) {
        this.key = key;
        this.pendingRepairs = new ConcurrentHashMap<Replica, Mutation>(repairs);
        this.writePlan = writePlan;
        Preconditions.checkState((boolean)Iterables.all(repairs.keySet(), r -> ((EndpointsForToken)writePlan.contacts()).contains((Replica)r)), (Object)"All repair targets should be part of contacts of read repair write plan.");
        int blockFor = writePlan.blockFor();
        for (Replica participant : (EndpointsForToken)writePlan.contacts()) {
            if (!repairs.containsKey(participant)) {
                --blockFor;
            }
            Preconditions.checkState((!writePlan.consistencyLevel().isDatacenterLocal() || InOurDcTester.replicas().test(participant) ? 1 : 0) != 0, (Object)("Local consistency blocking read repair is trying to contact remote DC node: " + participant.endpoint()));
        }
        this.latch = new CountDownLatch(Math.max(blockFor, 0));
    }

    int blockFor() {
        return this.writePlan.blockFor();
    }

    @VisibleForTesting
    int waitingOn() {
        return (int)this.latch.getCount();
    }

    @VisibleForTesting
    void ack(InetAddressAndPort from) {
        this.pendingRepairs.remove(this.writePlan.lookup(from));
        this.latch.countDown();
    }

    @Override
    public void onResponse(Message<Object> msg) {
        this.ack(msg.from());
    }

    private static PartitionUpdate extractUpdate(Mutation mutation) {
        return (PartitionUpdate)Iterables.getOnlyElement(mutation.getPartitionUpdates());
    }

    private PartitionUpdate mergeUnackedUpdates() {
        ArrayList updates = Lists.newArrayList((Iterable)Iterables.transform(this.pendingRepairs.values(), BlockingPartitionRepair::extractUpdate));
        return updates.isEmpty() ? null : PartitionUpdate.merge(updates);
    }

    @VisibleForTesting
    protected void sendRR(Message<Mutation> message, InetAddressAndPort endpoint) {
        MessagingService.instance().sendWithCallback(message, endpoint, this);
    }

    public void sendInitialRepairs() {
        this.mutationsSentTime = System.nanoTime();
        Replicas.assertFull(this.pendingRepairs.keySet());
        for (Map.Entry<Replica, Mutation> entry : this.pendingRepairs.entrySet()) {
            Replica destination = entry.getKey();
            Preconditions.checkArgument((boolean)destination.isFull(), (String)"Can't send repairs to transient replicas: %s", (Object)destination);
            Mutation mutation = entry.getValue();
            TableId tableId = BlockingPartitionRepair.extractUpdate((Mutation)mutation).metadata().id;
            Tracing.trace("Sending read-repair-mutation to {}", (Object)destination);
            this.sendRR(Message.out(Verb.READ_REPAIR_REQ, mutation), destination.endpoint());
            ColumnFamilyStore.metricsFor((TableId)tableId).readRepairRequests.mark();
            ReadRepairDiagnostics.sendInitialRepair(this, destination.endpoint(), mutation);
        }
    }

    public boolean awaitRepairsUntil(long timeoutAt, TimeUnit timeUnit) {
        long timeoutAtNanos = timeUnit.toNanos(timeoutAt);
        long remaining = timeoutAtNanos - System.nanoTime();
        try {
            return this.latch.await(remaining, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static int msgVersionIdx(int version) {
        return version - 10;
    }

    public void maybeSendAdditionalWrites(long timeout, TimeUnit timeoutUnit) {
        EndpointsForToken newCandidates;
        if (this.awaitRepairsUntil(timeout + timeoutUnit.convert(this.mutationsSentTime, TimeUnit.NANOSECONDS), timeoutUnit)) {
            return;
        }
        EndpointsForToken endpointsForToken = newCandidates = this.writePlan.consistencyLevel().isDatacenterLocal() ? (EndpointsForToken)((EndpointsForToken)this.writePlan.liveUncontacted()).filter((Predicate)InOurDcTester.replicas()) : (EndpointsForToken)this.writePlan.liveUncontacted();
        if (newCandidates.isEmpty()) {
            return;
        }
        PartitionUpdate update = this.mergeUnackedUpdates();
        if (update == null) {
            return;
        }
        ReadRepairMetrics.speculatedWrite.mark();
        Mutation[] versionedMutations = new Mutation[BlockingPartitionRepair.msgVersionIdx(12) + 1];
        for (Replica replica : newCandidates) {
            int versionIdx = BlockingPartitionRepair.msgVersionIdx(MessagingService.instance().versions.get(replica.endpoint()));
            Mutation mutation = versionedMutations[versionIdx];
            if (mutation == null) {
                versionedMutations[versionIdx] = mutation = BlockingReadRepairs.createRepairMutation(update, this.writePlan.consistencyLevel(), replica.endpoint(), true);
            }
            if (mutation == null) {
                ReadRepairDiagnostics.speculatedWriteOversized(this, replica.endpoint());
                continue;
            }
            Tracing.trace("Sending speculative read-repair-mutation to {}", (Object)replica);
            this.sendRR(Message.out(Verb.READ_REPAIR_REQ, mutation), replica.endpoint());
            ReadRepairDiagnostics.speculatedWrite(this, replica.endpoint(), mutation);
        }
    }

    Keyspace getKeyspace() {
        return this.writePlan.keyspace();
    }

    DecoratedKey getKey() {
        return this.key;
    }

    ConsistencyLevel getConsistency() {
        return this.writePlan.consistencyLevel();
    }
}

