/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;

public final class GossiperEvent
extends DiagnosticEvent {
    private final InetAddressAndPort endpoint;
    @Nullable
    private final Long quarantineExpiration;
    @Nullable
    private final EndpointState localState;
    private final Map<InetAddressAndPort, EndpointState> endpointStateMap;
    private final boolean inShadowRound;
    private final Map<InetAddressAndPort, Long> justRemovedEndpoints;
    private final long lastProcessedMessageAt;
    private final Set<InetAddressAndPort> liveEndpoints;
    private final List<String> seeds;
    private final Set<InetAddressAndPort> seedsInShadowRound;
    private final Map<InetAddressAndPort, Long> unreachableEndpoints;
    public GossiperEventType type;

    GossiperEvent(GossiperEventType type, Gossiper gossiper, InetAddressAndPort endpoint, @Nullable Long quarantineExpiration, @Nullable EndpointState localState) {
        this.type = type;
        this.endpoint = endpoint;
        this.quarantineExpiration = quarantineExpiration;
        this.localState = localState;
        this.endpointStateMap = gossiper.getEndpointStateMap();
        this.inShadowRound = gossiper.isInShadowRound();
        this.justRemovedEndpoints = gossiper.getJustRemovedEndpoints();
        this.lastProcessedMessageAt = gossiper.getLastProcessedMessageAt();
        this.liveEndpoints = gossiper.getLiveMembers();
        this.seeds = gossiper.getSeeds();
        this.seedsInShadowRound = gossiper.getSeedsInShadowRound();
        this.unreachableEndpoints = gossiper.getUnreachableEndpoints();
    }

    public Enum<GossiperEventType> getType() {
        return this.type;
    }

    public HashMap<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (this.endpoint != null) {
            ret.put("endpoint", (Serializable)((Object)this.endpoint.getHostAddressAndPort()));
        }
        ret.put("quarantineExpiration", this.quarantineExpiration);
        ret.put("localState", (Serializable)((Object)String.valueOf(this.localState)));
        ret.put("endpointStateMap", (Serializable)((Object)String.valueOf(this.endpointStateMap)));
        ret.put("inShadowRound", Boolean.valueOf(this.inShadowRound));
        ret.put("justRemovedEndpoints", (Serializable)((Object)String.valueOf(this.justRemovedEndpoints)));
        ret.put("lastProcessedMessageAt", Long.valueOf(this.lastProcessedMessageAt));
        ret.put("liveEndpoints", (Serializable)((Object)String.valueOf(this.liveEndpoints)));
        ret.put("seeds", (Serializable)((Object)String.valueOf(this.seeds)));
        ret.put("seedsInShadowRound", (Serializable)((Object)String.valueOf(this.seedsInShadowRound)));
        ret.put("unreachableEndpoints", (Serializable)((Object)String.valueOf(this.unreachableEndpoints)));
        return ret;
    }

    public static enum GossiperEventType {
        MARKED_AS_SHUTDOWN,
        CONVICTED,
        REPLACEMENT_QUARANTINE,
        REPLACED_ENDPOINT,
        EVICTED_FROM_MEMBERSHIP,
        REMOVED_ENDPOINT,
        QUARANTINED_ENDPOINT,
        MARKED_ALIVE,
        REAL_MARKED_ALIVE,
        MARKED_DEAD,
        MAJOR_STATE_CHANGE_HANDLED,
        SEND_GOSSIP_DIGEST_SYN;

    }
}

