/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.selection.CollectionFactory;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

final class TupleSelector
extends Selector {
    private final AbstractType<?> type;
    private final List<Selector> elements;

    public static Selector.Factory newFactory(final AbstractType<?> type, final SelectorFactories factories) {
        return new CollectionFactory(type, factories){

            @Override
            protected String getColumnName() {
                return Tuples.tupleToString(factories, Selector.Factory::getColumnName);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new TupleSelector(type, factories.newInstances(options));
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).addFetchedColumns(builder);
        }
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).addInput(protocolVersion, rs);
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        ByteBuffer[] buffers = new ByteBuffer[this.elements.size()];
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            buffers[i] = this.elements.get(i).getOutput(protocolVersion);
        }
        return TupleType.buildValue(buffers);
    }

    @Override
    public void reset() {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            this.elements.get(i).reset();
        }
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return Tuples.tupleToString(this.elements);
    }

    private TupleSelector(AbstractType<?> type, List<Selector> elements) {
        this.type = type;
        this.elements = elements;
    }
}

