/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.BatchUpdatesCollector;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.QualifiedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SingleTableUpdatesCollector;
import org.apache.cassandra.cql3.statements.UpdatesCollector;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.metrics.BatchMetrics;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class BatchStatement
implements CQLStatement {
    public final Type type;
    private final VariableSpecifications bindVariables;
    private final List<ModificationStatement> statements;
    private final Map<TableId, RegularAndStaticColumns> updatedColumns;
    private final RegularAndStaticColumns conditionColumns;
    private final boolean updatesRegularRows;
    private final boolean updatesStaticRow;
    private final Attributes attrs;
    private final boolean hasConditions;
    private final boolean updatesVirtualTables;
    private static final Logger logger = LoggerFactory.getLogger(BatchStatement.class);
    private static final String UNLOGGED_BATCH_WARNING = "Unlogged batch covering {} partitions detected against table{} {}. You should use a logged batch for atomicity, or asynchronous writes for performance.";
    private static final String LOGGED_BATCH_LOW_GCGS_WARNING = "Executing a LOGGED BATCH on table{} {}, configured with a gc_grace_seconds of 0. The gc_grace_seconds is used to TTL batchlog entries, so setting gc_grace_seconds too low on tables involved in an atomic batch might cause batchlog entries to expire before being replayed.";
    public static final BatchMetrics metrics = new BatchMetrics();

    public BatchStatement(Type type, VariableSpecifications bindVariables, List<ModificationStatement> statements, Attributes attrs) {
        this.type = type;
        this.bindVariables = bindVariables;
        this.statements = statements;
        this.attrs = attrs;
        boolean hasConditions = false;
        MultiTableColumnsBuilder regularBuilder = new MultiTableColumnsBuilder();
        RegularAndStaticColumns.Builder conditionBuilder = RegularAndStaticColumns.builder();
        boolean updateRegular = false;
        boolean updateStatic = false;
        boolean updatesVirtualTables = false;
        for (ModificationStatement stmt : statements) {
            regularBuilder.addAll(stmt.metadata(), stmt.updatedColumns());
            updateRegular |= stmt.updatesRegularRows();
            updatesVirtualTables |= stmt.isVirtual();
            if (!stmt.hasConditions()) continue;
            hasConditions = true;
            conditionBuilder.addAll(stmt.conditionColumns());
            updateStatic |= stmt.updatesStaticRow();
        }
        this.updatedColumns = regularBuilder.build();
        this.conditionColumns = conditionBuilder.build();
        this.updatesRegularRows = updateRegular;
        this.updatesStaticRow = updateStatic;
        this.hasConditions = hasConditions;
        this.updatesVirtualTables = updatesVirtualTables;
    }

    @Override
    public List<ColumnSpecification> getBindVariables() {
        return this.bindVariables.getBindVariables();
    }

    @Override
    public short[] getPartitionKeyBindVariableIndexes() {
        boolean affectsMultipleTables = !this.statements.isEmpty() && !this.statements.stream().map(s -> s.metadata().id).allMatch(Predicate.isEqual(this.statements.get((int)0).metadata().id));
        return affectsMultipleTables || this.statements.isEmpty() ? null : this.bindVariables.getPartitionKeyBindVariableIndexes(this.statements.get(0).metadata());
    }

    @Override
    public Iterable<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (ModificationStatement statement : this.statements) {
            statement.addFunctionsTo(functions);
        }
        return functions;
    }

    @Override
    public void authorize(ClientState state) throws InvalidRequestException, UnauthorizedException {
        for (ModificationStatement statement : this.statements) {
            statement.authorize(state);
        }
    }

    public void validate() throws InvalidRequestException {
        if (this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        boolean timestampSet = this.attrs.isTimestampSet();
        if (timestampSet) {
            if (this.hasConditions) {
                throw new InvalidRequestException("Cannot provide custom timestamp for conditional BATCH");
            }
            if (this.isCounter()) {
                throw new InvalidRequestException("Cannot provide custom timestamp for counter BATCH");
            }
        }
        boolean hasCounters = false;
        boolean hasNonCounters = false;
        boolean hasVirtualTables = false;
        boolean hasRegularTables = false;
        for (ModificationStatement statement : this.statements) {
            if (timestampSet && statement.isTimestampSet()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (statement.isCounter()) {
                hasCounters = true;
            } else {
                hasNonCounters = true;
            }
            if (statement.isVirtual()) {
                hasVirtualTables = true;
                continue;
            }
            hasRegularTables = true;
        }
        if (timestampSet && hasCounters) {
            throw new InvalidRequestException("Cannot provide custom timestamp for a BATCH containing counters");
        }
        if (this.isCounter() && hasNonCounters) {
            throw new InvalidRequestException("Cannot include non-counter statement in a counter batch");
        }
        if (hasCounters && hasNonCounters) {
            throw new InvalidRequestException("Counter and non-counter mutations cannot exist in the same batch");
        }
        if (this.isLogged() && hasCounters) {
            throw new InvalidRequestException("Cannot include a counter statement in a logged batch");
        }
        if (this.isLogged() && hasVirtualTables) {
            throw new InvalidRequestException("Cannot include a virtual table statement in a logged batch");
        }
        if (hasVirtualTables && hasRegularTables) {
            throw new InvalidRequestException("Mutations for virtual and regular tables cannot exist in the same batch");
        }
        if (this.hasConditions && hasVirtualTables) {
            throw new InvalidRequestException("Conditional BATCH statements cannot include mutations for virtual tables");
        }
        if (this.hasConditions) {
            String ksName = null;
            String cfName = null;
            for (ModificationStatement stmt : this.statements) {
                if (!(ksName == null || stmt.keyspace().equals(ksName) && stmt.columnFamily().equals(cfName))) {
                    throw new InvalidRequestException("Batch with conditions cannot span multiple tables");
                }
                ksName = stmt.keyspace();
                cfName = stmt.columnFamily();
            }
        }
    }

    private boolean isCounter() {
        return this.type == Type.COUNTER;
    }

    private boolean isLogged() {
        return this.type == Type.LOGGED;
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.validate(state);
        }
    }

    public List<ModificationStatement> getStatements() {
        return this.statements;
    }

    @VisibleForTesting
    public List<? extends IMutation> getMutations(BatchQueryOptions options, boolean local, long batchTimestamp, int nowInSeconds, long queryStartNanoTime) {
        if (this.statements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<ByteBuffer>> partitionKeys = new ArrayList<List<ByteBuffer>>(this.statements.size());
        HashMap<TableId, HashMultiset<ByteBuffer>> partitionCounts = new HashMap<TableId, HashMultiset<ByteBuffer>>(this.updatedColumns.size());
        TableMetadata metadata = this.statements.get((int)0).metadata;
        int isize = this.statements.size();
        for (int i = 0; i < isize; ++i) {
            ModificationStatement stmt = this.statements.get(i);
            if (metadata != null && !stmt.metadata.id.equals(metadata.id)) {
                metadata = null;
            }
            List<ByteBuffer> stmtPartitionKeys = stmt.buildPartitionKeyNames(options.forStatement(i));
            partitionKeys.add(stmtPartitionKeys);
            HashMultiset perKeyCountsForTable = partitionCounts.computeIfAbsent(stmt.metadata.id, k -> HashMultiset.create());
            int stmtSize = stmtPartitionKeys.size();
            for (int stmtIdx = 0; stmtIdx < stmtSize; ++stmtIdx) {
                perKeyCountsForTable.add((Object)stmtPartitionKeys.get(stmtIdx));
            }
        }
        HashSet<String> tablesWithZeroGcGs = null;
        UpdatesCollector collector = metadata != null ? new SingleTableUpdatesCollector(metadata, this.updatedColumns.get(metadata.id), (HashMultiset<ByteBuffer>)((HashMultiset)partitionCounts.get(metadata.id))) : new BatchUpdatesCollector(this.updatedColumns, partitionCounts);
        int isize2 = this.statements.size();
        for (int i = 0; i < isize2; ++i) {
            ModificationStatement statement = this.statements.get(i);
            if (this.isLogged() && statement.metadata().params.gcGraceSeconds == 0) {
                if (tablesWithZeroGcGs == null) {
                    tablesWithZeroGcGs = new HashSet<String>();
                }
                tablesWithZeroGcGs.add(statement.metadata.toString());
            }
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(batchTimestamp, statementOptions);
            statement.addUpdates(collector, (List)partitionKeys.get(i), statementOptions, local, timestamp, nowInSeconds, queryStartNanoTime);
        }
        if (tablesWithZeroGcGs != null) {
            String suffix = tablesWithZeroGcGs.size() == 1 ? "" : "s";
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, LOGGED_BATCH_LOW_GCGS_WARNING, suffix, tablesWithZeroGcGs);
            ClientWarn.instance.warn(MessageFormatter.arrayFormat((String)LOGGED_BATCH_LOW_GCGS_WARNING, (Object[])new Object[]{suffix, tablesWithZeroGcGs}).getMessage());
        }
        return collector.toMutations();
    }

    private static void verifyBatchSize(Collection<? extends IMutation> mutations) throws InvalidRequestException {
        if (mutations.size() <= 1) {
            return;
        }
        long warnThreshold = DatabaseDescriptor.getBatchSizeWarnThreshold();
        long size = IMutation.dataSize(mutations);
        if (size > warnThreshold) {
            HashSet<String> tableNames = new HashSet<String>();
            for (IMutation iMutation : mutations) {
                for (PartitionUpdate update : iMutation.getPartitionUpdates()) {
                    tableNames.add(update.metadata().toString());
                }
            }
            long failThreshold = DatabaseDescriptor.getBatchSizeFailThreshold();
            String format = "Batch for {} is of size {}, exceeding specified threshold of {} by {}.{}";
            if (size > failThreshold) {
                Tracing.trace(format, tableNames, FBUtilities.prettyPrintMemory(size), FBUtilities.prettyPrintMemory(failThreshold), FBUtilities.prettyPrintMemory(size - failThreshold), " (see batch_size_fail_threshold_in_kb)");
                logger.error(format, new Object[]{tableNames, FBUtilities.prettyPrintMemory(size), FBUtilities.prettyPrintMemory(failThreshold), FBUtilities.prettyPrintMemory(size - failThreshold), " (see batch_size_fail_threshold_in_kb)"});
                throw new InvalidRequestException("Batch too large");
            }
            if (logger.isWarnEnabled()) {
                logger.warn(format, new Object[]{tableNames, FBUtilities.prettyPrintMemory(size), FBUtilities.prettyPrintMemory(warnThreshold), FBUtilities.prettyPrintMemory(size - warnThreshold), ""});
            }
            ClientWarn.instance.warn(MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{tableNames, size, warnThreshold, size - warnThreshold, ""}).getMessage());
        }
    }

    private void verifyBatchType(Collection<? extends IMutation> mutations) {
        if (!this.isLogged() && mutations.size() > 1) {
            HashSet<DecoratedKey> keySet = new HashSet<DecoratedKey>();
            HashSet<String> tableNames = new HashSet<String>();
            for (IMutation iMutation : mutations) {
                for (PartitionUpdate update : iMutation.getPartitionUpdates()) {
                    keySet.add(update.partitionKey());
                    tableNames.add(update.metadata().toString());
                }
            }
            if (keySet.size() > DatabaseDescriptor.getUnloggedBatchAcrossPartitionsWarnThreshold()) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, UNLOGGED_BATCH_WARNING, keySet.size(), tableNames.size() == 1 ? "" : "s", tableNames);
                ClientWarn.instance.warn(MessageFormatter.arrayFormat((String)UNLOGGED_BATCH_WARNING, (Object[])new Object[]{keySet.size(), tableNames.size() == 1 ? "" : "s", tableNames}).getMessage());
            }
        }
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options, long queryStartNanoTime) {
        return this.execute(queryState, BatchQueryOptions.withoutPerStatementVariables(options), queryStartNanoTime);
    }

    public ResultMessage execute(QueryState queryState, BatchQueryOptions options, long queryStartNanoTime) {
        long timestamp = options.getTimestamp(queryState);
        int nowInSeconds = options.getNowInSeconds(queryState);
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (options.getSerialConsistency() == null) {
            throw new InvalidRequestException("Invalid empty serial consistency level");
        }
        if (this.hasConditions) {
            return this.executeWithConditions(options, queryState, queryStartNanoTime);
        }
        if (this.updatesVirtualTables) {
            this.executeInternalWithoutCondition(queryState, options, queryStartNanoTime);
        } else {
            this.executeWithoutConditions(this.getMutations(options, false, timestamp, nowInSeconds, queryStartNanoTime), options.getConsistency(), queryStartNanoTime);
        }
        return new ResultMessage.Void();
    }

    private void executeWithoutConditions(List<? extends IMutation> mutations, ConsistencyLevel cl, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        if (mutations.isEmpty()) {
            return;
        }
        BatchStatement.verifyBatchSize(mutations);
        this.verifyBatchType(mutations);
        this.updatePartitionsPerBatchMetrics(mutations.size());
        boolean mutateAtomic = this.isLogged() && mutations.size() > 1;
        StorageProxy.mutateWithTriggers(mutations, cl, mutateAtomic, queryStartNanoTime);
    }

    private void updatePartitionsPerBatchMetrics(int updatedPartitions) {
        if (this.isLogged()) {
            BatchStatement.metrics.partitionsPerLoggedBatch.update(updatedPartitions);
        } else if (this.isCounter()) {
            BatchStatement.metrics.partitionsPerCounterBatch.update(updatedPartitions);
        } else {
            BatchStatement.metrics.partitionsPerUnloggedBatch.update(updatedPartitions);
        }
    }

    private ResultMessage executeWithConditions(BatchQueryOptions options, QueryState state, long queryStartNanoTime) {
        Pair<CQL3CasRequest, Set<ColumnMetadata>> p = this.makeCasRequest(options, state);
        CQL3CasRequest casRequest = (CQL3CasRequest)p.left;
        Set columnsWithConditions = (Set)p.right;
        String ksName = casRequest.metadata.keyspace;
        String tableName = casRequest.metadata.name;
        try (RowIterator result = StorageProxy.cas(ksName, tableName, casRequest.key, casRequest, options.getSerialConsistency(), options.getConsistency(), state.getClientState(), options.getNowInSeconds(state), queryStartNanoTime);){
            ResultMessage.Rows rows = new ResultMessage.Rows(ModificationStatement.buildCasResultSet(ksName, tableName, result, columnsWithConditions, true, state, options.forStatement(0)));
            return rows;
        }
    }

    private Pair<CQL3CasRequest, Set<ColumnMetadata>> makeCasRequest(BatchQueryOptions options, QueryState state) {
        long batchTimestamp = options.getTimestamp(state);
        int nowInSeconds = options.getNowInSeconds(state);
        DecoratedKey key = null;
        CQL3CasRequest casRequest = null;
        LinkedHashSet columnsWithConditions = new LinkedHashSet();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(batchTimestamp, statementOptions);
            List<ByteBuffer> pks = statement.buildPartitionKeyNames(statementOptions);
            if (statement.getRestrictions().keyIsInRelation()) {
                throw new IllegalArgumentException("Batch with conditions cannot span multiple partitions (you cannot use IN on the partition key)");
            }
            if (key == null) {
                key = statement.metadata().partitioner.decorateKey(pks.get(0));
                casRequest = new CQL3CasRequest(statement.metadata(), key, this.conditionColumns, this.updatesRegularRows, this.updatesStaticRow);
            } else if (!key.getKey().equals(pks.get(0))) {
                throw new InvalidRequestException("Batch with conditions cannot span multiple partitions");
            }
            RequestValidations.checkFalse(statement.getRestrictions().clusteringKeyRestrictionsHasIN(), "IN on the clustering key columns is not supported with conditional %s", statement.type.isUpdate() ? "updates" : "deletions");
            if (statement.hasSlices()) {
                assert (!statement.hasConditions());
                Slices slices = statement.createSlices(statementOptions);
                if (slices.isEmpty()) continue;
                for (Slice slice : slices) {
                    casRequest.addRangeDeletion(slice, statement, statementOptions, timestamp, nowInSeconds);
                }
                continue;
            }
            Clustering clustering = (Clustering)Iterables.getOnlyElement(statement.createClustering(statementOptions));
            if (statement.hasConditions()) {
                statement.addConditions(clustering, casRequest, statementOptions);
                if (statement.hasIfNotExistCondition() || statement.hasIfExistCondition()) {
                    columnsWithConditions = null;
                } else if (columnsWithConditions != null) {
                    Iterables.addAll(columnsWithConditions, statement.getColumnsWithConditions());
                }
            }
            casRequest.addRowUpdate(clustering, statement, statementOptions, timestamp, nowInSeconds);
        }
        return Pair.create(casRequest, columnsWithConditions);
    }

    @Override
    public boolean hasConditions() {
        return this.hasConditions;
    }

    @Override
    public ResultMessage executeLocally(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        BatchQueryOptions batchOptions = BatchQueryOptions.withoutPerStatementVariables(options);
        if (this.hasConditions) {
            return this.executeInternalWithConditions(batchOptions, queryState);
        }
        this.executeInternalWithoutCondition(queryState, batchOptions, System.nanoTime());
        return new ResultMessage.Void();
    }

    private ResultMessage executeInternalWithoutCondition(QueryState queryState, BatchQueryOptions batchOptions, long queryStartNanoTime) {
        long timestamp = batchOptions.getTimestamp(queryState);
        int nowInSeconds = batchOptions.getNowInSeconds(queryState);
        for (IMutation iMutation : this.getMutations(batchOptions, true, timestamp, nowInSeconds, queryStartNanoTime)) {
            iMutation.apply();
        }
        return null;
    }

    private ResultMessage executeInternalWithConditions(BatchQueryOptions options, QueryState state) {
        Pair<CQL3CasRequest, Set<ColumnMetadata>> p = this.makeCasRequest(options, state);
        CQL3CasRequest request = (CQL3CasRequest)p.left;
        Set columnsWithConditions = (Set)p.right;
        String ksName = request.metadata.keyspace;
        String tableName = request.metadata.name;
        long timestamp = options.getTimestamp(state);
        int nowInSeconds = options.getNowInSeconds(state);
        try (RowIterator result = ModificationStatement.casInternal(request, timestamp, nowInSeconds);){
            ResultSet resultSet = ModificationStatement.buildCasResultSet(ksName, tableName, result, columnsWithConditions, true, state, options.forStatement(0));
            ResultMessage.Rows rows = new ResultMessage.Rows(resultSet);
            return rows;
        }
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.BATCH);
    }

    private static class MultiTableColumnsBuilder {
        private final Map<TableId, RegularAndStaticColumns.Builder> perTableBuilders = new HashMap<TableId, RegularAndStaticColumns.Builder>();

        private MultiTableColumnsBuilder() {
        }

        public void addAll(TableMetadata table, RegularAndStaticColumns columns) {
            RegularAndStaticColumns.Builder builder = this.perTableBuilders.get(table.id);
            if (builder == null) {
                builder = RegularAndStaticColumns.builder();
                this.perTableBuilders.put(table.id, builder);
            }
            builder.addAll(columns);
        }

        public Map<TableId, RegularAndStaticColumns> build() {
            HashMap m = Maps.newHashMapWithExpectedSize((int)this.perTableBuilders.size());
            for (Map.Entry<TableId, RegularAndStaticColumns.Builder> p : this.perTableBuilders.entrySet()) {
                m.put(p.getKey(), p.getValue().build());
            }
            return m;
        }
    }

    public static class Parsed
    extends QualifiedStatement {
        private final Type type;
        private final Attributes.Raw attrs;
        private final List<ModificationStatement.Parsed> parsedStatements;

        public Parsed(Type type, Attributes.Raw attrs, List<ModificationStatement.Parsed> parsedStatements) {
            super(null);
            this.type = type;
            this.attrs = attrs;
            this.parsedStatements = parsedStatements;
        }

        @Override
        public void setKeyspace(ClientState state) throws InvalidRequestException {
            for (ModificationStatement.Parsed statement : this.parsedStatements) {
                statement.setKeyspace(state);
            }
        }

        @Override
        public BatchStatement prepare(ClientState state) {
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.parsedStatements.size());
            this.parsedStatements.forEach(s -> statements.add(s.prepare(this.bindVariables)));
            Attributes prepAttrs = this.attrs.prepare("[batch]", "[batch]");
            prepAttrs.collectMarkerSpecification(this.bindVariables);
            BatchStatement batchStatement = new BatchStatement(this.type, this.bindVariables, statements, prepAttrs);
            batchStatement.validate();
            return batchStatement;
        }
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

