/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.transport.CQLMessageHandler;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlers {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlers.class);

    public static ChannelInboundHandlerAdapter postV5Handler(FrameEncoder.PayloadAllocator allocator, ProtocolVersion version) {
        return new PostV5ExceptionHandler(allocator, version);
    }

    static final class UnexpectedChannelExceptionHandler
    implements Predicate<Throwable> {
        private static final Set<String> ioExceptionsAtDebugLevel = ImmutableSet.builder().add((Object)"Connection reset by peer").add((Object)"Broken pipe").add((Object)"Connection timed out").build();
        private final Channel channel;
        private final boolean alwaysLogAtError;

        UnexpectedChannelExceptionHandler(Channel channel, boolean alwaysLogAtError) {
            this.channel = channel;
            this.alwaysLogAtError = alwaysLogAtError;
        }

        public boolean apply(Throwable exception) {
            String message;
            try {
                message = "Unexpected exception during request; channel = " + this.channel;
            }
            catch (Exception ignore) {
                message = "Unexpected exception during request; channel = <unprintable>";
            }
            if (!this.alwaysLogAtError && (exception instanceof IOException || exception.getCause() instanceof IOException)) {
                String errorMessage = exception.getMessage();
                boolean logAtTrace = false;
                for (String ioException : ioExceptionsAtDebugLevel) {
                    if (!errorMessage.contains(ioException)) continue;
                    logAtTrace = true;
                    break;
                }
                if (logAtTrace) {
                    logger.trace(message, exception);
                } else {
                    logger.info(message, exception);
                }
            } else {
                logger.error(message, exception);
            }
            return true;
        }
    }

    private static final class PostV5ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private final FrameEncoder.PayloadAllocator allocator;
        private final ProtocolVersion version;

        public PostV5ExceptionHandler(FrameEncoder.PayloadAllocator allocator, ProtocolVersion version) {
            this.allocator = allocator;
            this.version = version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            UnexpectedChannelExceptionHandler handler = new UnexpectedChannelExceptionHandler(ctx.channel(), false);
            if (ctx.channel().isOpen()) {
                ErrorMessage errorMessage = ErrorMessage.fromException(cause, handler);
                Envelope response = errorMessage.encode(this.version);
                FrameEncoder.Payload payload = this.allocator.allocate(true, CQLMessageHandler.envelopeSize(response.header));
                try {
                    response.encodeInto(payload.buffer);
                    response.release();
                    payload.finish();
                    ChannelPromise promise = ctx.newPromise();
                    if (cause instanceof ProtocolException) {
                        promise.addListener(future -> ctx.close());
                    }
                    ctx.writeAndFlush((Object)payload, promise);
                }
                finally {
                    payload.release();
                    JVMStabilityInspector.inspectThrowable(cause);
                }
            }
        }
    }
}

