/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.ArrayListMultimap;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStatWithPort;
import org.apache.cassandra.tools.nodetool.SetHostStatWithPort;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="status", description="Print cluster information (state, load, IDs, ...)")
public class Status
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace>]", description="The keyspace name")
    private String keyspace = null;
    @Option(title="resolve_ip", name={"-r", "--resolve-ip"}, description="Show node domain names instead of IPs")
    private boolean resolveIp = false;
    private boolean isTokenPerNode = true;
    private Collection<String> joiningNodes;
    private Collection<String> leavingNodes;
    private Collection<String> movingNodes;
    private Collection<String> liveNodes;
    private Collection<String> unreachableNodes;
    private Map<String, String> loadMap;
    private Map<String, String> hostIDMap;
    private EndpointSnitchInfoMBean epSnitchInfo;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        this.joiningNodes = probe.getJoiningNodes(this.printPort);
        this.leavingNodes = probe.getLeavingNodes(this.printPort);
        this.movingNodes = probe.getMovingNodes(this.printPort);
        this.loadMap = probe.getLoadMap(this.printPort);
        Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap(this.printPort);
        this.liveNodes = probe.getLiveNodes(this.printPort);
        this.unreachableNodes = probe.getUnreachableNodes(this.printPort);
        this.hostIDMap = probe.getHostIdMap(this.printPort);
        this.epSnitchInfo = probe.getEndpointSnitchInfoProxy();
        StringBuilder errors = new StringBuilder();
        TableBuilder.SharedTable sharedTable = new TableBuilder.SharedTable("  ");
        Map<String, Float> ownerships = null;
        boolean hasEffectiveOwns = false;
        try {
            ownerships = probe.effectiveOwnershipWithPort(this.keyspace);
            hasEffectiveOwns = true;
        }
        catch (IllegalStateException e) {
            ownerships = probe.getOwnershipWithPort();
            errors.append("Note: ").append(e.getMessage()).append("%n");
        }
        catch (IllegalArgumentException ex) {
            out.printf("%nError: %s%n", ex.getMessage());
            System.exit(1);
        }
        SortedMap<String, SetHostStatWithPort> dcs = NodeTool.getOwnershipByDcWithPort(probe, this.resolveIp, tokensToEndpoints, ownerships);
        if (dcs.size() < tokensToEndpoints.size()) {
            this.isTokenPerNode = false;
        }
        for (Map.Entry<String, SetHostStatWithPort> dc : dcs.entrySet()) {
            TableBuilder tableBuilder = sharedTable.next();
            this.addNodesHeader(hasEffectiveOwns, tableBuilder);
            ArrayListMultimap hostToTokens = ArrayListMultimap.create();
            for (HostStatWithPort stat : dc.getValue()) {
                hostToTokens.put((Object)stat.ipOrDns(this.printPort), (Object)stat);
            }
            for (String endpoint : hostToTokens.keySet()) {
                Float owns = ownerships.get(endpoint);
                List tokens = hostToTokens.get((Object)endpoint);
                this.addNode(endpoint, owns, ((HostStatWithPort)tokens.get(0)).ipOrDns(this.printPort), ((HostStatWithPort)tokens.get((int)0)).token, tokens.size(), hasEffectiveOwns, tableBuilder);
            }
        }
        Iterator<TableBuilder> results = sharedTable.complete().iterator();
        boolean first = true;
        for (Map.Entry<String, SetHostStatWithPort> dc : dcs.entrySet()) {
            if (!first) {
                out.println();
            }
            first = false;
            String dcHeader = String.format("Datacenter: %s%n", dc.getKey());
            out.print(dcHeader);
            for (int i = 0; i < dcHeader.length() - 1; ++i) {
                out.print('=');
            }
            out.println();
            out.println("Status=Up/Down");
            out.println("|/ State=Normal/Leaving/Joining/Moving");
            TableBuilder dcTable = results.next();
            dcTable.printTo(out);
        }
        out.printf("%n" + errors, new Object[0]);
    }

    private void addNodesHeader(boolean hasEffectiveOwns, TableBuilder tableBuilder) {
        String owns;
        String string = owns = hasEffectiveOwns ? "Owns (effective)" : "Owns";
        if (this.isTokenPerNode) {
            tableBuilder.add("--", "Address", "Load", owns, "Host ID", "Token", "Rack");
        } else {
            tableBuilder.add("--", "Address", "Load", "Tokens", owns, "Host ID", "Rack");
        }
    }

    private void addNode(String endpoint, Float owns, String epDns, String token, int size, boolean hasEffectiveOwns, TableBuilder tableBuilder) {
        String rack;
        String status = this.liveNodes.contains(endpoint) ? "U" : (this.unreachableNodes.contains(endpoint) ? "D" : "?");
        String state = this.joiningNodes.contains(endpoint) ? "J" : (this.leavingNodes.contains(endpoint) ? "L" : (this.movingNodes.contains(endpoint) ? "M" : "N"));
        String statusAndState = status.concat(state);
        String load = this.loadMap.getOrDefault(endpoint, "?");
        String strOwns = owns != null && hasEffectiveOwns ? new DecimalFormat("##0.0%").format(owns) : "?";
        String hostID = this.hostIDMap.get(endpoint);
        try {
            rack = this.epSnitchInfo.getRack(endpoint);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (this.isTokenPerNode) {
            tableBuilder.add(statusAndState, epDns, load, strOwns, hostID, token, rack);
        } else {
            tableBuilder.add(statusAndState, epDns, load, String.valueOf(size), strOwns, hostID, rack);
        }
    }
}

