/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class ResourceLimits {

    public static enum Outcome {
        SUCCESS,
        INSUFFICIENT_ENDPOINT,
        INSUFFICIENT_GLOBAL,
        BELOW_LIMIT,
        ABOVE_LIMIT;

    }

    public static class EndpointAndGlobal {
        final Limit endpoint;
        final Limit global;

        public EndpointAndGlobal(Limit endpoint, Limit global) {
            this.endpoint = endpoint;
            this.global = global;
        }

        public Limit endpoint() {
            return this.endpoint;
        }

        public Limit global() {
            return this.global;
        }

        public Outcome tryAllocate(long amount) {
            if (!this.global.tryAllocate(amount)) {
                return Outcome.INSUFFICIENT_GLOBAL;
            }
            if (this.endpoint.tryAllocate(amount)) {
                return Outcome.SUCCESS;
            }
            this.global.release(amount);
            return Outcome.INSUFFICIENT_ENDPOINT;
        }

        public void allocate(long amount) {
            this.global.allocate(amount);
            this.endpoint.allocate(amount);
        }

        public Outcome release(long amount) {
            Outcome endpointReleaseOutcome = this.endpoint.release(amount);
            Outcome globalReleaseOutcome = this.global.release(amount);
            return endpointReleaseOutcome == Outcome.ABOVE_LIMIT || globalReleaseOutcome == Outcome.ABOVE_LIMIT ? Outcome.ABOVE_LIMIT : Outcome.BELOW_LIMIT;
        }
    }

    public static class Basic
    implements Limit {
        private long limit;
        private long using;

        public Basic(long limit) {
            this.limit = limit;
        }

        @Override
        public long limit() {
            return this.limit;
        }

        @Override
        public long setLimit(long newLimit) {
            long oldLimit = this.limit;
            this.limit = newLimit;
            return oldLimit;
        }

        @Override
        public long remaining() {
            return this.limit - this.using;
        }

        @Override
        public long using() {
            return this.using;
        }

        @Override
        public boolean tryAllocate(long amount) {
            if (this.using + amount > this.limit) {
                return false;
            }
            this.using += amount;
            return true;
        }

        @Override
        public void allocate(long amount) {
            this.using += amount;
        }

        @Override
        public Outcome release(long amount) {
            assert (amount >= 0L && amount <= this.using);
            this.using -= amount;
            return this.using >= this.limit ? Outcome.ABOVE_LIMIT : Outcome.BELOW_LIMIT;
        }
    }

    public static class Concurrent
    implements Limit {
        private volatile long limit;
        private static final AtomicLongFieldUpdater<Concurrent> limitUpdater = AtomicLongFieldUpdater.newUpdater(Concurrent.class, "limit");
        private volatile long using;
        private static final AtomicLongFieldUpdater<Concurrent> usingUpdater = AtomicLongFieldUpdater.newUpdater(Concurrent.class, "using");

        public Concurrent(long limit) {
            this.limit = limit;
        }

        @Override
        public long limit() {
            return this.limit;
        }

        @Override
        public long setLimit(long newLimit) {
            long oldLimit;
            while (!limitUpdater.compareAndSet(this, oldLimit = this.limit, newLimit)) {
            }
            return oldLimit;
        }

        @Override
        public long remaining() {
            return this.limit - this.using;
        }

        @Override
        public long using() {
            return this.using;
        }

        @Override
        public boolean tryAllocate(long amount) {
            long next;
            long current;
            do {
                if ((next = (current = this.using) + amount) <= this.limit) continue;
                return false;
            } while (!usingUpdater.compareAndSet(this, current, next));
            return true;
        }

        @Override
        public void allocate(long amount) {
            long next;
            long current;
            while (!usingUpdater.compareAndSet(this, current = this.using, next = current + amount)) {
            }
        }

        @Override
        public Outcome release(long amount) {
            assert (amount >= 0L);
            long using = usingUpdater.addAndGet(this, -amount);
            assert (using >= 0L);
            return using >= this.limit ? Outcome.ABOVE_LIMIT : Outcome.BELOW_LIMIT;
        }
    }

    public static interface Limit {
        public long limit();

        public long setLimit(long var1);

        public long remaining();

        public long using();

        public boolean tryAllocate(long var1);

        public void allocate(long var1);

        public Outcome release(long var1);
    }
}

