/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.marshal.ValueComparators;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.github.jamm.Unmetered;

@Unmetered
public abstract class AbstractType<T>
implements Comparator<ByteBuffer>,
AssignmentTestable {
    public final Comparator<ByteBuffer> reverseComparator;
    public final ComparisonType comparisonType;
    public final boolean isByteOrderComparable;
    public final ValueComparators comparatorSet;

    protected AbstractType(ComparisonType comparisonType) {
        this.comparisonType = comparisonType;
        this.isByteOrderComparable = comparisonType == ComparisonType.BYTE_ORDER;
        this.reverseComparator = (o1, o2) -> this.compare((ByteBuffer)o2, (ByteBuffer)o1);
        try {
            Method custom = this.getClass().getMethod("compareCustom", Object.class, ValueAccessor.class, Object.class, ValueAccessor.class);
            if (custom.getDeclaringClass() == AbstractType.class == (comparisonType == ComparisonType.CUSTOM)) {
                throw new IllegalStateException((comparisonType == ComparisonType.CUSTOM ? "compareCustom must be overridden if ComparisonType is CUSTOM" : "compareCustom should not be overridden if ComparisonType is not CUSTOM") + " (" + this.getClass().getSimpleName() + ")");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
        this.comparatorSet = new ValueComparators((l, r) -> this.compare(l, ByteArrayAccessor.instance, r, ByteArrayAccessor.instance), (l, r) -> this.compare(l, ByteBufferAccessor.instance, r, ByteBufferAccessor.instance));
    }

    static <VL, VR, T extends Comparable<T>> int compareComposed(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR, AbstractType<T> type) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        return ((Comparable)type.compose(left, accessorL)).compareTo(type.compose(right, accessorR));
    }

    public static List<String> asCQLTypeStringList(List<AbstractType<?>> abstractTypes) {
        ArrayList<String> r = new ArrayList<String>(abstractTypes.size());
        for (AbstractType<?> abstractType : abstractTypes) {
            r.add(abstractType.asCQL3Type().toString());
        }
        return r;
    }

    public final T compose(ByteBuffer bytes) {
        return this.getSerializer().deserialize(bytes);
    }

    public <V> T compose(V value, ValueAccessor<V> accessor) {
        return this.getSerializer().deserialize(value, accessor);
    }

    public ByteBuffer decompose(T value) {
        return this.getSerializer().serialize(value);
    }

    public <V> String getString(V value, ValueAccessor<V> accessor) {
        if (value == null) {
            return "null";
        }
        TypeSerializer<T> serializer = this.getSerializer();
        serializer.validate(value, accessor);
        return serializer.toString(serializer.deserialize(value, accessor));
    }

    public final String getString(ByteBuffer bytes) {
        return this.getString(bytes, ByteBufferAccessor.instance);
    }

    public abstract ByteBuffer fromString(String var1) throws MarshalException;

    public abstract Term fromJSONObject(Object var1) throws MarshalException;

    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return '\"' + Objects.toString(this.getSerializer().deserialize(buffer), "") + '\"';
    }

    public <V> String toJSONString(V value, ValueAccessor<V> accessor, ProtocolVersion protocolVersion) {
        return this.toJSONString(accessor.toBuffer(value), protocolVersion);
    }

    public void validate(ByteBuffer bytes) throws MarshalException {
        this.validate(bytes, ByteBufferAccessor.instance);
    }

    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        this.getSerializer().validate(value, accessor);
    }

    @Override
    public final int compare(ByteBuffer left, ByteBuffer right) {
        return this.compare(left, ByteBufferAccessor.instance, right, ByteBufferAccessor.instance);
    }

    public final <VL, VR> int compare(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return this.isByteOrderComparable ? ValueAccessor.compare(left, accessorL, right, accessorR) : this.compareCustom(left, accessorL, right, accessorR);
    }

    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        throw new UnsupportedOperationException();
    }

    public <V> void validateCellValue(V cellValue, ValueAccessor<V> accessor) throws MarshalException {
        this.validate(cellValue, accessor);
    }

    public CQL3Type asCQL3Type() {
        return new CQL3Type.Custom(this);
    }

    public int compareForCQL(ByteBuffer v1, ByteBuffer v2) {
        return this.compare(v1, v2);
    }

    public abstract TypeSerializer<T> getSerializer();

    public String getString(Collection<ByteBuffer> names) {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public boolean isCounter() {
        return false;
    }

    public boolean isFrozenCollection() {
        return this.isCollection() && !this.isMultiCell();
    }

    public boolean isReversed() {
        return false;
    }

    public static AbstractType<?> parseDefaultParameters(AbstractType<?> baseType, TypeParser parser) throws SyntaxException {
        Map<String, String> parameters = parser.getKeyValueParameters();
        String reversed = parameters.get("reversed");
        if (reversed != null && (reversed.isEmpty() || reversed.equals("true"))) {
            return ReversedType.getInstance(baseType);
        }
        return baseType;
    }

    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this.equals(previous);
    }

    public boolean isValueCompatibleWith(AbstractType<?> otherType) {
        return this.isValueCompatibleWithInternal(otherType instanceof ReversedType ? ((ReversedType)otherType).baseType : otherType);
    }

    protected boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this.isCompatibleWith(otherType);
    }

    public <VL, VR> int compareCollectionMembers(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR, VL collectionName) {
        return this.compare(left, accessorL, right, accessorR);
    }

    public <V> void validateCollectionMember(V value, V collectionName, ValueAccessor<V> accessor) throws MarshalException {
        this.getSerializer().validate(value, accessor);
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isUDT() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isMultiCell() {
        return false;
    }

    public boolean isFreezable() {
        return false;
    }

    public AbstractType<?> freeze() {
        return this;
    }

    public List<AbstractType<?>> subTypes() {
        return Collections.emptyList();
    }

    public AbstractType<?> freezeNestedMulticellTypes() {
        return this;
    }

    public boolean isEmptyValueMeaningless() {
        return false;
    }

    public String toString(boolean ignoreFreezing) {
        return this.toString();
    }

    public List<AbstractType<?>> getComponents() {
        return Collections.singletonList(this);
    }

    public int valueLengthIfFixed() {
        return -1;
    }

    public void writeValue(ByteBuffer value, DataOutputPlus out) throws IOException {
        this.writeValue(value, ByteBufferAccessor.instance, out);
    }

    public <V> void writeValue(V value, ValueAccessor<V> accessor, DataOutputPlus out) throws IOException {
        assert (!accessor.isEmpty(value));
        if (this.valueLengthIfFixed() >= 0) {
            accessor.write(value, out);
        } else {
            accessor.writeWithVIntLength(value, out);
        }
    }

    public long writtenLength(ByteBuffer value) {
        return this.writtenLength(value, ByteBufferAccessor.instance);
    }

    public <V> long writtenLength(V value, ValueAccessor<V> accessor) {
        assert (!accessor.isEmpty(value)) : "bytes should not be empty for type " + this;
        return this.valueLengthIfFixed() >= 0 ? (long)accessor.size(value) : (long)accessor.sizeWithVIntLength(value);
    }

    public ByteBuffer readBuffer(DataInputPlus in) throws IOException {
        return this.readBuffer(in, Integer.MAX_VALUE);
    }

    public ByteBuffer readBuffer(DataInputPlus in, int maxValueSize) throws IOException {
        return this.read(ByteBufferAccessor.instance, in, maxValueSize);
    }

    public byte[] readArray(DataInputPlus in, int maxValueSize) throws IOException {
        return this.read(ByteArrayAccessor.instance, in, maxValueSize);
    }

    public <V> V read(ValueAccessor<V> accessor, DataInputPlus in, int maxValueSize) throws IOException {
        int length = this.valueLengthIfFixed();
        if (length >= 0) {
            return accessor.read(in, length);
        }
        int l = (int)in.readUnsignedVInt();
        if (l < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        if (l > maxValueSize) {
            throw new IOException(String.format("Corrupt value length %d encountered, as it exceeds the maximum of %d, which is set via max_value_size_in_mb in cassandra.yaml", l, maxValueSize));
        }
        return accessor.read(in, l);
    }

    public void skipValue(DataInputPlus in) throws IOException {
        int length = this.valueLengthIfFixed();
        if (length >= 0) {
            in.skipBytesFully(length);
        } else {
            ByteBufferUtil.skipWithVIntLength(in);
        }
    }

    public final boolean referencesUserType(ByteBuffer name) {
        return this.referencesUserType(name, ByteBufferAccessor.instance);
    }

    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return false;
    }

    public AbstractType<?> withUpdatedUserType(UserType udt) {
        return this;
    }

    public AbstractType<?> expandUserTypes() {
        return this;
    }

    public boolean referencesDuration() {
        return false;
    }

    public AssignmentTestable.TestResult testAssignment(AbstractType<?> receiverType) {
        if (this.isFreezable() && !this.isMultiCell()) {
            receiverType = receiverType.freeze();
        }
        if (this.isReversed() && !receiverType.isReversed()) {
            receiverType = ReversedType.getInstance(receiverType);
        }
        if (this.equals(receiverType)) {
            return AssignmentTestable.TestResult.EXACT_MATCH;
        }
        if (receiverType.isValueCompatibleWith(this)) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void checkComparable() {
        switch (this.comparisonType) {
            case NOT_COMPARABLE: {
                throw new IllegalArgumentException(this + " cannot be used in comparisons, so cannot be used as a clustering column");
            }
        }
    }

    @Override
    public final AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        return this.testAssignment(receiver.type);
    }

    public static enum ComparisonType {
        NOT_COMPARABLE,
        BYTE_ORDER,
        CUSTOM;

    }
}

