/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.frame.compress;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.frame.FrameBodyTransformer;
import org.apache.cassandra.transport.frame.compress.Compressor;
import org.apache.cassandra.transport.frame.compress.LZ4Compressor;
import org.apache.cassandra.transport.frame.compress.SnappyCompressor;

public abstract class CompressingTransformer
implements FrameBodyTransformer {
    private static final CompressingTransformer LZ4 = new LZ4();
    private static final CompressingTransformer SNAPPY = new Snappy();
    private static final EnumSet<Frame.Header.Flag> headerFlags = EnumSet.of(Frame.Header.Flag.COMPRESSED);

    public static final CompressingTransformer getTransformer(Compressor compressor) {
        if (compressor instanceof LZ4Compressor) {
            return LZ4;
        }
        if (compressor instanceof SnappyCompressor) {
            if (SnappyCompressor.INSTANCE == null) {
                throw new ProtocolException("This instance does not support Snappy compression");
            }
            return SNAPPY;
        }
        throw new ProtocolException("Unsupported compression implementation: " + compressor.getClass().getCanonicalName());
    }

    CompressingTransformer() {
    }

    @Override
    public EnumSet<Frame.Header.Flag> getOutboundHeaderFlags() {
        return headerFlags;
    }

    @Override
    public ByteBuf transformInbound(ByteBuf inputBuf, EnumSet<Frame.Header.Flag> flags) throws IOException {
        return this.transformInbound(inputBuf);
    }

    abstract ByteBuf transformInbound(ByteBuf var1) throws IOException;

    private static class Snappy
    extends CompressingTransformer {
        private Snappy() {
        }

        @Override
        public ByteBuf transformOutbound(ByteBuf inputBuf) throws IOException {
            byte[] input = CBUtil.readRawBytes(inputBuf);
            int uncompressedLength = input.length;
            int maxCompressedLength = SnappyCompressor.INSTANCE.maxCompressedLength(uncompressedLength);
            ByteBuf outputBuf = CBUtil.allocator.heapBuffer(maxCompressedLength);
            try {
                int written = SnappyCompressor.INSTANCE.compress(input, 0, uncompressedLength, outputBuf.array(), outputBuf.arrayOffset());
                outputBuf.writerIndex(written);
                return outputBuf;
            }
            catch (IOException e) {
                outputBuf.release();
                throw e;
            }
        }

        @Override
        ByteBuf transformInbound(ByteBuf inputBuf) throws IOException {
            byte[] input = CBUtil.readRawBytes(inputBuf);
            int uncompressedLength = org.xerial.snappy.Snappy.uncompressedLength((byte[])input);
            ByteBuf outputBuf = CBUtil.allocator.heapBuffer(uncompressedLength);
            try {
                outputBuf.writeBytes(SnappyCompressor.INSTANCE.decompress(input, 0, input.length, uncompressedLength));
                return outputBuf;
            }
            catch (IOException e) {
                outputBuf.release();
                throw e;
            }
        }
    }

    private static class LZ4
    extends CompressingTransformer {
        private LZ4() {
        }

        @Override
        public ByteBuf transformOutbound(ByteBuf inputBuf) throws IOException {
            byte[] input = CBUtil.readRawBytes(inputBuf);
            int maxCompressedLength = LZ4Compressor.INSTANCE.maxCompressedLength(input.length);
            ByteBuf outputBuf = CBUtil.allocator.heapBuffer(4 + maxCompressedLength);
            byte[] output = outputBuf.array();
            int outputOffset = outputBuf.arrayOffset();
            output[outputOffset] = (byte)(input.length >>> 24);
            output[outputOffset + 1] = (byte)(input.length >>> 16);
            output[outputOffset + 2] = (byte)(input.length >>> 8);
            output[outputOffset + 3] = (byte)input.length;
            try {
                int written = LZ4Compressor.INSTANCE.compress(input, 0, input.length, output, 4 + outputOffset);
                outputBuf.writerIndex(4 + written);
                return outputBuf;
            }
            catch (IOException e) {
                outputBuf.release();
                throw e;
            }
        }

        @Override
        ByteBuf transformInbound(ByteBuf inputBuf) throws IOException {
            byte[] input = CBUtil.readRawBytes(inputBuf);
            int uncompressedLength = (input[0] & 0xFF) << 24 | (input[1] & 0xFF) << 16 | (input[2] & 0xFF) << 8 | input[3] & 0xFF;
            ByteBuf outputBuf = CBUtil.allocator.heapBuffer(uncompressedLength);
            try {
                outputBuf.writeBytes(LZ4Compressor.INSTANCE.decompress(input, 4, input.length - 4, uncompressedLength));
                return outputBuf;
            }
            catch (IOException e) {
                outputBuf.release();
                throw e;
            }
        }
    }
}

