/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLFactory.class);
    @VisibleForTesting
    static volatile boolean checkedExpiry = false;
    private static final boolean openSslIsAvailable = Boolean.getBoolean("cassandra.disable_tcactive_openssl") ? false : OpenSsl.isAvailable();
    private static final ConcurrentHashMap<CacheKey, SslContext> cachedSslContexts = new ConcurrentHashMap();
    private static volatile List<HotReloadableFile> hotReloadableFiles = ImmutableList.of();
    public static final int DEFAULT_HOT_RELOAD_INITIAL_DELAY_SEC = 600;
    public static final int DEFAULT_HOT_RELOAD_PERIOD_SEC = 600;
    private static boolean isHotReloadingInitialized = false;

    public static boolean openSslIsAvailable() {
        return openSslIsAvailable;
    }

    public static SSLContext createSSLContext(EncryptionOptions options, boolean buildTruststore) throws IOException {
        TrustManager[] trustManagers = null;
        if (buildTruststore) {
            trustManagers = SSLFactory.buildTrustManagerFactory(options).getTrustManagers();
        }
        KeyManagerFactory kmf = SSLFactory.buildKeyManagerFactory(options);
        try {
            SSLContext ctx = SSLContext.getInstance(options.protocol);
            ctx.init(kmf.getKeyManagers(), trustManagers, null);
            return ctx;
        }
        catch (Exception e) {
            throw new IOException("Error creating/initializing the SSL Context", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TrustManagerFactory buildTrustManagerFactory(EncryptionOptions options) throws IOException {
        try (InputStream tsf = Files.newInputStream(Paths.get(options.truststore, new String[0]), new OpenOption[0]);){
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(options.algorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : options.algorithm);
            KeyStore ts = KeyStore.getInstance(options.store_type);
            ts.load(tsf, options.truststore_password.toCharArray());
            tmf.init(ts);
            TrustManagerFactory trustManagerFactory = tmf;
            return trustManagerFactory;
        }
        catch (Exception e) {
            throw new IOException("failed to build trust manager store for secure connections", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static KeyManagerFactory buildKeyManagerFactory(EncryptionOptions options) throws IOException {
        try (InputStream ksf = Files.newInputStream(Paths.get(options.keystore, new String[0]), new OpenOption[0]);){
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(options.algorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : options.algorithm);
            KeyStore ks = KeyStore.getInstance(options.store_type);
            ks.load(ksf, options.keystore_password.toCharArray());
            if (!checkedExpiry) {
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    Date expires;
                    String alias = aliases.nextElement();
                    if (!ks.getCertificate(alias).getType().equals("X.509") || !(expires = ((X509Certificate)ks.getCertificate(alias)).getNotAfter()).before(new Date())) continue;
                    logger.warn("Certificate for {} expired on {}", (Object)alias, (Object)expires);
                }
                checkedExpiry = true;
            }
            kmf.init(ks, options.keystore_password.toCharArray());
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
        catch (Exception e) {
            throw new IOException("failed to build trust manager store for secure connections", e);
        }
    }

    public static String[] filterCipherSuites(String[] supported, String[] desired) {
        ImmutableSet ssupported;
        if (Arrays.equals(supported, desired)) {
            return desired;
        }
        List<String> ldesired = Arrays.asList(desired);
        Object[] ret = (String[])Iterables.toArray((Iterable)Iterables.filter(ldesired, (Predicate)Predicates.in((Collection)(ssupported = ImmutableSet.copyOf((Object[])supported)))), String.class);
        if (desired.length > ret.length && logger.isWarnEnabled()) {
            Iterable missing = Iterables.filter(ldesired, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)Sets.newHashSet((Object[])ret))));
            logger.warn("Filtering out {} as it isn't supported by the socket", (Object)Iterables.toString((Iterable)missing));
        }
        return ret;
    }

    public static SslContext getOrCreateSslContext(EncryptionOptions options, boolean buildTruststore, SocketType socketType) throws IOException {
        return SSLFactory.getOrCreateSslContext(options, buildTruststore, socketType, SSLFactory.openSslIsAvailable());
    }

    @VisibleForTesting
    static SslContext getOrCreateSslContext(EncryptionOptions options, boolean buildTruststore, SocketType socketType, boolean useOpenSsl) throws IOException {
        CacheKey key = new CacheKey(options, socketType, useOpenSsl);
        SslContext sslContext = cachedSslContexts.get(key);
        if (sslContext != null) {
            return sslContext;
        }
        sslContext = SSLFactory.createNettySslContext(options, buildTruststore, socketType, useOpenSsl);
        SslContext previous = cachedSslContexts.putIfAbsent(key, sslContext);
        if (previous == null) {
            return sslContext;
        }
        ReferenceCountUtil.release((Object)sslContext);
        return previous;
    }

    static SslContext createNettySslContext(EncryptionOptions options, boolean buildTruststore, SocketType socketType, boolean useOpenSsl) throws IOException {
        SslContextBuilder builder;
        KeyManagerFactory kmf = SSLFactory.buildKeyManagerFactory(options);
        if (socketType == SocketType.SERVER) {
            builder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
            builder.clientAuth(options.require_client_auth ? ClientAuth.REQUIRE : ClientAuth.NONE);
        } else {
            builder = SslContextBuilder.forClient().keyManager(kmf);
        }
        builder.sslProvider(useOpenSsl ? SslProvider.OPENSSL : SslProvider.JDK);
        if (options.cipher_suites != null && !options.cipher_suites.isEmpty()) {
            builder.ciphers(options.cipher_suites, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        }
        if (buildTruststore) {
            builder.trustManager(SSLFactory.buildTrustManagerFactory(options));
        }
        return builder.build();
    }

    public static void checkCertFilesForHotReloading(EncryptionOptions.ServerEncryptionOptions serverOpts, EncryptionOptions clientOpts) {
        if (!isHotReloadingInitialized) {
            throw new IllegalStateException("Hot reloading functionality has not been initialized.");
        }
        logger.debug("Checking whether certificates have been updated {}", hotReloadableFiles);
        if (hotReloadableFiles.stream().anyMatch(HotReloadableFile::shouldReload)) {
            logger.info("SSL certificates have been updated. Reseting the ssl contexts for new connections.");
            try {
                SSLFactory.validateSslCerts(serverOpts, clientOpts);
                cachedSslContexts.clear();
            }
            catch (Exception e) {
                logger.error("Failed to hot reload the SSL Certificates! Please check the certificate files.", (Throwable)e);
            }
        }
    }

    public static synchronized void initHotReloading(EncryptionOptions.ServerEncryptionOptions serverOpts, EncryptionOptions clientOpts, boolean force) throws IOException {
        if (isHotReloadingInitialized && !force) {
            return;
        }
        logger.debug("Initializing hot reloading SSLContext");
        SSLFactory.validateSslCerts(serverOpts, clientOpts);
        ArrayList<HotReloadableFile> fileList = new ArrayList<HotReloadableFile>();
        if (serverOpts != null && serverOpts.isEnabled()) {
            fileList.add(new HotReloadableFile(serverOpts.keystore));
            fileList.add(new HotReloadableFile(serverOpts.truststore));
        }
        if (clientOpts != null && clientOpts.isEnabled()) {
            fileList.add(new HotReloadableFile(clientOpts.keystore));
            fileList.add(new HotReloadableFile(clientOpts.truststore));
        }
        hotReloadableFiles = ImmutableList.copyOf(fileList);
        if (!isHotReloadingInitialized) {
            ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(() -> SSLFactory.checkCertFilesForHotReloading(DatabaseDescriptor.getInternodeMessagingEncyptionOptions(), DatabaseDescriptor.getNativeProtocolEncryptionOptions()), 600L, 600L, TimeUnit.SECONDS);
        }
        isHotReloadingInitialized = true;
    }

    public static void validateSslCerts(EncryptionOptions.ServerEncryptionOptions serverOpts, EncryptionOptions clientOpts) throws IOException {
        try {
            if (serverOpts != null && serverOpts.isEnabled()) {
                SSLFactory.createNettySslContext(serverOpts, true, SocketType.SERVER, SSLFactory.openSslIsAvailable());
                SSLFactory.createNettySslContext(serverOpts, true, SocketType.CLIENT, SSLFactory.openSslIsAvailable());
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to create SSL context using server_encryption_options!", e);
        }
        try {
            if (clientOpts != null && clientOpts.isEnabled()) {
                SSLFactory.createNettySslContext(clientOpts, clientOpts.require_client_auth, SocketType.SERVER, SSLFactory.openSslIsAvailable());
                SSLFactory.createNettySslContext(clientOpts, clientOpts.require_client_auth, SocketType.CLIENT, SSLFactory.openSslIsAvailable());
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to create SSL context using client_encryption_options!", e);
        }
    }

    static class CacheKey {
        private final EncryptionOptions encryptionOptions;
        private final SocketType socketType;
        private final boolean useOpenSSL;

        public CacheKey(EncryptionOptions encryptionOptions, SocketType socketType, boolean useOpenSSL) {
            this.encryptionOptions = encryptionOptions;
            this.socketType = socketType;
            this.useOpenSSL = useOpenSSL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.socketType == cacheKey.socketType && this.useOpenSSL == cacheKey.useOpenSSL && Objects.equals(this.encryptionOptions, cacheKey.encryptionOptions);
        }

        public int hashCode() {
            int result = 0;
            result += 31 * this.socketType.hashCode();
            result += 31 * this.encryptionOptions.hashCode();
            return result += 31 * Boolean.hashCode(this.useOpenSSL);
        }
    }

    private static class HotReloadableFile {
        private final File file;
        private volatile long lastModTime;

        HotReloadableFile(String path) {
            this.file = new File(path);
            this.lastModTime = this.file.lastModified();
        }

        boolean shouldReload() {
            long curModTime = this.file.lastModified();
            boolean result = curModTime != this.lastModTime;
            this.lastModTime = curModTime;
            return result;
        }

        public String toString() {
            return "HotReloadableFile{file=" + this.file + ", lastModTime=" + this.lastModTime + '}';
        }
    }

    public static enum SocketType {
        SERVER,
        CLIENT;

    }
}

