/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.MigrationTask;
import org.apache.cassandra.schema.Schema;

final class SchemaMigrationEvent
extends DiagnosticEvent {
    private final MigrationManagerEventType type;
    @Nullable
    private final InetAddressAndPort endpoint;
    @Nullable
    private final UUID endpointSchemaVersion;
    private final UUID localSchemaVersion;
    private final Integer localMessagingVersion;
    private final SystemKeyspace.BootstrapState bootstrapState;
    @Nullable
    private Integer inflightTaskCount;
    @Nullable
    private Integer endpointMessagingVersion;
    @Nullable
    private Boolean endpointGossipOnlyMember;
    @Nullable
    private Boolean isAlive;

    SchemaMigrationEvent(MigrationManagerEventType type, @Nullable InetAddressAndPort endpoint, @Nullable UUID endpointSchemaVersion) {
        this.type = type;
        this.endpoint = endpoint;
        this.endpointSchemaVersion = endpointSchemaVersion;
        this.localSchemaVersion = Schema.instance.getVersion();
        this.localMessagingVersion = 12;
        ConcurrentLinkedQueue<CountDownLatch> inflightTasks = MigrationTask.getInflightTasks();
        if (inflightTasks != null) {
            this.inflightTaskCount = inflightTasks.size();
        }
        this.bootstrapState = SystemKeyspace.getBootstrapState();
        if (endpoint == null) {
            return;
        }
        if (MessagingService.instance().versions.knows(endpoint)) {
            this.endpointMessagingVersion = MessagingService.instance().versions.getRaw(endpoint);
        }
        this.endpointGossipOnlyMember = Gossiper.instance.isGossipOnlyMember(endpoint);
        this.isAlive = FailureDetector.instance.isAlive(endpoint);
    }

    @Override
    public Enum<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (this.endpoint != null) {
            ret.put("endpoint", (Serializable)((Object)this.endpoint.getHostAddressAndPort()));
        }
        ret.put("endpointSchemaVersion", (Serializable)((Object)Schema.schemaVersionToString(this.endpointSchemaVersion)));
        ret.put("localSchemaVersion", (Serializable)((Object)Schema.schemaVersionToString(this.localSchemaVersion)));
        if (this.endpointMessagingVersion != null) {
            ret.put("endpointMessagingVersion", this.endpointMessagingVersion);
        }
        if (this.localMessagingVersion != null) {
            ret.put("localMessagingVersion", this.localMessagingVersion);
        }
        if (this.endpointGossipOnlyMember != null) {
            ret.put("endpointGossipOnlyMember", this.endpointGossipOnlyMember);
        }
        if (this.isAlive != null) {
            ret.put("endpointIsAlive", this.isAlive);
        }
        if (this.bootstrapState != null) {
            ret.put("bootstrapState", (Serializable)((Object)this.bootstrapState.name()));
        }
        if (this.inflightTaskCount != null) {
            ret.put("inflightTaskCount", this.inflightTaskCount);
        }
        return ret;
    }

    static enum MigrationManagerEventType {
        UNKNOWN_LOCAL_SCHEMA_VERSION,
        VERSION_MATCH,
        SKIP_PULL,
        RESET_LOCAL_SCHEMA,
        TASK_CREATED,
        TASK_SEND_ABORTED,
        TASK_REQUEST_SEND;

    }
}

