/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Reservoir;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.transport.ClientStat;
import org.apache.cassandra.transport.ConnectedClient;
import org.apache.cassandra.transport.Server;

public final class ClientMetrics {
    public static final ClientMetrics instance = new ClientMetrics();
    private static final MetricNameFactory factory = new DefaultNameFactory("Client");
    private volatile boolean initialized = false;
    private Collection<Server> servers = Collections.emptyList();
    private Meter authSuccess;
    private Meter authFailure;
    private AtomicInteger pausedConnections;
    private Gauge<Integer> pausedConnectionsGauge;
    private Meter requestDiscarded;

    private ClientMetrics() {
    }

    public void markAuthSuccess() {
        this.authSuccess.mark();
    }

    public void markAuthFailure() {
        this.authFailure.mark();
    }

    public void pauseConnection() {
        this.pausedConnections.incrementAndGet();
    }

    public void unpauseConnection() {
        this.pausedConnections.decrementAndGet();
    }

    public void markRequestDiscarded() {
        this.requestDiscarded.mark();
    }

    public List<ConnectedClient> allConnectedClients() {
        ArrayList<ConnectedClient> clients = new ArrayList<ConnectedClient>();
        for (Server server : this.servers) {
            clients.addAll(server.getConnectedClients());
        }
        return clients;
    }

    public synchronized void init(Collection<Server> servers) {
        if (this.initialized) {
            return;
        }
        this.servers = servers;
        this.registerGauge("ConnectedNativeClients", "connectedNativeClients", this::countConnectedClients);
        this.registerGauge("ConnectedNativeClientsByUser", "connectedNativeClientsByUser", this::countConnectedClientsByUser);
        this.registerGauge("Connections", "connections", this::connectedClients);
        this.registerGauge("ClientsByProtocolVersion", "clientsByProtocolVersion", this::recentClientStats);
        this.registerGauge("RequestsSize", Server.EndpointPayloadTracker::getCurrentGlobalUsage);
        final Reservoir ipUsageReservoir = Server.EndpointPayloadTracker.ipUsageReservoir();
        CassandraMetricsRegistry.Metrics.register(factory.createMetricName("RequestsSizeByIpDistribution"), new Histogram(ipUsageReservoir){

            public long getCount() {
                return ipUsageReservoir.size();
            }
        });
        this.authSuccess = this.registerMeter("AuthSuccess");
        this.authFailure = this.registerMeter("AuthFailure");
        this.pausedConnections = new AtomicInteger();
        this.pausedConnectionsGauge = this.registerGauge("PausedConnections", this.pausedConnections::get);
        this.requestDiscarded = this.registerMeter("RequestDiscarded");
        this.initialized = true;
    }

    private int countConnectedClients() {
        int count = 0;
        for (Server server : this.servers) {
            count += server.countConnectedClients();
        }
        return count;
    }

    private Map<String, Integer> countConnectedClientsByUser() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Server server : this.servers) {
            server.countConnectedClientsByUser().forEach((username, count) -> counts.put((String)username, counts.getOrDefault(username, 0) + count));
        }
        return counts;
    }

    private List<Map<String, String>> connectedClients() {
        ArrayList<Map<String, String>> clients = new ArrayList<Map<String, String>>();
        for (Server server : this.servers) {
            for (ConnectedClient client : server.getConnectedClients()) {
                clients.add(client.asMap());
            }
        }
        return clients;
    }

    private List<Map<String, String>> recentClientStats() {
        ArrayList<Map<String, String>> stats = new ArrayList<Map<String, String>>();
        for (Server server : this.servers) {
            for (ClientStat stat : server.recentClientStats()) {
                stats.add(new HashMap<String, String>(stat.asMap()));
            }
        }
        stats.sort(Comparator.comparing(map -> (String)map.get("protocolVersion")));
        return stats;
    }

    private <T> Gauge<T> registerGauge(String name, Gauge<T> gauge) {
        return CassandraMetricsRegistry.Metrics.register(factory.createMetricName(name), gauge);
    }

    private void registerGauge(String name, String deprecated, Gauge<?> gauge) {
        Gauge<?> registeredGauge = this.registerGauge(name, gauge);
        CassandraMetricsRegistry.Metrics.registerMBean((Metric)registeredGauge, factory.createMetricName(deprecated).getMBeanName());
    }

    private Meter registerMeter(String name) {
        return CassandraMetricsRegistry.Metrics.meter(factory.createMetricName(name));
    }
}

