/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.RatioGauge;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.DoubleSupplier;
import org.apache.cassandra.cache.CacheSize;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;
    public final Meter hits;
    public final Meter misses;
    public final Metered requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Double> oneMinuteHitRate;
    public final Gauge<Double> fiveMinuteHitRate;
    public final Gauge<Double> fifteenMinuteHitRate;
    protected final MetricNameFactory factory;

    public CacheMetrics(String type, CacheSize cache) {
        this.factory = new DefaultNameFactory("Cache", type);
        this.capacity = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Capacity"), cache::capacity);
        this.size = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Size"), cache::weightedSize);
        this.entries = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Entries"), cache::size);
        this.hits = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Hits"));
        this.misses = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Misses"));
        this.requests = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Requests"), CacheMetrics.sumMeters((Metered)this.hits, (Metered)this.misses));
        this.hitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("HitRate"), CacheMetrics.ratioGauge(() -> ((Meter)this.hits).getCount(), () -> ((Metered)this.requests).getCount()));
        this.oneMinuteHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("OneMinuteHitRate"), CacheMetrics.ratioGauge(() -> ((Meter)this.hits).getOneMinuteRate(), () -> ((Metered)this.requests).getOneMinuteRate()));
        this.fiveMinuteHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("FiveMinuteHitRate"), CacheMetrics.ratioGauge(() -> ((Meter)this.hits).getFiveMinuteRate(), () -> ((Metered)this.requests).getFiveMinuteRate()));
        this.fifteenMinuteHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("FifteenMinuteHitRate"), CacheMetrics.ratioGauge(() -> ((Meter)this.hits).getFifteenMinuteRate(), () -> ((Metered)this.requests).getFifteenMinuteRate()));
    }

    @VisibleForTesting
    public void reset() {
        this.hits.mark(-this.hits.getCount());
        this.misses.mark(-this.misses.getCount());
    }

    private static Metered sumMeters(final Metered first, final Metered second) {
        return new Metered(){

            public long getCount() {
                return first.getCount() + second.getCount();
            }

            public double getMeanRate() {
                return first.getMeanRate() + second.getMeanRate();
            }

            public double getOneMinuteRate() {
                return first.getOneMinuteRate() + second.getOneMinuteRate();
            }

            public double getFiveMinuteRate() {
                return first.getFiveMinuteRate() + second.getFiveMinuteRate();
            }

            public double getFifteenMinuteRate() {
                return first.getFifteenMinuteRate() + second.getFifteenMinuteRate();
            }
        };
    }

    private static RatioGauge ratioGauge(final DoubleSupplier numeratorSupplier, final DoubleSupplier denominatorSupplier) {
        return new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)numeratorSupplier.getAsDouble(), (double)denominatorSupplier.getAsDouble());
            }
        };
    }
}

