/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public abstract class SimpleBuilders {
    private SimpleBuilders() {
    }

    private static DecoratedKey makePartitonKey(TableMetadata metadata, Object ... partitionKey) {
        if (partitionKey.length == 1 && partitionKey[0] instanceof DecoratedKey) {
            return (DecoratedKey)partitionKey[0];
        }
        ByteBuffer key = metadata.partitionKeyAsClusteringComparator().make(partitionKey).serializeAsPartitionKey();
        return metadata.partitioner.decorateKey(key);
    }

    private static Clustering<?> makeClustering(TableMetadata metadata, Object ... clusteringColumns) {
        if (clusteringColumns.length == 1 && clusteringColumns[0] instanceof Clustering) {
            return (Clustering)clusteringColumns[0];
        }
        if (clusteringColumns.length == 0) {
            assert (metadata.comparator.size() == 0 || !metadata.staticColumns().isEmpty());
            return metadata.comparator.size() == 0 ? Clustering.EMPTY : Clustering.STATIC_CLUSTERING;
        }
        return metadata.comparator.make(clusteringColumns);
    }

    public static class RowBuilder
    extends AbstractBuilder<Row.SimpleBuilder>
    implements Row.SimpleBuilder {
        private final TableMetadata metadata;
        private final Set<ColumnMetadata> columns = new HashSet<ColumnMetadata>();
        private final Row.Builder builder;
        private boolean initiated;
        private boolean noPrimaryKeyLivenessInfo;

        public RowBuilder(TableMetadata metadata, Object ... clusteringColumns) {
            this.metadata = metadata;
            this.builder = BTreeRow.unsortedBuilder();
            this.builder.newRow(SimpleBuilders.makeClustering(metadata, clusteringColumns));
        }

        Set<ColumnMetadata> columns() {
            return this.columns;
        }

        private void maybeInit() {
            if (this.initiated) {
                return;
            }
            if (!this.noPrimaryKeyLivenessInfo) {
                this.builder.addPrimaryKeyLivenessInfo(LivenessInfo.create(this.timestamp, this.ttl, this.nowInSec));
            }
            this.initiated = true;
        }

        @Override
        public Row.SimpleBuilder add(String columnName, Object value) {
            return this.add(columnName, value, true);
        }

        @Override
        public Row.SimpleBuilder appendAll(String columnName, Object value) {
            return this.add(columnName, value, false);
        }

        private Row.SimpleBuilder add(String columnName, Object value, boolean overwriteForCollection) {
            this.maybeInit();
            ColumnMetadata column = this.getColumn(columnName);
            if (!(overwriteForCollection || column.type.isMultiCell() && column.type.isCollection())) {
                throw new IllegalArgumentException("appendAll() can only be called on non-frozen collections");
            }
            this.columns.add(column);
            if (!column.type.isMultiCell()) {
                this.builder.addCell(this.cell(column, this.toByteBuffer(value, column.type), null));
                return this;
            }
            assert (column.type instanceof CollectionType) : "Collection are the only multi-cell types supported so far";
            if (value == null) {
                this.builder.addComplexDeletion(column, new DeletionTime(this.timestamp, this.nowInSec));
                return this;
            }
            if (overwriteForCollection) {
                this.builder.addComplexDeletion(column, new DeletionTime(this.timestamp - 1L, this.nowInSec));
            }
            switch (((CollectionType)column.type).kind) {
                case LIST: {
                    ListType lt = (ListType)column.type;
                    assert (value instanceof List);
                    for (Object elt : (List)value) {
                        this.builder.addCell(this.cell(column, this.toByteBuffer(elt, lt.getElementsType()), CellPath.create(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes()))));
                    }
                    break;
                }
                case SET: {
                    SetType st = (SetType)column.type;
                    assert (value instanceof Set);
                    for (Object elt : (Set)value) {
                        this.builder.addCell(this.cell(column, ByteBufferUtil.EMPTY_BYTE_BUFFER, CellPath.create(this.toByteBuffer(elt, st.getElementsType()))));
                    }
                    break;
                }
                case MAP: {
                    MapType mt = (MapType)column.type;
                    assert (value instanceof Map);
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        this.builder.addCell(this.cell(column, this.toByteBuffer(entry.getValue(), mt.getValuesType()), CellPath.create(this.toByteBuffer(entry.getKey(), mt.getKeysType()))));
                    }
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return this;
        }

        @Override
        public Row.SimpleBuilder delete() {
            assert (!this.initiated) : "If called, delete() should be called before any other column value addition";
            this.builder.addRowDeletion(Row.Deletion.regular(new DeletionTime(this.timestamp, this.nowInSec)));
            return this;
        }

        @Override
        public Row.SimpleBuilder delete(String columnName) {
            return this.add(columnName, null);
        }

        @Override
        public Row.SimpleBuilder noPrimaryKeyLivenessInfo() {
            this.noPrimaryKeyLivenessInfo = true;
            return this;
        }

        @Override
        public Row build() {
            this.maybeInit();
            return this.builder.build();
        }

        private ColumnMetadata getColumn(String columnName) {
            ColumnMetadata column = this.metadata.getColumn(new ColumnIdentifier(columnName, true));
            assert (column != null) : "Cannot find column " + columnName;
            assert (!column.isPrimaryKeyColumn());
            assert (!column.isStatic() || this.builder.clustering() == Clustering.STATIC_CLUSTERING) : "Cannot add non-static column to static-row";
            return column;
        }

        private Cell<?> cell(ColumnMetadata column, ByteBuffer value, CellPath path) {
            if (value == null) {
                return BufferCell.tombstone(column, this.timestamp, this.nowInSec, path);
            }
            return this.ttl == 0 ? BufferCell.live(column, this.timestamp, value, path) : BufferCell.expiring(column, this.timestamp, this.ttl, this.nowInSec, value, path);
        }

        private ByteBuffer toByteBuffer(Object value, AbstractType<?> type) {
            if (value == null) {
                return null;
            }
            if (value instanceof ByteBuffer) {
                return (ByteBuffer)value;
            }
            if (type.isCounter()) {
                assert (value instanceof Long) : "Attempted to adjust Counter cell with non-long value.";
                return CounterContext.instance().createGlobal(CounterId.getLocalId(), 1L, (Long)value);
            }
            return type.decompose(value);
        }
    }

    public static class PartitionUpdateBuilder
    extends AbstractBuilder<PartitionUpdate.SimpleBuilder>
    implements PartitionUpdate.SimpleBuilder {
        private final TableMetadata metadata;
        private final DecoratedKey key;
        private final Map<Clustering<?>, RowBuilder> rowBuilders = new HashMap();
        private List<RTBuilder> rangeBuilders = null;
        private List<RangeTombstone> rangeTombstones = null;
        private DeletionTime partitionDeletion = DeletionTime.LIVE;

        public PartitionUpdateBuilder(TableMetadata metadata, Object ... partitionKeyValues) {
            this.metadata = metadata;
            this.key = SimpleBuilders.makePartitonKey(metadata, partitionKeyValues);
        }

        @Override
        public TableMetadata metadata() {
            return this.metadata;
        }

        @Override
        public Row.SimpleBuilder row(Object ... clusteringValues) {
            Clustering clustering = SimpleBuilders.makeClustering(this.metadata, clusteringValues);
            RowBuilder builder = this.rowBuilders.get(clustering);
            if (builder == null) {
                builder = new RowBuilder(this.metadata, clustering);
                this.rowBuilders.put(clustering, builder);
            }
            this.copyParams(builder);
            return builder;
        }

        @Override
        public PartitionUpdate.SimpleBuilder delete() {
            this.partitionDeletion = new DeletionTime(this.timestamp, this.nowInSec);
            return this;
        }

        @Override
        public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder addRangeTombstone() {
            if (this.rangeBuilders == null) {
                this.rangeBuilders = new ArrayList<RTBuilder>();
            }
            RTBuilder builder = new RTBuilder(this.metadata.comparator, new DeletionTime(this.timestamp, this.nowInSec));
            this.rangeBuilders.add(builder);
            return builder;
        }

        @Override
        public PartitionUpdate.SimpleBuilder addRangeTombstone(RangeTombstone rt) {
            if (this.rangeTombstones == null) {
                this.rangeTombstones = new ArrayList<RangeTombstone>();
            }
            this.rangeTombstones.add(rt);
            return this;
        }

        @Override
        public PartitionUpdate build() {
            RegularAndStaticColumns.Builder columns = RegularAndStaticColumns.builder();
            for (RowBuilder builder : this.rowBuilders.values()) {
                columns.addAll(builder.columns());
            }
            PartitionUpdate.Builder update = new PartitionUpdate.Builder(this.metadata, this.key, columns.build(), this.rowBuilders.size());
            update.addPartitionDeletion(this.partitionDeletion);
            if (this.rangeBuilders != null) {
                for (RTBuilder rTBuilder : this.rangeBuilders) {
                    update.add(rTBuilder.build());
                }
            }
            if (this.rangeTombstones != null) {
                for (RangeTombstone rangeTombstone : this.rangeTombstones) {
                    update.add(rangeTombstone);
                }
            }
            for (RowBuilder rowBuilder : this.rowBuilders.values()) {
                update.add(rowBuilder.build());
            }
            return update.build();
        }

        @Override
        public Mutation buildAsMutation() {
            return new Mutation(this.build());
        }

        private static class RTBuilder
        implements PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder {
            private final ClusteringComparator comparator;
            private final DeletionTime deletionTime;
            private Object[] start;
            private Object[] end;
            private boolean startInclusive = true;
            private boolean endInclusive = true;

            private RTBuilder(ClusteringComparator comparator, DeletionTime deletionTime) {
                this.comparator = comparator;
                this.deletionTime = deletionTime;
            }

            @Override
            public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder start(Object ... values) {
                this.start = values;
                return this;
            }

            @Override
            public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder end(Object ... values) {
                this.end = values;
                return this;
            }

            @Override
            public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder inclStart() {
                this.startInclusive = true;
                return this;
            }

            @Override
            public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder exclStart() {
                this.startInclusive = false;
                return this;
            }

            @Override
            public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder inclEnd() {
                this.endInclusive = true;
                return this;
            }

            @Override
            public PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder exclEnd() {
                this.endInclusive = false;
                return this;
            }

            private RangeTombstone build() {
                ClusteringBound<?> startBound = ClusteringBound.create(this.comparator, true, this.startInclusive, this.start);
                ClusteringBound<?> endBound = ClusteringBound.create(this.comparator, false, this.endInclusive, this.end);
                return new RangeTombstone(Slice.make(startBound, endBound), this.deletionTime);
            }
        }
    }

    public static class MutationBuilder
    extends AbstractBuilder<Mutation.SimpleBuilder>
    implements Mutation.SimpleBuilder {
        private final String keyspaceName;
        private final DecoratedKey key;
        private final Map<TableId, PartitionUpdateBuilder> updateBuilders = new HashMap<TableId, PartitionUpdateBuilder>();

        public MutationBuilder(String keyspaceName, DecoratedKey key) {
            this.keyspaceName = keyspaceName;
            this.key = key;
        }

        @Override
        public PartitionUpdate.SimpleBuilder update(TableMetadata metadata) {
            assert (metadata.keyspace.equals(this.keyspaceName));
            PartitionUpdateBuilder builder = this.updateBuilders.get(metadata.id);
            if (builder == null) {
                builder = new PartitionUpdateBuilder(metadata, this.key);
                this.updateBuilders.put(metadata.id, builder);
            }
            this.copyParams(builder);
            return builder;
        }

        @Override
        public PartitionUpdate.SimpleBuilder update(String tableName) {
            TableMetadata metadata = Schema.instance.getTableMetadata(this.keyspaceName, tableName);
            assert (metadata != null) : "Unknown table " + tableName + " in keyspace " + this.keyspaceName;
            return this.update(metadata);
        }

        @Override
        public Mutation build() {
            assert (!this.updateBuilders.isEmpty()) : "Cannot create empty mutation";
            if (this.updateBuilders.size() == 1) {
                return new Mutation(this.updateBuilders.values().iterator().next().build());
            }
            Mutation.PartitionUpdateCollector mutationBuilder = new Mutation.PartitionUpdateCollector(this.keyspaceName, this.key);
            for (PartitionUpdateBuilder builder : this.updateBuilders.values()) {
                mutationBuilder.add(builder.build());
            }
            return mutationBuilder.build();
        }
    }

    private static class AbstractBuilder<T> {
        protected long timestamp = FBUtilities.timestampMicros();
        protected int ttl = 0;
        protected int nowInSec = FBUtilities.nowInSeconds();

        private AbstractBuilder() {
        }

        protected void copyParams(AbstractBuilder<?> other) {
            other.timestamp = this.timestamp;
            other.ttl = this.ttl;
            other.nowInSec = this.nowInSec;
        }

        public T timestamp(long timestamp) {
            this.timestamp = timestamp;
            return (T)this;
        }

        public T ttl(int ttl) {
            this.ttl = ttl;
            return (T)this;
        }

        public T nowInSec(int nowInSec) {
            this.nowInSec = nowInSec;
            return (T)this;
        }
    }
}

