/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractOnHeapClusteringPrefix;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;

public abstract class AbstractArrayClusteringPrefix
extends AbstractOnHeapClusteringPrefix<byte[]> {
    public static final byte[][] EMPTY_VALUES_ARRAY = new byte[0][];

    public AbstractArrayClusteringPrefix(ClusteringPrefix.Kind kind, byte[][] values) {
        super(kind, (V[])values);
    }

    @Override
    public ValueAccessor<byte[]> accessor() {
        return ByteArrayAccessor.instance;
    }

    @Override
    public ByteBuffer[] getBufferArray() {
        ByteBuffer[] out = new ByteBuffer[((byte[][])this.values).length];
        for (int i = 0; i < ((byte[][])this.values).length; ++i) {
            out[i] = ByteBuffer.wrap(((byte[][])this.values)[i]);
        }
        return out;
    }

    @Override
    public ClusteringPrefix<byte[]> minimize() {
        return this;
    }
}

